// This module is used for printing all of the advertisements that match the search criteria.
// The function takes request body-, user data-, advertisements- and regions-objects as parameters.
// A new advertisements-array is first created. Then for each region in the regions-object
// a slot is created in the new array. Each of the advertisements' "maakunta" attribute in the
// advertisements json-object is compared with the "arrayname.tunniste"-attribute in each slot.
// The advertisements are then pushed to the slots that match. When a region holds at least
// one advertisement in it, then a header is added on top. If no regions or jobfield are selected
// an error is thrown. If no results are found, then a message is printed. Also the search phrase
// and chosen jobfield and regions submitted by the user are printed.

module.exports = {

    "tulostaTulokset": async (rqstbody, userdata, ilmoitukset, regions, cb) => {

        let ilmoitusarray = [];
        
        regions.forEach(region => {
            ilmoitusarray.push({ arrayname: region, docs: [] });
        });
        
        ilmoitukset.forEach(ilmoitus => {
            ilmoitusarray.forEach(alue => {
                if (alue.arrayname.tunniste == ilmoitus.maakunta) {
                    alue.docs.push(ilmoitus);
                }
            });
        });
		
		let docstotal = 0;
        
        for (i = 0; i < regions.length; i++) {
			docstotal += ilmoitusarray[i].docs.length;
            if (ilmoitusarray[i].docs.length > 0) {
                ilmoitusarray[i].docs.unshift("<h3>---------------- " + ilmoitusarray[i].arrayname.kuvaus + " ----------------</h3>");
            }
        }

        let regionnames = "";
        regions.forEach(region => regionnames += region.kuvaus + " ");

        if (regions.length == 0 || rqstbody.jobfield == null) {
            var kuvaus = "<p style='color: red; text-shadow: 0px 0px 0px;'>Valitse toimiala ja vähintään yksi alue!</p>";
        } else {
            var kuvaus = "<p>Valitettavasti hakusi ei tuottanut yht��n tulosta.</p>";
        }

        if (docstotal > 0) {

            cb({
                "logsign": false,
                "user": userdata,
                "token": rqstbody.access,
                "ruutu": "haku",
                "modal": false,
                "kuvaus": null,
                "hakusana": "Tarkennettu haku: " + rqstbody.otsikko + " Toimiala: " + rqstbody.jobfield + " Alueet: " + regionnames,
                "content": ilmoitusarray,
                "modalcontent": null
            });

        } else {

            cb({
                "logsign": false,
                "user": userdata,
                "token": rqstbody.access,
                "ruutu": "haku",
                "modal": false,
                "kuvaus": kuvaus,
                "hakusana": "Tarkennettu haku: " + rqstbody.otsikko + " Toimiala: " + rqstbody.jobfield + " Alueet: " + regionnames,
                "content": "noresults",
                "modalcontent": null
            });
        
        }

    }

};