// This module is used for checking whether both of the text fields in the application form have been filled.
// The function takes a request body- and a user data-objects as arguments.  If either of the text fields are
// empty, then a notification is displayed under the form. If neither are empty, then the process moves forward.

module.exports = {

    "tarkistaHakemus": async (rqstbody, userdata, cb) => {

        if (rqstbody.cnt) { var content = rqstbody.cnt; } else { var content = null; }

        let notification = "";

        if (rqstbody.otsikko == "" || rqstbody.hakemusteksti == "") {

            notification += "<p style='color: red; text-shadow: 0px 0px 0px;'>Täytä molemmat tekstikentät!</p>";
            
            cb( Error, {
                "logsign": false,
                "user": userdata,
                "token": rqstbody.access,
                "ruutu": "haku",
                "modal": "hakemus",
                "kuvaus": null,
                "content": JSON.parse(content),
                "modalcontent": JSON.parse(rqstbody.mdlcntnt),
                "title": rqstbody.otsikko,
                "descriptiontext": rqstbody.hakemusteksti,
                "huomautus": notification,
                "hakusana": rqstbody.searchdefs
            });

        } else {

            cb();

        }

	}
	
};