// This module is used for downloading a cv file from the database to the user computer with GridFSBucket.
// The function takes a request body-object as a parameter.
// First a temporary filepath is created, then a download stream is opened from the fs.files-collection,
// then the file will be written to the temporary filepath specified earlier. Then it's copied to the "file"-variable
// with readFileSync-operation. The temporary filepath is then unlinked (deleted) and the file is returned.

const fs = require('fs');
var path = require('path');
const mongodb = require('mongodb');
const { dburl } = require('../main');

module.exports = {

    "lataaCV": async (rqstbody, cb) => {
		
		let filepath = await path.join(__dirname, '../', rqstbody.cv);
		await mongodb.MongoClient.connect(dburl,
			{ useNewUrlParser: true, useUnifiedTopology: true }, (error, client) => {
				let db = client.db('ont_database');
				let bucket = new mongodb.GridFSBucket(db);

				bucket.openDownloadStream(rqstbody.user).
					pipe(fs.createWriteStream(filepath)).on('finish', () => {
						let file = fs.readFileSync(filepath);
						fs.unlinkSync(filepath);
						cb(file);
					});

		});
		
    }
    
};