#pragma once

#include<string>
#include<Windows.h>

#include"nullptr.h"
#include"Preprocessor.h"
#include"Interpreter.h"

namespace VOSystemsNullptr
{
	namespace Core
	{
		struct LibraryFunction{
			std::string name,dllname;
			unsigned char mode;
			unsigned char ArguInt,ArguBool,ArguString;
		};

		typedef std::vector<struct LibraryFunction> Library;

		typedef BasicTypes::String (*StrFunc)(std::string, BasicTypes::Int*,BasicTypes::String*);
		typedef BasicTypes::Int (*IntFunc)(std::string, BasicTypes::Int*,BasicTypes::String*);

		class Module
		{
		private:
			std::vector<Library> m_modules;
			std::string m_CurrentConnectModuleName;
			HMODULE m_module;
			LibraryFunction m_mf;
			BasicTypes::Int m_int;
			BasicTypes::String m_str;

			LibraryFunction DllSearch(std::string name);
		public:
			bool Connect(std::string name);
			bool Run(std::string name, BasicTypes::Int* paramInt, BasicTypes::String* paramString);
			bool DisConnect(void);
			template<typename _Ty> _Ty GetResult(void)
			{
				if(typeid(_Ty)==typeid(BasicTypes::Int)){
					return m_int;
				}else if(typeid(_Ty)==typeid(BasicTypes::String)){
					return m_str;
				}
			}
		};
	}
}