/*
	nullptr interpreter
	(C) 2015 VOSystems.
*/

#include"nullptr.h"
#include"Interpreter.h"
#include<regex>
#include<vector>
#include<string>

using namespace std;
using namespace VOSystemsNullptr;

bool Nullptr::NewVar(std::string line)
{
	regex_replace(line,regex(" +"),"\t");
	line=Replace(line,"\t"," ");
	vector<string> str=Split(line," ");

	unsigned long long type=0;

	for(size_t C=0; C<str.size(); C++){
		if(str[C]=="Int"){
			C++;
			vector<string> s=Split(str[C],"=");
			if(s.size()>0){
				string name=s[0];
				BasicTypes::Int intd={0,true};

				if(s.size()>1){
					intd.data=stoll(Replace(s[1],"\"",""));
					intd.positive=(intd.data>=0);
				}
				return NewInt(name,intd);
			}

		}else if(str[C]=="String"){
			C++;
			vector<string> s=Split(str[C],"=");
			if(s.size()>0){
				string name=s[0];
				string value;
				if(s.size()>1){
					value=Replace(s[1],"\"","");
				}
				return NewStr(name,value);
			}
		}

	}
	return false;
}

bool Nullptr::NewInt(std::string name, BasicTypes::Int value)
{
	BasicTypes::IntManager inte(name,value);
	m_int.push_back(inte);
	return true;
}

bool Nullptr::AssignInt(std::string name, BasicTypes::Int value)
{
	for(size_t C=0; C<m_int.size(); C++){
		if(m_int[C].GetName()==name){
			m_int[C]=value;
			return true;
		}
	}
	return false;
}

bool Nullptr::GetInt(std::string name, BasicTypes::Int& target)
{
	for(size_t C=0; C<m_int.size(); C++){
		if(m_int[C].GetName()==name){
			target=m_int[C]();
			return true;
		}
	}
	return false;
}

bool Nullptr::NewStr(std::string name, std::string value)
{
	BasicTypes::String str;
	str.data=value;
	str.name=name;
	m_string.push_back(str);
	return true;
}

bool Nullptr::AssignStr(std::string name, std::string value)
{
	for(size_t C=0; C<m_string.size(); C++){
		if(m_string[C].name==name){
			m_string[C].data=value;
			return true;
		}
	}
	return false;
}

bool Nullptr::GetStr(std::string name, std::string& target)
{
	for(size_t C=0; C<m_string.size(); C++){
		if(m_string[C].name==name){
			target=m_string[C].data;
			return true;
		}
	}
	return false;
}