/*
	nullptr interpreter
	(C) 2015 VOSystems.
*/

#include"nullptr.h"
#include"Interpreter.h"
#include<iostream>
#include<fstream>
#include<direct.h>
#include<cctype>
#include<algorithm>
#include<Windows.h>

using namespace VOSystemsNullptr;
using namespace std;

void Nullptr::Screen(std::string line)
{
	vector<string> str=Split(line,"<<<");

	for(size_t C=1; C<str.size(); C++){
		if(regex_match(str[C],regex("\".+\""))){
			cout<<Replace(str[C],"\"","");
		}else if(str[C]=="endl"){
			cout<<endl;
		}else if(str[C]=="flush"){
			cout<<flush;
		}else if(regex_match(str[C],regex("\\d+"))){
			cout<<stoi(str[C]);
		}else{
			BasicTypes::Int ull;
			if(GetInt(str[C],ull)){
				cout<<BasicTypes::IntManager(to_string(0),ull)(ull,'d');
			}else{
				string s;
				if(GetStr(str[C],s)){
					cout<<s;
				}
			}
		}
	}
}

void Nullptr::Keyboard(std::string line)
{
	vector<string> str=Split(line,">>>");
	for(size_t C=1; C<str.size(); C++){
		string in;
		cin>>in;
		if(all_of(in.cbegin(),in.cend(),isdigit)){
			BasicTypes::Int ints={stoll(in)<0 ? -stoll(in) : stoull(in),stoll(in)>=0};
			AssignInt(str[C],ints);
		}else{
			AssignStr(str[C],in);
		}
	}
}

void Nullptr::EScreen(std::string line)
{
	vector<string> str=Split(line,"<<<");

	for(size_t C=1; C<str.size(); C++){
		if(regex_match(str[C],regex("\".+\""))){
			cerr<<Replace(str[C],"\"","");
		}else if(str[C]=="endl"){
			cerr<<endl;
		}else if(str[C]=="flush"){
			cerr<<flush;
		}else if(regex_match(str[C],regex("\\d+"))){
			cerr<<stoi(str[C]);
		}else{
			BasicTypes::Int ull;
			if(GetInt(str[C],ull)){
				cerr<<BasicTypes::IntManager(to_string(0),ull)(ull,'d');
			}else{
				string s;
				if(GetStr(str[C],s)){
					cerr<<s;
				}
			}
		}
	}
}