﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Windows;
using System.Windows.Interop;
using Forms = System.Windows.Forms;

namespace JoinNotes
{
    /// <summary>
    /// App.xaml の相互作用ロジック
    /// </summary>
    public partial class App : Application
    {
        internal const int WM_HOTKEY = 0x312;
        internal const int WM_ACTIVATEAPP = 0x1C;
        internal const int WM_APP = 0x8000;
        internal const int WM_APP_ACTIVATEAPP = WM_APP + 1;
        internal const int SW_RESTORE = 9;

        internal static Dictionary<string, int> HotKeyId = new Dictionary<string, int> { };
        internal static Dictionary<string, HotKey> HotKey = new Dictionary<string, HotKey> { };

        internal static Search searchWindow;
        internal static Config configWindow;
        internal static Forms.Form aboutWindow;
        //internal static Menu mainWindow;
        internal static NotifyTray mainWindow;
        //internal static Menu NotifyContainer { get; set; }
        internal static Window NotifyContainer { get; set; }
        internal static FileInfo HelpFile;
        //internal string basepath;
        internal static DirectoryInfo DocumentPath;
        internal static DirectoryInfo DocumentPathDefault;

        //internal static Window MainWindow { get; private set; }
        internal static App Instance { get; private set; }

        internal Dictionary<Uri, Editor> EditorWindows = new Dictionary<Uri, Editor> { };
        internal HashSet<Editor> UntitledEditorWindows = new HashSet<Editor> { };

        internal static string NotifyContainerTitle { get; private set; }
        internal static Microsoft.VisualBasic.ApplicationServices.AssemblyInfo AssemblyInfo { get; private set; }

        static App()
        {
            App.AssemblyInfo = new Microsoft.VisualBasic.ApplicationServices.AssemblyInfo(Assembly.GetExecutingAssembly());

            try
            {
                App.DocumentPathDefault = new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), @"JoinNotes"));

                //FIXME: 設定をAppに置くかConfigに置くか
                App.DocumentPath = (JoinNotes.Properties.Settings.Default.DocumentPath == "")
                    ? new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), App.AssemblyInfo.ProductName))
                    : new DirectoryInfo(JoinNotes.Properties.Settings.Default.DocumentPath);

                //FIXME: ディレクトリが無ければモードレスな警告をするだけに。ディレクトリ設定はデフォルトと見なす。
                if (!App.DocumentPath.Exists) App.DocumentPath.Create();

                //UNDONE: .sdfを読み込んで例外が起きるなら、Configで初期化するように促す。
                //UNDONE: .sdfを読み込めないなら情報は全てデフォルト値を使う。
                var dbFile = new FileInfo(Path.Combine(App.DocumentPath.FullName, "JoinNotes.sdf"));
                if (!dbFile.Exists)
                {
                    //FIXME: プロジェクトのプロパティ > 発行 > アプリケーションファイル で.sdfをデータディレクトリに置くように。
                    var original = new FileInfo(Path.Combine(Path.GetDirectoryName(System.Reflection.Assembly.GetEntryAssembly().Location), "JoinNotes.sdf"));
                    original.CopyTo(dbFile.FullName);
                }

            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
                EventLog.WriteEntry(ex.Source, ex.Message);
            }

            __t.test();
        }

        public App()
        {
            this.Exit += new ExitEventHandler(Application_Exit);
        }

        protected override void OnStartup(StartupEventArgs e)
        {
            App.Instance = this;

            App.NotifyContainerTitle = Assembly.GetEntryAssembly().GetName().Name + " " + this.GetType().Name;

            var current = Process.GetCurrentProcess();


            //HACK: なぜかApp.xamlの<Application.Resources>セクションで定義するとデザイン時にファイルが見つからないエラーが出るので、ここで指定。
            this.Resources.Source = new Uri(@"pack://application:,,,/JoinNotes;component/Themes/Generic.xaml");

            App.HelpFile = new FileInfo("JoinNotes.chm");

            //// デバッグ用
            //var otherProcs = Process.GetProcessesByName("JoinNotes").ToList();
            //otherProcs.AddRange(Process.GetProcessesByName("JoinNotes.vshost"));
            //otherProcs = otherProcs.Where(p => p.Id != current.Id).ToList();

            //FIXME: リリース時はこちら
            var otherProcs = Process.GetProcessesByName(current.ProcessName).Where(p => p.MainModule.FileName == current.MainModule.FileName && p.Id != current.Id).ToList();

            if (otherProcs.Count() == 0)
            {
                App.Current.MainWindow = App.mainWindow;
                //App.Current.MainWindow = App.searchWindow;

                ////FIXME: remove
                //App.Current.MainWindow.Show();

                base.OnStartup(e);
            }
            else
            {
                Debug.Assert(otherProcs.Count() >= 1);
                otherProcs.ForEach(new Action<Process>((p) => Debug.WriteLine(new { p.MainWindowHandle, p.MainWindowTitle }, "Send wakeup message to ")));
                //Util.WakeupWindow(otherProcs.First().MainWindowHandle);
                Util.WakeupWindow(otherProcs.First());
                //Util.WakeupWindow(otherProcs.First().Handle);
                this.Shutdown();
            }
        }

        //FIXME: OnStartupと統合
        void Application_Startup(object sender, StartupEventArgs e)
        {
            //{
            //    var activateHotKey = new HotKey(App.mainWindow.Handle,
            //        Menu.HotKey_ActivateHotKeyId,
            //        System.Windows.Forms.Keys.Oem5, // Oem5: \
            //        System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt); //HACK: Keys.AltはShiftキーのこと。
            //    Menu.HotKey_ActivateHotKey = activateHotKey;
            //}

            //searchWindow.Show();
            //editorWindow.Owner = App.Current.MainWindow;

            //mainWindow.Show();
            //editorWindow.Show();
            //searchWindow.Show();
            //configWindow.Show();

            //this.ShutdownMode = System.Windows.ShutdownMode.OnExplicitShutdown;
            this.ShutdownMode = System.Windows.ShutdownMode.OnMainWindowClose;

            //App.mainWindow = new Menu();
            App.mainWindow = new NotifyTray();
            App.NotifyContainer = App.mainWindow;

            //HACK: 一度表示しないとなぜかプロセス外からEnumWindows()で発見できないので
            App.NotifyContainer.Show();
            App.NotifyContainer.Hide();

            App.searchWindow = new Search();
            App.configWindow = new Config();
            App.aboutWindow = new AboutBox1();

            //App.searchWindow.Owner = App.mainWindow;
            //App.configWindow.Owner = App.mainWindow;

            App.Current.MainWindow.Closed += new EventHandler(Window_Closed);
            configWindow.Closed += new EventHandler(Window_Closed);

            App.Instance.ApplySettings();

            InvokeStartupTask();

            //App.Current.MainWindow.Show();
        }

        internal void InvokeStartupTask()
        {
            //FIXME: スタートアップ時に開くウィンドウは別の設定項目に
            var classname = JoinNotes.Properties.Settings.Default.StartupWindowClassName;
            Window startupWindow;
            if (classname == typeof(Editor).Name)
                startupWindow = Editor.Create(Util.ValidateFilename(JoinNotes.Properties.Settings.Default.StartPageName) + @".join.rtf");
            else
                startupWindow = this.GetWindow(classname);

            startupWindow.Show();
            startupWindow.Activate();
        }

        //void App_Startup(object sender, StartupEventArgs e)
        //{
        //    Debug.Assert(App.mainWindow != null && App.mainWindow is NotifyTray);
        //    //App.NotifyContainer = new Menu();
        //    App.NotifyContainer = App.mainWindow;
        //}

        //FIXME: Application_Exitと統合
        protected override void OnExit(ExitEventArgs e)
        {
            base.OnExit(e);

            if (searchWindow != null)
                searchWindow.Close();
            if (configWindow != null)
                configWindow.Close();
            if (mainWindow != null)
                mainWindow.Close();
        }

        internal void Window_Closed(object sender, EventArgs e)
        {
            var c = (Window)sender;

            if (hiddenWindows.Contains(c))
                hiddenWindows.Remove(c);
        }

        void Application_Exit(object sender, ExitEventArgs e)
        {
            if (App.NotifyContainer != null)
                App.NotifyContainer.Close();

            if (App.HotKey.ContainsKey("ActivateHotKey"))
            {
                Debug.Assert(App.HotKey["ActivateHotKey"] != null);
                try
                {
                    App.HotKey["ActivateHotKey"].Unregister();
                }
                catch (Win32Exception ex)
                {
                    Debug.WriteLine(ex.Message, ex.Source);
                }
            }
        }

        internal Window GetWindow(string classname)
        {
            Window ret;

            //FIXME: ComboBoxでのラベルと設定値の対応付け方法
            if (classname == typeof(Editor).Name)
            {
                ret = Editor.Create();

                //FIXME: GetWindowかEditor.Create()か一方に統一
                //FIXME: Create(string) -> Create(ValidFilename型)
                //ret = Editor.Create(Util.ValidateFilename(JoinNotes.Properties.Settings.Default.StartPageName) + @".join.rtf");
            }
            else if (classname == typeof(Search).Name)
            {
                if (App.searchWindow == null)
                    App.searchWindow = new Search();
                ret = App.searchWindow;
            }
            else if (classname == typeof(Config).Name)
            {
                if (App.configWindow == null)
                    App.configWindow = new Config();
                ret = App.configWindow;
            }
            else if (classname == typeof(NotifyTray).Name)
            {
                if (App.mainWindow == null)
                    App.mainWindow = new NotifyTray();
                ret = App.mainWindow;
            }
            else
            {
                ret = null;
                Debug.Fail("GetWindow", "classname: " + classname);
            }

            return ret;
        }

        internal static void SwitchApplicationVisibility()
        {
            // ウィンドウが1つでも表示されていれば、全てを記録して非表示。1つも表示されていなければ記録してあるWindowを全て表示。
            var ws = new List<Window>(App.Current.Windows.Cast<Window>());
            if (ws.Exists(w => w.IsVisible))
                InactivateWindows();
            else
                ActivateWindows();
        }

        private static HashSet<Window> hiddenWindows = new HashSet<Window> { };
        internal static void InactivateWindows()
        {
            App.hiddenWindows.Clear();

            var ws = new List<Window>(App.Current.Windows.Cast<Window>());
            foreach (var w in ws.Where(w => w.IsVisible))
            {
                w.Visibility = Visibility.Collapsed;
                App.hiddenWindows.Add(w);
            }
        }

        internal static void ActivateWindows()
        {
            var ws = new List<Window>(App.Current.Windows.Cast<Window>());
            foreach (var w in ws.Where(w => App.hiddenWindows.Contains(w)))
            {
                w.Show();
                if (w.WindowState == WindowState.Minimized)
                    w.WindowState = WindowState.Normal;
                w.Activate();
                App.hiddenWindows.Remove(w);
            }
        }

        void ApplySettings()
        {
            // 設定の読み込み・有効化

            {
                //FIXME: ActivateHotkeyを型にあった名前に
                var hotKeyName = "ActivateHotKey";
                ApplySettings2(hotKeyName);
            }
            {
                //FIXME: OpenWindowHotKeyを型にあった名前に
                var hotKeyName = "OpenWindowHotKey";
                ApplySettings2(hotKeyName);
            }

            //try
            //{
            //    //FIXME: OpenWindowHotKeyを型にあった名前に
            //    var keys = Properties.Settings.Default.OpenWindowHotKey;
            //    //var hotKey = new HotKey(App.mainWindow.Handle,
            //    var hotKey = new HotKey(new WindowInteropHelper(App.mainWindow).Handle,
            //        NotifyTray.HotKey_OpenWindowHotKeyId,
            //        keys & Forms.Keys.KeyCode,
            //        keys & Forms.Keys.Modifiers);
            //    NotifyTray.HotKey_OpenWindowHotKey = hotKey;
            //}
            //catch (Win32Exception ex)
            //{
            //    Debug.WriteLine(ex.Message, ex.Source);
            //}

        }

        private void ApplySettings2(string hotKeyName)
        {
            try
            {
                var keys = (Forms.Keys)JoinNotes.Properties.Settings.Default[hotKeyName];
                //var hotKey = new HotKey(App.mainWindow.Handle,
                var hotKey = new HotKey(new WindowInteropHelper(App.mainWindow).Handle,
                    App.HotKeyId[hotKeyName],
                    keys & Forms.Keys.KeyCode,
                    keys & Forms.Keys.Modifiers);
                App.HotKey[hotKeyName] = hotKey;
            }
            catch (Win32Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }
        }

    }

}
