#! /usr/bin/perl
#------------------------------------------------------------------
# YOU ARE COMING TO THE DESTINATION ALMOST. PLEASE DO A LITTLE EFFORT.
#
# How to setup search form of htags
# =================================
#
# You must setup HTTP server so that this script can be executed
# as a CGI script. This setup depends on the HTTP server which you
# are using.
#
# If you are using Apache HTTP Server [http://httpd.apache.org/],
# you may set it up by adding an entry to the configuration file
# [http.conf] like follows:
#
# +-----------------------------------------
# |...
# |<Directory /usr/local/apache/htdocs/tour> <= depends your environment
# |    Options +ExecCGI
# |    AddHandler cgi-script .cgi
# |</Directory>
# |...
# +-----------------------------------------
#
# If you are using other systems, please consult the manuals.
#------------------------------------------------------------------
#
# Copyright (c) 1997, 2004, 2006, 2008 Tama Communications Corporation
#
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
print "Content-type: text/html\n\n";
print "<html>\
<head>\
<title>Result</title>\
<meta name='robots' content='noindex,nofollow'>\
<meta name='generator' content='GLOBAL-5.7.1'>\
</head>\n";
print "<body text='#191970' bgcolor='#f5f5dc' vlink='gray'>\n";
$htmlbase = $ENV{'HTTP_REFERER'};
if (!$htmlbase) {
	print "<h1><font color='#cc0000'>Error</font></h1>\n";
	print "<h3>Your browser doesn't send HTTP_REFERER.</h3>\n";
	print "</body>\n";
	print "</html>\n";
	exit 0;
}
$htmlbase =~ s!/[^\/]+$!!;		# remove file name.
$htmlbase =~ s!/defines$!!;
$htmlbase =~ s!/S$!!;
$htmlbase =~ s!/$!!;
if (! -x '/usr/bin/global') {
	print "<h1><font color='#cc0000'>Error</font></h1>\n";
	print "<h3>Server side command not found. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
	print "</body>\n";
	print "</html>\n";
	exit 0;
}
@pairs = split (/&/, $ENV{'QUERY_STRING'});
foreach $p (@pairs) {
	($name, $value) = split(/=/, $p);
	$value =~ tr/+/ /;
	$value =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack("C", hex($1))/eg;
	$form{$name} = $value;
}
if ($form{'pattern'} eq '') {
	print "<h1><font color='#cc0000'>Error</font></h1>\n";
	print "<h3>Pattern not specified. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
	print "</body>\n";
	print "</html>\n";
	exit 0;
}
$pattern = $form{'pattern'};
$flag = '';
$words = 'definitions';
if ($form{'type'} eq 'reference') {
	$flag = 'r';
	$words = 'references';
} elsif ($form{'type'} eq 'symbol') {
	$flag = 's';
	$words = 'symbols';
} elsif ($form{'type'} eq 'path') {
	$flag = 'P';
	$words = 'paths';
} elsif ($form{'type'} eq 'grep') {
	$flag = 'g';
	$words = 'patterns';
} elsif ($form{'type'} eq 'idutils') {
	$flag = 'I';
	$words = 'patterns';
}
$iflag = '';
if ($form{'icase'}) {
	$iflag = 'i';
}
$oflag = '';
if ($form{'other'} && ($flag eq 'g' || $flag eq 'P')) {
	$oflag = 'o';
}
if ($form{'id'}) {
	chdir("$form{'id'}/cgi-bin");
	if ($?) {	
		print "<h1><font color='#cc0000'>Error</font></h1>\n";
		print "<h3>Couldn't find tag directory in secure mode. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
		print "</body>\n";
		print "</html>\n";
		exit 0;
	}
}
chdir("../..");
if ($?) {	
	print "<h1><font color='#cc0000'>Error</font></h1>\n";
	print "<h3>Couldn't change directory for $form{'type'} search. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
	print "</body>\n";
	print "</html>\n";
	exit 0;
}
#
# Sanity check
# GTAGS and GPATH is indispensable file.
#
$missed = '';
if (! -f 'GTAGS') {
	$missed = 'GTAGS';
} elsif (! -f 'GPATH') {
	$missed = 'GPATH';
} elsif ($flag eq 'r' && ! -f 'GRTAGS') {
	$missed = 'GRTAGS';
} elsif ($flag eq 's' && ! -f 'GSYMS') {
	$missed = 'GSYMS';
} elsif ($flag eq 'I' && ! -f 'ID') {
	$missed = 'ID';
}
if ($missed) {
	print "<h1><font color='#cc0000'>Error</font></h1>\n";
	print "<h3>Tag file ($missed) not found. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
	print "</body>\n";
	print "</html>\n";
	exit 0;
}
local(%ctab) = ('&', '&amp;', '<', '&lt;', '>', '&gt;');
#
# fork and exec global(1) to avoid command substitutions in $pattern.
# The --result=ctags-xid print the file id of the path at the head
# of each line.
#
$flags = $flag . $iflag . $oflag;
if ($flags eq '') {
	open(PIPE, "-|") || exec '/usr/bin/global', '--result=ctags-xid', '-e', $pattern;
} else {
	open(PIPE, "-|") || exec '/usr/bin/global', '--result=ctags-xid', '-'.$flags, '-e', $pattern;
}
if ($?) {	
	print "<h1><font color='#cc0000'>Error</font></h1>\n";
	print "<h3>Cannot execute global. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
	print "</body>\n";
	print "</html>\n";
	exit 0;
}
$pattern =~ s/([&<>])/$ctab{$1}/ge;
print "<h1><font color='#cc0000'>" . $pattern . "</font></h1>\n";
print "Following $words are matched to above pattern.<hr>\n";
$cnt = 0;
local($tag, $lno, $filename);
print "<pre>\n";
#
# Input format:
#
# fid tag   lno filename
# ---------------------------------------------
# 100 main  32 ./main.c main(argc, argv)
#
while (<PIPE>) {
	$cnt++;
	($fid, $tag, $lno, $filename) = split;
	s/^[0-9]+[ \t]+//;
	s/([&<>])/$ctab{$1}/ge;
	s!(^[^ \t]+)!<a href='$htmlbase/S/$fid.html#L$lno'>$1<\/a>!;
	print;
}
close(PIPE);
print "</pre>\n";
if ($cnt == 0) {
	print "<h3>Pattern not found. <a href='$htmlbase/mains.html'>[return]</a></h3>\n";
}
print "<hr>\n";
print "</body>\n";
print "</html>\n";
exit 0;
