/* 
 * Funded by IPA̤Ƨեȥ¤ 2001
 * Copyright (C) 2001-2002 UGAWA Tomoharu
 */

#ifndef _rkhelper_h_include_
#define _rkhelper_h_include_

#ifdef __cplusplus
extern "C" {
#endif


#define RKOPT_US 0
#define RKOPT_JP 1

enum {
  RKMAP_ASCII, RKMAP_SHIFT_ASCII,
  RKMAP_HIRAGANA, RKMAP_KATAKANA,
  RKMAP_WASCII, RKMAP_HANKAKU_KANA,
  NR_RKMAP
};

#define RK_OPTION_SYMBOL  0
#define RK_OPTION_TOGGLE  1
#define RK_OPTION_ERROR  -1

struct rk_option;

/* rk_optionνѹ */
extern struct rk_option *anthy_input_create_rk_option(void);
extern int anthy_input_free_rk_option(struct rk_option *opt);
extern int anthy_input_do_edit_rk_option(struct rk_option* opt, int map,
				  const char* from, const char* to, const char *follow);
extern int anthy_input_do_edit_toggle_option(struct rk_option *opt, char toggle);
extern int anthy_input_do_clear_rk_option(struct rk_option *opt, int enable_default);

/* rk_map */
extern struct rk_map* make_rkmap_ascii(struct rk_option* opt);
extern struct rk_map* make_rkmap_wascii(struct rk_option* opt);
extern struct rk_map* make_rkmap_shiftascii(struct rk_option* opt);
extern struct rk_map* make_rkmap_hiragana(struct rk_option* opt);
extern struct rk_map* make_rkmap_katakana(struct rk_option* opt);
extern struct rk_map* make_rkmap_hankaku_kana(struct rk_option* opt);


#ifdef __cplusplus
}
#endif

#endif /* _rkhelper_h_include_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
