/* features
 *
 * ֹỌ̇̄äƴ
 *
 * Copyright (C) 2006-2007 TABATA Yusuke
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <anthy/segclass.h>
#include <anthy/feature_set.h>
/* for MW_FEATURE* constants */
#include <anthy/splitter.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ARPA_INET_H)
# include <arpa/inet.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_NETINET_IN_H)
# include <netinet/in.h>
#endif

#include "anthy/segclass.h"
#include "anthy/feature_set.h"
#include "anthy/splitter.h"
#endif

#if 0		/* Patched by G-HAL, Wed,05 Oct,2011 - Fri,07 Oct,2011 */
/* ֹ
 *
 * 0-19 饹
 * 30-319(30+SEG_SIZE^2) 饹°
 * 540-579 ¾
 * 580- (1024) °μ
 */

#define CUR_CLASS_BASE 0
#define DEP_TYPE_FEATURE_BASE 20
#define CLASS_TRANS_BASE 30
#define FEATURE_SV 542
#define FEATURE_WEAK 543
#define FEATURE_SUFFIX 544
#define FEATURE_NUM 546
#define FEATURE_CORE1 547
#define FEATURE_HIGH_FREQ 548
#define FEATURE_WEAK_SEQ 549
#define COS_BASE 573
#define DEP_FEATURE_BASE 580

void
anthy_feature_list_init(struct feature_list *fl)
{
  fl->nr = 0;
  fl->size = NR_EM_FEATURES;
}

void
anthy_feature_list_free(_unused struct feature_list *fl)
{
}

void
anthy_feature_list_add(struct feature_list *fl, int f)
{
  if (fl->nr < NR_EM_FEATURES) {
    fl->u.index[fl->nr] = f;
    fl->nr++;
  }
}

int
anthy_feature_list_nr(const struct feature_list *fl)
{
  return fl->nr;
}

int
anthy_feature_list_nth(const struct feature_list *fl, int nth)
{
  return fl->u.index[nth];
}
#endif

static int
cmp_short(const void *p1, const void *p2)
{
  return *((short *)p1) - *((short *)p2);
}

void
anthy_feature_list_sort(struct feature_list *fl)
{
  qsort(fl->u.index, fl->nr, sizeof(fl->u.index[0]),
	cmp_short);
}


#if 0		/* Patched by G-HAL, Wed,05 Oct,2011 - Fri,07 Oct,2011 */
void
anthy_feature_list_set_cur_class(struct feature_list *fl, int cl)
{
  anthy_feature_list_add(fl, CUR_CLASS_BASE + cl);
}

void
anthy_feature_list_set_class_trans(struct feature_list *fl, int pc, int cc)
{
  anthy_feature_list_add(fl, CLASS_TRANS_BASE + pc * SEG_SIZE + cc);
}

void
anthy_feature_list_set_dep_word(struct feature_list *fl, int h)
{
  anthy_feature_list_add(fl, h + DEP_FEATURE_BASE);
}

void
anthy_feature_list_set_dep_class(struct feature_list *fl, int c)
{
  anthy_feature_list_add(fl, c + DEP_TYPE_FEATURE_BASE);
}

void
anthy_feature_list_set_noun_cos(struct feature_list *fl, wtype_t wt)
{
  int c;
  if (anthy_wtype_get_pos(wt) != POS_NOUN) {
    return ;
  }
  c = anthy_wtype_get_cos(wt);
  if (c == COS_SUFFIX) {
    anthy_feature_list_add(fl, COS_BASE + c);
  }
}

/** Ρɤ core_wt Ӥ
 *@param[in]		wt1		ΥΡ
 *@param[in]		wt2		ΥΡ
 *@retval		+1		ۤʤ
 *@retval		0		Ʊ
 *@retval		-1		ۤʤ
 *
 *	Patched by G-HAL
 *		Mon,27 Sep,2010
 */
int anthy_feature_list_cmp_wtype( wtype_t wt1, wtype_t wt2 )
{
  if (POS_NOUN != anthy_wtype_get_pos(wt1)) {
    if (POS_NOUN != anthy_wtype_get_pos(wt2)) {
      return 0;
    } else {
      return -1;
    }
  } else {
    if (POS_NOUN != anthy_wtype_get_pos(wt2)) {
      return +1;
    } else {
      if (COS_SUFFIX != anthy_wtype_get_cos(wt1)) {
	if (COS_SUFFIX != anthy_wtype_get_cos(wt2)) {
	  return 0;
	} else {
	  return -1;
	}
      } else {
	if (COS_SUFFIX != anthy_wtype_get_cos(wt2)) {
	  return +1;
	} else {
	  return 0;
	}
      }
    }
  }
}

void
anthy_feature_list_set_mw_features(struct feature_list *fl, int mask)
{
  if (mask & MW_FEATURE_WEAK_CONN) {
    anthy_feature_list_add(fl, FEATURE_WEAK);
  }
  if (mask & MW_FEATURE_SUFFIX) {
    anthy_feature_list_add(fl, FEATURE_SUFFIX);
  }
  if (mask & MW_FEATURE_SV) {
    anthy_feature_list_add(fl, FEATURE_SV);
  }
  if (mask & MW_FEATURE_NUM) {
    anthy_feature_list_add(fl, FEATURE_NUM);
  }
  if (mask & MW_FEATURE_CORE1) {
    anthy_feature_list_add(fl, FEATURE_CORE1);
  }
  if (mask & MW_FEATURE_HIGH_FREQ) {
    anthy_feature_list_add(fl, FEATURE_HIGH_FREQ);
  }
  if (mask & MW_FEATURE_WEAK_SEQ) {
    anthy_feature_list_add(fl, FEATURE_WEAK_SEQ);
  }
}
#endif

void
anthy_feature_list_print(struct feature_list *fl)
{
  int i;
  printf("features=");
  for (i = 0; i < fl->nr; i++) {
    if (i) {
      printf(",");
    }
    printf("%d", fl->u.index[i]);
  }
  printf("\n");
}

#if 0	/* Patched by G-HAL, Sat,17 Sep,2011 */
static int
compare_line(const void *kp, const void *cp)
{
  const int *f = (const int*) kp;
  const struct feature_freq *c = (const struct feature_freq*) cp;
  int i;
  for (i = 0; i < NR_EM_FEATURES; i++) {
    if (f[i] != (int)ntohl(c->f[i])) {
      return f[i] - ntohl(c->f[i]);
    }
  }
  return 0;
}
#else
static int compare_line( const void* kp, const void* cp )
{
  const int* const f = (const int* const)kp;
  const struct feature_freq* const c = (const struct feature_freq* const)cp;
  int i;
  for (i = 0; i < NR_EM_FEATURES; ++i) {
    const int val = (f[i] - (int)ntohl(c->f[i]));
    if (0 != val) {
      return val;
    }
  }
  return 0;
}
#endif

struct feature_freq *
anthy_find_array_freq(const void *image, int *f, int nr,
		      struct feature_freq *arg)
{
  struct feature_freq *res;
  int nr_lines, i;
  const int *array = (int *)image;
  int n[NR_EM_FEATURES];
  if (!image) {
    return NULL;
  }
  /* ԡ */
  for (i = 0; i < NR_EM_FEATURES; i++) {
    if (i < nr) {
      n[i] = f[i];
    } else {
      n[i] = 0;
    }
  }
  /**/
  nr_lines = ntohl(array[1]);
  res = (struct feature_freq *) bsearch(n, &array[16], nr_lines,
		sizeof(struct feature_freq),
		compare_line);
  if (!res) {
    return NULL;
  }
  for (i = 0; i < NR_EM_FEATURES + 2; i++) {
    arg->f[i] = ntohl(res->f[i]);
  }
  return arg;
}

struct feature_freq *
anthy_find_feature_freq(const void *image,
			const struct feature_list *fl,
			struct feature_freq *arg)
{
  int i, nr;
  int f[NR_EM_FEATURES + 2];

  /* ˥ԡ */
  nr = anthy_feature_list_nr(fl);
  for (i = 0; i < NR_EM_FEATURES + 2; i++) {
    if (i < nr) {
      f[i] = anthy_feature_list_nth(fl, i);
    } else {
      f[i] = 0;
    }
  }
  return anthy_find_array_freq(image, f, NR_EM_FEATURES, arg);
}

void
anthy_init_features(void)
{
}
/* vim:ts=8 sw=2 nomodified:
 */
