/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	㳰Ū˳ؽʤñΥå
 *@date		Thu,21 Aug,2008 - Fri,22 Aug,2008
 *@date		Sat,01 Nov,2008
 *@date		Sun,12 Jun,2009
 *@date		Wed,18 Nov,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 *
 *@note
 *		Anthy ʸɤ UTF-16(UCS4) ʤΤǡ
 *		EUC  ISO-2022 Ǥߤʰ縡ϤǤʤΤǤ
 *		Unicode ϡ˰¸ʸ¤ӽ̵뤷Ƥ뤿ᡢ
 *		оݤưˤơ󤹤뤷ʤΤǤ
 *
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 */

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif

#include "anthy/xstr.h"
#include "exception_word_list.h"


static const char*const	exception_word_list_cstr[] = {
	" ", "",

	"!", "",
	"\"", "",
	"#", "",
	"$", "",
	"%", "",
	"&", "",
	"'", "",
	"(", "",
	")", "",
	"*", "",
	"+", "",
	",", "", "",
	"-", "",
	".", "", "",
	"/", "", "",

	"0", "",
	"1", "",
	"2", "",
	"3", "",
	"4", "",
	"5", "",
	"6", "",
	"7", "",
	"8", "",
	"9", "",
	":", "",
	";", "",
	"<", "",
	"=", "",
	">", "",
	"?", "",

	"@", "",
	"[", "",
	"\\", "", "",
	"]", "",
	"^", "",
	"_", "",
	"`", "",
	"{", "",
	"|", "", "",
	"}", "",
	"~", "", "",

	"", "",
	"", "",

	NULL,	/* ʼ */
};
static xstr*	exception_word_list = NULL;
static size_t	exception_word_list_count = 0;


void anthy_init_exception_word_list( void )
{
	exception_word_list_count = (sizeof(exception_word_list_cstr)/sizeof((exception_word_list_cstr)[0]));
	exception_word_list = (xstr*) calloc( exception_word_list_count, sizeof(xstr) );
	if (!exception_word_list) return;

	{	const char*const*	in_ptr;
		xstr*				out_ptr;
		xstr*				xs;
		for (in_ptr = exception_word_list_cstr, out_ptr = exception_word_list; *in_ptr; in_ptr++, out_ptr++) {
			if (*in_ptr) {
				xs = anthy_cstr_to_xstr( *in_ptr, 0 );
				if (xs) {
					memcpy( out_ptr, xs, sizeof(*out_ptr) );
					free( xs );
				}
			}
		}
	}
	return;
}


void anthy_quit_exception_word_list( void )
{
	if (exception_word_list) {
		xstr*	check_ptr;
		size_t	i;
		for (check_ptr = &(exception_word_list[exception_word_list_count-1]), i = exception_word_list_count; 0 < i; check_ptr--, i--) {
			if (check_ptr->str) {
				free( check_ptr->str );
			}
		}
		free( exception_word_list );
		exception_word_list = NULL;
		exception_word_list_count = 0;
	}
	return;
}


int anthy_ishit_exception_word( const xstr* const xs )
{
	const xstr*	check_ptr;
	size_t		i;

	if (!exception_word_list) return 0;

  #if 0
	for (check_ptr = exception_word_list; check_ptr->len; check_ptr++) {
		if (0 == anthy_xstrcmp( check_ptr, xs )) {
			return 1;
		}
	}
	return 0;
  #elif 0
	for (i = 0; i < xs->len; ++i) {
		for (check_ptr = exception_word_list; check_ptr->len; ++check_ptr) {
			if (xs->str[i] == check_ptr->str[0]) {
				goto HIT;
			}
		}
		return 0;

	  HIT:
		;
	}
	return 1;
  #else
	for (i = 0; i < xs->len; ++i) {
		for (check_ptr = exception_word_list; check_ptr->len; ++check_ptr) {
			if (xs->str[i] == check_ptr->str[0]) {
				return 1;
			}
		}
	}
	return 0;
  #endif
}
#else /* !defined(USE_ICONV) */

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif

#include "anthy/xstr.h"
#include "exception_word_list.h"


void anthy_init_exception_word_list( void )
{
	return;
}

void anthy_quit_exception_word_list( void )
{
	return;
}


int anthy_ishit_exception_word( const xstr* const xs )
{
	const xchar*	xc_ptr;
	size_t			i;

	xc_ptr = xs->str;
	for (i = 0; i < xs->len; ++i, ++xc_ptr) {
		const enum XCT_t type = anthy_get_xchar_type( *xc_ptr );
		if (XCT_DONTLEARN & type) {
			return 1;
		}
	}
	return 0;
}

#endif /* !defined(USE_ICONV) */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
