/**@file
 *			Patches for the Anthy, by G-HAL
 *@brief	ؽǡ metaword 
 *@date		Thu,21 Aug,2008
 *@date		Fri,17 Oct,2008
 *@date		Tue,04 Nov,2008
 *@date		Wed,05 Nov,2008
 *@date		Fri,07 Nov,2008 - Sat,08 Nov,2008
 *@date		Fri,14 Nov,2008
 *@date		Mon,17 Nov,2008
 *@date		Sat,17 Jan,2009
 *@date		Sat,24 Jan,2009
 *@date		Sun,08 Feb,2009 - Mon,09 Feb,2009
 *@date		Thu,19 Feb,2009
 *@date		Sat,21 Feb,2009
 *@date		Wed,25 Feb,2009
 *@date		Sat,25 Apr,2009 - Mon,27 Apr,2009
 *@date		Fri,01 May,2009, Sun,03 May,2009 - Mon,04 May,2009
 *@date		Sun,17 May,2009
 *@date		Tue,19 May,2009 - Wed,20 May,2009
 *@date		Sun,07 Jun,2009
 *@date		Tue,04 Aug,2009 - Wed,05 Aug,2009
 *@date		Thu,27 Aug,2009
 *@date		Sat,17 Oct,2009
 *@date		Sat,14 Nov,2009 - Sun,15 Nov,2009
 *@date		Wed,18 Nov,2009
 *@date		Fri,08 Oct,2010
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ALLOCA_H)
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/anthy.h"
#include "anthy/logger.h"
#include "anthy/settings.h"
#include "anthy/xstr.h"
#include "anthy/record.h"
#include "anthy/cand_ent_score.h"
#include "src-splitter/lattice.h"
#include "src-splitter/metaword.h"



/** ؽǡ metaword Υ롣
 *@param			sw				̾ʸ᥹(0)ؽ(1)
 *@param			frequency		
 *@param			timestamp		ॹ
 *@return							
 *
 *	Patches by G-HAL
 *		Tue,04 Nov,2008
 *		Wed,05 Nov,2008
 *		Sat,17 Jan,2009
 *		Thu,19 Feb,2009
 *		Sun,15 Nov,2009
 *		Fri,08 Oct,2010
 */
static int calc_metawordscore_by_learn( int sw, int frequency, anthy_time_t timestamp )
{
	static const int64_t	Seconds_in_a_Month = 60*60*24*30;
	int64_t					tmp = anthy_settings.timestamp.currentsession - timestamp;
	int64_t					tmp_score;
	if (timestamp <= 0) {
		return 0;
	}
	if (!sw) {
		return 1000;
	}

	if (tmp < 0) {
		return OCHAIRE_SCORE + OCHAIRE_SCORE;
	} else if (tmp < Seconds_in_a_Month) {
		return OCHAIRE_SCORE + OCHAIRE_SCORE - tmp;
	}

	tmp_score = OCHAIRE_SCORE + OCHAIRE_SCORE - Seconds_in_a_Month - (tmp - Seconds_in_a_Month) / 60;
	if (tmp_score < OCHAIRE_SCORE) {
		return OCHAIRE_SCORE;
	}
	return tmp_score;
}



/** metaword  metaword 򸫤Ĥơʣդؤ򤹤롣
 *@param[in,out]	sc				ʸǡ
 *@param[in]		mw0				metaword
 *@retval			-1				
 *@retval			0				metaword  metaword Ĥʤ
 *
 *	Patches by G-HAL
 *		Fri,01 May,2009, Sun,03 May,2009 - Mon,04 May,2009
 *		Sun,17 May,2009
 *		Wed,20 May,2009
 *		Thu,27 Aug,2009
 */
static int commit_mw_withdep( struct splitter_context* const sc, struct meta_word* const mw0 )
{
	int		hit = 0;
	if ((mw0->len < 1)
		|| (NULL == mw0->cand_hint.str)
		|| (mw0->cand_hint.len < 1)
	) {
		return 0;
	}
	{	const xchar* const		yomi_index = sc->ce[0].c;
		const int				cand_base_len = mw0->len;
		const struct meta_word*	mw;
		for (mw = sc->word_split_info->cnode[mw0->from].mw; mw; mw = mw->next) {
			if (mw->can_use <= ng) {
				continue;
			}
			if (mw->len != cand_base_len) {
				continue;
			}
			if ((MW_learned_min <= mw->type) && (mw->type <= MW_learned_max)) {
				continue;
			}
			if (MW_DUMMY == mw->type) {
				continue;
			}
			if (mw_is_match(yomi_index, mw0, mw)) {
				/*  */
				struct meta_word* const mw_new = alloc_metaword( sc );
				mw_new->from                    = mw0->from;
				mw_new->len                     = mw->len;
				mw_new->score                   = mw0->score;
				mw_new->struct_score            = mw0->struct_score;
				mw_new->extra_score             = mw0->extra_score;
				mw_new->dep_word_hash           = mw->dep_word_hash;
				mw_new->mw_features             = mw->mw_features;
				mw_new->core_wt                 = mw->core_wt;
				mw_new->dep_class               = mw->dep_class;
				mw_new->seg_class               = mw->seg_class;
				mw_new->can_use                 = mw->can_use;
				mw_new->type                    = mw0->type;
				mw_new->ochaire_opposite        = mw0->ochaire_opposite;
				mw_new->wl                      = NULL;	/* mw->wl; wl ĤȡΥ󥰤 wl ѤƹԤƤޤ */
				mw_new->ochaire_phrase_score    = mw0->ochaire_phrase_score;
				mw_new->ochaire_total_len       = mw0->ochaire_total_len;
				mw_new->mw1_left                = mw0->mw1_left;
				mw_new->mw1_right               = mw0->mw1_right;
				mw_new->mw1                     = mw0->mw1;
				mw_new->mw2                     = mw0->mw2;
				mw_new->cand_hint_freq          = mw->cand_hint_freq;
				mw_new->cand_hint_learned_freq  = mw0->cand_hint_learned_freq;
				mw_new->cand_hint_depth_of_dep  = mw->cand_hint_depth_of_dep;
				mw_new->cand_hint_length_of_dep = mw->cand_hint_length_of_dep;
				mw_new->nr_parts                = 0;	/* mw->nr_parts; wl ϻäƤʤ */
				anthy_xstrcat( &(mw_new->cand_hint), &(mw0->cand_hint) );
				anthy_commit_meta_word( sc, mw_new );
				hit = 1;
				/* break; */
			}
		}
	  #if defined(DEBUG)
		if (!hit) {
			char	buf[256];
			anthy_snputxstr(buf, _number_(buf)-1, &(mw0->cand_hint), ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
			anthy_log(1, "commit_mw_withdep(): *** BROKEN DATA *** Unknown metaword:'%s'\n", buf );
		}
	  #endif
	}
	return hit;
}



/** metaword °ղäʪ metaword 򸫤Ĥơʣդؤ򤹤롣
 *@param[in,out]	sc				ʸǡ
 *@param[in]		mw0				ˤ metaword
 *@param			ochaire1_mode	OCHAIRE1 롼ŬѤ⡼(1)вǤOKʥ⡼(0)
 *@retval			-1				
 *@retval			0				metaword  metaword Ĥʤ
 *
 *	Patches by G-HAL
 *		Mon,27 Apr,2009
 *		Fri,01 May,2009, Sun,03 May,2009 - Mon,04 May,2009
 *		Sun,17 May,2009
 *		Tue,19 May,2009 - Wed,20 May,2009
 *		Wed,05 Aug,2009
 *		Thu,27 Aug,2009
 *		Thu,19 Aug,2010
 */
static int expand_mw_withdep( struct splitter_context* const sc, const struct meta_word* const mw0, int ochaire1_mode )
{
	int		hit = 0;
	if (!anthy_settings.anthy_mode.lattice.autoexpand_deps) {
		return 0;
	}
	if ((mw0->len < 1)
		|| (NULL == mw0->cand_hint.str)
		|| (mw0->cand_hint.len < 1)
	) {
		return 0;
	}
	{	const xchar* const		yomi_index = sc->ce[0].c;
		const int				cand_base_len = mw0->len;
		const struct meta_word*	mw;
		for (mw = sc->word_split_info->cnode[mw0->from].mw; mw; mw = mw->next) {
			if (mw->can_use <= ng) {
				continue;
			}
			if (mw->len <= cand_base_len) {
				continue;
			}
			if ((MW_learned_min <= mw->type) && (mw->type <= MW_learned_max)) {
				continue;
			}
			if (MW_DUMMY == mw->type) {
				continue;
			}
			if (mw->dep_class == DEP_PART_GUESS) {
				continue;
			}
			if ((cand_base_len == (mw->len - mw->cand_hint_length_of_dep))
				&& mw_is_match( yomi_index, mw0, mw )
			) {
				if (ochaire1_mode) {
					if ((0 != mw->from) || (mw->len != sc->char_count)) {
						continue;
					}
				}
				/*  */
				struct meta_word* const mw_new = alloc_metaword( sc );
				mw_new->from                    = mw0->from;
				mw_new->len                     = mw->len;
				mw_new->score                   = mw0->score;
				mw_new->struct_score            = mw0->struct_score;
				mw_new->extra_score             = mw0->extra_score;
				mw_new->dep_word_hash           = mw->dep_word_hash;
				mw_new->mw_features             = mw->mw_features;
				mw_new->core_wt                 = mw->core_wt;
				mw_new->dep_class               = mw->dep_class;
				mw_new->seg_class               = mw->seg_class;
				mw_new->can_use                 = mw->can_use;
				mw_new->type                    = mw0->type;
				mw_new->ochaire_opposite        = mw0->ochaire_opposite;
				mw_new->wl                      = NULL; /* mw->wl; wl ĤȡΥ󥰤 wl ѤƹԤƤޤ */
				mw_new->ochaire_phrase_score    = mw0->ochaire_phrase_score;
				mw_new->ochaire_total_len       = mw0->ochaire_total_len;
				mw_new->mw1_left                = mw0->mw1_left;
				mw_new->mw1_right               = mw0->mw1_right;
				mw_new->mw1                     = mw0->mw1;
				mw_new->mw2                     = mw0->mw2;
				mw_new->cand_hint.str           = NULL;
				mw_new->cand_hint.len           = 0;
				mw_new->cand_hint_freq          = mw->cand_hint_freq;
				mw_new->cand_hint_learned_freq  = mw0->cand_hint_learned_freq;
				mw_new->cand_hint_depth_of_dep  = mw->cand_hint_depth_of_dep;
				mw_new->cand_hint_length_of_dep = mw->cand_hint_length_of_dep;
				mw_new->nr_parts                = 0; /* mw->nr_parts; wl ϻäƤʤ */
				{	xstr tmp;
					anthy_xstrcat( &(mw_new->cand_hint), &(mw0->cand_hint) );
					tmp.len = (mw->len - cand_base_len);
					tmp.str = sc->ce[mw0->from + cand_base_len].c;
					anthy_xstrcat( &(mw_new->cand_hint), &tmp );
				}
				anthy_commit_meta_word( sc, mw_new );
				hit = 1;
			}
		}
	}
	return hit;
}



/** CAND_HISTORYؽ metaword 
 *@param[in,out]	sc				metaword δ¤
 *
 *	Patches by G-HAL
 *		Tue,04 Nov,2008
 *		Sat,24 Jan,2009
 *		Sat,21 Feb,2009
 *		Sun,26 Apr,2009 - Mon,27 Apr,2009
 *		Fri,01 May,2009
 *		Sat,14 Nov,2009
 */
void anthy_make_metaword_by_candhistory( struct splitter_context* const sc )
{
	size_t		i, j;
	int			k;
	xstr		xs;
	const xstr*	key;
	int			nr;
	int			phrase_score;
  #if defined(DEBUG) && (2 <= DEBUG)
	char		buf[256];
  #endif
	if (-1 == anthy_select_section(CAND_HISTORY, 0)) {
		return;
	}

	for (i = 0; i < sc->char_count; ++i) {
		for (j = (sc->char_count - i); 1 <= j; --j) {
			int		mw_commited = 0;
			xstr*	err_xs = NULL;
			/* ؽǡ */
			xs.len = j;
			xs.str = sc->ce[i].c;
			if (1 < j) {
				if (0 != anthy_select_longest_row(&xs)) {
					j = 2;
					continue;
					/* ա anthy_select_longest_row() ϡʸʾΤ߸ */
				}
			} else {
				if (0 != anthy_select_row(&xs,0)) {
					break;
				}
			}
			key = anthy_get_index_xstr();
			nr = anthy_get_nr_values();
		  #if defined(DEBUG) && (2 <= DEBUG)
			anthy_snputxstr(buf, _number_(buf)-1, key, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
			fprintf(stderr,"MW_CANDHISTORY:%d'%s'\n", key->len, buf );
		  #endif
			j = key->len;
			phrase_score = 0;
			for (k = 0; k < nr; ++k) {
				struct meta_word*	mw;
				const xstr*			h;
				int					frequency = 0;
				const anthy_time_t	timestamp = anthy_get_nth_int64( k );
				if (0 != timestamp) {
					k++; if (nr <= k) break;
					frequency = anthy_get_nth_value( k );
					if (0 != frequency) {
						k++; if (nr <= k) break;
					} else {
						h = anthy_get_nth_xstr( k );
						if (NULL == h) {
							k++; if (nr <= k) break;
						} else {
							/* May be broken data. */
						}
					}
				}
				h = anthy_get_nth_xstr( k );
				if ((NULL == h) || (NULL == h->str) || (h->len < 1)) {
					/* May be broken data. */
					break;
				}
				++ phrase_score;
				/* ƱۻޤȤƣĤ metaword ˤ١
				 * frequency  timestamp ϸѤʪǤϤʤ
				 * row̤ʪȤ
				 * ġƱΰۻ̤ metaword ˤϡ
				 * ̤ frequency  timestamp Ȥ
				 */
				/* frequency = anthy_get_row_frequency(); */
				/* timestamp = anthy_get_row_timestamp(); */
				/* metaword  */
				mw = alloc_metaword( sc );
				mw->from          = i;
				mw->len           = key->len;
				mw->score         = calc_metawordscore_by_learn( anthy_settings.anthy_mode.lattice.with_candhistory, frequency, timestamp );
				mw->type          = MW_CANDHISTORY;
				mw->ochaire_phrase_score   = (anthy_settings.limit.historyrecord_maxdepth - phrase_score) * 100 / anthy_settings.limit.historyrecord_maxdepth;
				mw->ochaire_total_len      = key->len;
				mw->cand_hint_learned_freq = frequency;
				mw->cand_hint.str = (xchar*) malloc( sizeof(xchar) * h->len );
				anthy_xstrcpy( &mw->cand_hint, h );
				mw_commited = commit_mw_withdep( sc, mw );
				if (!mw_commited) {
					anthy_commit_meta_word( sc, mw );
					err_xs = &(mw->cand_hint);
				}
				/* break;*/
			}
			if (anthy_settings.anthy_mode.enable_error_record && err_xs) {
				if (!anthy_select_section(ERROR, 1)) {
					if (!anthy_select_row_with_learn(key,1,0)) {
						char buf[256];
						xstr* msg;
						anthy_set_nth_xstr( 0, err_xs );
						{	snprintf( buf, sizeof(buf), "cand_hint_freq is less than 1." );
							msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
							anthy_set_nth_xstr( 1, msg );
							anthy_free_xstr( msg );
						}
						{	snprintf( buf, sizeof(buf), "src-splitter/metaword_bylearn.c:anthy_make_metaword_by_candhistory()" );
							msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
							anthy_set_nth_xstr( 1, msg );
							anthy_free_xstr( msg );
						}
						anthy_mark_row_used();
					}
				}
				anthy_select_section(CAND_HISTORY, 0);
			}
		}
	}
	return;
}



/** OCHAIREؽ metaword 
 *@param[in,out]	sc				ʸ
 *@param			from			ߤʤγϰ
 *@param			len				ߤʤĹ
 *
 *	Patched by G-HAL
 *		Tue,04 Nov,2008
 *		Fri,14 Nov,2008
 *		Mon,17 Nov,2008
 *		Sat,24 Jan,2009
 *		Sun,08 Feb,2009 - Mon,09 Feb,2009
 *		Thu,19 Feb,2009
 *		Sat,21 Feb,2009
 *		Sat,25 Apr,2009
 *		Mon,27 Apr,2009
 *		Fri,01 May,2009 - Sun,03 May,2009
 *		Sat,09 May,2009
 *		Tue,04 Aug,2009 - Wed,05 Aug,2009
 *		Thu,27 Aug,2009
 *		Sun,15 Nov,2009
 *		Wed,18 Aug,2010 - Thu,19 Aug,2010
 */
static void make_ochaire_metaword( struct splitter_context* const sc, int from, int len )
{
	const int count = anthy_get_nth_value(0);
	struct meta_word** const mw = alloca( count * sizeof(struct meta_word*) );
	const int freq_continuous   = anthy_get_nth_value(1 + count * 2 + 0);
	const int freq_withindep    = anthy_get_nth_value(1 + count * 2 + 1);
	const int freq_withoutindep = anthy_get_nth_value(1 + count * 2 + 2);
	const int freq_withoutdep   = anthy_get_nth_value(1 + count * 2 + 3);
	const int freq_withdep      = anthy_get_nth_value(1 + count * 2 + 4);
	const enum metaword_type mw_type
			= (0 == freq_withoutdep)
			? ((0 == freq_withindep) ? MW_OCHAIREwithoutINDEP : MW_OCHAIRE)
			: ((0 == freq_withindep) ? MW_OCHAIREwithoutINDEPwithoutDEP : MW_OCHAIREwithoutDEP);
	const int frequency = anthy_get_row_frequency();
	const anthy_time_t timestamp = anthy_get_row_timestamp();
	int		s;
	int		j;
	int		seg_len;
	int		mw_len = 0;
	xstr*	xs;
	int		mw_commited;
	xstr*	err_xs = NULL;

	{	/* Ϣܾ */
		if (NULL == mw) {
			return;
		}
		for (j = (count - 1); 0 <= j; --j) {
			mw[j] = alloc_metaword( sc );
			if (NULL == mw[j]) {
				return;
			}
		}
		for (j = (count - 1); 1 <= j; --j) {
			mw[j]->mw1_left    = mw[j-1];
			mw[j-1]->mw1_right = mw[j];
			mw[j-1]->mw1       = mw[j];
		}
	}

	if (timestamp <= 0) {
		/* ե饰դǡ */
		return;
	}
	if ((1 + count * 2 + 5) != anthy_get_nr_values()) {
		/* OCHAIREؽΥǡ㤦ΤŬѤʤ */
		return;
	}
	if ((0 == freq_withindep) && (0 == freq_withoutindep)) {
		/* Ѵ̡ܺѴ̡ˤγؽʤΤǡ̾ϢʸˤŬѤʤ */
		return;
	}

	/* ֱʸΤʸιפ׻ */
	for (s = 0, j = 0; j < count - 1; ++j) {
		s += anthy_get_nth_value( j * 2 + 1 );
	}
	if (len != (s + anthy_get_nth_value(j * 2 + 1))) {
		/* May be broken data. */
		char				buf[256];
		const xstr* const	key = anthy_get_index_xstr();
		anthy_snputxstr(buf, _number_(buf)-1, key, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
		anthy_log(1, "make_ochaire_metaword(): *** BROKEN DATA *** OCHAIRE:'%s'\n", buf );
		return;
	}

	/* ֱʸmetaword */
	j = count - 1;
	xs = anthy_get_nth_xstr( j * 2 + 2 );
	if (!xs) {
		return;
	}
	{	struct meta_word* const mw_cur = mw[j];
		seg_len = anthy_get_nth_value( j * 2 + 1 );
		mw_cur->from  = from + s;
		mw_cur->len   = seg_len;
		mw_cur->score = calc_metawordscore_by_learn( anthy_settings.anthy_mode.lattice.with_ochaire, frequency, timestamp );
		mw_cur->type  = mw_type;
		mw_cur->ochaire_phrase_score   = count * 100;
		mw_cur->ochaire_total_len      = len;
		mw_cur->cand_hint_learned_freq = frequency;
		mw_cur->cand_hint.str = (xchar*) malloc( sizeof(xchar) * (xs->len) );
		anthy_xstrcpy( &(mw_cur->cand_hint), xs );
		if (1 == count) {
			do {	/* OCHAIRE1 ⡼ */
				if (0 < from) {
					break;
				}
				if (0 < freq_withoutdep) {
					mw_commited = expand_mw_withdep( sc, mw_cur, 1 );
					if ((!mw_commited) && (0 == freq_withdep)) {
						err_xs = &(mw_cur->cand_hint);
					}
				}
				if (0 < freq_withdep) {
					if (len == sc->char_count) {
						mw_cur->type = ((0 == freq_withindep) ? MW_OCHAIREwithoutINDEP : MW_OCHAIRE);
						mw_commited = commit_mw_withdep( sc, mw_cur );
						if (!mw_commited) {
							err_xs = &(mw_cur->cand_hint);
						}
					}
				}
			} while(0);
		} else {
			/* OCHAIRE2over ⡼ */
			if (0 < freq_withoutdep) {
				mw_commited = expand_mw_withdep( sc, mw_cur, 0 );
				if (!mw_commited) {
					mw_commited = commit_mw_withdep( sc, mw_cur );
					if (!mw_commited) {
						anthy_commit_meta_word( sc, mw_cur );
						err_xs = &(mw_cur->cand_hint);
					}
				}
			}
			if (0 != freq_withdep) {
				mw_cur->type = ((0 == freq_withindep) ? MW_OCHAIREwithoutINDEP : MW_OCHAIRE);
				mw_commited = commit_mw_withdep( sc, mw_cur );
				if (!mw_commited) {
					anthy_commit_meta_word( sc, mw_cur );
					err_xs = &(mw_cur->cand_hint);
				}
			}
		}
	}

	mw_len += seg_len;
	/* ʳʸmetaword */
	for (--j; 0 <= j; --j) {
		struct meta_word* const mw_cur = mw[j];
		seg_len = anthy_get_nth_value( j * 2 + 1 );
		s -= seg_len;
		xs = anthy_get_nth_xstr( j * 2 + 2 );
		if (!xs) {
			return;
		}
		mw_cur->from  = from + s;
		mw_cur->len   = seg_len;
		mw_cur->score = calc_metawordscore_by_learn( anthy_settings.anthy_mode.lattice.with_ochaire, frequency, timestamp );
		mw_cur->type  = mw_type;
		mw_cur->ochaire_phrase_score   = count * 100;
		mw_cur->ochaire_total_len      = len;
		mw_cur->cand_hint_learned_freq = frequency;
		mw_cur->cand_hint.str = (xchar*) malloc( sizeof(xchar) * (xs->len) );
		anthy_xstrcpy( &(mw_cur->cand_hint), xs );
		if ((0 < j) || (0 != freq_withindep)) {
			mw_commited = commit_mw_withdep( sc, mw_cur );
			if (!mw_commited) {
				anthy_commit_meta_word( sc, mw_cur );
				if ((0 < j) || (freq_withoutindep < 1)) {
					err_xs = &(mw_cur->cand_hint);
				}
			}
		}
		mw_len += seg_len;
	}

	if (anthy_settings.anthy_mode.enable_error_record && err_xs) {
		const xstr* const key = anthy_get_index_xstr();
		if (!anthy_select_section(ERROR, 1)) {
			if (!anthy_select_row_with_learn(key,1,0)) {
				char buf[256];
				xstr* msg;
				anthy_set_nth_xstr( 0, err_xs );
				{	snprintf( buf, sizeof(buf), "cand_hint_freq is less than 1." );
					msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
					anthy_set_nth_xstr( 1, msg );
					anthy_free_xstr( msg );
				}
				{	snprintf( buf, sizeof(buf), "src-splitter/metaword_bylearn.c:make_ochaire_metaword()" );
					msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
					anthy_set_nth_xstr( 1, msg );
					anthy_free_xstr( msg );
				}
				anthy_mark_row_used();
			}
		}
		anthy_select_section(OCHAIRE, 0);
	}
	return;
}



/** ŬѲǽ OCHAIREؽ򸡺
 *@param[in,out]	sc				ʸ
 *
 *	Patched by G-HAL
 *		Thu,21 Aug,2008
 *		Fri,17 Oct,2008
 *		Fri,07 Nov,2008 - Sat,08 Nov,2008
 */
void anthy_make_metaword_by_ochaire( struct splitter_context* const sc )
{
	size_t		i, j;
	xstr		xs;
	const xstr*	key;
  #if defined(DEBUG) && (2 <= DEBUG)
	char		buf[256];
  #endif
	if (-1 == anthy_select_section(OCHAIRE, 0)) {
		return;
	}

	for (i = 0; i < sc->char_count; ++i) {
		for (j = (sc->char_count - i); 2 <= j; --j) {
			/* ؽǡ */
			xs.len = j;
			xs.str = sc->ce[i].c;
			if (0 != anthy_select_longest_row(&xs)) {
				break;
			}
			key = anthy_get_index_xstr();
		  #if defined(DEBUG) && (2 <= DEBUG)
			anthy_snputxstr(buf, _number_(buf)-1, key, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
			fprintf(stderr,"MW_OCHAIRE:%d'%s'\n", key->len, buf );
		  #endif
			j = key->len;
			make_ochaire_metaword( sc, i, key->len );
		}
	}
	return;
}



/** Ƥ̣ơOCHAIREؽ metaword 
 *@param[in,out]	sc				ʸ
 *@param			prev_yomi_len	ƬʸɤߤĹѴ̡
 *@param			yomi_len		ɤߤʸѴ̤ޤ
 *
 *	Patched by G-HAL
 *		Sun,26 Apr,2009 - Mon,27 Apr,2009
 *		Mon,27 Apr,2009
 *		Fri,01 May,2009, Sun,03 May,2009
 *		Wed,05 Aug,2009
 *		Sun,15 Nov,2009
 *
 *@comment
 *		ʸOCHAIREʳŬѤʤġļȴ
 */
static void make_keepaliveochaire_metaword( struct splitter_context* const sc, size_t prev_yomi_len, size_t yomi_len )
{
	const int			count = anthy_get_nth_value(0);
	const anthy_time_t	timestamp = anthy_get_row_timestamp();
	xstr*				xs;

	if (timestamp <= 0) {
		/* Ѥ߳ؽǡʤΤŬѤʤ */
		return;
	}
	if ((1 + count * 2 + 5) != anthy_get_nr_values()) {
		/* OCHAIREؽΥǡ㤦ΤŬѤʤ */
		return;
	}
	if (2 != count) {
		/* ʸOCHAIREʳŬѤʤġļȴ */
		return;
	}

	if (prev_yomi_len != anthy_get_nth_value(0 * 2 + 1)) {
		/* ʸζڤ֤ʤ */
		return;
	}
	{	/* ʸѴ̤ΰȽ */
		xstr	prev_cand;
		prev_cand.str = sc->prev_commit.cand.str;
		prev_cand.len = sc->prev_commit.cand.len;
		xs = anthy_get_nth_xstr( 0 * 2 + 2 );
		if (prev_cand.len < xs->len) {
			return;
		}
		prev_cand.str += (prev_cand.len - xs->len);
		prev_cand.len = xs->len;
		if (0 != anthy_xstrcmp(xs,&prev_cand)) {
			return;
		}
	}
	if ((yomi_len - prev_yomi_len) != anthy_get_nth_value(1 * 2 + 1)) {
		/* May be broken data. */
		char				buf[256];
		const xstr* const	key = anthy_get_index_xstr();
		anthy_snputxstr(buf, _number_(buf)-1, key, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
		anthy_log(1, "make_keepaliveochaire_metaword(): *** BROKEN DATA *** OCHAIRE:'%s'\n", buf );
		return;
	}

	{	/* metaword */
		struct meta_word* mw;
		const int freq_continuous   = anthy_get_nth_value( 1 + count * 2 + 0 );
		const int freq_withindep    = anthy_get_nth_value( 1 + count * 2 + 1 );
		const int freq_withoutindep = anthy_get_nth_value( 1 + count * 2 + 2 );
		const int freq_withoutdep   = anthy_get_nth_value( 1 + count * 2 + 3 );
		const int freq_withdep      = anthy_get_nth_value( 1 + count * 2 + 4 );
		const enum metaword_type mw_type
				= (ANTHY_LATTICE_MODE_VITERBI == anthy_settings.anthy_mode.lattice.mode)
				? (
				   (0 == freq_withoutdep)
				   ? ((0 == freq_withindep) ? MW_OCHAIRE : MW_OCHAIRE)
				   : ((0 == freq_withindep) ? MW_OCHAIREwithoutDEP : MW_OCHAIREwithoutDEP))
				: ((0 == freq_withoutdep)
				   ? ((0 == freq_withindep) ? MW_OCHAIREwithoutINDEP : MW_OCHAIRE)
				   : ((0 == freq_withindep) ? MW_OCHAIREwithoutINDEPwithoutDEP : MW_OCHAIREwithoutDEP));
		const int frequency = anthy_get_row_frequency();
		int		mw_commited;
		xstr*	err_xs = NULL;

		xs = anthy_get_nth_xstr( 1 * 2 + 2 );
		if (!xs) {
			return;
		}
		mw = alloc_metaword( sc );
		mw->from  = 0;
		mw->len   = anthy_get_nth_value( 1 * 2 + 1 );
		mw->score = calc_metawordscore_by_learn( anthy_settings.anthy_mode.lattice.with_ochaire, frequency, timestamp );
		mw->type  = mw_type;
		mw->ochaire_phrase_score   = count * 100;
		mw->ochaire_total_len      = yomi_len;
		mw->cand_hint_learned_freq = frequency;
		mw->cand_hint.str = (xchar*) malloc( sizeof(xchar) * (xs->len) );
		anthy_xstrcpy( &(mw->cand_hint), xs );
		if (0 != freq_withdep) {
			mw_commited = commit_mw_withdep( sc, mw );
			if (!mw_commited) {
				anthy_commit_meta_word( sc, mw );
				err_xs = &(mw->cand_hint);
			}
		}
		if (0 < freq_withoutdep) {
			mw_commited = expand_mw_withdep( sc, mw, 0 );
			if (!mw_commited) {
				mw_commited = commit_mw_withdep( sc, mw );
				if (!mw_commited) {
					anthy_commit_meta_word( sc, mw );
					err_xs = &(mw->cand_hint);
				}
			}
		}
		if (anthy_settings.anthy_mode.enable_error_record && err_xs) {
			const xstr* const key = anthy_get_index_xstr();
			if (!anthy_select_section(ERROR, 1)) {
				if (!anthy_select_row_with_learn(key,1,0)) {
					char buf[256];
					xstr* msg;
					anthy_set_nth_xstr( 0, err_xs );
					{	snprintf( buf, sizeof(buf), "cand_hint_freq is less than 1." );
						msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
						anthy_set_nth_xstr( 1, msg );
						anthy_free_xstr( msg );
					}
					{	snprintf( buf, sizeof(buf), "src-splitter/metaword_bylearn.c:make_keepaliveochaire_metaword()" );
						msg = anthy_cstr_to_xstr( buf, ANTHY_COMPILED_ENCODING );
						anthy_set_nth_xstr( 1, msg );
						anthy_free_xstr( msg );
					}
					anthy_mark_row_used();
				}
			}
			anthy_select_section(OCHAIRE, 0);
		}
	}
	return;
}



/** Ƥ̣ơOCHAIREؽ򸡺
 *@param[in,out]	sc				ʸ
 *
 *	Patched by G-HAL
 *		Sun,26 Apr,2009
 */
void anthy_make_metaword_by_keepaliveochaire( struct splitter_context* const sc )
{
	const xstr* const	prev_yomi = &(sc->prev_commit.yomi);
	if ((!anthy_settings.anthy_mode.keepalive.enable_refer_ochaire)
		|| (prev_yomi->len <= 0) || (sc->prev_commit.cand.len <= 0)
		|| (-1 == anthy_select_section(OCHAIRE, 0))
	) {
		return;
	}

	{	size_t	i, j;
		xstr	yomi;
		xstr*	key;
		xstr	xs;
	  #if defined(DEBUG) && (2 <= DEBUG)
		char	buf[256];
	  #endif

		{	xstr	tmp;
			yomi.len = 0;
			yomi.str = NULL;
			anthy_xstrcat( &yomi, prev_yomi );
			tmp.len = sc->char_count;
			tmp.str = sc->ce[0].c;
			anthy_xstrcat( &yomi, &tmp );
		}

		/* ؽǡ */
		for (i = 0; i < prev_yomi->len; ++i) {
			xs.str = &(yomi.str[i]);
			for (j = 0; j < sc->char_count; ++j) {
				xs.len = yomi.len - i - j;
				if (0 != anthy_select_longest_row(&xs)) {
					break;
				}
				key = anthy_get_index_xstr();
				j = yomi.len - i - key->len;
				if (key->len <= (prev_yomi->len - i)) {
					/* ƤǴ뤷ƤΤŬѤʤ */
					break;
				}
			  #if defined(DEBUG) && (2 <= DEBUG)
				anthy_snputxstr(buf, _number_(buf)-1, key, ANTHY_COMPILED_ENCODING );	buf[_number_(buf)-1] = '\x0';
				anthy_log(1, "MW_OCHAIRE(KeepAlive):%d'%s'\n", key->len, buf );
			  #endif
				make_keepaliveochaire_metaword( sc, (prev_yomi->len - i), key->len );
			}
		}

		anthy_free_xstr_str( &yomi );
	}
	return;
}



/** Ƥ̣ơʣ򸡺
 *@param[in,out]	sc				ʸ
 *
 *	Patched by G-HAL
 *		Sun,26 Apr,2009
 *		Mon,27 Apr,2009
 *		Sun,03 May,2009
 */
void anthy_make_metaword_by_keepalivecompound( struct splitter_context* const sc )
{
	const xstr* const	prev_yomi = &(sc->prev_commit.yomi);
	if ((!anthy_settings.anthy_mode.keepalive.enable_refer_compound)
		|| (prev_yomi->len <= 0) || (sc->prev_commit.cand.len <= 0)
	) {
		return;
	}
	{	size_t				j, i, k, top_seg_num;
		xstr				yomi;
		xstr				cand;
		xstr				xs;
		seq_ent_t			se;
		compound_ent_t		ce;
		int					seg_num;
		int					len, yomi_len, cand_len;
		struct meta_word*	mw;

		{	xstr	tmp;
			yomi.len = 0;
			yomi.str = NULL;
			anthy_xstrcat( &yomi, prev_yomi );
			tmp.len = sc->char_count;
			tmp.str = sc->ce[0].c;
			anthy_xstrcat( &yomi, &tmp );
		}
		anthy_gang_load_dic( &yomi, sc->is_reverse );

		for (j = yomi.len; prev_yomi->len < j; --j) {
			yomi.len = j;
			se = anthy_get_seq_ent_from_xstr( &yomi, sc->is_reverse );
			if (!se) {
				continue;
			}
			if (anthy_has_compound_ents(se)) {
				const int ent_num = anthy_get_nr_dic_ents( se, NULL );
				for (i = 0; i < ent_num; ++i) {
					if (!anthy_get_nth_dic_ent_is_compound(se, i)) {
						continue;
					}
					ce = anthy_get_nth_compound_ent( se, i );
					seg_num = anthy_compound_get_nr_segments( ce );
					cand.str = sc->prev_commit.cand.str;
					cand.len = sc->prev_commit.cand.len;
					cand_len = cand.len;
					yomi_len = prev_yomi->len;
					for (top_seg_num = 0; top_seg_num < seg_num; ++top_seg_num) {
						len = anthy_compound_get_nth_segment_len( ce, top_seg_num );
						if (yomi_len < len) {
							top_seg_num = seg_num;
							break;
						}

						anthy_compound_get_nth_segment_xstr( ce, top_seg_num, &xs );
						if (cand_len < xs.len) {
							top_seg_num = seg_num;
							break;
						}
						if (0 != anthy_xstrncmp(&xs,&cand,xs.len)) {
							top_seg_num = seg_num;
							break;
						}

						/* ʬפ */
						yomi_len -= len;
						cand.str += xs.len;
						cand.len -= xs.len;
						cand_len -= xs.len;
						if ((0 == yomi_len) && (0 == cand_len)) {
							/* פ */
							break;
						}
					}
					++ top_seg_num;
					if (seg_num <= top_seg_num) {
						continue;
					}

					/* ʣΡĤʬ metaword ˤ
					 * ġ word_list ˤʬ䤷 metaword ˤɤΤɡ
					 * ݤˤʤä
					 */
					len = 0;
					cand.str = NULL;
					cand.len = 0;
					for (k = top_seg_num; k < seg_num; ++k) {
						len += anthy_compound_get_nth_segment_len( ce, k );
						anthy_compound_get_nth_segment_xstr( ce, k, &xs );
						anthy_xstrcat( &cand, &xs );
					}
					{
						mw = alloc_metaword( sc );
						mw->from  = 0;
						mw->len   = len;
						mw->score = 1000;
						mw->type  = MW_OCHAIREwithoutDEP;
						mw->ochaire_phrase_score = seg_num;
						mw->ochaire_total_len    = j;
						mw->cand_hint_freq          = anthy_compound_get_freq( ce );
						mw->cand_hint_learned_freq  = 0;
						mw->cand_hint_depth_of_dep  = 0;
						mw->cand_hint_length_of_dep = 0;
						mw->seg_class = SEG_BUNSETSU;
						mw->cand_hint.str = cand.str;
						mw->cand_hint.len = cand.len;
						if (mw->cand_hint_freq < 1) {
							mw->cand_hint_freq = 1;
						}
						anthy_commit_meta_word( sc, mw );

						expand_mw_withdep( sc, mw, 0 );
					}
					/* anthy_free_xstr_str( &cand ); mw->cand_hint.str Τ free ʤ */
				}
			}
		}

		anthy_free_xstr_str( &yomi );
	}
	return;
}

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
