/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	ʻΥܥ
 *@date		Wed,28 Oct,2009
 *@date		Tue,10 Nov,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#include "anthy/settings.h"
#include "src-splitter/cand_wt_name.h"



/** ʻ̾μ
 *@param[in]		ce				cand_ent
 *@param[in,out]	name			ɽʸ
 *@retval			0				
 *@retval			-1				
 *
 *	Patches by G-HAL
 *		Wed,28 Oct,2009
 *		Tue,10 Nov,2009
 */
int anthy_get_ce_wtname( const struct cand_ent* const ce, const char* const* wt_name )
{
	int		ce_core;
	size_t	nth;
	const struct cand_elm*	elm;

	assert( NULL != ce );

	ce_core = ce->core_elm_index;
	if (ce_core < 0) {
		return -1;
	}

	elm = &(ce->elm[ce_core]);
	return anthy_get_nth_dic_ent_wtname( elm->se, elm->nth, wt_name );
}
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
