/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	HashΥå
 *@date		Fri,30 Jan,2009
 *@date		Sat,17 Oct,2009
 *@date		Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 *
 *@attention
 *		դδؿϡ֤ *BSD ǤƤʤȻפ
 */
#ifndef _anthy_hash_h_included_
#define _anthy_hash_h_included_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


#if defined(ANTHY_HASH_TYPE)

# if defined(HAVE_SYS_TYPES_H)
#  include <sys/types.h>
# endif

# if (2 == ANTHY_HASH_TYPE)	/* MD2 ϥϥåȤƤϼ夤ƤΤǡƥϢˤϻѶػ */
#  if !defined(HAVE_MD2INIT)
#   error	"You have no MD2Init()."
#  endif
#  if defined(HAVE_MD2_H)
#   include <md2.h>
#  endif
#  define	HASH_TYPE	MD2
#  define	HASH_CTX	MD2_CTX
#  define	HASH_Init(context)							MD2Init(context)
#  define	HASH_Update(context,data,len)				MD2Update(context,data,len)
#  define	HASH_Final(digest,context)					MD2Final(digest,context)
#  define	HASH_End(context,buf)						MD2End(context,buf)
#  define	HASH_File(filename,buf)						MD2File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	MD2FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						MD2Data(data,len,buf)
#  define	HASH_DIGEST_LEN	16

# elif (4 == ANTHY_HASH_TYPE)	/* MD4 ϥϥåȤƤϼ夤ƤΤǡƥϢˤϻѶػ */
#  if !defined(HAVE_MD4INIT)
#   error	"You have no MD4Init()."
#  endif
#  if defined(HAVE_MD4_H)
#   include <md4.h>
#  endif
#  define	HASH_TYPE	MD4
#  define	HASH_CTX	MD4_CTX
#  define	HASH_Init(context)							MD4Init(context)
#  define	HASH_Update(context,data,len)				MD4Update(context,data,len)
#  define	HASH_Final(digest,context)					MD4Final(digest,context)
#  define	HASH_End(context,buf)						MD4End(context,buf)
#  define	HASH_File(filename,buf)						MD4File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	MD4FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						MD4Data(data,len,buf)
#  define	HASH_DIGEST_LEN	16

# elif (5 == ANTHY_HASH_TYPE)	/* MD5 ϥϥåȤƤϼ夤줿ΤǡƥϢǤλѻߴ𤬽ФƤ */
#  if !defined(HAVE_MD5INIT)
#   error	"You have no MD5Init()."
#  endif
#  if defined(HAVE_MD5_H)
#   include <md5.h>
#  endif
#  define	HASH_TYPE	MD5
#  define	HASH_CTX	MD5_CTX
#  define	HASH_Init(context)							MD5Init(context)
#  define	HASH_Update(context,data,len)				MD5Update(context,data,len)
#  define	HASH_Final(digest,context)					MD5Final(digest,context)
#  define	HASH_End(context,buf)						MD5End(context,buf)
#  define	HASH_File(filename,buf)						MD5File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	MD5FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						MD5Data(data,len,buf)
#  define	HASH_DIGEST_LEN	16

# elif (160 == ANTHY_HASH_TYPE)
#  if !defined(HAVE_RIPEMD160_INIT) && !defined(HAVE_RMD160INIT)
#   error	"You have no RIPEMD160_Init() nor RMD160Init."
#  endif
#  if defined(HAVE_RIPEMD_H)
#   include <ripemd.h>
#  elif defined(HAVE_RMD160_H)
#   include <rmd160.h>
#  endif
#  if defined(HAVE_RIPEMD160_INIT)
#   define	HASH_TYPE	RIPEMD160_
#   define	HASH_CTX	RIPEMD160_CTX
#   define	HASH_Init(context)							RIPEMD160_Init(context)
#   define	HASH_Update(context,data,len)				RIPEMD160_Update(context,data,len)
#   define	HASH_Final(digest,context)					RIPEMD160_Final(digest,context)
#   define	HASH_End(context,buf)						RIPEMD160_End(context,buf)
#   define	HASH_File(filename,buf)						RIPEMD160_File(filename,buf)
#   define	HASH_FileChunk(filename,buf,offset,length)	RIPEMD160_FileCunk(filename,buf,offset,length)
#   define	HASH_Data(data,len,buf)						RIPEMD160_Data(data,len,buf)
#   define	HASH_DIGEST_LEN	20
#  elif defined(HAVE_RMD160INIT)
#   define	HASH_TYPE	RMD160_
#   define	HASH_CTX	RMD160_CTX
#   define	HASH_Init(context)							RMD160Init(context)
#   define	HASH_Update(context,data,len)				RMD160Update(context,data,len)
#   define	HASH_Final(digest,context)					RMD160Final(digest,context)
#   define	HASH_End(context,buf)						RMD160End(context,buf)
#   define	HASH_File(filename,buf)						RMD160File(filename,buf)
#   define	HASH_FileChunk(filename,buf,offset,length)	RMD160FileCunk(filename,buf,offset,length)
#   define	HASH_Data(data,len,buf)						RMD160Data(data,len,buf)
#   define	HASH_DIGEST_LEN	20
#  endif

# elif (0 == ANTHY_HASH_TYPE)	/* SHA0 ϥϥåȤƤϼ夤ƤΤǡƥϢˤϻѶػ */
#  if !defined(HAVE_SHA_INIT)
#   error	"You have no SHA_Init()."
#  endif
#  if defined(HAVE_SHA_H)
#   include <sha.h>
#  endif
#  define	HASH_TYPE	SHA_
#  define	HASH_CTX	SHA_CTX
#  define	HASH_Init(context)							SHA_Init(context)
#  define	HASH_Update(context,data,len)				SHA_Update(context,data,len)
#  define	HASH_Final(digest,context)					SHA_Final(digest,context)
#  define	HASH_End(context,buf)						SHA_End(context,buf)
#  define	HASH_File(filename,buf)						SHA_File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	SHA_FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						SHA_Data(data,len,buf)
#  define	HASH_DIGEST_LEN	20

# elif (1 == ANTHY_HASH_TYPE)
#  if !defined(HAVE_SHA1_INIT) && !defined(HAVE_SHA1INIT)
#   error	"You have no SHA1_Init() nor SHA1Init()."
#  endif
#  if defined(HAVE_SHA_H)
#   include <sha.h>
#  endif
#  if defined(HAVE_SHA1_H)
#   include <sha1.h>
#  endif
#  if defined(HAVE_SHA1_INIT)
#   define	HASH_TYPE	SHA1_
#   define	HASH_CTX	SHA_CTX
#   define	HASH_Init(context)							SHA1_Init(context)
#   define	HASH_Update(context,data,len)				SHA1_Update(context,data,len)
#   define	HASH_Final(digest,context)					SHA1_Final(digest,context)
#   define	HASH_End(context,buf)						SHA1_End(context,buf)
#   define	HASH_File(filename,buf)						SHA1_File(filename,buf)
#   define	HASH_FileChunk(filename,buf,offset,length)	SHA1_FileCunk(filename,buf,offset,length)
#   define	HASH_Data(data,len,buf)						SHA1_Data(data,len,buf)
#   define	HASH_DIGEST_LEN	20
#  elif defined(HAVE_SHA1INIT)
#   define	HASH_TYPE	SHA1
#   define	HASH_CTX	SHA1_CTX
#   define	HASH_Init(context)							SHA1Init(context)
#   define	HASH_Update(context,data,len)				SHA1Update(context,data,len)
#   define	HASH_Final(digest,context)					SHA1Final(digest,context)
#   define	HASH_End(context,buf)						SHA1End(context,buf)
#   define	HASH_File(filename,buf)						SHA1File(filename,buf)
#   define	HASH_FileChunk(filename,buf,offset,length)	SHA1FileCunk(filename,buf,offset,length)
#   define	HASH_Data(data,len,buf)						SHA1Data(data,len,buf)
#   define	HASH_DIGEST_LEN	20
#  endif

# elif (256 == ANTHY_HASH_TYPE)
#  if !defined(HAVE_SHA256_INIT)
#   error	"You have no SHA256_Init()."
#  endif
#  if defined(HAVE_SHA256_H)
#   include <sha256.h>
#  endif
#  if defined(HAVE_SHA2_H)
#   include <sha2.h>
#  endif
#  define	HASH_TYPE	SHA256_
#  define	HASH_CTX	SHA256_CTX
#  define	HASH_Init(context)							SHA256_Init(context)
#  define	HASH_Update(context,data,len)				SHA256_Update(context,data,len)
#  define	HASH_Final(digest,context)					SHA256_Final(digest,context)
#  define	HASH_End(context,buf)						SHA256_End(context,buf)
#  define	HASH_File(filename,buf)						SHA256_File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	SHA256_FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						SHA256_Data(data,len,buf)
#  define	HASH_DIGEST_LEN	32

# elif (384 == ANTHY_HASH_TYPE)
#  if !defined(HAVE_SHA384_INIT)
#   error	"You have no SHA384_Init()."
#  endif
#  if defined(HAVE_SHA2_H)
#   include <sha2.h>
#  endif
#  define	HASH_TYPE	SHA384_
#  define	HASH_CTX	SHA384_CTX
#  define	HASH_Init(context)							SHA384_Init(context)
#  define	HASH_Update(context,data,len)				SHA384_Update(context,data,len)
#  define	HASH_Final(digest,context)					SHA384_Final(digest,context)
#  define	HASH_End(context,buf)						SHA384_End(context,buf)
#  define	HASH_File(filename,buf)						SHA384_File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	SHA384_FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						SHA384_Data(data,len,buf)
#  define	HASH_DIGEST_LEN	48

# elif (512 == ANTHY_HASH_TYPE)
#  if !defined(HAVE_SHA512_INIT)
#   error	"You have no SHA512_Init()."
#  endif
#  if defined(HAVE_SHA2_H)
#   include <sha2.h>
#  endif
#  define	HASH_TYPE	SHA512_
#  define	HASH_CTX	SHA512_CTX
#  define	HASH_Init(context)							SHA512_Init(context)
#  define	HASH_Update(context,data,len)				SHA512_Update(context,data,len)
#  define	HASH_Final(digest,context)					SHA512_Final(digest,context)
#  define	HASH_End(context,buf)						SHA512_End(context,buf)
#  define	HASH_File(filename,buf)						SHA512_File(filename,buf)
#  define	HASH_FileChunk(filename,buf,offset,length)	SHA512_FileCunk(filename,buf,offset,length)
#  define	HASH_Data(data,len,buf)						SHA512_Data(data,len,buf)
#  define	HASH_DIGEST_LEN	64

# else
#  error	"Hash type was not specified."
# endif

#endif /* defined(ANTHY_HASH_TYPE) */


#ifdef __cplusplus
}
#endif

#endif /* _anthy_hash_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
