<?php
// PukiWiki - Yet another WikiWikiWeb clone.
// $Id: ls2.inc.php,v 1.30 2011/01/25 15:01:01 henoheno Exp $
// Copyright (C)
//   2002-2004, 2006-2007 PukiWiki Developers Team
//   2002       panda  http://home.arino.jp/?ls2.inc.php 
//   2002       Y.MASUI GPL2 http://masui.net/pukiwiki/ masui@masui.net (ls.inc.php)
// License: GPL version 2
//
// List plugin 2

/*
 * ۲Υڡ䡢θФ(*,**,***)ΰɽ
 * Usage
 *  #ls2(pattern[,title|include|link|reverse|compact, ...],heading title)
 *
 * pattern  : άȤ⥫ޤɬ
 * 'title'  : Фΰɽ
 * 'include': 󥯥롼ɤƤڡθФƵŪ󤹤
 * 'link   ': actionץ饰ƤӽФ󥯤ɽ
 * 'reverse': ڡ¤ӽȿž߽ˤ
 * 'compact': Ф٥Ĵ
 *     PLUGIN_LS2_LIST_COMPACTTRUEλ̵(Ѳʤ)
 * heading title: ФΥȥꤹ (linkꤷΤ)
 */

// Ф󥫡ν
define('PLUGIN_LS2_ANCHOR_PREFIX', '#content_1_');

// Ф󥫡γֹ
define('PLUGIN_LS2_ANCHOR_ORIGIN', 0);

// Ф٥Ĵ(ǥե)
define('PLUGIN_LS2_LIST_COMPACT', FALSE);

function plugin_ls2_action()
{
	global $vars, $_ls2_msg_title;

	$keys   = array('title', 'include', 'reverse');
	$params = array();
	foreach ($keys as $key) {
		$params[$key] = isset($vars[$key]);
	}

	$prefix = isset($vars['prefix']) ? $vars['prefix'] : '';
	$body   = plugin_ls2_show_lists($prefix, $params);

	return array(
		'body' => $body,
		'msg'  => str_replace('$1', htmlsc($prefix), $_ls2_msg_title)
	);
}

function plugin_ls2_convert()
{
	global $vars, $_ls2_msg_title;

	$params = array(
		'link'    => FALSE,
		'title'   => FALSE,
		'include' => FALSE,
		'reverse' => FALSE,
		'compact' => PLUGIN_LS2_LIST_COMPACT,
		'_args'   => array(),
		'_done'   => FALSE
	);

	$args = func_get_args();
	$prefix = '';
	if (! empty($args)) $prefix = array_shift($args);
	if ($prefix == '')  $prefix = strip_bracket($vars['page']) . '/';

	foreach ($args as $arg) {
		plugin_ls2_check_arg($arg, $params);
	}

	$title = (! empty($params['_args'])) ? join(',', $params['_args']) :   // Manual
		str_replace('$1', htmlsc($prefix), $_ls2_msg_title); // Auto

	if (! $params['link']) {
		return plugin_ls2_show_lists($prefix, $params);
	}

	$tmp = array();
	$tmp[] = 'plugin=ls2&amp;prefix=' . rawurlencode($prefix);
	if (isset($params['title']))   $tmp[] = 'title=1';
	if (isset($params['include'])) $tmp[] = 'include=1';

	return '<p><a href="' . get_script_uri() . '?' . join('&amp;', $tmp) . '">' .
		$title . '</a></p>' . "\n";
}

function plugin_ls2_show_lists($prefix, & $params)
{
	if ($prefix == '') {
		$pages = get_existpages();
	} else {
		$pages = preg_grep('#^' .  preg_quote($prefix , '#') . '#', get_existpages());
	}
	if (empty($pages)) {
		global $_ls2_err_nopages;
		return str_replace('$1', htmlsc($prefix), $_ls2_err_nopages);
	}

	natcasesort($pages);
	if ($params['reverse']) $pages = array_reverse($pages);

	foreach ($pages as $page) {
		$params['page_ ' . $page] = 0;
	}

	$params['result'] = $params['saved'] = array();
	foreach ($pages as $page) {
		plugin_ls2_get_headings($page, $params, 1);
	}

	return join("\n", $params['result']) . join("\n", $params['saved']);
}

function plugin_ls2_get_headings($page, & $params, $level, $include = FALSE)
{
	static $_ls2_anchor = 0;

	// ڡ̤ɽΤȤ
	$is_done = (isset($params["page_$page"]) && $params["page_$page"] > 0);
	if (! $is_done) $params["page_$page"] = ++$_ls2_anchor;

	$r_page = rawurlencode($page);
	$s_page = htmlsc($page);
	$title  = $s_page . ' ' . get_pg_passage($page, FALSE);
	$href   = get_script_uri() . '?cmd=read&amp;page=' . $r_page;

	plugin_ls2_list_push($params, $level);
	$ret = $include ? '<li>include ' : '<li>';

	if ($params['title'] && $is_done) {
		$ret .= '<a href="' . $href . '" title="' . $title . '">' . $s_page . '</a> ';
		$ret .= '<a href="#list_' . $params["page_$page"] . '"><sup>&uarr;</sup></a>';
		array_push($params['result'], $ret);
		return;
	}

	$ret .= '<a id="list_' . $params["page_$page"] . '" href="' . $href .
		'" title="' . $title . '">' . $s_page . '</a>';

	array_push($params['result'], $ret);

	$anchor = PLUGIN_LS2_ANCHOR_ORIGIN;
	$matches = array();
	foreach (get_source($page) as $line) {
		if ($params['title'] && preg_match('/^(\*{1,3})/', $line, $matches)) {
			$id    = make_heading($line);
			$level = strlen($matches[1]);
			$id    = PLUGIN_LS2_ANCHOR_PREFIX . $anchor++;
			plugin_ls2_list_push($params, $level + strlen($level));
			array_push($params['result'],
				'<li><a href="' . $href . $id . '">' . $line . '</a>');
		} else if ($params['include'] &&
			preg_match('/^#include\((.+)\)/', $line, $matches) &&
			is_page($matches[1]))
		{
			plugin_ls2_get_headings($matches[1], $params, $level + 1, TRUE);
		}
	}
}

//ꥹȹ¤ۤ
function plugin_ls2_list_push(& $params, $level)
{
	global $_ul_left_margin, $_ul_margin, $_list_pad_str;

	$result = & $params['result'];
	$saved  = & $params['saved'];
	$cont   = TRUE;
	$open   = '<ul%s>';
	$close  = '</li></ul>';

	while (count($saved) > $level || (! empty($saved) && $saved[0] != $close)) {
		array_push($result, array_shift($saved));
	}

	$margin = $level - count($saved);

	// count($saved)䤹
	while (count($saved) < ($level - 1)) array_unshift($saved, '');

	if (count($saved) < $level) {
		$cont = FALSE;
		array_unshift($saved, $close);

		$left = ($level == $margin) ? $_ul_left_margin : 0;
		if ($params['compact']) {
			$left  += $_ul_margin;   // ޡ
			$level -= ($margin - 1); // ٥
		} else {
			$left += $margin * $_ul_margin;
		}
		$str = sprintf($_list_pad_str, $level, $left, $left);
		array_push($result, sprintf($open, $str));
	}

	if ($cont) array_push($result, '</li>');
}

// ץϤ
function plugin_ls2_check_arg($value, & $params)
{
	if ($value == '') {
		$params['_done'] = TRUE;
		return;
	}

	if (! $params['_done']) {
		foreach (array_keys($params) as $param) {
			if (strtolower($value)  == $param &&
			    preg_match('/^[a-z]/', $param)) {
				$params[$param] = TRUE;
				return;
			}
		}
		$params['_done'] = TRUE;
	}

	$params['_args'][] = htmlsc($value); // Link title
}
?>
