/*
 * Copyright (C) 2014 kgto.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
/*
 * $Id: SearchData.java 83 2014-09-22 00:49:37Z tuna_p $
 */

package WebScraping;

/**
 * 検索データ.
 * @author kgto
 */
public class SearchData {

    private String item;
    private String htmltag;
    private String htmlid;
    private String htmlclass;
    private String around;
    private String regexp;

    public SearchData() {
        initialize();
    }
    
    public SearchData(SearchData dat) {
        this.item      = dat.getitem();
        this.htmltag   = dat.getHtmltag();
        this.htmlid    = dat.getHtmlid();
        this.htmlclass = dat.getHtmlclass();
        this.around    = dat.getaround();
        this.regexp    = dat.getregexp();
    }
    
    /**
     * データ初期化.
     */
    public final void initialize() {
        this.item      = "";
        this.htmltag   = "";
        this.htmlid    = "";
        this.htmlclass = "";
        this.around    = "";
        this.regexp    = "";
    }
    
    // Setter
    public void setitem(String item) {
        this.item = item;
    }

    public void setHtmltag(String htmltag) {
        this.htmltag = htmltag;
    }

    public void setHtmlid(String htmlid) {
        this.htmlid = htmlid;
    }

    public void setHtmlclass(String htmlclass) {
        this.htmlclass = htmlclass;
    }

    public void setaround(String around) {
        this.around = around;
    }

    public void setregexp(String regexp) {
        this.regexp = regexp;
    }

    // Getter
    public String getitem() {
        return item;
    }

    public String getHtmltag() {
        return htmltag;
    }

    public String getHtmlid() {
        return htmlid;
    }

    public String getHtmlclass() {
        return htmlclass;
    }

    public String getaround() {
        return around;
    }

    public String getregexp() {
        return regexp;
    }

}
