/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package htmltest1;

import java.io.*;
import java.net.*;
import java.util.HashMap;

import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.text.html.parser.ParserDelegator;

/**
 *
 * @author kgto
 */
public class HtmlParser {
    
    String adress;
    String pageData;
    
    public HtmlParser() {
        adress = null;
    }
    
    public HtmlParser(String adress) {
        this.adress = adress;
    }

    public void exec(){
        try {
            System.out.println(adress);
            
            URL url = new URL(adress);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(con.getInputStream(), "utf-8"));
            
            String wkline;
            StringBuilder sb = new StringBuilder();
            while((wkline = reader.readLine()) != null) {
                sb.append(wkline).append("\n");
            }
            pageData = sb.toString();
            
            con.disconnect();
            
            System.out.println("exec END");
        }
        catch(IOException e) {
            System.err.println(e);
        }
    }
    
    public void exec2(){
        //HtmlTagSearch skey = new HtmlTagSearch();
        //skey.setall(HTML.Tag.DL, "dl-dataid1", "dl-dataclass1");
        
        Reader reader;
        try {
            reader = new BufferedReader(new StringReader(pageData));
            // ここを検索したいタグ分繰り返せばいいのだろうか？
            MyParserCallback cb = new MyParserCallback();
            ParserDelegator pd = new ParserDelegator();

            System.out.println("--- 1 ---");
            pd.parse(reader, cb, true);
            
            reader.close();
            
        } catch (IOException e) {
            System.err.println(e);
        }
        
        
    }
    
    class MyParserCallback extends HTMLEditorKit.ParserCallback {
        
        // Tag毎の階層
        HashMap<HTML.Tag,Integer> tagMap = new HashMap<>();
        
        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attr, int pos){
            
            
            //--- DEBUG OUT ---- start ---
            StringBuffer strBuf = new StringBuffer();
            String ret;

            strBuf.append("x : S : ").append(tag.toString());
            ret = (String)attr.getAttribute(HTML.Attribute.VALUE);
            if(ret != null) {
                strBuf.append(" [VALUE] ").append(ret);
            }
            System.out.println(strBuf);
            //--- DEBUG OUT ---- end ---
            
        }
        
        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attr, int pos){
            // Tag毎の階層を保持
            int count = 1;
            if(tagMap.containsKey(tag)) {
                count = tagMap.get(tag);
                count++;
            }
            tagMap.put(tag, count);

            //--- DEBUG OUT ---- start ---
            StringBuffer strBuf = new StringBuffer();
            String ret;
            
            strBuf.append(count).append(" : F : ").append(tag.toString());
            ret = (String)attr.getAttribute(HTML.Attribute.ID);
            if(ret != null) {
                strBuf.append(" [ID] ").append(ret);
            }
            ret = (String)attr.getAttribute(HTML.Attribute.CLASS);
            if(ret != null) {
                strBuf.append(" [CLASS] ").append(ret);
            }
            ret = (String)attr.getAttribute(HTML.Attribute.VALUE);
            if(ret != null) {
                strBuf.append(" [VALUE] ").append(ret);
            }
            System.out.println(strBuf);
            //--- DEBUG OUT ---- end ---
            
            //String currentID    = (String)attr.getAttribute(HTML.Attribute.ID);
            //String currentClass = (String)attr.getAttribute(HTML.Attribute.CLASS);
            
            
            
        }
        
        @Override
        public void handleEndTag(HTML.Tag tag, int pos){
            // Tag毎の階層を取得
            int count = 0;
            if(tagMap.containsKey(tag)) {
                count = tagMap.get(tag);
            }
            
            
            
            
            //--- DEBUG OUT ---- start ---
            System.out.println(count + " : E : " + tag.toString());
            //--- DEBUG OUT ---- end ---
            
            // Tag毎の階層減算
            tagMap.put(tag, --count);
        }
        
        @Override
        public void handleText(char[] data, int pos){
            
            //--- DEBUG OUT ---- start ---
            String dat = new String(data);
            System.out.println(dat);
            //--- DEBUG OUT ---- end ---
            
        }
    }
    
}
