package XmlTest1;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import java.io.*;

public class AllShow {

    /**
     * 読み込むXMLファイル名
     */
    final static String uri = "example1.xml";

    /**
     * 主メソッド
     */
    public void runner() {
        DocumentBuilderFactory factory;
        DocumentBuilder builder;
        Node root;
        Node child;
        NodeList XMLdata;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setValidating(true);
            root = builder.parse(uri);

            showNodes(root, "");

        } catch (ParserConfigurationException | SAXException | IOException e0) {
            System.out.println(e0.getMessage());
        }
    }

    /**
     * nodeの子ノードを全て表示します。子ノードがない場合はなにも出力しません。 
     * spaceはノードを表示する前の行頭のスペースです。
     * （再帰処理をしているので注意）
     * @param node
     * @param space
     */
    public void showNodes(Node node, String space) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); i++) {
            Node node2 = nodes.item(i);
            System.out.println(space + "「" + node2.getNodeName() + "/" + node2.getNodeValue() + "/" + getTypeMes(node2) + "」");
            showNodes(node2, space + "    ");
        }
    }

    /**
     * ノードの種類を示します
     * @param node
     * @return 
     */
    public String getTypeMes(Node node) {
        String s = null;
        switch (node.getNodeType()) {
            case Node.ATTRIBUTE_NODE:
                s = "Attr";
            case Node.CDATA_SECTION_NODE:
                s = "CDATASection";
            case Node.COMMENT_NODE:
                s = "Comment";
            case Node.DOCUMENT_FRAGMENT_NODE:
                s = "DocumentFragment";
            case Node.DOCUMENT_NODE:
                s = "Document";
            case Node.DOCUMENT_TYPE_NODE:
                s = "DocumentType";
            case Node.ELEMENT_NODE:
                s = "Element";
            case Node.ENTITY_NODE:
                s = "Entity";
            case Node.ENTITY_REFERENCE_NODE:
                s = "EntityReference";
            case Node.NOTATION_NODE:
                s = "Notation";
            case Node.PROCESSING_INSTRUCTION_NODE:
                s = "ProcessingInstruction";
            case Node.TEXT_NODE:
                s = "Text";
        }
        return s;
    }

    /**
     * メイン
     * @param argv
     */
    public static void main(String[] argv) {
        AllShow t = new AllShow();
        t.runner();
    }
}
