/*
 * ＨＴＭＬの検索タグ情報格納
 */

package HtmlParser;

import java.util.ArrayList;
import javax.swing.text.html.*;

/**
 * ＨＴＭＬのTAG,ID,CLASSで１キーとし、ユニークなキーをリストに登録、検索する。
 * @author kgto
 */
public class HtmlTagSearch {

    class structdata {
            HTML.Tag Tag;
            String Id;
            String Class;
    }
    /**
     * キー情報が格納されたリスト
     */
    ArrayList<structdata> slist;
    /**
     * キー情報(HTMLのタグ名,タグのＩＤ,タグのClass)を格納
     */
    structdata dat;
    
    /**
     * 格納するキーリストを作成する。
     */
    public HtmlTagSearch() {
        slist = new ArrayList<>();
    }
    
    /**
     * キー情報を登録する。
     * TAG+ID+CLASSで１キーとし、重複登録は行わない。
     * @param Tag HTMLのタグ名
     * @param Id  タグのＩＤ
     * @param Class タグのClass
     */
    public void setall(HTML.Tag Tag, String Id, String Class) {
        if(searchall(Tag, Id, Class) == false) {    // 重複チェック
            dat   = new structdata();
            dat.Tag   = Tag;
            dat.Id    = Id;
            dat.Class = Class;
            slist.add(dat);
        }
    }
    
    /**
     * キー情報を登録する。
     * TAG+IDで１キーとし、重複登録は行わない。
     * @param Tag HTMLのタグ名
     * @param Id  タグのＩＤ
     */
    public void setid(HTML.Tag Tag, String Id) {
        if(!(Id == null)) {
            setall(Tag, Id, null);
        }
    }
    
    /**
     * キー情報を登録する。
     * TAG+CLASSで１キーとし、重複登録は行わない。
     * @param Tag HTMLのタグ名
     * @param Class タグのClass
     */
    public void setclass(HTML.Tag Tag, String Class) {
        if(!(Class == null)) {
            setall(Tag, null, Class);
        }
    }
    
    /**
     * 登録されているキーリストより、指定された位置のキー情報を取得する。
     * @param i 取得したいキー情報のリスト位置
     */
    public void get(int i) {
        if(i < slist.size()) {
            dat = slist.get(i);
        }
    }
    
    /**
     * 取得したいキー情報の項目値を取り出す。</>
     * ※先にgetメソッドにより、取得したいキー情報を取得しておくこと。
     * @return キー情報内の、HTMLのタグ名を返す。
     */
    public HTML.Tag gettag() {
        return dat.Tag;
    }
    
    /**
     * 取得したいキー情報の項目値を取り出す。</>
     * ※先にgetメソッドにより、取得したいキー情報を取得しておくこと。
     * @return キー情報内の、タグのＩＤを返す。
     */
    public String getid() {
        return dat.Id;
    }
    
    /**
     * 取得したいキー情報の項目値を取り出す。</>
     * ※先にgetメソッドにより、取得したいキー情報を取得しておくこと。
     * @return キー情報内の、タグのClassを返す。
     */
    public String getclass() {
        return dat.Class;
    }
    
    /**
     * 既に登録されているキーのデータ数を返す。
     * @return 登録されているキーのデータ数
     */
    public int size() {
        return slist.size();
    }
    
    /**
     * 入力されたキーより、登録されたキーリストの存在をチェックする。
     * @param Tag 検索するHTMLのタグ名
     * @param Id  検索するタグのＩＤ
     * @param Class 検索するタグのClass
     * @return 引数のTag,Id,Classに一致するキーが存在した場合、True
     */
    public boolean searchall(HTML.Tag Tag, String Id, String Class) {
        
        for (structdata slist1 : slist) {
            boolean chkflg[] = {false, false, false};
            // Tag
            if(slist1.Tag == null) {
                if(Tag == null) {
                    chkflg[0] = true;
                }
            } else {
                if(slist1.Tag.equals(Tag)) {
                    chkflg[0] = true;
                }
            }
            // Id
            if(slist1.Id == null) {
                if(Id == null) {
                    chkflg[1] = true;
                }
            } else {
                if(slist1.Id.equals(Id)) {
                    chkflg[1] = true;
                }
            }
            // Class
            if(slist1.Class == null) {
                if(Class == null) {
                    chkflg[2] = true;
                }
            } else {
                if(slist1.Class.equals(Class)) {
                    chkflg[2] = true;
                }
            }
            //
            if(chkflg[0] & chkflg[1] & chkflg[2] ) {
                return true;
            }
        }
        return false;
    }
    
    /**
     * 入力されたキーより、登録されたキーリストの存在をチェックする。
     * @param Tag 検索するHTMLのタグ名
     * @param Id  検索するタグのＩＤ
     * @return 引数のTag,Idに一致するキーが存在した場合、True
     */
    public boolean searchid(HTML.Tag Tag, String Id) {
        if(Id == null) {
            return false;
        }
        return searchall(Tag, Id, null);
    }
    
    /**
     * 入力されたキーより、登録されたキーリストの存在をチェックする。
     * @param Tag 検索するHTMLのタグ名
     * @param Class 検索するタグのClass
     * @return 引数のTag,Classに一致するキーが存在した場合、True
     */
    public boolean searchclass(HTML.Tag Tag, String Class) {
        if(Class == null) {
            return false;
        }
        return searchall(Tag, null, Class);
    }
    
}
