/*
 * Copyright (C) 2014 kgto.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
/*
 * $Id: SearchData.java 123 2015-02-27 01:10:03Z tuna_p $
 */

package webScraping.core;

import java.util.ArrayList;

/**
 * タグ検索データ.
 * @author kgto
 */
public class SearchData {
    /* ---------------------------------------------------------------------- *
     *   フィールド
     * ---------------------------------------------------------------------- */
    private String item;
    private String htmltag;
    private String htmlid;
    private String htmlclass;
    private String around;
    private String regexp;

    /* ---------------------------------------------------------------------- *
     *   static 処理
     * ---------------------------------------------------------------------- */
    public static class Context {
        public Class  columnClass;
        public String columnName;
        public String columnNameJp;
        
        public Context(Class columnClass, String columnName, String columnNameJp) {
            this.columnClass  = columnClass;
            this.columnName   = columnName;
            this.columnNameJp = columnNameJp;
        }
    }
    
    public static final Context[] context = {
        /*  0 */    new Context(String.class , "item"      , "項目名"),
        /*  1 */    new Context(String.class , "htmltag"   , "タグ"),
        /*  2 */    new Context(String.class , "htmlid"    , "ＩＤ"),
        /*  3 */    new Context(String.class , "htmlclass" , "クラス"),
        /*  4 */    new Context(String.class , "around"    , "位置"),
        /*  5 */    new Context(String.class , "regexp"    , "抽出条件")
    };

    /* ---------------------------------------------------------------------- */
    private static ArrayList<SearchData> slist = new ArrayList<>();
    
    public static void addSearchData(
            String item, String htmltag, String htmlid,
            String htmlclass, String around, String regexp) {
        SearchData sdat = new SearchData();
        sdat.setitem(item);
        sdat.setHtmltag(htmltag);
        sdat.setHtmlid(htmlid);
        sdat.setHtmlclass(htmlclass);
        sdat.setaround(around);
        sdat.setregexp(regexp);
        
        slist.add(sdat);
    }
    
    public static void add(SearchData sdat) {
        slist.add(sdat);
    }
    
    public static SearchData get(int i) {
        return slist.get(i);
    }
    
    public static int size() {
        return slist.size();
    }
    
    public static SearchData remove(int index) {
        return slist.remove(index);
    }
    
    public static void clear() {
        slist.clear();
    }
    
    /* ---------------------------------------------------------------------- *
     *   コンストラクタ
     * ---------------------------------------------------------------------- */
    public SearchData() {
        initialize();
    }
    
    public SearchData(SearchData dat) {
        this.item      = dat.getitem();
        this.htmltag   = dat.getHtmltag();
        this.htmlid    = dat.getHtmlid();
        this.htmlclass = dat.getHtmlclass();
        this.around    = dat.getaround();
        this.regexp    = dat.getregexp();
    }
    
    /* ---------------------------------------------------------------------- *
     *   Setter
     * ---------------------------------------------------------------------- */
    public void setitem(String item) {
        this.item = item;
    }

    public void setHtmltag(String htmltag) {
        this.htmltag = htmltag;
    }

    public void setHtmlid(String htmlid) {
        this.htmlid = htmlid;
    }

    public void setHtmlclass(String htmlclass) {
        this.htmlclass = htmlclass;
    }

    public void setaround(String around) {
        this.around = around;
    }

    public void setregexp(String regexp) {
        this.regexp = regexp;
    }

    /* ---------------------------------------------------------------------- *
     *   Getter
     * ---------------------------------------------------------------------- */
    public String getitem() {
        return item;
    }

    public String getHtmltag() {
        return htmltag;
    }

    public String getHtmlid() {
        return htmlid;
    }

    public String getHtmlclass() {
        return htmlclass;
    }

    public String getaround() {
        return around;
    }

    public String getregexp() {
        return regexp;
    }
    
    /* ---------------------------------------------------------------------- *
     *   メソッド
     * ---------------------------------------------------------------------- */
    /**
     * データ初期化.
     */
    public final void initialize() {
        this.item      = "";
        this.htmltag   = "";
        this.htmlid    = "";
        this.htmlclass = "";
        this.around    = "";
        this.regexp    = "";
    }
    
    public Object[] getObjData() {
        Object[] obj = {
            /*  0 */    getitem(),          // 項目名
            /*  1 */    getHtmltag(),       // タグ
            /*  2 */    getHtmlid(),        // ＩＤ
            /*  3 */    getHtmlclass(),     // クラス
            /*  4 */    getaround(),        // 位置
            /*  5 */    getregexp()         // 抽出条件
        };
        return obj;
    }
    
}
