/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package package01;

import java.awt.Color;
import static java.lang.Math.floor;
import javax.swing.JOptionPane;

/**
 *
 * @author kgto
 */
public class TestColor01 extends javax.swing.JFrame {
    int valueMin, valueMax, valuePoint;
    int jRBselect;

    /**
     * Creates new form Test01
     */
    public TestColor01() {
        initComponents();
        
        jRBtn_percent.setSelected(true);
        jRBselect = 1;
        sliderSet_range();
        
        valueMin = jSlider1.getMinimum();
        valueMax = jSlider1.getMaximum();
        valuePoint = 0;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jSlider1 = new javax.swing.JSlider();
        jTextField1 = new javax.swing.JTextField();
        jTextred = new javax.swing.JTextField();
        jTextgreen = new javax.swing.JTextField();
        jTextblue = new javax.swing.JTextField();
        jRBtn_MinMaxAndPoint = new javax.swing.JRadioButton();
        jRBtn_percent = new javax.swing.JRadioButton();
        jRBtn_MinMax = new javax.swing.JRadioButton();
        jTextsmin = new javax.swing.JTextField();
        jTextsmax = new javax.swing.JTextField();
        jTextssmin = new javax.swing.JTextField();
        jTextssmax = new javax.swing.JTextField();
        jTextsspoint = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jSlider1.setMajorTickSpacing(10);
        jSlider1.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider1.setPaintTicks(true);
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });

        jTextField1.setToolTipText("スライダー位置");

        jTextred.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextred.setText("RED");

        jTextgreen.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextgreen.setText("GREEN");

        jTextblue.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextblue.setText("BLUE");

        buttonGroup1.add(jRBtn_MinMaxAndPoint);
        jRBtn_MinMaxAndPoint.setText("指定値＆基準値");
        jRBtn_MinMaxAndPoint.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jRBtn_MinMaxAndPointMouseClicked(evt);
            }
        });

        buttonGroup1.add(jRBtn_percent);
        jRBtn_percent.setText("％(パーセント)");
        jRBtn_percent.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jRBtn_percentMouseClicked(evt);
            }
        });

        buttonGroup1.add(jRBtn_MinMax);
        jRBtn_MinMax.setText("指定値(低-高)");
        jRBtn_MinMax.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jRBtn_MinMaxMouseClicked(evt);
            }
        });

        jTextsmin.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextsmin.setText("50");

        jTextsmax.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextsmax.setText("150");

        jTextssmin.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextssmin.setText("30");

        jTextssmax.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextssmax.setText("90");

        jTextsspoint.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextsspoint.setText("60");

        jTextField2.setToolTipText("グラデーションパーセント");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jTextred, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextgreen, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextblue, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jTextField1, javax.swing.GroupLayout.DEFAULT_SIZE, 38, Short.MAX_VALUE)
                            .addComponent(jTextField2))
                        .addGap(91, 91, 91)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jRBtn_MinMax)
                            .addComponent(jRBtn_MinMaxAndPoint)
                            .addComponent(jRBtn_percent)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(21, 21, 21)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jTextssmin, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jTextssmax, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jTextsspoint, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jTextsmin, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jTextsmax, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)))))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(80, 80, 80)
                        .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(41, 41, 41)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jTextred, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextgreen, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextblue, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(8, 8, 8)
                        .addComponent(jRBtn_percent)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRBtn_MinMax)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jTextsmin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextsmax, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRBtn_MinMaxAndPoint)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jTextssmin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextssmax, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextsspoint, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(14, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged
        int sliderValue = jSlider1.getValue();
        jTextField1.setText(String.valueOf(sliderValue));
        
        float rangeSlider, rangeValue;
        int value = 0;
        
        switch(jRBselect) {
            case 1 :  // percent
                value = sliderValue;
                break;
            case 2 :  // MinMax
                rangeSlider = valueMax - valueMin;
                rangeValue = sliderValue - valueMin;
                value = (int)floor(rangeValue / rangeSlider * 100.0);
                break;
            case 3 :  // MinMaxAndPoint
                if(sliderValue >= valuePoint) {
                    float rangeColor = valueMax - valuePoint;
                    rangeValue = sliderValue - valuePoint;
                    value = (int)floor(rangeValue/rangeColor * 100.0);
                }
                break;
        }
        jTextField2.setText(String.valueOf(value));
        if(jRBselect > 0) {
            jTextred.setBackground(toneColor(Color.RED, value));
            jTextgreen.setBackground(toneColor(Color.GREEN, value));
            jTextblue.setBackground(toneColor(Color.BLUE, value));
        }
        
    }//GEN-LAST:event_jSlider1StateChanged

    private void jRBtn_percentMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRBtn_percentMouseClicked
        sliderSet_range();
    }//GEN-LAST:event_jRBtn_percentMouseClicked

    private void jRBtn_MinMaxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRBtn_MinMaxMouseClicked
        sliderSet_range();
    }//GEN-LAST:event_jRBtn_MinMaxMouseClicked

    private void jRBtn_MinMaxAndPointMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRBtn_MinMaxAndPointMouseClicked
        sliderSet_range();
    }//GEN-LAST:event_jRBtn_MinMaxAndPointMouseClicked

    /**
     * スライダーの可動範囲を設定.
     */
    private void sliderSet_range() {
        int new_jRBselect = 0;
        int chkMin = 0, chkMax = 100;
        
        if(jRBtn_percent.isSelected())         new_jRBselect = 1;
        if(jRBtn_MinMax.isSelected())          new_jRBselect = 2;
        if(jRBtn_MinMaxAndPoint.isSelected())  new_jRBselect = 3;
        
        // 入力チェック
        if(new_jRBselect == 2) {
            chkMin = Integer.parseInt(jTextsmin.getText());
            chkMax = Integer.parseInt(jTextsmax.getText());
        }
        if(new_jRBselect == 3) {
            chkMin = Integer.parseInt(jTextssmin.getText());
            chkMax = Integer.parseInt(jTextssmax.getText());
        }
        if(chkMin >= chkMax) {
            JOptionPane.showMessageDialog(null, "エラー(最小値＞最大値)");
            switch(jRBselect) {  // 直前の設定に戻す
                case 1 : jRBtn_percent.setSelected(true);        break;
                case 2 : jRBtn_MinMax.setSelected(true);         break;
                case 3 : jRBtn_MinMaxAndPoint.setSelected(true); break;    
            }
            return;
        }
        
        jRBselect = new_jRBselect;
        switch(jRBselect) {
            case 1 :  // percent
                valueMin = 0;
                valueMax = 100;
                sliderSet_MinMax(valueMin, valueMax);
                break;
            case 2 :  // MinMax
                valueMin = Integer.parseInt(jTextsmin.getText());
                valueMax = Integer.parseInt(jTextsmax.getText());
                sliderSet_MinMax(valueMin, valueMax);
                break;
            case 3 :  // MinMaxAndPoint
                valueMin = Integer.parseInt(jTextssmin.getText());
                valueMax = Integer.parseInt(jTextssmax.getText());
                valuePoint = Integer.parseInt(jTextsspoint.getText());
                sliderSet_MinMax(valueMin, valueMax);
                break;
        }
        jSlider1.setValue(valueMin);
    }
    
    void sliderSet_MinMax(int min, int max) {
        jSlider1.setMinimum(min);
        jSlider1.setMaximum(max);
    }

    /**
     * カラー設定.
     * @param strongColor  強調色
     * @param value グラデーション値
     * @return カラー属性
     */
    Color toneColor(Color strongColor, int value) {
        final int MAXRGB = 255;
        
        int toneR = MAXRGB;
        int toneG = MAXRGB;
        int toneB = MAXRGB;
        
        if(value < 0)   value = 0;
        if(value > 100) value = 100;
        
        int percentRGB     = MAXRGB * value / 100;
        int subtractionRGB = MAXRGB - percentRGB;
        if(Color.RED.equals(strongColor)) {
            toneG = subtractionRGB;
            toneB = subtractionRGB;
        }
        if(Color.GREEN.equals(strongColor)) {
            toneR = subtractionRGB;
            toneB = subtractionRGB;
        }
        if(Color.BLUE.equals(strongColor)) {
            toneR = subtractionRGB;
            toneG = subtractionRGB;
        }
        return new Color(toneR, toneG, toneB);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(TestColor01.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(TestColor01.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(TestColor01.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(TestColor01.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TestColor01().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton jRBtn_MinMax;
    private javax.swing.JRadioButton jRBtn_MinMaxAndPoint;
    private javax.swing.JRadioButton jRBtn_percent;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextblue;
    private javax.swing.JTextField jTextgreen;
    private javax.swing.JTextField jTextred;
    private javax.swing.JTextField jTextsmax;
    private javax.swing.JTextField jTextsmin;
    private javax.swing.JTextField jTextssmax;
    private javax.swing.JTextField jTextssmin;
    private javax.swing.JTextField jTextsspoint;
    // End of variables declaration//GEN-END:variables
    
}
