use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(header=>1,dir=>'asc');
&main_proc();

sub main_proc{

    my $res=GetOptions(\%opts,'in_file=s','out_file=s','header=i','tab','key_cols=s','dir=s');
    print decode("cp932",Dumper(\%opts));
    my $sep_char;
    if (defined($opts{tab})) {
        $sep_char="\t";
    }else{
        $sep_char=",";
    }
    
    my $csvobj = CSVAsHash->new(csv_header=>$opts{header},csv_sep_char=>$sep_char);
    my $aoh_in = $csvobj->csv2aoh($opts{'in_file'});
    my $org_cnt=scalar(@$aoh_in);
    printf "%s:%d件入力\n",decode("cp932",$opts{'in_file'}),$org_cnt;
    
    my $aoh_sort = CSVAsHash::sort_aoh($aoh_in,decode("cp932",$opts{key_cols}),dir=>$opts{dir});
    $csvobj->aoh2csv($aoh_sort,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@$aoh_sort);
}

