=pod
CSVの指定列の値が重複しているものを出力

patterns
    正規表現を","で区切る
reverse
    0:  合致するものを出力
    1:  合致しないものを出力
=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(header=>1);
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','col_names=s','header=i','tab');
    print decode("cp932",Dumper(\%opts));
    
    my $in_sep_char;
    if (defined($opts{tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    my $csv_in = CSVAsHash->new(csv_header=>$opts{header},csv_sep_char=>$in_sep_char);
    
    my $aoh_in = $csv_in->csv2aoh($opts{'in_file'});
    my $org_cnt=scalar(@$aoh_in);
    printf "%s:%d件入力\n",decode("cp932",$opts{'in_file'}),$org_cnt;
    
    my $arr = CSVAsHash::get_cols_values_duplicated($aoh_in,decode("cp932",$opts{col_names}));
	print join("\n",@$arr);
    printf "%d件重複\n",scalar(@$arr);
}

