=pod
CSVを結合
同一キーが存在する場合、削除してから追加
同一キーが複数行ある場合を想定

del_within_file
    0   同一ファイル内では消込を行わない
    1   同一ファイル内で消込を行う(デフォルト)
=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

#globals
my %opts=(in_header=>1,del_within_file=>1);
my $key_col_names;
my %g_cnt=(in=>0,del=>0);
my $csv_in;
my $csv_log;
my $aoh_in;
my $aoh_out;
my $aoh_buf;
my $aoh_log=[];

&main_proc();

sub main_proc{
    
   my $res=GetOptions(\%opts,'in_file=s','add_file_pattern=s','out_file=s','key_col_names=s','in_header=i','in_tab','log_file=s','del_within_file=i');
    print decode("cp932",Dumper(\%opts));
    if (!$res){
        die ('option err');
    }
    
    @$key_col_names = split(/,/,decode('cp932',$opts{key_col_names}));
    
    $csv_log=CSVAsHash->new;
    my @col_names = @$key_col_names;
    push @col_names,('読込順','ファイル','追加行数','削除行数');
    $csv_log->col_names(\@col_names);
    
    my @files = glob $opts{add_file_pattern};
    if (scalar(@files) == 0) {
        printf "%s:ファイルが見つかりません\n",decode('cp932',$opts{add_file_pattern});
        exit;
    }
    
    if (defined($opts{in_file})&&(-f $opts{in_file})) {
        unshift @files,$opts{in_file};
    }
    
    my $in_sep_char;
    if (defined($opts{in_tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    $csv_in = CSVAsHash->new(csv_header=>$opts{in_header},csv_sep_char=>$in_sep_char);
    
    @$aoh_out=();
    my $first_header;
    for (my $i=0;$i<scalar(@files);$i++) {
        $aoh_in=$csv_in->csv2aoh($files[$i]);
        if ($i==0){
        	$first_header=$csv_in->col_names();
        }else{
        	if (Util::is_same_array($csv_in->col_names(),$first_header,sort=>1)!=1) {
        		die("$files[$i]:ヘッダが一致しません\n");
        	}
        }   	
		add_file($files[$i]);
    }

    $csv_in->aoh2csv($aoh_out,$opts{out_file});
    my $diff=$g_cnt{in}-$g_cnt{del}-scalar(@$aoh_out);
    printf "%s:入力%d/削除%d/出力%d/差異%d件\n",
        decode("cp932",$opts{out_file}),$g_cnt{in},$g_cnt{del},scalar(@$aoh_out),$diff;
    if ($diff!=0){
        printf("差異がありました！\n");
    }
    $csv_log->aoh2csv($aoh_log,$opts{log_file});

}

sub add_file{
	my ($file) = @_;
	
    printf "%s:%d件入力\n",decode("cp932",$file),scalar(@$aoh_in);
    $g_cnt{in}+=scalar(@$aoh_in);
    
    @$aoh_buf=();
    my $lno=1;
    my @lines=();
    my $key_prev="";
    for my $line (@$aoh_in){
        my $key=CSVAsHash::concate_cols($line,$key_col_names);
        if ((scalar(@lines)>0) && ($key_prev ne $key)){
       		#キー割れ時
       		add_lines(\@lines,$file);
       		@lines=();
        }
        push @lines,$line;
        $key_prev=$key;  
        $lno++;
    }
    if (scalar(@lines)>0) {
    	add_lines(\@lines,$file);
    }
 	if ($opts{del_within_file}==0){   
        push @$aoh_out,@$aoh_buf;
 	}
}

sub add_lines{
	my ($lines,$file)=@_;
	
	my $header=$lines->[0];
	#既存の同一キーデータを削除
	my %key_hash=();
	my $log_hash=$csv_log->get_blank_row();
	for my $col_name (@$key_col_names){
		$key_hash{$col_name} = $header->{$col_name};
		$log_hash->{$col_name} = $header->{$col_name};		
	}
	
	my $del_cnt=CSVAsHash::delete_aoh($aoh_out,\%key_hash);
	if ($del_cnt>0){
  
	    $log_hash->{読込順}=scalar(@$aoh_log)+1;
	    #削除したデータ元ファイル名
	    my $aoh_sel = CSVAsHash::filter_aoh_by_value($aoh_log,\%key_hash);
	    my $files = CSVAsHash::get_cols_values($aoh_sel,"ファイル");
	    $log_hash->{ファイル}= join(",",@$files);
	    $log_hash->{追加行数}="";
	    $log_hash->{削除行数}=$del_cnt;
        push @$aoh_log,$log_hash; 
	    $g_cnt{del}+=$del_cnt;
	}
	
	#出力
	if ($opts{del_within_file}==1){
	   push @$aoh_out,@$lines;  
	}else{
	   push @$aoh_buf,@$lines;
	}
	
	$log_hash=$csv_log->get_blank_row();	
	for my $col_name (@$key_col_names){
		$log_hash->{$col_name} = $header->{$col_name};		
	}
	$log_hash->{読込順}=scalar(@$aoh_log)+1;
	$log_hash->{ファイル}=decode('cp932',$file);
	$log_hash->{追加行数}=scalar(@$lines);
    $log_hash->{削除行数}="";
    push @$aoh_log,$log_hash; 
        		

}
