use strict;
use warnings;
use Carp;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;
use Util;
#use Term::Getch;
use IO::Handle;
use File::Path 'rmtree';
use File::Copy qw /copy/;
use File::Glob::Windows;

STDOUT->autoflush(1);
binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

#$File::Glob::Windows::encoding = File::Glob::Windows::getCodePage();
my %opts=(dir1=>".");
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'dir1=s','dir2=s');
    print decode("cp932",Dumper(\%opts));
    printf("[%s]と[%s]を比較\n",decode("cp932",$opts{dir1}),decode("cp932",$opts{dir2}));
    
    my $hash1=get_hash($opts{dir1});
    my $hash2=get_hash($opts{dir2});

    my $hoh = Util::compare_hash($hash1,$hash2);
    my @keys = sort keys %$hoh;
    my ($new_zips_dir1,$new_zips_dir2) = (0,0);
    for my $key (@keys) {
        my $zip=$hoh->{$key};
        if ($zip->{compare} eq '<' ){
            $new_zips_dir2=1;
        }
        if ($zip->{compare} eq '>' ){
            $new_zips_dir1=1;
        }
        printf("%s%-5s%-20s%-20s\n",
            Util::get_paddedstr4unicode($key,20),
            $zip->{compare},
            $zip->{val1},
            $zip->{val2});
    }
    
    if ($new_zips_dir1==0 && $new_zips_dir2==0) {
        print "***全て最新です***\n";
    }
    
    if ($new_zips_dir1==1){
        printf "新しいZIPを%sにコピーしますか?(y/n)",decode('cp932',$opts{dir2});
        my $char=<STDIN>;
        chomp($char);
        if ($char eq 'y' ) {
            for my $key (@keys) {
                my $zip=$hoh->{$key};
                if ($zip->{compare} eq '>') {
                    my $zip_file = sprintf("%s_%s.zip",$zip->{key},$zip->{val1});
                    printf "copy:%s\n",$zip_file;
                    $zip_file=encode('cp932',$zip_file);
                    copy $zip_file,$opts{dir2} || die @!;
                }
            }
        }
    }

    if ($new_zips_dir2==1){
        print "新しいZIPを展開しますか?(y/n)";
        my $char=<STDIN>;
        chomp($char);
        if ($char eq 'y' ) {
            for my $key (@keys) {
                my $zip=$hoh->{$key};
                if ($zip->{compare} eq '<') {
                    my $dir_sjis=encode('cp932',$zip->{key});
                    if (-d $dir_sjis) {
                        rmtree($dir_sjis,{verose=>1})||croak $!;
                    }
                    my $old_zip = sprintf("%s_*.zip",$dir_sjis);
                    unlink glob($old_zip);
                    my $zip_file = sprintf("%s_%s.zip",$zip->{key},$zip->{val2});
                    printf "extract:%s\n",$zip_file;
                    $zip_file=encode('cp932',$zip_file);
                    copy $opts{dir2}."/".$zip_file,"." || die @!;
                    Util::unzip($zip_file);
                }
            }
        }
    }
}

sub get_hash{
    my $dir=shift;
    
    my %hash=();
    my @files = glob("$dir\\*.zip");
    for my $file (@files) {
        $file = decode('cp932',$file);
        if ($file =~ /\\([^\\]*)_(\d{8}_\d{4})/){
            if (!defined($hash{$1})){
                $hash{$1}=$2;
            }else{
                if (($hash{$1} cmp $2) <0) {
                    $hash{$1} = $2;
                }
            }
        }
    }
    return \%hash;
}
