=pod
CSVを参照CSVで更新

--rule=a:b
	参照CSVのa列から入力CSVのb列にコピー
	a,bは列名
=cut

use strict;
use warnings;

use Getopt::Long;
use IO::File;
use Data::Dumper;
use utf8;
use Encode;

use Util;
use CSVAsHash;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

my %opts=(in_header=>1,ref_header=>1);
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'in_file=s','ref_file=s','out_file=s','in_key_col_names=s','ref_key_col_names=s','in_header=i','ref_header=i','in_tab','ref_tab','rule=s@');
    print decode("cp932",Dumper(\%opts));
    
    my $in_sep_char;
    if (defined($opts{in_tab})) {
        $in_sep_char="\t";
    }else{
        $in_sep_char=",";
    }
    
    my $csv_in = CSVAsHash->new(csv_header=>$opts{in_header},csv_sep_char=>$in_sep_char);
    
    my $ref_sep_char;
    if (defined($opts{ref_tab})) {
        $ref_sep_char="\t";
    }else{
        $ref_sep_char=",";
    }
    
    my $csv_ref = CSVAsHash->new(csv_header=>$opts{ref_header},csv_sep_char=>$ref_sep_char);
    
    my $aoh_in = $csv_in->csv2aoh($opts{'in_file'});
    my $org_cnt=scalar(@$aoh_in);
    printf "%s:%d件入力\n",decode("cp932",$opts{'in_file'}),$org_cnt;
    
    my $hoh_ref = $csv_in->csv2hoh($opts{ref_file},decode("cp932",$opts{ref_key_col_names}));
    
    my %rules=();
    for my $rule (@{$opts{rule}}){
    	$rule = decode("cp932",$rule);
    	if ($rule =~ /(.+):(.+)/ ){
    		$rules{$1} = $2;
    	}
    }
    print Dumper \%rules;
    CSVAsHash::update_aoh($aoh_in,decode("cp932",$opts{in_key_col_names}),$hoh_ref,\%rules);
    $csv_in->aoh2csv($aoh_in,$opts{out_file});
    printf "%s:%d件出力しました\n",decode("cp932",$opts{out_file}),scalar(@$aoh_in);
}

