package com.komasan.komainu;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import android.util.Log;

/**
 * Created by 005869 on 2015/06/20.
 */
public class FileWriterKomasan{

    public String FileName = "";
//    public static final String PATH = "/data/data/com.komasan.komainu/files/";
//    public static final String PATH = "/data/";
//    private static final String FILENAME = "test.csv";
public static final String StrageDir = "/data/data/com.komasan.komainu/files/";


    public FileWriterKomasan(String fileName) {
        Log.d("FileWriter", "onCreate");
        Log.d("FileWriter", "Filename:" + fileName);
        FileName = fileName;
    }

    // デバック用　不要になったら消してください
    public List<String> debugList(){
        List<String> list = new ArrayList<>();
        // ワード,限界回数,現在回数
        list.add("ばか,10,0");
        list.add("あほ,8,5");
        list.add("死ね,3,2");
        list.add("はげ,10,5");
        list.add("たこ,15,0");
        list.add("Fuck,10,2");
        return list;
    }

    // デバック用　不要になったら消してください
    public void logList(List<String> list) {
        for(String str: list){
            Log.d("FileWriter", str);
        }
    }

    /**
     * CSVファイルからいじめワード情報を読み込む<br>
     * ファイルが見つからなかった場合はテンプレートを作成＆ファイル保存する。
     *
     * @return CSVファイルから読み込んだいじめワードリスト
     */
    public List<String> readCsvKomasan() {
        List<String> list = new ArrayList<>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(StrageDir + FileName), "UTF-8"));
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        } catch (FileNotFoundException fnfe) {
            if(FileName == NotificationService.IZIMEDB) {
                list = debugList();
            }
            else {
                Log.d("readCsvKomasan", "ReadError FileName:" + FileName);
            }
            return writeCsvKomasan(list, FileName);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    /**
     * CSVファイルにいじめワード情報を書き込む
     *
     * @param list 更新対象リスト
     * @param filename 書き込みファイル名
     */
    public List<String> writeCsvKomasan(List<String> list, String filename) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(StrageDir + filename));
//            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(MainActivity.StrageDir + filename), "UTF-8"));

            for (String str : list) {
                bw.write(str);
                bw.newLine();
            }
        } catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (bw != null) {
                try {
                    bw.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return list;
        }
    }
}


