
/* --------------------------------------------- */
/*  H8-3069F Start up routine                    */
/*                (c) KAZ.Imamura                */
/*  Target : AKI-3069-USB on h8mon               */
/* --------------------------------------------- */

	.h8300h
	.section .text
	.global	_start
	.global	_permit_irq
	.global	_prohibit_irq
	.global	_wait_100us


_start:
	jmp	_main					; Goto main()
	
_sleep:
	sleep
	rts
	
_permit_irq:
	andc.b #0x7f, ccr
	rts

_prohibit_irq:
	orc.b #0x80, ccr
	rts


_wait_100us:
	orc.b #0x80, ccr				; 2 state
	push.w r2						; 8 state
	mov.w #0x0271, r2				; 4 state  
	dec.w #1, r2					; 2 state
	bne .-2							; 2 state  ----- 4 state (160ns) * 620+5(O) = 100us
	pop.w r2						; 2 state
	andc.b #0x7f, ccr				; 2 state
	rts
	.end
	