
/* --------------------------------------------- */
/*  H8-3069F LED function                        */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */


#include "led.h"

#define LED_NUM 2

static unsigned char led_mode[LED_NUM];
unsigned int led_timer1;
unsigned int led_timer2;
unsigned char led_timing_bit;		// bit7:1000ms , bit6:300ms

void led_initialize( void );
void led_20ms_handler( void );
void led_process( void );

void led_mode_set( unsigned char ch, unsigned char mode );

// -------------------------------------------
//  LED initialize
// -------------------------------------------
void led_initialize( void ) {
	unsigned char i;
	
	led_timer1 = 0;
	led_timer2 = 0;
	led_timing_bit = 0;
	for(i=0; i<LED_NUM; i++) led_mode[i] = LED_MODE_OFF;
}


// -------------------------------------------
//  LED mode set service function
// -------------------------------------------
void led_mode_set( unsigned char ch, unsigned char mode ) {
	if( ch >= LED_NUM ) return;
	led_mode[ch] = mode;
}

// -------------------------------------------
//  LED Process
// -------------------------------------------
void led_process( void ) {
	unsigned char i;
	
	for(i=0;i<LED_NUM; i++) {
		switch( led_mode[i] ) {
			case LED_MODE_OFF:
				P4DR.BYTE |= 0x80 >> i;
				break;
			case LED_MODE_ON:
				P4DR.BYTE &= ~(0x80 >> i);
				break;
				
			case LED_MODE_BLINK_300MS:
				if(led_timing_bit & 0x80 )	P4DR.BYTE &= ~(0x80 >> i);
				else 						P4DR.BYTE |= (0x80 >> i);
				break;
				
			case LED_MODE_BLINK_1000MS:
				if(led_timing_bit & 0x40 )	P4DR.BYTE &= ~(0x80 >> i);
				else 						P4DR.BYTE |= (0x80 >> i);
				break;
				
			case LED_MODE_BLINK_R300MS:
				if(led_timing_bit & 0x80 )	P4DR.BYTE |= (0x80 >> i);
				else 						P4DR.BYTE &= ~(0x80 >> i);
				break;
				
			case LED_MODE_BLINK_R1000MS:
				if(led_timing_bit & 0x40 )	P4DR.BYTE |= (0x80 >> i);
				else 						P4DR.BYTE &= ~(0x80 >> i);
				break;
			default:
				break;
		}
	}
}


// -------------------------------------------
//  LED 1ms interrupt handler
// -------------------------------------------
void led_20ms_handler(void) {
	unsigned char i;
	
	i = led_timing_bit;
	if( ++led_timer1 >= 15 ) {				// 300ms
		led_timing_bit &= 0x7F;			// clear
		led_timing_bit |= (~i)&0x80;	// set
		led_timer1 = 0;
	}
	
	if( ++led_timer2 >= 50 ) {				// 1000ms
		led_timing_bit &= 0xBF;			// clear
		led_timing_bit |= (~i)&0x40;	// set
		led_timer2 = 0;
	}
}


