require 'test_helper'

class OrderNotifierTest < ActionMailer::TestCase
  test "received" do
    mail = OrderNotifier.received(orders(:one))
    assert_equal "Pragmatic Store Order Conrirmation", mail.subject
    assert_equal ["deve@example.org"], mail.to
    assert_equal ["depot@example.com"], mail.from
    assert_match /1 x Programing Ruby 1.9/, mail.body.encoded
  end

  test "shipped" do
    mail = OrderNotifier.shipped(orders(:one))
    assert_equal "Progmatic Store Order Shipped", mail.subject
    assert_equal ["dave@example.org"], mail.to
    assert_equal ["dapot@example.com"], mail.from
    assert_match "Hi", mail.body.encoded
  end

end
