#ifndef GETTID_H
#define GETTID_H

#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>

#include <boost/noncopyable.hpp>

namespace l7vs
{

class get_tid : boost::noncopyable
{
public:
        static pid_t gettid(void) {
                return syscall(SYS_gettid);
        };
};

/*
extern "C"
pid_t gettid(void)
{
        return syscall(SYS_gettid);
}
*/

}

#endif
