<?php
/*
  $Id: header.php,v 1.3 2006/07/16 05:09:34 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

// check if the 'install' directory exists, and warn of its existence
  if (WARN_INSTALL_EXISTENCE == 'true') {
    if (file_exists(dirname($_SERVER['SCRIPT_FILENAME']) . '/install')) {
      echo '<p class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_INSTALL_DIRECTORY_EXISTS . '</p>';
    }
  }

// check if the configure.php file is writeable
  if (WARN_CONFIG_WRITEABLE == 'true') {
    if ( (file_exists(dirname($_SERVER['SCRIPT_FILENAME']) . '/includes/configure.php')) && (is_writeable(dirname($_SERVER['SCRIPT_FILENAME']) . '/includes/configure.php')) ) {
      echo '<p class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_CONFIG_FILE_WRITEABLE . '</p>';
    }
  }

// check if the session folder is writeable
  if (WARN_SESSION_DIRECTORY_NOT_WRITEABLE == 'true') {
    if (STORE_SESSIONS == '') {
      if (!is_dir(tep_session_save_path())) {
        echo '<p class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_SESSION_DIRECTORY_NON_EXISTENT . '</p>';
      } elseif (!is_writeable(tep_session_save_path())) {
        echo '<p class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_SESSION_DIRECTORY_NOT_WRITEABLE . '</p>';
      }
    }
  }

// check session.auto_start is disabled
  if ( (function_exists('ini_get')) && (WARN_SESSION_AUTO_START == 'true') ) {
    if (ini_get('session.auto_start') == '1') {
      echo '<p class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_SESSION_AUTO_START . '</p>';
    }
  }

  if ( (WARN_DOWNLOAD_DIRECTORY_NOT_READABLE == 'true') && (DOWNLOAD_ENABLED == 'true') ) {
    if (!is_dir(DIR_FS_DOWNLOAD)) {
      echo '<p class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT . '</p>';
    }
  }
?>
<div id="header">
<div id="headerLeft">
<h1><?php echo '<a href="' . tep_href_link(FILENAME_DEFAULT) . '">' . tep_image(DIR_WS_IMAGES . KN_HEADER_IMAGE01, TITLE) . '</a>'; ?></h1>
<p class="naviskip"><a href="#skipped"><?php echo tep_image(DIR_WS_IMAGES . 'pixel_trans.gif', TEXT_NAVISKIP); ?></a></p>
</div>
<div id="headerRight"><?php echo tep_image(DIR_WS_IMAGES . KN_HEADER_IMAGE02, TITLE); ?></div>
</div>
<hr />
<div id="headerBar">
<p id="breadcrumb"><?php echo $breadcrumb->trail(' &raquo; '); ?></p>
<?php
  if (!defined("KN_CFG_ALLOW_CHECKOUT") || (KN_CFG_ALLOW_CHECKOUT == "true")) {
?>
<hr />
<ul id="headerMenu">
<?php
  if (tep_session_is_registered('customer_id')) {
?>
<li><a href="<?php echo tep_href_link(FILENAME_LOGOFF, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGOFF; ?></a></li>
<?php
   }
?>
<li><a href="<?php echo tep_href_link(FILENAME_ACCOUNT, '', 'SSL'); ?>"><?php echo HEADER_TITLE_MY_ACCOUNT; ?></a></li>
<li><a href="<?php echo tep_href_link(FILENAME_SHOPPING_CART); ?>"><?php echo HEADER_TITLE_CART_CONTENTS; ?></a></li>
<li><a href="<?php echo tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'); ?>"><?php echo HEADER_TITLE_CHECKOUT; ?></a></li>
</ul>
<?php
  }
?>
<br class="clear" />
</div>
<?php
  if (isset($_GET['error_message']) && tep_not_null($_GET['error_message'])) {
?>
<p class="headerError"><?php echo htmlspecialchars(urldecode($_GET['error_message'])); ?></p>
<?php
  }

  if (isset($_GET['info_message']) && tep_not_null($_GET['info_message'])) {
?>
<p class="headerInfo"><?php echo htmlspecialchars($_GET['info_message']); ?></p>
<?php
  }
?>
