<?php
/*
  $Id: advanced_search_result.php,v 1.12 2009/04/14 23:51:23 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_ADVANCED_SEARCH_RESULT);

  $error = 0; // reset error flag to false
  $errorno = 0;

  // 郎åȤƤ뤫ɤΥå
  if ((isset($_GET['keywords_p_name']) && empty($_GET['keywords_p_name'])) &&
       empty($_GET['keywords_p_author']) &&
       empty($_GET['keywords_p_publishers']) &&
       empty($_GET['categories_id']) &&
       empty($_GET['manufacturers_id']) &&
       (empty($_GET['dfrom']) || ($_GET['dfrom'] == DOB_FORMAT_STRING)) &&
       (empty($_GET['dto']) || ($_GET['dto'] == DOB_FORMAT_STRING)) &&
       empty($_GET['pfrom']) &&
       empty($_GET['pto'])) {
    $errorno += 1;
    $error = 1;
  } elseif (isset($_GET['keywords']) && empty($_GET['keywords'])) {
    tep_redirect(tep_href_link(FILENAME_ADVANCED_SEARCH));
  }

  $dfrom_to_check = (($_GET['dfrom'] == DOB_FORMAT_STRING) ? '' : $_GET['dfrom']);
  $dto_to_check = (($_GET['dto'] == DOB_FORMAT_STRING) ? '' : $_GET['dto']);

  // Ͽʳˤå
  if (strlen($dfrom_to_check) > 0) {
    if (!tep_checkdate($dfrom_to_check, DOB_FORMAT_STRING, $dfrom_array)) {
      $errorno += 10;
      $error = 1;
    }
  }  

  // Ͽʽλˤå
  if (strlen($dto_to_check) > 0) {
    if (!tep_checkdate($dto_to_check, DOB_FORMAT_STRING, $dto_array)) {
      $errorno += 100;
      $error = 1;
    }
  }

  // ϿʳˤϿʽλˤΤۤ夫ɤΥå
  if (strlen($dfrom_to_check) > 0 && !(($errorno & 10) == 10) && strlen($dto_to_check) > 0 && !(($errorno & 100) == 100)) {
    if (mktime(0, 0, 0, $dfrom_array[1], $dfrom_array[2], $dfrom_array[0]) > mktime(0, 0, 0, $dto_array[1], $dto_array[2], $dto_array[0])) {
      $errorno += 1000;
      $error = 1;
    }
  }

  // ʡʺˤͤɤΥå
  if (strlen($_GET['pfrom']) > 0) {
    $pfrom_to_check = $_GET['pfrom'];
    if (!settype($pfrom_to_check, "double")) {
      $errorno += 10000;
      $error = 1;
    }
  }

  // ʡʺǹˤͤɤΥå
  if (strlen($_GET['pto']) > 0) {
    $pto_to_check = $_GET['pto'];
    if (!settype($pto_to_check, "double")) {
      $errorno += 100000;
      $error = 1;
    }
  }

  // ʡʺˤʡʺǹˤΤۤ⤤ɤΥå
  if (strlen($_GET['pfrom']) > 0 && !(($errorno & 10000) == 10000) && strlen($_GET['pto']) > 0 && !(($errorno & 100000) == 100000)) {
    if ($pfrom_to_check > $pto_to_check) {
      $errorno += 1000000;
      $error = 1;
    }
  }

  // ɤå
  if (strlen($_GET['keywords']) > 0) {
    if (!tep_parse_search_string(stripslashes($_GET['keywords']), $search_keywords)) {
      $errorno += 10000000;
      $error = 1;
    }
  }
  
  if ($error == 1) {
    tep_redirect(tep_href_link(FILENAME_ADVANCED_SEARCH, 'errorno=' . $errorno . '&' . tep_get_all_get_params(array('x', 'y'))));
  } else {
    $breadcrumb->add(NAVBAR_TITLE1, tep_href_link(FILENAME_ADVANCED_SEARCH));
    $breadcrumb->add(NAVBAR_TITLE2, tep_href_link(FILENAME_ADVANCED_SEARCH_RESULT, 'keywords=' . $_GET['keywords'] . '&search_in_description=' . $_GET['search_in_description'] . '&categories_id=' . $_GET['categories_id'] . '&inc_subcat=' . $_GET['inc_subcat'] . '&manufacturers_id=' . $_GET['manufacturers_id'] . '&pfrom=' . $_GET['pfrom'] . '&pto=' . $_GET['pto'] . '&dfrom=' . $_GET['dfrom'] . '&dto=' . $_GET['dto']));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<?php 
  $customCSS = substr(FILENAME_ADVANCED_SEARCH_RESULT, 0, strrpos(FILENAME_ADVANCED_SEARCH_RESULT, '.')). ".css";
  if (file_exists($customCSS)){
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"$customCSS\" media=\"screen,print\" />";
  }
?>
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="advancedSearch">
<?php
  // create column list
  $define_list = array();
  $define_list['PRODUCT_LIST_MODEL'] = KN_CFG_PRODUCT_LIST_MODEL;
  $define_list['PRODUCT_LIST_NAME'] = KN_CFG_PRODUCT_LIST_NAME;
  if (KN_CFG_USE_SUBTITLE == 'true') {
    $define_list['PRODUCT_LIST_SUBTITLE'] = KN_CFG_PRODUCT_LIST_SUBTITLE;
  }
  if (KN_CFG_USE_SERIES_TITLE == 'true') {
    $define_list['PRODUCT_LIST_SERIES_TITLE'] = KN_CFG_PRODUCT_LIST_SERIES_TITLE;
  }
  if (KN_CFG_USE_AUTHOR == 'true') {
    $define_list['PRODUCT_LIST_AUTHOR'] = KN_CFG_PRODUCT_LIST_AUTHOR;
  }
  if (KN_CFG_USE_PUBLISHED == 'true') {
    $define_list['PRODUCT_LIST_PUBLISHED'] = KN_CFG_PRODUCT_LIST_PUBLISHED;
  }
  if (KN_CFG_USE_PUBLISHERS == 'true') {
    $define_list['PRODUCT_LIST_PUBLISHERS'] = KN_CFG_PRODUCT_LIST_PUBLISHERS;
  }
  if (KN_CFG_USE_VOLUME == 'true') {
    $define_list['PRODUCT_LIST_VOLUME'] = KN_CFG_PRODUCT_LIST_VOLUME;
  }
  if (KN_CFG_USE_ISBN == 'true') {
    $define_list['PRODUCT_LIST_ISBN'] = KN_CFG_PRODUCT_LIST_ISBN;
  }
  $define_list['PRODUCT_LIST_PRICE'] = KN_CFG_PRODUCT_LIST_PRICE;
  $define_list['PRODUCT_LIST_BUY_NOW'] = KN_CFG_PRODUCT_LIST_BUY_NOW;
  $define_list['PRODUCT_LIST_IMAGE'] = KN_CFG_PRODUCT_LIST_IMAGE;
  $define_list['PRODUCT_LIST_QUANTITY'] = KN_CFG_PRODUCT_LIST_QUANTITY;
  $define_list['PRODUCT_LIST_WEIGHT'] = KN_CFG_PRODUCT_LIST_WEIGHT;
  $define_list['PRODUCT_LIST_DESCRIPTION'] = KN_CFG_PRODUCT_LIST_DESCRIPTION;
  asort($define_list);

  $column_list = array();
  reset($define_list);
  while (list($column, $value) = each($define_list)) {
    if ($value) $column_list[] = $column;
  }

  $select_column_list = '';
  $flg_subtitle = 0;
  $flg_series_title = 0;
  $flg_volume = 0;
  $flg_published = 0;
  $flg_publishers = 0;
  for ($col=0, $n=sizeof($column_list); $col<$n; $col++) {
    if ( ($column_list[$col] == 'PRODUCT_LIST_BUY_NOW') || ($column_list[$col] == 'PRODUCT_LIST_NAME') || ($column_list[$col] == 'PRODUCT_LIST_PRICE') ) {
      continue;
    }

    if (tep_not_null($select_column_list)) {
      $select_column_list .= ', ';
    }

    switch ($column_list[$col]) {
      case 'PRODUCT_LIST_MODEL':
        $select_column_list .= 'p.products_model';
        break;
      case 'PRODUCT_LIST_SUBTITLE':
        if ($flg_subtitle) {
          $select_column_list = rtrim($select_column_list, ', ');
          break;
        }
        $select_column_list .= 'pd.products_subtitle';
        $flg_subtitle = 1;
        break;
      case 'PRODUCT_LIST_SERIES_TITLE':
        if ($flg_series_title) {
          $select_column_list = rtrim($select_column_list, ', ');
          break;
        }
        $select_column_list .= 'pd.products_series_title';
        $flg_series_title = 1;
        break;
      case 'PRODUCT_LIST_AUTHOR':
        $select_column_list .= 'pd.products_author';
        break;
      case 'PRODUCT_LIST_PUBLISHED':
        if ($flg_published) {
          $select_column_list = rtrim($select_column_list, ', ');
          break;
        }
        $select_column_list .= 'pd.products_published';
        $flg_published = 1;
        break;
      case 'PRODUCT_LIST_PUBLISHERS':
        if ($flg_publishers) {
          $select_column_list = rtrim($select_column_list, ', ');
          break;
        }
        $select_column_list .= 'pd.products_publishers';
        $flg_publishers = 1;
        break;
      case 'PRODUCT_LIST_VOLUME':
        if ($flg_volume) {
          $select_column_list = rtrim($select_column_list, ', ');
          break;
        }
        $select_column_list .= 'pd.products_volume';
        $flg_volume = 1;
        break;
      case 'PRODUCT_LIST_ISBN':
        $select_column_list .= 'p.products_isbn';
        break;
      case 'PRODUCT_LIST_QUANTITY':
        $select_column_list .= 'p.products_quantity';
        break;
      case 'PRODUCT_LIST_IMAGE':
        $select_column_list .= 'p.products_image';
        break;
      case 'PRODUCT_LIST_WEIGHT':
        $select_column_list .= 'p.products_weight';
        break;
      case 'PRODUCT_LIST_DESCRIPTION':
        if (!$flg_subtitle) {
          $select_column_list .= 'pd.products_subtitle, ';
          $flg_subtitle = 1;
        }
        if (!$flg_series_title) {
          $select_column_list .= 'pd.products_series_title, ';
          $flg_series_title = 1;
        }
        if (!$flg_published) {
          $select_column_list .= 'pd.products_published, ';
          $flg_published = 1;
        }
        if (!$flg_publishers) {
          $select_column_list .= 'pd.products_publishers, ';
          $flg_publishers = 1;
        }
        if (!$flg_volume) {
          $select_column_list .= 'pd.products_volume, ';
          $flg_volume = 1;
        }
        $select_column_list .= 'pd.products_description';
        break;
    }
  }

  if (tep_not_null($select_column_list)) {
    $select_column_list .= ', ';
  }

  $select_str = "select distinct " . $select_column_list . " m.manufacturers_id, p.products_id, pd.products_name, p.products_price, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, IF(s.status, s.specials_new_products_price, p.products_price) as final_price ";

  if ( (DISPLAY_PRICE_WITH_TAX == 'true') && ( (isset($_GET['pfrom']) && tep_not_null($_GET['pfrom'])) || (isset($_GET['pto']) && tep_not_null($_GET['pto']))) ) {
    $select_str .= ", SUM(tr.tax_rate) as tax_rate ";
  }

  $from_str = "from (" . TABLE_PRODUCTS . " p left join " . TABLE_MANUFACTURERS . " m using(manufacturers_id), " . TABLE_PRODUCTS_DESCRIPTION . " pd) left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c";

  if ( (DISPLAY_PRICE_WITH_TAX == 'true') && ( (isset($_GET['pfrom']) && tep_not_null($_GET['pfrom'])) || (isset($_GET['pto']) && tep_not_null($_GET['pto']))) ) {
    if (!tep_session_is_registered('customer_country_id')) {
      $customer_country_id = STORE_COUNTRY;
      $customer_zone_id = STORE_ZONE;
    }
    $from_str .= " left join " . TABLE_TAX_RATES . " tr on p.products_tax_class_id = tr.tax_class_id left join " . TABLE_ZONES_TO_GEO_ZONES . " gz on tr.tax_zone_id = gz.geo_zone_id and (gz.zone_country_id is null or gz.zone_country_id = '0' or gz.zone_country_id = '" . $customer_country_id . "') and (gz.zone_id is null or gz.zone_id = '0' or gz.zone_id = '" . $customer_zone_id . "')";
  }

  $where_str = " where p.products_status = '1' and p.products_id = pd.products_id and pd.language_id = '" . $languages_id . "' and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id ";

  if (isset($_GET['categories_id']) && tep_not_null($_GET['categories_id'])) {
    if ($_GET['inc_subcat'] == '1') {
      $subcategories_array = array();
      tep_get_subcategories($subcategories_array, $_GET['categories_id']);
      $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and (p2c.categories_id = '" . (int)$_GET['categories_id'] . "'";
      for ($i=0, $n=sizeof($subcategories_array); $i<$n; $i++ ) {
        $where_str .= " or p2c.categories_id = '" . $subcategories_array[$i] . "'";
      }
      $where_str .= ")";
    } else {
      $where_str .= " and p2c.products_id = p.products_id and p2c.products_id = pd.products_id and pd.language_id = '" . $languages_id . "' and p2c.categories_id = '" . $_GET['categories_id'] . "'";
    }
  }

  if (isset($_GET['manufacturers_id']) && tep_not_null($_GET['manufacturers_id'])) {
    $where_str .= " and m.manufacturers_id = '" . $_GET['manufacturers_id'] . "'";
  }

  // BOXθ
  if (isset($_GET['keywords']) && tep_not_null($_GET['keywords'])) {
    if (tep_parse_search_string(stripslashes($_GET['keywords']), $search_keywords)) {
      $where_str .= " and (";
      for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
        switch ($search_keywords[$i]) {
          case '(':
          case ')':
          case 'and':
          case 'or':
            $where_str .= " " . $search_keywords[$i] . " ";
            break;
          default:
            $where_str .= "(pd.products_name like '%" . addslashes($search_keywords[$i]) . "%'";
            if (KN_CFG_USE_SUBTITLE == 'true') {
              $where_str .= " or pd.products_subtitle like '%" . addslashes($search_keywords[$i]) . "%'";
            }
            if (KN_CFG_USE_SERIES_TITLE == 'true') {
              $where_str .= " or pd.products_series_title like '%" . addslashes($search_keywords[$i]) . "%'";
            }
            if (KN_CFG_USE_AUTHOR == 'true') {
              $where_str .= " or pd.products_author like '%" . addslashes($search_keywords[$i]) . "%'";
            }
            if (KN_CFG_USE_PUBLISHERS == 'true') {
              $where_str .= " or pd.products_publishers like '%" . addslashes($search_keywords[$i]) . "%'";
            }
            $where_str .= " or pd.products_keywords like '%" . addslashes($search_keywords[$i]) . "%'";
            if (isset($_GET['search_in_description']) && ($_GET['search_in_description'] == '1')) $where_str .= " or pd.products_description like '%" . addslashes($search_keywords[$i]) . "%'";
              $where_str .= ')';
            break;
        }
      }
      $where_str .= " )";
    }
  } else {
    // ܺٸξ̾
    if (isset($_GET['keywords_p_name']) && tep_not_null($_GET['keywords_p_name'])) {
      if (tep_parse_search_string(stripslashes($_GET['keywords_p_name']), $search_keywords)) {
        $where_str .= " and (";
        for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
          switch ($search_keywords[$i]) {
            case '(':
            case ')':
            case 'and':
            case 'or':
              $where_str .= " " . $search_keywords[$i] . " ";
              break;
            default:
              $where_str .= "(pd.products_name like '%" . addslashes($search_keywords[$i]) . "%'";
              if (isset($_GET['search_in_subtitle']) && ($_GET['search_in_subtitle'] == '1')) {
                if (KN_CFG_USE_SUBTITLE == 'true') {
                  $where_str .= " or pd.products_subtitle like '%" . addslashes($search_keywords[$i]) . "%'";
                }
                if (KN_CFG_USE_SERIES_TITLE == 'true') {
                  $where_str .= " or pd.products_series_title like '%" . addslashes($search_keywords[$i]) . "%'";
                }
              }
              $where_str .= ')';
              break;
          }
        }
        $where_str .= " )";
      }
    }
    // ܺٸ̾
    if (isset($_GET['keywords_p_author']) && tep_not_null($_GET['keywords_p_author'])) {
      if (tep_parse_search_string(stripslashes($_GET['keywords_p_author']), $search_keywords)) {
        $where_str .= " and (";
        for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
          switch ($search_keywords[$i]) {
            case '(':
            case ')':
            case 'and':
            case 'or':
              $where_str .= " " . $search_keywords[$i] . " ";
              break;
            default:
              $where_str .= "(pd.products_author like '%" . addslashes($search_keywords[$i]) . "%')";
              break;
          }
        }
        $where_str .= " )";
      }
    }
    // ܺٸνǼҸ
    if (isset($_GET['keywords_p_publishers']) && tep_not_null($_GET['keywords_p_publishers'])) {
      if (tep_parse_search_string(stripslashes($_GET['keywords_p_publishers']), $search_keywords)) {
        $where_str .= " and (";
        for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
          switch ($search_keywords[$i]) {
            case '(':
            case ')':
            case 'and':
            case 'or':
              $where_str .= " " . $search_keywords[$i] . " ";
              break;
            default:
              $where_str .= "(pd.products_publishers like '%" . addslashes($search_keywords[$i]) . "%')";
              break;
          }
        }
        $where_str .= " )";
      }
    }
    // ܺٸISBN
    if (isset($_GET['keywords_p_isbn']) && tep_not_null($_GET['keywords_p_isbn'])) {
      if (tep_parse_search_string(stripslashes($_GET['keywords_p_isbn']), $search_keywords)) {
        $where_str .= " and (";
        for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
          switch ($search_keywords[$i]) {
            case '(':
            case ')':
            case 'and':
            case 'or':
              $where_str .= " " . $search_keywords[$i] . " ";
              break;
            default:
              $where_str .= "(p.products_isbn like '%" . addslashes($search_keywords[$i]) . "%')";
              break;
          }
        }
        $where_str .= " )";
      }
    }
  }


  if (isset($_GET['dfrom']) && tep_not_null($_GET['dfrom']) && ($_GET['dfrom'] != DOB_FORMAT_STRING)) {
    $where_str .= " and p.products_date_added >= '" . tep_date_raw($dfrom_to_check) . "'";
  }

  if (isset($_GET['dto']) && tep_not_null($_GET['dto']) && ($_GET['dto'] != DOB_FORMAT_STRING)) {
    $where_str .= " and p.products_date_added <= '" . tep_date_raw($dto_to_check) . "'";
  }

  $rate = $currencies->get_value($currency);
  if ($rate) {
    $pfrom = $_GET['pfrom'] / $rate;
    $pto = $_GET['pto'] / $rate;
  }

  if (DISPLAY_PRICE_WITH_TAX == 'true') {
    if ($pfrom) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) * if(gz.geo_zone_id is null, 1, 1 + (tr.tax_rate / 100) ) >= " . $pfrom . ")";
    if ($pto)   $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) * if(gz.geo_zone_id is null, 1, 1 + (tr.tax_rate / 100) ) <= " . $pto . ")";
  } else {
    if ($pfrom) $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) >= " . $pfrom . ")";
    if ($pto)   $where_str .= " and (IF(s.status, s.specials_new_products_price, p.products_price) <= " . $pto . ")";
  }

  if ( (DISPLAY_PRICE_WITH_TAX == 'true') && ((isset($_GET['pfrom']) && tep_not_null($_GET['pfrom'])) || (isset($_GET['pto']) && tep_not_null($_GET['pto']))) ) {
    $where_str .= " group by p.products_id, tr.tax_priority";
  }

  if ( (!isset($_GET['sort'])) || (!preg_match('/[1-8][ad]/', $_GET['sort'])) || (substr($_GET['sort'], 0 , 1) > sizeof($column_list)) ) {
    $sort_order_check = false;
    for ($col=0, $n=sizeof($column_list); $col<$n; $col++) {
      if ($column_list[$col] == 'PRODUCT_LIST_MODEL') {
        $_GET['sort'] = $col+1 . 'a';
        $order_str = ' order by p.sort_order, p.products_model';
        break;
      }
    }
    if ($sort_order_check == false) {
      $order_str = ' order by p.sort_order';
    }
  } else {
    $sort_col = substr($_GET['sort'], 0 , 1);
    $sort_order = substr($_GET['sort'], 1);
    $order_str = ' order by ';
    switch ($column_list[$sort_col-1]) {
      case 'PRODUCT_LIST_MODEL':
        $order_str .= "p.products_model " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
        break;
      case 'PRODUCT_LIST_NAME':
        $order_str .= "pd.products_name " . ($sort_order == 'd' ? "desc" : "");
        break;
      case 'PRODUCT_LIST_SUBTITLE':
        $order_str .= "pd.products_subtitle " . ($sort_order == 'd' ? "desc" : "");
        break;
      case 'PRODUCT_LIST_SERIES_TITLE':
        $order_str .= "pd.products_series_title " . ($sort_order == 'd' ? "desc" : "");
        break;
      case 'PRODUCT_LIST_AUTHOR':
        $order_str .= "pd.products_author " . ($sort_order == 'd' ? 'desc' : '');
        break;
      case 'PRODUCT_LIST_PUBLISHED':
        $order_str .= "pd.products_published " . ($sort_order == 'd' ? 'desc' : '');
        break;
      case 'PRODUCT_LIST_PUBLISHERS':
        $order_str .= "pd.products_publishers " . ($sort_order == 'd' ? 'desc' : '');
        break;
      case 'PRODUCT_LIST_VOLUME':
        $order_str .= "pd.products_volume " . ($sort_order == 'd' ? 'desc' : '');
        break;
      case 'PRODUCT_LIST_ISBN':
        $order_str .= "p.products_isbn " . ($sort_order == 'd' ? 'desc' : '');
        break;
      case 'PRODUCT_LIST_QUANTITY':
        $order_str .= "p.products_quantity " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
        break;
      case 'PRODUCT_LIST_IMAGE':
        $order_str .= "pd.products_name";
        break;
      case 'PRODUCT_LIST_WEIGHT':
        $order_str .= "p.products_weight " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
        break;
      case 'PRODUCT_LIST_PRICE':
        $order_str .= "final_price " . ($sort_order == 'd' ? "desc" : "") . ", pd.products_name";
        break;
    }
  }

  $listing_sql = $select_str . $from_str . $where_str . $order_str;

  $option_search_engine_safe = false;
  require(DIR_WS_MODULES . FILENAME_PRODUCT_LISTING);
?>
<div class="buttonLine">
<p class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_ADVANCED_SEARCH, tep_get_all_get_params(array('sort', 'page', 'x', 'y')), 'NONSSL', true, false) . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></p>
</div>
</div>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php
  }

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>
