/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.bdd.BDD;
import jdd.examples.Queens;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.Test;
import jdd.util.math.Digits;

public class BDDQueens
extends BDD
implements Queens {
    private int[] bdds;
    private int[] nbdds;
    private int N;
    private int queen;
    private double sols;
    private double memory_usage;
    private long time;
    private boolean[] solvec;

    private int X(int n, int n2) {
        return this.bdds[n2 + n * this.N];
    }

    private int nX(int n, int n2) {
        return this.nbdds[n2 + n * this.N];
    }

    public BDDQueens(int n) {
        super(1 + Math.max(1000, (int)Math.pow(4.4, n - 6) * 1000), 10000);
        int n2;
        int n3;
        this.N = n;
        this.time = System.currentTimeMillis();
        int n4 = n * n;
        this.bdds = new int[n4];
        this.nbdds = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.bdds[n3] = this.createVar();
            this.nbdds[n3] = this.ref(this.not(this.bdds[n3]));
        }
        this.queen = 1;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = this.orTo(n2, this.X(n3, i));
            }
            this.queen = this.andTo(this.queen, n2);
            this.deref(n2);
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                this.build(n3, n2);
            }
        }
        this.sols = this.satCount(this.queen);
        this.time = System.currentTimeMillis() - this.time;
        this.memory_usage = this.getMemoryUsage();
        if (this.queen == 0) {
            this.solvec = null;
        }
        int[] nArray = this.oneSat(this.queen, null);
        this.solvec = new boolean[nArray.length];
        for (n2 = 0; n2 < this.solvec.length; ++n2) {
            this.solvec[n2] = nArray[n2] == 1;
        }
        this.deref(this.queen);
        if (Options.verbose) {
            this.showStats();
        }
        this.cleanup();
    }

    private void build(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        int n9 = 1;
        for (int i = 0; i < this.N; ++i) {
            if (i == n2) continue;
            n5 = this.ref(this.imp(this.X(n, n2), this.nX(n, i)));
            n9 = this.andTo(n9, n5);
            this.deref(n5);
        }
        for (n4 = 0; n4 < this.N; ++n4) {
            if (n4 == n) continue;
            n5 = this.ref(this.imp(this.X(n, n2), this.nX(n4, n2)));
            n8 = this.andTo(n8, n5);
            this.deref(n5);
        }
        for (n4 = 0; n4 < this.N; ++n4) {
            n5 = n4 - n + n2;
            if (n5 < 0 || n5 >= this.N || n4 == n) continue;
            n3 = this.ref(this.imp(this.X(n, n2), this.nX(n4, n5)));
            n7 = this.andTo(n7, n3);
            this.deref(n3);
        }
        for (n4 = 0; n4 < this.N; ++n4) {
            n5 = n + n2 - n4;
            if (n5 < 0 || n5 >= this.N || n4 == n) continue;
            n3 = this.ref(this.imp(this.X(n, n2), this.nX(n4, n5)));
            n6 = this.andTo(n6, n3);
            this.deref(n3);
        }
        n7 = this.andTo(n7, n6);
        this.deref(n6);
        n8 = this.andTo(n8, n7);
        this.deref(n7);
        n9 = this.andTo(n9, n8);
        this.deref(n8);
        this.queen = this.andTo(this.queen, n9);
        this.deref(n9);
    }

    public void showOneSolution() {
        if (this.solvec == null) {
            return;
        }
        for (int i = 0; i < this.solvec.length; ++i) {
            if (i % this.N == 0) {
                JDDConsole.out.println();
            }
            JDDConsole.out.print(this.solvec[i] ? "*|" : "_|");
        }
        JDDConsole.out.println();
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public double numberOfSolutions() {
        return this.sols;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public double getMemory() {
        return this.memory_usage;
    }

    @Override
    public boolean[] getOneSolution() {
        return this.solvec;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            BDDQueens bDDQueens = new BDDQueens(Integer.parseInt(stringArray[0]));
            double d = Digits.numberDivided(bDDQueens.getMemory(), 0x100000L);
            JDDConsole.out.println("There are " + bDDQueens.numberOfSolutions() + " solutions (time: " + bDDQueens.getTime() + ", memory: " + d + " MB)");
        }
    }

    public static void internal_test() {
        Test.start("BDDQueens");
        int[] nArray = new int[]{1, 0, 0, 2, 10, 4, 40, 92};
        for (int i = 0; i < nArray.length; ++i) {
            BDDQueens bDDQueens = new BDDQueens(i + 1);
            Test.checkEquality(bDDQueens.numberOfSolutions(), (double)nArray[i], "correct solutions for " + (i + 1) + " queens");
        }
        Test.end();
    }
}

