/*
 * Decompiled with CFR 0.152.
 */
package jdd.zdd;

import jdd.bdd.OptimizedCache;
import jdd.util.Configuration;
import jdd.util.Test;
import jdd.zdd.ZDD2;

public class ZDDCSP
extends ZDD2 {
    protected static final int CACHE_RESTRICT = 0;
    protected static final int CACHE_NOSUPSET = 1;
    protected OptimizedCache csp_cache;

    public ZDDCSP(int n, int n2) {
        super(n, n2);
        this.csp_cache = new OptimizedCache("csp", n2 / Configuration.zddCSPCacheDiv, 3, 2);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.csp_cache = null;
    }

    @Override
    protected void post_removal_callbak() {
        super.post_removal_callbak();
        this.csp_cache.free_or_grow(this);
    }

    public final int restrict(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == n2) {
            return n;
        }
        if (this.csp_cache.lookup(n, n2, 0)) {
            return this.csp_cache.answer;
        }
        int n3 = this.csp_cache.hash_value;
        int n4 = 0;
        int n5 = this.getVar(n);
        if (n5 < this.getVar(n2)) {
            int n6 = this.restrict(n, this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n6;
            int n7 = n6;
            n4 = this.mk(this.getVar(n2), n7, 0);
            --this.work_stack_tos;
        } else if (n5 > this.getVar(n2)) {
            int n8 = this.restrict(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n8;
            int n9 = n8;
            int n10 = this.restrict(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n10;
            int n11 = n10;
            n4 = this.mk(n5, n11, n9);
            this.work_stack_tos -= 2;
        } else {
            int n12 = this.restrict(this.getHigh(n), this.getHigh(n2));
            this.work_stack[this.work_stack_tos++] = n12;
            int n13 = n12;
            int n14 = this.restrict(this.getHigh(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n14;
            int n15 = n14;
            n13 = this.union(n13, n15);
            this.work_stack_tos -= 2;
            this.work_stack[this.work_stack_tos++] = n13;
            int n16 = this.restrict(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n16;
            n15 = n16;
            n4 = this.mk(n5, n15, n13);
            this.work_stack_tos -= 2;
        }
        this.csp_cache.insert(n3, n, n2, 0, n4);
        return n4;
    }

    private final int exclude_slow(int n, int n2) {
        int n3 = this.restrict(n, n2);
        this.work_stack[this.work_stack_tos++] = n3;
        int n4 = n3;
        n4 = this.diff(n, n4);
        --this.work_stack_tos;
        return n4;
    }

    private final int exclude_fast(int n, int n2) {
        if (this.emptyIn(n2)) {
            return 0;
        }
        return this.noSupset_rec(n, n2);
    }

    private final int noSupset_rec(int n, int n2) {
        int n3;
        int n4;
        if (n == 0 || n2 == 1 || n == n2) {
            return 0;
        }
        if (n == 1 || n2 == 0) {
            return n;
        }
        if (this.csp_cache.lookup(n, n2, 1)) {
            return this.csp_cache.answer;
        }
        int n5 = this.csp_cache.hash_value;
        int n6 = this.getVar(n);
        if (n6 < (n4 = this.getVar(n2))) {
            n3 = this.noSupset_rec(n, this.getLow(n2));
        } else if (n6 > n4) {
            int n7 = this.noSupset_rec(this.getHigh(n), n2);
            this.work_stack[this.work_stack_tos++] = n7;
            int n8 = n7;
            int n9 = this.noSupset_rec(this.getLow(n), n2);
            this.work_stack[this.work_stack_tos++] = n9;
            int n10 = n9;
            n3 = this.mk(n6, n10, n8);
            this.work_stack_tos -= 2;
        } else {
            int n11;
            int n12;
            int n13 = this.getHigh(n2);
            if (this.emptyIn(n13)) {
                this.work_stack[this.work_stack_tos++] = 0;
                n12 = 0;
            } else {
                int n14 = this.getHigh(n);
                int n15 = this.noSupset_rec(n14, this.getLow(n2));
                this.work_stack[this.work_stack_tos++] = n15;
                n12 = n15;
                int n16 = this.noSupset_rec(n14, n13);
                this.work_stack[this.work_stack_tos++] = n16;
                n11 = n16;
                n12 = this.intersect(n12, n11);
                this.work_stack_tos -= 2;
                this.work_stack[this.work_stack_tos++] = n12;
            }
            int n17 = this.noSupset_rec(this.getLow(n), this.getLow(n2));
            this.work_stack[this.work_stack_tos++] = n17;
            n11 = n17;
            n3 = this.mk(n6, n11, n12);
            this.work_stack_tos -= 2;
        }
        this.csp_cache.insert(n5, n, n2, 1, n3);
        return n3;
    }

    public final int exclude(int n, int n2) {
        return this.exclude_fast(n, n2);
    }

    @Override
    public void showStats() {
        super.showStats();
        this.csp_cache.showStats();
    }

    @Override
    public long getMemoryUsage() {
        long l = super.getMemoryUsage();
        if (this.csp_cache != null) {
            l += this.csp_cache.getMemoryUsage();
        }
        return l;
    }

    public static void internal_test() {
        Test.start("ZDDCSP");
        ZDDCSP zDDCSP = new ZDDCSP(200, 1000);
        int n = zDDCSP.createVar();
        int n2 = zDDCSP.createVar();
        int n3 = zDDCSP.createVar();
        int n4 = zDDCSP.createVar();
        int n5 = zDDCSP.createVar();
        int n6 = zDDCSP.cubes_union("00011 00111 01110");
        int n7 = zDDCSP.cubes_union("00110 00111");
        int n8 = zDDCSP.cubes_union("00111 01111 01110");
        Test.checkEquality(n8, zDDCSP.mul(n6, n7), "P * Q");
        Test.checkEquality(zDDCSP.work_stack_tos, 0, "TOS restored (1)");
        int n9 = 0;
        Test.checkEquality(n9, zDDCSP.div(n6, n7), "P / Q");
        Test.checkEquality(zDDCSP.work_stack_tos, 0, "TOS restored (2)");
        int n10 = zDDCSP.cubes_union("00011 00111 01110");
        Test.checkEquality(n10, zDDCSP.mod(n6, n7), "P % Q");
        Test.checkEquality(zDDCSP.work_stack_tos, 0, "TOS restored (3)");
        int n11 = zDDCSP.cubes_union("00111 01110");
        int n12 = zDDCSP.cube("00111");
        Test.checkEquality(zDDCSP.restrict(n6, n7), n11, "Restrict(P,Q)");
        Test.checkEquality(zDDCSP.restrict(n7, n6), n12, "Restrict(Q,P)");
        Test.checkEquality(zDDCSP.work_stack_tos, 0, "TOS restored (4)");
        int n13 = zDDCSP.cube("00011");
        int n14 = zDDCSP.cube("00110");
        Test.checkEquality(zDDCSP.exclude(n6, n7), n13, "Exclude(P,Q)");
        Test.checkEquality(zDDCSP.exclude(n7, n6), n14, "Exclude(Q,P)");
        Test.checkEquality(zDDCSP.work_stack_tos, 0, "TOS restored (5)");
        Test.end();
    }
}

