/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.gsat;

import java.io.IOException;
import java.util.Enumeration;
import jdd.sat.CNF;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Solver;
import jdd.sat.Var;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class GSATSolver
implements Solver {
    protected CNF cnf = null;
    protected long maxtime;
    protected int[] stack;

    public GSATSolver(long l) {
        this.maxtime = Math.max(1000L, l);
    }

    @Override
    public void setFormula(CNF cNF) {
        this.cnf = cNF;
        this.stack = new int[cNF.num_lits];
    }

    @Override
    public void cleanup() {
        this.cnf = null;
        this.stack = null;
    }

    @Override
    public int[] solve() {
        int n = this.cnf.num_lits;
        boolean[] blArray = new boolean[n];
        int n2 = -1;
        int n3 = Math.min(1000, 5 * n);
        long l = System.currentTimeMillis();
        long l2 = l + this.maxtime;
        long l3 = 0L;
        int n4 = n3;
        while (l2 > System.currentTimeMillis()) {
            ++l3;
            if (n4 == n3) {
                n4 = 0;
                n2 = -1;
                this.randomize(blArray);
            } else {
                ++n4;
            }
            if (this.cnf.satisfies(blArray)) {
                JDDConsole.out.println("SAT/" + (System.currentTimeMillis() - l) + "ms");
                return this.toIntVector(blArray);
            }
            int n5 = this.chooseFlip(blArray, n2);
            blArray[n5] = !blArray[n5];
            n2 = n5;
        }
        JDDConsole.out.println("UNKNOWN (" + l3 + " tries)/" + (System.currentTimeMillis() - l) + "ms");
        return null;
    }

    protected int[] toIntVector(boolean[] blArray) {
        int n = blArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        return nArray;
    }

    protected void randomize(boolean[] blArray) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            blArray[i] = Math.random() >= 0.5;
        }
    }

    protected int chooseFlip(boolean[] blArray, int n) {
        int n2 = blArray.length;
        int n3 = -2147483647;
        int n4 = 0;
        int n5 = this.cnf.conflicts(blArray);
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            int n6 = this.satisfiableIfFlip(i, blArray);
            if (n6 == n5) {
                return i;
            }
            if (n3 < n6) {
                n4 = 0;
                n3 = n6;
            }
            if (n3 != n6) continue;
            this.stack[n4++] = i;
        }
        Test.check(n4 != 0);
        return this.stack[this.random(n4)];
    }

    protected int satisfiableIfFlip(int n, boolean[] blArray) {
        Var var = this.cnf.vars[n];
        boolean bl = blArray[n];
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = var.occurs.elements();
        while (enumeration.hasMoreElements()) {
            Clause clause = (Clause)enumeration.nextElement();
            blArray[n] = true;
            if (clause.satisfies(blArray)) {
                ++n2;
            }
            blArray[n] = false;
            if (!clause.satisfies(blArray)) continue;
            ++n3;
        }
        blArray[n] = bl;
        return bl ? n3 - n2 : n2 - n3;
    }

    protected final int random(int n) {
        return (int)(Math.random() * (double)n);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    GSATSolver gSATSolver = new GSATSolver(2000L);
                    gSATSolver.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    gSATSolver.solve();
                    gSATSolver.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

