/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import java.util.Enumeration;
import jdd.bdd.BDDUtil;
import jdd.des.automata.Automaton;
import jdd.des.automata.Event;
import jdd.des.automata.State;
import jdd.des.automata.Transition;
import jdd.des.automata.bdd.BDDAutomata;
import jdd.util.math.Digits;

public class BDDAutomaton {
    private Automaton original;
    int[] bdd_var_s;
    int[] bdd_var_sp;
    private int bdd_cube_s;
    private int bdd_cube_sp;
    private int bdd_i;
    private int bdd_m;
    private int bdd_f;
    private int bdd_delta;
    private int bdd_delta_top;
    private int bdd_care_event;
    private int bdd_care_state;
    private int bdd_keep;
    private int bits;
    private int states;

    public BDDAutomaton(Automaton automaton, BDDAutomata bDDAutomata) {
        int n;
        this.original = automaton;
        this.original.lockAutomaton();
        this.states = this.original.numOfNodes();
        this.bits = Digits.log2_ceil(this.states);
        this.bdd_var_s = new int[this.bits];
        this.bdd_var_sp = new int[this.bits];
        this.bdd_keep = 1;
        this.bdd_cube_sp = 1;
        this.bdd_cube_s = 1;
        for (n = 0; n < this.bits; ++n) {
            this.bdd_var_s[n] = bDDAutomata.createVar();
            this.bdd_var_sp[n] = bDDAutomata.createVar();
            this.bdd_cube_s = bDDAutomata.andTo(this.bdd_cube_s, this.bdd_var_s[n]);
            this.bdd_cube_sp = bDDAutomata.andTo(this.bdd_cube_sp, this.bdd_var_sp[n]);
            int n2 = bDDAutomata.ref(bDDAutomata.biimp(this.bdd_var_s[n], this.bdd_var_sp[n]));
            this.bdd_keep = bDDAutomata.andTo(this.bdd_keep, n2);
            bDDAutomata.deref(n2);
        }
        n = 0;
        this.bdd_care_state = 0;
        Enumeration enumeration = automaton.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            State state = (State)enumeration.nextElement();
            int n3 = BDDUtil.numberToBDD(bDDAutomata, this.bdd_var_s, n);
            int n4 = BDDUtil.numberToBDD(bDDAutomata, this.bdd_var_sp, n);
            state.setBDDState(n3);
            state.setBDDStateP(n4);
            this.bdd_care_state = bDDAutomata.orTo(this.bdd_care_state, n3);
            ++n;
        }
    }

    public void cleanup() {
        this.original.unlockAutomaton();
    }

    void buildRelations(BDDAutomata bDDAutomata) {
        Object object;
        this.bdd_m = 0;
        this.bdd_f = 0;
        this.bdd_i = 0;
        Object object2 = this.original.getNodes().elements();
        while (object2.hasMoreElements()) {
            object = (State)object2.nextElement();
            int n = ((State)object).getBDDState();
            if (((State)object).isInitial()) {
                this.bdd_i = bDDAutomata.orTo(this.bdd_i, n);
            }
            if (((State)object).isMarked()) {
                this.bdd_m = bDDAutomata.orTo(this.bdd_f, n);
            }
            if (!((State)object).isForbidden()) continue;
            this.bdd_f = bDDAutomata.orTo(this.bdd_m, n);
        }
        this.bdd_care_event = 0;
        object2 = this.original.getAlphabet().head();
        while (object2 != null) {
            this.bdd_care_event = bDDAutomata.orTo(this.bdd_care_event, ((Event)object2).parent.getBDD());
            object2 = ((Event)object2).next;
        }
        this.bdd_delta = 0;
        object2 = this.original.getEdges().elements();
        while (object2.hasMoreElements()) {
            object = (Transition)object2.nextElement();
            State state = (State)((Transition)object).n1;
            State state2 = (State)((Transition)object).n2;
            int n = bDDAutomata.ref(bDDAutomata.and(state.getBDDState(), state2.getBDDStateP()));
            n = bDDAutomata.andTo(n, ((Transition)object).event.parent.getBDD());
            this.bdd_delta = bDDAutomata.orTo(this.bdd_delta, n);
            bDDAutomata.deref(n);
        }
        int n = bDDAutomata.ref(bDDAutomata.not(this.bdd_care_event));
        int n2 = bDDAutomata.ref(bDDAutomata.and(n, this.bdd_keep));
        this.bdd_delta_top = bDDAutomata.ref(bDDAutomata.or(n2, this.bdd_delta));
        bDDAutomata.deref(n);
        bDDAutomata.deref(n2);
    }

    public Automaton getAutomaton() {
        return this.original;
    }

    public int getNumBits() {
        return this.bits;
    }

    public int getNumStates() {
        return this.states;
    }

    public int getBDDCubeS() {
        return this.bdd_cube_s;
    }

    public int getBDDCubeSp() {
        return this.bdd_cube_sp;
    }

    public int getBDDI() {
        return this.bdd_i;
    }

    public int getBDDM() {
        return this.bdd_m;
    }

    public int getBDDF() {
        return this.bdd_f;
    }

    public int getBDDDelta() {
        return this.bdd_delta;
    }

    public int getBDDDeltaTop() {
        return this.bdd_delta_top;
    }

    public int getBDDCareEvent() {
        return this.bdd_care_event;
    }

    public int getBDDCareState() {
        return this.bdd_care_state;
    }

    public int getBDDKeep() {
        return this.bdd_keep;
    }

    public String toString() {
        return this.original.getName();
    }
}

