/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import jdd.util.JDDConsole;

public class Matrix {
    private double[] data;
    private int rows;
    private int cols;
    private int total;

    public Matrix(int n, int n2, double d) {
        this(n, n2);
        this.setAll(d);
    }

    public Matrix(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.total = n * n2;
        this.data = new double[this.total];
    }

    public Matrix(Matrix matrix) {
        this.rows = matrix.rows;
        this.cols = matrix.cols;
        this.total = matrix.total;
        this.data = new double[this.total];
        System.arraycopy(matrix.data, 0, this.data, 0, this.data.length);
    }

    public int numOfCols() {
        return this.cols;
    }

    public int numOfRows() {
        return this.rows;
    }

    public double[] getRaw() {
        return this.data;
    }

    public double get(int n, int n2) {
        return this.data[n + n2 * this.cols];
    }

    public void set(int n, int n2, double d) {
        this.data[n + n2 * this.cols] = d;
    }

    public void setAll(double d) {
        for (int i = 0; i < this.total; ++i) {
            this.data[i] = d;
        }
    }

    public boolean equals(Matrix matrix) {
        if (matrix.rows != this.rows || matrix.cols != this.cols) {
            return false;
        }
        for (int i = 0; i < this.total; ++i) {
            if (matrix.data[i] == this.data[i]) continue;
            return false;
        }
        return true;
    }

    public void add(double d) {
        int n = 0;
        while (n < this.total) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
    }

    public void sub(double d) {
        int n = 0;
        while (n < this.total) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
    }

    public void add(Matrix matrix) {
        for (int i = 0; i < this.total; ++i) {
            int n = i;
            this.data[n] = this.data[n] + matrix.data[i];
        }
    }

    public void sub(Matrix matrix) {
        for (int i = 0; i < this.total; ++i) {
            int n = i;
            this.data[n] = this.data[n] - matrix.data[i];
        }
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix.cols != this.rows || matrix.rows != this.cols) {
            return null;
        }
        Matrix matrix2 = new Matrix(this.rows, this.cols);
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n = i + j * this.cols;
                matrix2.data[n] = 0.0;
                for (int k = 0; k < this.rows; ++k) {
                    int n2 = n;
                    matrix2.data[n2] = matrix2.data[n2] + this.get(i, k) * matrix.get(k, j);
                }
            }
        }
        return matrix2;
    }

    public void show() {
        int n = 0;
        JDDConsole.out.println();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (j != 0) {
                    JDDConsole.out.print("\t");
                }
                JDDConsole.out.print("" + this.data[n++]);
            }
            JDDConsole.out.println();
        }
    }
}

