/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.examples.Queens;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.Test;
import jdd.zdd.ZDDCSP;

public class ZDDCSPQueens
extends ZDDCSP
implements Queens {
    private int n;
    private int sols;
    private int[] x;
    private int[] xv;
    private boolean[] solvec;
    private long time = System.currentTimeMillis();
    private long memory;

    private int get(int n, int n2) {
        return this.x[n + n2 * this.n];
    }

    private int getVar(int n, int n2) {
        return this.xv[n + n2 * this.n];
    }

    public ZDDCSPQueens(int n) {
        super(1 + Math.max(1000, (int)Math.pow(2.0, n - 5) * 800), 10000);
        int n2;
        int n3;
        this.n = n;
        this.x = new int[n * n];
        this.xv = new int[n * n];
        boolean[] blArray = new boolean[n * n];
        for (n3 = 0; n3 < n * n; ++n3) {
            this.xv[n3] = this.createVar();
            this.x[n3] = this.ref(this.change(1, this.xv[n3]));
        }
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 = this.unionWith(n3, this.get(0, n2));
        }
        n2 = n3;
        for (int i = 1; i < n; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                int n5 = this.build(i, j, n2, blArray);
                n4 = this.unionWith(n4, n5);
                this.deref(n5);
            }
            this.deref(n2);
            n2 = n4;
        }
        this.solvec = this.satOne(n2, null);
        this.sols = this.count(n2);
        this.deref(n2);
        this.time = System.currentTimeMillis() - this.time;
        if (Options.verbose) {
            this.showStats();
        }
        this.memory = this.getMemoryUsage();
        this.cleanup();
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public double numberOfSolutions() {
        return this.sols;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public long getMemory() {
        return this.memory;
    }

    @Override
    public boolean[] getOneSolution() {
        return this.solvec;
    }

    private boolean valid(int n, int n2) {
        return n >= 0 && n < this.n && n2 >= 0 && n2 < this.n;
    }

    private int build(int n, int n2, int n3, boolean[] blArray) {
        int n4;
        int n5;
        int n6;
        Array.set(blArray, false);
        for (n6 = 0; n6 < n; ++n6) {
            blArray[n6 + this.n * n2] = true;
        }
        for (n6 = 1; n6 <= n; ++n6) {
            n5 = n - n6;
            n4 = n2 - n6;
            if (this.valid(n5, n4)) {
                blArray[n5 + this.n * n4] = true;
            }
            if (!this.valid(n5, n4 = n2 + n6)) continue;
            blArray[n5 + this.n * n4] = true;
        }
        n6 = 0;
        for (n4 = 0; n4 < this.n * this.n; ++n4) {
            if (!blArray[n4]) continue;
            n5 = n4 / this.n;
            int n7 = n4 % this.n;
            n6 = this.unionWith(n6, this.get(n7, n5));
        }
        n4 = this.ref(this.exclude(n3, n6));
        this.deref(n6);
        n5 = this.ref(this.mul(n4, this.get(n, n2)));
        this.deref(n4);
        return n5;
    }

    private int unionWith(int n, int n2) {
        int n3 = this.ref(this.union(n, n2));
        this.deref(n);
        return n3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            ZDDCSPQueens zDDCSPQueens = new ZDDCSPQueens(Integer.parseInt(stringArray[0]));
            JDDConsole.out.println("There are " + zDDCSPQueens.numberOfSolutions() + " solutions (time: " + zDDCSPQueens.getTime() + ")");
        }
    }

    public static void internal_test() {
        Test.start("ZDDCSPQueens");
        int[] nArray = new int[]{1, 0, 0, 2, 10, 4, 40, 92, 352, 724, 2680};
        for (int i = 0; i < nArray.length; ++i) {
            ZDDCSPQueens zDDCSPQueens = new ZDDCSPQueens(i + 1);
            Test.check(zDDCSPQueens.numberOfSolutions() == (double)nArray[i], "correct solutions for " + (i + 1) + " queens");
        }
        Test.end();
    }
}

