/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.sat.CNF;
import jdd.sat.Clause;
import jdd.sat.Lit;

public class QueensCNFGenerator {
    private int n;
    private CNF cnf;
    private Lit[] var;
    private Lit[] nvar;

    public QueensCNFGenerator(int n) {
        this.n = n;
        this.cnf = null;
    }

    public int getN() {
        return this.n;
    }

    public CNF cnf() {
        if (this.cnf == null) {
            this.generate();
        }
        return this.cnf;
    }

    private Lit var(int n, int n2, boolean bl) {
        int n3 = n * this.n + n2;
        return bl ? this.var[n3] : this.nvar[n3];
    }

    private void generate() {
        int n;
        Clause clause;
        int n2;
        int n3;
        int n4;
        int n5 = this.n * this.n + 3 * this.n * this.n * this.n;
        this.cnf = new CNF(n5, this.n * this.n);
        this.var = new Lit[this.n * this.n];
        this.nvar = new Lit[this.n * this.n];
        for (n4 = 0; n4 < this.n * this.n; ++n4) {
            this.var[n4] = this.cnf.getLit(n4 + 1, false);
            this.nvar[n4] = this.cnf.getLit(n4 + 1, true);
        }
        for (n3 = n4 = this.n - 1; n3 >= 0; --n3) {
            n2 = n4;
            clause = new Clause(this.n);
            for (n = 0; n < this.n; ++n) {
                clause.insert(this.var(n3, n2--, true));
            }
            this.cnf.insert(clause);
        }
        for (n3 = n4; n3 >= 0; --n3) {
            n2 = n4;
            clause = new Clause(this.n);
            for (n = 0; n < this.n; ++n) {
                clause.insert(this.var(n2--, n3, true));
            }
            this.cnf.insert(clause);
        }
        for (n3 = n4; n3 >= 0; --n3) {
            for (n = n4; n >= 0; --n) {
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    clause = new Clause(2);
                    clause.insert(this.var(n3, n, false));
                    clause.insert(this.var(n2, n, false));
                    this.cnf.insert(clause);
                    clause = new Clause(2);
                    clause.insert(this.var(n, n3, false));
                    clause.insert(this.var(n, n2, false));
                    this.cnf.insert(clause);
                }
            }
        }
        for (n3 = n4; n3 >= 0; --n3) {
            for (n = n4; n >= 0; --n) {
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    for (int i = n4; i >= 0; --i) {
                        if (n3 - n2 != Math.abs(n - i)) continue;
                        clause = new Clause(2);
                        clause.insert(this.var(n3, n, false));
                        clause.insert(this.var(n2, i, false));
                        this.cnf.insert(clause);
                    }
                }
            }
        }
    }
}

