/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.petrinets;

import java.util.HashMap;
import jdd.des.petrinets.interactive.IPetrinet;
import jdd.des.petrinets.interactive.IPlace;
import jdd.des.petrinets.interactive.ITransition;
import jdd.util.JDDConsole;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class PetrinetXMLHandler
extends DefaultHandler {
    private static final int STATE_NONE = 0;
    private static final int STATE_DOCUMENT = 1;
    private static final int STATE_PN = 2;
    private static final int STATE_PLACES = 3;
    private static final int STATE_TRANSITIONS = 4;
    private static final int STATE_TRANSITION = 5;
    IPetrinet petrinet = null;
    private ITransition current = null;
    private HashMap placemap = new HashMap();
    private int state = 0;

    PetrinetXMLHandler() {
    }

    private String safe(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        return string3 != null ? string3 : string2;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("Document")) {
            if (this.state == 0) {
                this.state = 1;
            }
        } else if (string3.equals("Petrinet")) {
            if (this.state == 2) {
                this.state = 1;
            }
        } else if (string3.equals("Transitions")) {
            if (this.state == 4) {
                this.state = 2;
            }
        } else if (string3.equals("Transition")) {
            if (this.state == 5) {
                this.state = 4;
            }
        } else if (string3.equals("Places") && this.state == 3) {
            this.state = 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("Document")) {
            if (this.state != 0) return;
            this.state = 1;
            return;
        } else if (string3.equals("Petrinet")) {
            if (this.state != 1 && this.state != 0) {
                return;
            }
            this.state = 2;
            if (this.petrinet != null) {
                JDDConsole.out.println("Multiple petrinets in XML file");
                return;
            } else {
                this.petrinet = new IPetrinet();
                this.placemap.clear();
            }
            return;
        } else if (string3.equals("Places")) {
            if (this.state != 2) return;
            this.state = 3;
            return;
        } else if (string3.equals("Place")) {
            if (this.state != 3) {
                return;
            }
            String string4 = attributes.getValue("label");
            String string5 = this.safe(attributes, "token", "0");
            int n = 0;
            n = string5.equals("false") ? 0 : (string5.equals("true") ? 1 : Integer.parseInt(string5));
            IPlace iPlace = new IPlace(string4, n);
            this.petrinet.add(iPlace);
            this.placemap.put(string4, iPlace);
            return;
        } else if (string3.equals("Transitions")) {
            if (this.state != 2) return;
            this.state = 4;
            return;
        } else if (string3.equals("Transition")) {
            if (this.state != 4) {
                return;
            }
            this.state = 5;
            String string6 = attributes.getValue("label");
            this.current = new ITransition(string6);
            String string7 = attributes.getValue("controllable");
            this.current.setControllable(string7 == null || string7.equals("true"));
            string7 = attributes.getValue("observable");
            this.current.setObservable(string7 == null || string7.equals("true"));
            this.petrinet.add(this.current);
            return;
        } else if (string3.equals("Input")) {
            if (this.state != 5) {
                return;
            }
            String string8 = attributes.getValue("place");
            IPlace iPlace = (IPlace)this.placemap.get(string8);
            this.petrinet.add(iPlace, this.current);
            return;
        } else {
            if (!string3.equals("Output")) return;
            if (this.state != 5) {
                return;
            }
            String string9 = attributes.getValue("place");
            IPlace iPlace = (IPlace)this.placemap.get(string9);
            this.petrinet.add(this.current, iPlace);
        }
    }
}

