/*
 * main.c
 *
 *  Created on: 2014/06/15
 *      Author: takemasa
 */


#include <math.h>
#include <stdio.h>
#define CUTOFF (0.475)

	/* x : [0, 1.0) */
double hanning(double x);
	/* cutoff : normalized frequency where cutoff freq / sampling freq */
double sinc(double x, double cutoff);

double h( double x, int lenght);

int main(void)
{

	int i;

	for ( i=0; i<127; i++)
	{
//		printf( "%f\n", sinc(i, CUTOFF));
		printf( "%f\n", h( i, 127));
	}

	return 0;
}


	/* Lenght must be an odd number */
double h( double x, int length)
{
	int center;
	double fractional;

	fractional = x - floor(x);

	center = (length -1 )/2;

	return sinc( x - center, CUTOFF );
//	return  hanning ( x / ( length - 1 ));
}

double sinc(double x, double cutoff )
{
	return x?sin(2*M_PI*x*cutoff)/(x*M_PI):cutoff*2;
}

double hanning(double x)
{
	if ( 0 <= x && x < 1.0 )
		return 0.5 - 0.5 * cos( 2 * M_PI * x );
	else
		return 0.0;
}
