
#include <t_services.h>
#include "kernel_id.h"
#include "uzume_sample.h"
#include <cdefBF592-A.h>
#include <fract.h>
#include <uzume.h>

#define MAXINTERVAL 1000
#define MININTERVAL 100

/**
 * @brief メインタスク。
 */
void main_task(VP_INT exinf)
{
    int i;
    fract32 interval;

    syslog(LOG_NOTICE, "LED Flashing demo. PORT G pin 12-15 flashes");
    syslog(LOG_NOTICE, "    Volume 1 : Flash interval");
    unsigned short ledstate;

    // PG12-15はLED1-4に対応しており、出力として使う。
    *pPORTGIO_DIR   |= 0xF000;  // 出力設定
    *pPORTGIO_SET  = 0xF000;  // LED消灯

    tslp_tsk(100);

    while (1) {
        syslog(LOG_NOTICE, "volume : %08x, interval : %5d");
        ledstate = 0x1000;          // LED1点灯
        for (i=0; i<4; i++){
            *pPORTGIO_SET    = 0xF000;    // LED消灯
            *pPORTGIO_CLEAR = ledstate;  // LED点灯
            ledstate <<= 1;
            interval = mult_fr1x32x32( get_volume(0), MAXINTERVAL-MININTERVAL )+MININTERVAL;
            tslp_tsk((int)interval);
        }
    }
}

