;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File name: ` ~/.emacs '
;;; ---------------------
;;;
;;; If you need your own personal ~/.emacs
;;; please make a copy of this file
;;; an placein your changes and/or extension.
;;;
;;; Copyright (c) 1997-2002 SuSE Gmbh Nuernberg, Germany.
;;;
;;; Author: Werner Fink, <feedback@suse.de> 1997,98,99,2002


(global-font-lock-mode t)
(define-key global-map "\C-q" 'find-tag-other-window)
(define-key global-map "\C-x \C-r" 'replace-regexp)
(global-set-key "\C-h" 'delete-backward-char)
(global-set-key "\C-\\" 'undo)
(global-set-key "\C-m" 'newline-and-indent)
(global-set-key "\M-g" 'goto-line)
(global-set-key "\C-_" 'shrink-window)

;;(add-to-list 'vc-handled-backends 'SVN)
(require 'color-theme)

(setq load-path (cons (expand-file-name "/usr/share/emacs21/site-lisp/yatex/yatex") load-path))
(setq auto-mode-alist
      (cons (cons "\\.tex$" 'yatex-mode) auto-mode-alist))
(autoload 'yatex-mode "yatex" "Yet Another LaTeX mode" t)


(if (or (and window-system (>= emacs-major-version 19))
        (>= emacs-major-version 21))
    (progn

      (global-font-lock-mode t)
      (setq font-lock-maximum-decoration t)
      (setq fast-lock nil)
      (setq lazy-lock nil)
      (setq jit-lock t)
      (setq color-mate:theme-file "Wine")

      (setq hilit-background-mode 'dark)
      (require 'hilit-chg)
      (eval-after-load "color-theme"
	'(progn
	   (color-theme-initialize)
	   (color-theme-hober)
	   )
	)
    )

)

;;(require 'un-define)
;;(set-language-environment "Japanese")
(prefer-coding-system 'utf-8-unix)
(set-keyboard-coding-system 'utf-8-unix)
(set-terminal-coding-system 'utf-8-unix)
(auto-compression-mode t)
(setq-default transient-mark-mode t)

(load "emacs256colors.el")

(setq tab-width 4)
(global-font-lock-mode t)
(setq-default transient-mark-mode t)

(defface hline '((t (:background "grey20")))
           "Face to use for `hl-line-face'." :group 'hl-line)


(require 'hl-line)
(global-hl-line-mode)
(setq hl-line-face 'hline)
(transient-mark-mode t) 

;;
;;(add-to-list 'load-path "/usr/share/emacs/site-lisp/")
;;(require 'auto-complete-config)
;;(add-to-list 'ac-dictionary-directories "/usr/share/emacs/site-lisp//ac-dict")
;;(ac-config-default)
;;(require 'ac-python)
(require 'multi-term)
(require 'wb-line-number)
(wb-line-number-toggle)

(fset 'yes-or-no-p 'y-or-n-p)


