
#include "gtest/gtest.h"
#include "mt_typelist.h"
#include "mt_typelist_algo_foreach.h"

namespace mt {

namespace {
template <unsigned int N>
struct TestedClass
{
    TestedClass()
        : value()
    {}

    unsigned int value[N];
};

template <unsigned int N>
struct TestClass
{
    void operator()(TestedClass<4>& obj)
    {
        obj.value[N] = N + 10;
    }
};

template <unsigned int N>
struct TestClassTemplate
{
    template <typename T>
    void operator()(T& obj)
    {
        obj.value[N] = N + 20;
    }
};

} // namespace

TEST(MtForEachTest, simple_type_loop)
{
    typedef mt::MakeTypelist<TestClass<0>, TestClass<1>, TestClass<2>, TestClass<3> >::Result Types;

    TestedClass<4> obj;
    mt::ForEach<Types>()(obj);

    for (unsigned int i = 0; i < 4; ++i) {
        EXPECT_EQ(obj.value[i], (i + 10));
    }

    for (unsigned int i = 0; i < 4; ++i) {
        obj.value[i] = 0;
    }

    typedef mt::MakeTypelist<TestClassTemplate<0>, TestClassTemplate<1>, TestClassTemplate<2>, TestClassTemplate<3> >::Result Types2;
    mt::ForEach<Types2>()(obj);

    for (unsigned int i = 0; i < 4; ++i) {
       EXPECT_EQ(obj.value[i], (i + 20));
    }
}

} // namespace mt
