
#ifndef INC_MT_TYPE_ERASURE_HANDLER_H_
#define INC_MT_TYPE_ERASURE_HANDLER_H_

namespace mt {

template <typename Ret>
class HandlerBase
{
public:
    virtual ~HandlerBase()
    {}

    virtual Ret handleIt() = 0;
};

template <typename Ret, typename Arg, typename T>
class HandlerHolder1Arg : public HandlerBase<Ret>
{
public:
    HandlerHolder1Arg(T& obj, Arg& event, bool (T::*handler)(Arg&))
        : value_(obj), event_(event), member_func_(handler)
    {}

    virtual Ret handleIt()
    {
        return (value_.*member_func_)(event_);
    }

private:
    T& value_;
    Arg& event_;
    bool (T::*member_func_)(Arg&);
};

template <typename Ret, typename Arg, typename T>
class HandlerConstHolder1Arg : public HandlerBase<Ret>
{
public:
    HandlerConstHolder1Arg(T& obj, Arg& event, bool (T::*handler)(Arg&) const)
        : value_(obj), event_(event), member_func_(handler)
    {}

    virtual Ret handleIt()
    {
        return (value_.*member_func_)(event_);
    }

private:
    T& value_;
    Arg& event_;
    bool (T::*member_func_)(Arg&) const;
};

} // namespace

#endif // INC_MT_TYPE_ERASURE_HANDLER_H_

