
#ifndef INC_CM_THREAD_IS_MAIN_THREAD_H_
#define INC_CM_THREAD_IS_MAIN_THREAD_H_

#if __linux__
#include <sys/types.h>
#include <sys/syscall.h>
#include <unistd.h>

namespace cm {

inline bool isMainThread()
{
    return syscall(SYS_gettid) == getpid();
}

} // namespace

#elif ((__FreeBSD__) || (__MACH__ && __APPLE__))
#include <pthread.h>

namespace cm {

inline bool isMainThread()
{
    return pthread_main_np();
}

} // namespace

#else
#error "portable way to define isMainThread() inline function is not found."
#endif

#endif // INC_CM_THREAD_IS_MAIN_THREAD_H_

