
#ifndef INC_CM_SOCKET_SERVER_H_
#define INC_CM_SOCKET_SERVER_H_

#include "mt_auto_ptr.h"
#include "cm_socket_type.h"

namespace cm {

class SocketIf;

class SocketServer
{
public:
    SocketServer(SocketType type, const char* server_name, unsigned short port = 0u);

    virtual ~SocketServer();

    bool isReady() const;   // TODO: implement this member function in future

    inline mt::AutoPtr<SocketIf> accept()
    {
        return mt::AutoPtr<SocketIf>(doAccept());
    }

    inline int getFD() const
    {
        return fd_;
    }

private:
    // Non-copyable
    SocketServer(const SocketServer& rhs);
    SocketServer& operator=(const SocketServer& rhs);
    
    virtual SocketIf* doAccept(); 
    int fd_;
    SocketType socket_type_;
};

inline int getFD(SocketServer& server)
{
    return server.getFD();
}

} // namespace cm

#endif // INC_CM_SOCKET_SERVER_H_

