
#include "gtest/gtest.h"

#include "cm_thread.h"
#include "cm_mutex.h"

namespace cm {
namespace {

struct TestThreadArg
{
    bool flag;
    Mutex mutex;
};

class TestThread
{
public:
    TestThread(TestThreadArg* arg)
        : flag_(arg->flag), mutex_(arg->mutex)
    {}

    void run()
    {
        Mutex::Lock lock(mutex_);
        flag_ = true;
    }

    void runRecursively()
    {
        Mutex::Lock lock(mutex_);
        run();
    }

private:
    bool& flag_;
    Mutex& mutex_;
};

class MutexTest : public ::testing::Test
{
protected:
    virtual void SetUp()
    {}

    virtual void TearDown()
    {}

};

TEST_F(MutexTest, test)
{
    TestThreadArg arg;
    arg.flag = false;

    Thread<TestThread, TestThreadArg> thread("thread_name");
    {
        Mutex::Lock lock(arg.mutex);

        thread.create(&arg);

        sleep(1);
        EXPECT_EQ(arg.flag, false);
    }

    sleep(1);
    EXPECT_EQ(arg.flag, true);
    thread.join();

    EXPECT_EQ(arg.flag, true);
}

TEST_F(MutexTest, test_recursive_lock_from_same_thread)
{
    TestThreadArg arg;
    arg.flag = false;
    TestThread thread(&arg);

    thread.runRecursively();

    EXPECT_EQ(arg.flag, true);
}

}
} // namespace cm
