/******************************************************************************/
/* DISCLAIMER                                                                 */
/* This software is supplied by Renesas Electronics Corporation and is only   */
/* intended for use with Renesas products. No other uses are authorized.This  */
/* software is owned by Renesas Electronics Corporation and is protected      */
/* under all applicable laws, including copyright laws.                       */
/* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES          */
/* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING  */
/* BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR */
/* PURPOSE AND NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY           */
/* DISCLAIMED.                                                                */
/* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS     */
/* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE       */
/* LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL      */
/* DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS    */
/* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.           */
/* Renesas reserves the right, without notice, to make changes to this        */
/* software and to discontinue the availability of this software.             */
/* By using this software, you agree to the additional terms and conditions   */
/* found by accessing the following link:                                     */
/* http://www.renesas.com/disclaimer                                          */
/*                                                                            */
/* Device     : RL78/R5F10PPJ                                                 */
/* File Name  : iodefine.h                                                    */
/* Abstract   : Definition of Special Function Register (SFR)                 */
/* History    : V1.11  [Device File version]                                  */
/* Options    : -df=C:\Program Files (x86)\Renesas Electronics\CS+\CC\Device\ */
/*              RL78\Devicefile\DR5F10PPJ.DVF -o=D:\Movie\Papa\CSPlus\CLCheck */
/*              er\iodefine.h -f                                              */
/* Date       : 2016/03/19                                                    */
/* Version    : V1.05.00.01  [df2iodef.exe version]                           */
/* This is a typical example.                                                 */
/*                                                                            */
/******************************************************************************/
#ifndef __R5F10PPJIODEFINE_HEADER__
#define __R5F10PPJIODEFINE_HEADER__

typedef struct
{
    unsigned char no0:1;
    unsigned char no1:1;
    unsigned char no2:1;
    unsigned char no3:1;
    unsigned char no4:1;
    unsigned char no5:1;
    unsigned char no6:1;
    unsigned char no7:1;
} __bitf_T;

typedef struct
{
    unsigned char no0:1;
    unsigned char no1:1;
    unsigned char no2:1;
    unsigned char no3:1;
    unsigned char no4:1;
    unsigned char no5:1;
    unsigned char no6:1;
    unsigned char no7:1;
    unsigned char no8:1;
    unsigned char no9:1;
    unsigned char no10:1;
    unsigned char no11:1;
    unsigned char no12:1;
    unsigned char no13:1;
    unsigned char no14:1;
    unsigned char no15:1;
} __bitf_T2;



#define ADM2         (*(volatile __near unsigned char  *)0x10)
#define ADM2_bit     (*(volatile __near __bitf_T *)0x10)
#define ADTYP        (((volatile __near __bitf_T *)0x10)->no0)
#define AWC          (((volatile __near __bitf_T *)0x10)->no2)
#define ADRCK        (((volatile __near __bitf_T *)0x10)->no3)
#define ADUL         (*(volatile __near unsigned char  *)0x11)
#define ADLL         (*(volatile __near unsigned char  *)0x12)
#define ADTES        (*(volatile __near unsigned char  *)0x13)
#define PIOR0        (*(volatile __near unsigned char  *)0x16)
#define PIOR1        (*(volatile __near unsigned char  *)0x17)
#define PIOR2        (*(volatile __near unsigned char  *)0x18)
#define PIOR3        (*(volatile __near unsigned char  *)0x19)
#define PIOR4        (*(volatile __near unsigned char  *)0x1A)
#define PIOR5        (*(volatile __near unsigned char  *)0x1B)
#define PIOR6        (*(volatile __near unsigned char  *)0x1C)
#define PIOR7        (*(volatile __near unsigned char  *)0x1D)
#define PIOR8        (*(volatile __near unsigned char  *)0x1E)
#define PITHL1       (*(volatile __near unsigned char  *)0x21)
#define PITHL1_bit   (*(volatile __near __bitf_T *)0x21)
#define PITHL3       (*(volatile __near unsigned char  *)0x23)
#define PITHL3_bit   (*(volatile __near __bitf_T *)0x23)
#define PITHL4       (*(volatile __near unsigned char  *)0x24)
#define PITHL4_bit   (*(volatile __near __bitf_T *)0x24)
#define PITHL5       (*(volatile __near unsigned char  *)0x25)
#define PITHL5_bit   (*(volatile __near __bitf_T *)0x25)
#define PITHL6       (*(volatile __near unsigned char  *)0x26)
#define PITHL6_bit   (*(volatile __near __bitf_T *)0x26)
#define PITHL7       (*(volatile __near unsigned char  *)0x27)
#define PITHL7_bit   (*(volatile __near __bitf_T *)0x27)
#define PITHL10      (*(volatile __near unsigned char  *)0x2A)
#define PITHL10_bit  (*(volatile __near __bitf_T *)0x2A)
#define PITHL12      (*(volatile __near unsigned char  *)0x2C)
#define PITHL12_bit  (*(volatile __near __bitf_T *)0x2C)
#define PITHL15      (*(volatile __near unsigned char  *)0x2F)
#define PITHL15_bit  (*(volatile __near __bitf_T *)0x2F)
#define PU0          (*(volatile __near unsigned char  *)0x30)
#define PU0_bit      (*(volatile __near __bitf_T *)0x30)
#define PU1          (*(volatile __near unsigned char  *)0x31)
#define PU1_bit      (*(volatile __near __bitf_T *)0x31)
#define PU3          (*(volatile __near unsigned char  *)0x33)
#define PU3_bit      (*(volatile __near __bitf_T *)0x33)
#define PU4          (*(volatile __near unsigned char  *)0x34)
#define PU4_bit      (*(volatile __near __bitf_T *)0x34)
#define PU5          (*(volatile __near unsigned char  *)0x35)
#define PU5_bit      (*(volatile __near __bitf_T *)0x35)
#define PU6          (*(volatile __near unsigned char  *)0x36)
#define PU6_bit      (*(volatile __near __bitf_T *)0x36)
#define PU7          (*(volatile __near unsigned char  *)0x37)
#define PU7_bit      (*(volatile __near __bitf_T *)0x37)
#define PU10         (*(volatile __near unsigned char  *)0x3A)
#define PU10_bit     (*(volatile __near __bitf_T *)0x3A)
#define PU12         (*(volatile __near unsigned char  *)0x3C)
#define PU12_bit     (*(volatile __near __bitf_T *)0x3C)
#define PU14         (*(volatile __near unsigned char  *)0x3E)
#define PU14_bit     (*(volatile __near __bitf_T *)0x3E)
#define PU15         (*(volatile __near unsigned char  *)0x3F)
#define PU15_bit     (*(volatile __near __bitf_T *)0x3F)
#define PIM1         (*(volatile __near unsigned char  *)0x41)
#define PIM1_bit     (*(volatile __near __bitf_T *)0x41)
#define PIM3         (*(volatile __near unsigned char  *)0x43)
#define PIM3_bit     (*(volatile __near __bitf_T *)0x43)
#define PIM5         (*(volatile __near unsigned char  *)0x45)
#define PIM5_bit     (*(volatile __near __bitf_T *)0x45)
#define PIM6         (*(volatile __near unsigned char  *)0x46)
#define PIM6_bit     (*(volatile __near __bitf_T *)0x46)
#define PIM7         (*(volatile __near unsigned char  *)0x47)
#define PIM7_bit     (*(volatile __near __bitf_T *)0x47)
#define PIM12        (*(volatile __near unsigned char  *)0x4C)
#define PIM12_bit    (*(volatile __near __bitf_T *)0x4C)
#define POM1         (*(volatile __near unsigned char  *)0x51)
#define POM1_bit     (*(volatile __near __bitf_T *)0x51)
#define POM6         (*(volatile __near unsigned char  *)0x56)
#define POM6_bit     (*(volatile __near __bitf_T *)0x56)
#define POM7         (*(volatile __near unsigned char  *)0x57)
#define POM7_bit     (*(volatile __near __bitf_T *)0x57)
#define POM12        (*(volatile __near unsigned char  *)0x5C)
#define POM12_bit    (*(volatile __near __bitf_T *)0x5C)
#define PMC7         (*(volatile __near unsigned char  *)0x67)
#define PMC7_bit     (*(volatile __near __bitf_T *)0x67)
#define PMC12        (*(volatile __near unsigned char  *)0x6C)
#define PMC12_bit    (*(volatile __near __bitf_T *)0x6C)
#define NFEN0        (*(volatile __near unsigned char  *)0x70)
#define NFEN0_bit    (*(volatile __near __bitf_T *)0x70)
#define NFEN1        (*(volatile __near unsigned char  *)0x71)
#define NFEN1_bit    (*(volatile __near __bitf_T *)0x71)
#define NFEN2        (*(volatile __near unsigned char  *)0x72)
#define NFEN2_bit    (*(volatile __near __bitf_T *)0x72)
#define ISC          (*(volatile __near unsigned char  *)0x73)
#define ISC_bit      (*(volatile __near __bitf_T *)0x73)
#define TIS0         (*(volatile __near unsigned char  *)0x74)
#define TIS1         (*(volatile __near unsigned char  *)0x75)
#define ADPC         (*(volatile __near unsigned char  *)0x76)
#define PMS          (*(volatile __near unsigned char  *)0x77)
#define PMS_bit      (*(volatile __near __bitf_T *)0x77)
#define IAWCTL       (*(volatile __near unsigned char  *)0x78)
#define INTFLG0      (*(volatile __near unsigned char  *)0x79)
#define TIS2         (*(volatile __near unsigned char  *)0x7A)
#define LCHSEL       (*(volatile __near unsigned char  *)0x7B)
#define INTMSK       (*(volatile __near unsigned char  *)0x7C)
#define DFLCTL       (*(volatile __near unsigned char  *)0x90)
#define DFLCTL_bit   (*(volatile __near __bitf_T *)0x90)
#define DFLEN        (((volatile __near __bitf_T *)0x90)->no0)
#define HIOTRM       (*(volatile __near unsigned char  *)0xA0)
#define HOCODIV      (*(volatile __near unsigned char  *)0xA8)
#define SPMCTRL      (*(volatile __near unsigned char  *)0xD8)
#define SPOFR        (*(volatile __near unsigned short *)0xDA)
#define SPUFR        (*(volatile __near unsigned short *)0xDC)
#define PER0         (*(volatile __near unsigned char  *)0xF0)
#define PER0_bit     (*(volatile __near __bitf_T *)0xF0)
#define TAU0EN       (((volatile __near __bitf_T *)0xF0)->no0)
#define TAU1EN       (((volatile __near __bitf_T *)0xF0)->no1)
#define SAU0EN       (((volatile __near __bitf_T *)0xF0)->no2)
#define SAU1EN       (((volatile __near __bitf_T *)0xF0)->no3)
#define IICA0EN      (((volatile __near __bitf_T *)0xF0)->no4)
#define ADCEN        (((volatile __near __bitf_T *)0xF0)->no5)
#define RTCEN        (((volatile __near __bitf_T *)0xF0)->no7)
#define OSMC         (*(volatile __near unsigned char  *)0xF3)
#define BCDADJ       (*(volatile __near unsigned char  *)0xFE)
#define SSR00        (*(volatile __near unsigned short *)0x100)
#define SSR00L       (*(volatile __near unsigned char  *)0x100)
#define SSR01        (*(volatile __near unsigned short *)0x102)
#define SSR01L       (*(volatile __near unsigned char  *)0x102)
#define SIR00        (*(volatile __near unsigned short *)0x104)
#define SIR00L       (*(volatile __near unsigned char  *)0x104)
#define SIR01        (*(volatile __near unsigned short *)0x106)
#define SIR01L       (*(volatile __near unsigned char  *)0x106)
#define SMR00        (*(volatile __near unsigned short *)0x108)
#define SMR01        (*(volatile __near unsigned short *)0x10A)
#define SCR00        (*(volatile __near unsigned short *)0x10C)
#define SCR01        (*(volatile __near unsigned short *)0x10E)
#define SE0          (*(volatile __near unsigned short *)0x110)
#define SE0L         (*(volatile __near unsigned char  *)0x110)
#define SE0L_bit     (*(volatile __near __bitf_T *)0x110)
#define SS0          (*(volatile __near unsigned short *)0x112)
#define SS0L         (*(volatile __near unsigned char  *)0x112)
#define SS0L_bit     (*(volatile __near __bitf_T *)0x112)
#define ST0          (*(volatile __near unsigned short *)0x114)
#define ST0L         (*(volatile __near unsigned char  *)0x114)
#define ST0L_bit     (*(volatile __near __bitf_T *)0x114)
#define SPS0         (*(volatile __near unsigned short *)0x116)
#define SPS0L        (*(volatile __near unsigned char  *)0x116)
#define SO0          (*(volatile __near unsigned short *)0x118)
#define SOE0         (*(volatile __near unsigned short *)0x11A)
#define SOE0L        (*(volatile __near unsigned char  *)0x11A)
#define SOE0L_bit    (*(volatile __near __bitf_T *)0x11A)
#define SOL0         (*(volatile __near unsigned short *)0x120)
#define SOL0L        (*(volatile __near unsigned char  *)0x120)
#define SSE0         (*(volatile __near unsigned short *)0x122)
#define SSE0L        (*(volatile __near unsigned char  *)0x122)
#define SSR10        (*(volatile __near unsigned short *)0x140)
#define SSR10L       (*(volatile __near unsigned char  *)0x140)
#define SSR11        (*(volatile __near unsigned short *)0x142)
#define SSR11L       (*(volatile __near unsigned char  *)0x142)
#define SIR10        (*(volatile __near unsigned short *)0x144)
#define SIR10L       (*(volatile __near unsigned char  *)0x144)
#define SIR11        (*(volatile __near unsigned short *)0x146)
#define SIR11L       (*(volatile __near unsigned char  *)0x146)
#define SMR10        (*(volatile __near unsigned short *)0x148)
#define SMR11        (*(volatile __near unsigned short *)0x14A)
#define SCR10        (*(volatile __near unsigned short *)0x14C)
#define SCR11        (*(volatile __near unsigned short *)0x14E)
#define SE1          (*(volatile __near unsigned short *)0x150)
#define SE1L         (*(volatile __near unsigned char  *)0x150)
#define SE1L_bit     (*(volatile __near __bitf_T *)0x150)
#define SS1          (*(volatile __near unsigned short *)0x152)
#define SS1L         (*(volatile __near unsigned char  *)0x152)
#define SS1L_bit     (*(volatile __near __bitf_T *)0x152)
#define ST1          (*(volatile __near unsigned short *)0x154)
#define ST1L         (*(volatile __near unsigned char  *)0x154)
#define ST1L_bit     (*(volatile __near __bitf_T *)0x154)
#define SPS1         (*(volatile __near unsigned short *)0x156)
#define SPS1L        (*(volatile __near unsigned char  *)0x156)
#define SO1          (*(volatile __near unsigned short *)0x158)
#define SOE1         (*(volatile __near unsigned short *)0x15A)
#define SOE1L        (*(volatile __near unsigned char  *)0x15A)
#define SOE1L_bit    (*(volatile __near __bitf_T *)0x15A)
#define SOL1         (*(volatile __near unsigned short *)0x160)
#define SOL1L        (*(volatile __near unsigned char  *)0x160)
#define SSE1         (*(volatile __near unsigned short *)0x162)
#define SSE1L        (*(volatile __near unsigned char  *)0x162)
#define TCR00        (*(volatile __near unsigned short *)0x180)
#define TCR01        (*(volatile __near unsigned short *)0x182)
#define TCR02        (*(volatile __near unsigned short *)0x184)
#define TCR03        (*(volatile __near unsigned short *)0x186)
#define TCR04        (*(volatile __near unsigned short *)0x188)
#define TCR05        (*(volatile __near unsigned short *)0x18A)
#define TCR06        (*(volatile __near unsigned short *)0x18C)
#define TCR07        (*(volatile __near unsigned short *)0x18E)
#define TMR00        (*(volatile __near unsigned short *)0x190)
#define TMR01        (*(volatile __near unsigned short *)0x192)
#define TMR02        (*(volatile __near unsigned short *)0x194)
#define TMR03        (*(volatile __near unsigned short *)0x196)
#define TMR04        (*(volatile __near unsigned short *)0x198)
#define TMR05        (*(volatile __near unsigned short *)0x19A)
#define TMR06        (*(volatile __near unsigned short *)0x19C)
#define TMR07        (*(volatile __near unsigned short *)0x19E)
#define TSR00        (*(volatile __near unsigned short *)0x1A0)
#define TSR00L       (*(volatile __near unsigned char  *)0x1A0)
#define TSR01        (*(volatile __near unsigned short *)0x1A2)
#define TSR01L       (*(volatile __near unsigned char  *)0x1A2)
#define TSR02        (*(volatile __near unsigned short *)0x1A4)
#define TSR02L       (*(volatile __near unsigned char  *)0x1A4)
#define TSR03        (*(volatile __near unsigned short *)0x1A6)
#define TSR03L       (*(volatile __near unsigned char  *)0x1A6)
#define TSR04        (*(volatile __near unsigned short *)0x1A8)
#define TSR04L       (*(volatile __near unsigned char  *)0x1A8)
#define TSR05        (*(volatile __near unsigned short *)0x1AA)
#define TSR05L       (*(volatile __near unsigned char  *)0x1AA)
#define TSR06        (*(volatile __near unsigned short *)0x1AC)
#define TSR06L       (*(volatile __near unsigned char  *)0x1AC)
#define TSR07        (*(volatile __near unsigned short *)0x1AE)
#define TSR07L       (*(volatile __near unsigned char  *)0x1AE)
#define TE0          (*(volatile __near unsigned short *)0x1B0)
#define TE0L         (*(volatile __near unsigned char  *)0x1B0)
#define TE0L_bit     (*(volatile __near __bitf_T *)0x1B0)
#define TS0          (*(volatile __near unsigned short *)0x1B2)
#define TS0L         (*(volatile __near unsigned char  *)0x1B2)
#define TS0L_bit     (*(volatile __near __bitf_T *)0x1B2)
#define TT0          (*(volatile __near unsigned short *)0x1B4)
#define TT0L         (*(volatile __near unsigned char  *)0x1B4)
#define TT0L_bit     (*(volatile __near __bitf_T *)0x1B4)
#define TPS0         (*(volatile __near unsigned short *)0x1B6)
#define TO0          (*(volatile __near unsigned short *)0x1B8)
#define TO0L         (*(volatile __near unsigned char  *)0x1B8)
#define TOE0         (*(volatile __near unsigned short *)0x1BA)
#define TOE0L        (*(volatile __near unsigned char  *)0x1BA)
#define TOE0L_bit    (*(volatile __near __bitf_T *)0x1BA)
#define TOL0         (*(volatile __near unsigned short *)0x1BC)
#define TOL0L        (*(volatile __near unsigned char  *)0x1BC)
#define TOM0         (*(volatile __near unsigned short *)0x1BE)
#define TOM0L        (*(volatile __near unsigned char  *)0x1BE)
#define TCR10        (*(volatile __near unsigned short *)0x1C0)
#define TCR11        (*(volatile __near unsigned short *)0x1C2)
#define TCR12        (*(volatile __near unsigned short *)0x1C4)
#define TCR13        (*(volatile __near unsigned short *)0x1C6)
#define TCR14        (*(volatile __near unsigned short *)0x1C8)
#define TCR15        (*(volatile __near unsigned short *)0x1CA)
#define TCR16        (*(volatile __near unsigned short *)0x1CC)
#define TCR17        (*(volatile __near unsigned short *)0x1CE)
#define TMR10        (*(volatile __near unsigned short *)0x1D0)
#define TMR11        (*(volatile __near unsigned short *)0x1D2)
#define TMR12        (*(volatile __near unsigned short *)0x1D4)
#define TMR13        (*(volatile __near unsigned short *)0x1D6)
#define TMR14        (*(volatile __near unsigned short *)0x1D8)
#define TMR15        (*(volatile __near unsigned short *)0x1DA)
#define TMR16        (*(volatile __near unsigned short *)0x1DC)
#define TMR17        (*(volatile __near unsigned short *)0x1DE)
#define TSR10        (*(volatile __near unsigned short *)0x1E0)
#define TSR10L       (*(volatile __near unsigned char  *)0x1E0)
#define TSR11        (*(volatile __near unsigned short *)0x1E2)
#define TSR11L       (*(volatile __near unsigned char  *)0x1E2)
#define TSR12        (*(volatile __near unsigned short *)0x1E4)
#define TSR12L       (*(volatile __near unsigned char  *)0x1E4)
#define TSR13        (*(volatile __near unsigned short *)0x1E6)
#define TSR13L       (*(volatile __near unsigned char  *)0x1E6)
#define TSR14        (*(volatile __near unsigned short *)0x1E8)
#define TSR14L       (*(volatile __near unsigned char  *)0x1E8)
#define TSR15        (*(volatile __near unsigned short *)0x1EA)
#define TSR15L       (*(volatile __near unsigned char  *)0x1EA)
#define TSR16        (*(volatile __near unsigned short *)0x1EC)
#define TSR16L       (*(volatile __near unsigned char  *)0x1EC)
#define TSR17        (*(volatile __near unsigned short *)0x1EE)
#define TSR17L       (*(volatile __near unsigned char  *)0x1EE)
#define TE1          (*(volatile __near unsigned short *)0x1F0)
#define TE1L         (*(volatile __near unsigned char  *)0x1F0)
#define TE1L_bit     (*(volatile __near __bitf_T *)0x1F0)
#define TS1          (*(volatile __near unsigned short *)0x1F2)
#define TS1L         (*(volatile __near unsigned char  *)0x1F2)
#define TS1L_bit     (*(volatile __near __bitf_T *)0x1F2)
#define TT1          (*(volatile __near unsigned short *)0x1F4)
#define TT1L         (*(volatile __near unsigned char  *)0x1F4)
#define TT1L_bit     (*(volatile __near __bitf_T *)0x1F4)
#define TPS1         (*(volatile __near unsigned short *)0x1F6)
#define TO1          (*(volatile __near unsigned short *)0x1F8)
#define TO1L         (*(volatile __near unsigned char  *)0x1F8)
#define TOE1         (*(volatile __near unsigned short *)0x1FA)
#define TOE1L        (*(volatile __near unsigned char  *)0x1FA)
#define TOE1L_bit    (*(volatile __near __bitf_T *)0x1FA)
#define TOL1         (*(volatile __near unsigned short *)0x1FC)
#define TOL1L        (*(volatile __near unsigned char  *)0x1FC)
#define TOM1         (*(volatile __near unsigned short *)0x1FE)
#define TOM1L        (*(volatile __near unsigned char  *)0x1FE)
#define ERADR        (*(volatile __near unsigned short *)0x200)
#define ECCIER       (*(volatile __near unsigned char  *)0x202)
#define ECCER        (*(volatile __near unsigned char  *)0x203)
#define ECCTPR       (*(volatile __near unsigned char  *)0x204)
#define ECCTMDR      (*(volatile __near unsigned char  *)0x205)
#define ECCDWRVR     (*(volatile __near unsigned short *)0x206)
#define PSRSEL       (*(volatile __near unsigned char  *)0x220)
#define PSRSEL_bit   (*(volatile __near __bitf_T *)0x220)
#define PSNZCNT0     (*(volatile __near unsigned char  *)0x222)
#define PSNZCNT0_bit (*(volatile __near __bitf_T *)0x222)
#define PSNZCNT1     (*(volatile __near unsigned char  *)0x223)
#define PSNZCNT1_bit (*(volatile __near __bitf_T *)0x223)
#define PSNZCNT2     (*(volatile __near unsigned char  *)0x224)
#define PSNZCNT2_bit (*(volatile __near __bitf_T *)0x224)
#define PSNZCNT3     (*(volatile __near unsigned char  *)0x225)
#define PSNZCNT3_bit (*(volatile __near __bitf_T *)0x225)
#define DAM2         (*(volatile __near unsigned char  *)0x227)
#define DAM2_bit     (*(volatile __near __bitf_T *)0x227)
#define ANO0EN       (((volatile __near __bitf_T *)0x227)->no0)
#define PWMDLY0      (*(volatile __near unsigned short *)0x228)
#define PWMDLY1      (*(volatile __near unsigned short *)0x22A)
#define PWMDLY2      (*(volatile __near unsigned short *)0x22C)
#define IICCTL00     (*(volatile __near unsigned char  *)0x230)
#define IICCTL00_bit (*(volatile __near __bitf_T *)0x230)
#define SPT0         (((volatile __near __bitf_T *)0x230)->no0)
#define STT0         (((volatile __near __bitf_T *)0x230)->no1)
#define ACKE0        (((volatile __near __bitf_T *)0x230)->no2)
#define WTIM0        (((volatile __near __bitf_T *)0x230)->no3)
#define SPIE0        (((volatile __near __bitf_T *)0x230)->no4)
#define WREL0        (((volatile __near __bitf_T *)0x230)->no5)
#define LREL0        (((volatile __near __bitf_T *)0x230)->no6)
#define IICE0        (((volatile __near __bitf_T *)0x230)->no7)
#define IICCTL01     (*(volatile __near unsigned char  *)0x231)
#define IICCTL01_bit (*(volatile __near __bitf_T *)0x231)
#define PRS0         (((volatile __near __bitf_T *)0x231)->no0)
#define DFC0         (((volatile __near __bitf_T *)0x231)->no2)
#define SMC0         (((volatile __near __bitf_T *)0x231)->no3)
#define DAD0         (((volatile __near __bitf_T *)0x231)->no4)
#define CLD0         (((volatile __near __bitf_T *)0x231)->no5)
#define WUP0         (((volatile __near __bitf_T *)0x231)->no7)
#define IICWL0       (*(volatile __near unsigned char  *)0x232)
#define IICWH0       (*(volatile __near unsigned char  *)0x233)
#define SVA0         (*(volatile __near unsigned char  *)0x234)
#define TRJCR0       (*(volatile __near unsigned char  *)0x240)
#define TRJIOC0      (*(volatile __near unsigned char  *)0x241)
#define TRJIOC0_bit  (*(volatile __near __bitf_T *)0x241)
#define TRJMR0       (*(volatile __near unsigned char  *)0x242)
#define TRJMR0_bit   (*(volatile __near __bitf_T *)0x242)
#define TRJISR0      (*(volatile __near unsigned char  *)0x243)
#define TRJISR0_bit  (*(volatile __near __bitf_T *)0x243)
#define TRDELC       (*(volatile __near unsigned char  *)0x260)
#define TRDELC_bit   (*(volatile __near __bitf_T *)0x260)
#define TRDSTR       (*(volatile __near unsigned char  *)0x263)
#define TRDMR        (*(volatile __near unsigned char  *)0x264)
#define TRDMR_bit    (*(volatile __near __bitf_T *)0x264)
#define TRDSYNC      (((volatile __near __bitf_T *)0x264)->no0)
#define TRDBFC0      (((volatile __near __bitf_T *)0x264)->no4)
#define TRDBFD0      (((volatile __near __bitf_T *)0x264)->no5)
#define TRDBFC1      (((volatile __near __bitf_T *)0x264)->no6)
#define TRDBFD1      (((volatile __near __bitf_T *)0x264)->no7)
#define TRDPMR       (*(volatile __near unsigned char  *)0x265)
#define TRDPMR_bit   (*(volatile __near __bitf_T *)0x265)
#define TRDPWMB0     (((volatile __near __bitf_T *)0x265)->no0)
#define TRDPWMC0     (((volatile __near __bitf_T *)0x265)->no1)
#define TRDPWMD0     (((volatile __near __bitf_T *)0x265)->no2)
#define TRDPWMB1     (((volatile __near __bitf_T *)0x265)->no4)
#define TRDPWMC1     (((volatile __near __bitf_T *)0x265)->no5)
#define TRDPWMD1     (((volatile __near __bitf_T *)0x265)->no6)
#define TRDFCR       (*(volatile __near unsigned char  *)0x266)
#define TRDFCR_bit   (*(volatile __near __bitf_T *)0x266)
#define TRDOER1      (*(volatile __near unsigned char  *)0x267)
#define TRDOER1_bit  (*(volatile __near __bitf_T *)0x267)
#define TRDOER2      (*(volatile __near unsigned char  *)0x268)
#define TRDOER2_bit  (*(volatile __near __bitf_T *)0x268)
#define TRDSHUTS     (((volatile __near __bitf_T *)0x268)->no0)
#define TRDPTO       (((volatile __near __bitf_T *)0x268)->no7)
#define TRDOCR       (*(volatile __near unsigned char  *)0x269)
#define TRDOCR_bit   (*(volatile __near __bitf_T *)0x269)
#define TRDDF0       (*(volatile __near unsigned char  *)0x26A)
#define TRDDF0_bit   (*(volatile __near __bitf_T *)0x26A)
#define TRDDF1       (*(volatile __near unsigned char  *)0x26B)
#define TRDDF1_bit   (*(volatile __near __bitf_T *)0x26B)
#define TRDCR0       (*(volatile __near unsigned char  *)0x270)
#define TRDCR0_bit   (*(volatile __near __bitf_T *)0x270)
#define TRDIORA0     (*(volatile __near unsigned char  *)0x271)
#define TRDIORA0_bit (*(volatile __near __bitf_T *)0x271)
#define TRDIORC0     (*(volatile __near unsigned char  *)0x272)
#define TRDIORC0_bit (*(volatile __near __bitf_T *)0x272)
#define TRDSR0       (*(volatile __near unsigned char  *)0x273)
#define TRDSR0_bit   (*(volatile __near __bitf_T *)0x273)
#define TRDIER0      (*(volatile __near unsigned char  *)0x274)
#define TRDIER0_bit  (*(volatile __near __bitf_T *)0x274)
#define TRDPOCR0     (*(volatile __near unsigned char  *)0x275)
#define TRDPOCR0_bit (*(volatile __near __bitf_T *)0x275)
#define TRD0         (*(volatile __near unsigned short *)0x276)
#define TRDGRA0      (*(volatile __near unsigned short *)0x278)
#define TRDGRB0      (*(volatile __near unsigned short *)0x27A)
#define TRDCR1       (*(volatile __near unsigned char  *)0x280)
#define TRDCR1_bit   (*(volatile __near __bitf_T *)0x280)
#define TRDIORA1     (*(volatile __near unsigned char  *)0x281)
#define TRDIORA1_bit (*(volatile __near __bitf_T *)0x281)
#define TRDIORC1     (*(volatile __near unsigned char  *)0x282)
#define TRDIORC1_bit (*(volatile __near __bitf_T *)0x282)
#define TRDSR1       (*(volatile __near unsigned char  *)0x283)
#define TRDSR1_bit   (*(volatile __near __bitf_T *)0x283)
#define TRDIER1      (*(volatile __near unsigned char  *)0x284)
#define TRDIER1_bit  (*(volatile __near __bitf_T *)0x284)
#define TRDPOCR1     (*(volatile __near unsigned char  *)0x285)
#define TRDPOCR1_bit (*(volatile __near __bitf_T *)0x285)
#define TRD1         (*(volatile __near unsigned short *)0x286)
#define TRDGRA1      (*(volatile __near unsigned short *)0x288)
#define TRDGRB1      (*(volatile __near unsigned short *)0x28A)
#define CMPCTL       (*(volatile __near unsigned char  *)0x2A0)
#define CMPCTL_bit   (*(volatile __near __bitf_T *)0x2A0)
#define COE          (((volatile __near __bitf_T *)0x2A0)->no1)
#define HCMPON       (((volatile __near __bitf_T *)0x2A0)->no7)
#define CMPSEL       (*(volatile __near unsigned char  *)0x2A1)
#define CMPSEL_bit   (*(volatile __near __bitf_T *)0x2A1)
#define CPOE         (((volatile __near __bitf_T *)0x2A1)->no6)
#define CMPMON       (*(volatile __near unsigned char  *)0x2A2)
#define CMPMON_bit   (*(volatile __near __bitf_T *)0x2A2)
#define PER1         (*(volatile __near unsigned char  *)0x2C0)
#define PER1_bit     (*(volatile __near __bitf_T *)0x2C0)
#define TRJ0EN       (((volatile __near __bitf_T *)0x2C0)->no0)
#define DTCEN        (((volatile __near __bitf_T *)0x2C0)->no3)
#define TRD0EN       (((volatile __near __bitf_T *)0x2C0)->no4)
#define CMPEN        (((volatile __near __bitf_T *)0x2C0)->no5)
#define DACEN        (((volatile __near __bitf_T *)0x2C0)->no7)
#define PER2         (*(volatile __near unsigned char  *)0x2C1)
#define PER2_bit     (*(volatile __near __bitf_T *)0x2C1)
#define CAN0EN       (((volatile __near __bitf_T *)0x2C1)->no0)
#define LIN0EN       (((volatile __near __bitf_T *)0x2C1)->no2)
#define LIN1EN       (((volatile __near __bitf_T *)0x2C1)->no3)
#define CANCKSEL     (*(volatile __near unsigned char  *)0x2C2)
#define CANCKSEL_bit (*(volatile __near __bitf_T *)0x2C2)
#define CAN0MCKE     (((volatile __near __bitf_T *)0x2C2)->no0)
#define LINCKSEL     (*(volatile __near unsigned char  *)0x2C3)
#define LINCKSEL_bit (*(volatile __near __bitf_T *)0x2C3)
#define LIN0MCK      (((volatile __near __bitf_T *)0x2C3)->no0)
#define LIN1MCK      (((volatile __near __bitf_T *)0x2C3)->no1)
#define LIN0MCKE     (((volatile __near __bitf_T *)0x2C3)->no4)
#define LIN1MCKE     (((volatile __near __bitf_T *)0x2C3)->no5)
#define CKSEL        (*(volatile __near unsigned char  *)0x2C4)
#define CKSEL_bit    (*(volatile __near __bitf_T *)0x2C4)
#define SELLOSC      (((volatile __near __bitf_T *)0x2C4)->no0)
#define TRD_CKSEL    (((volatile __near __bitf_T *)0x2C4)->no2)
#define PLLCTL       (*(volatile __near unsigned char  *)0x2C5)
#define PLLCTL_bit   (*(volatile __near __bitf_T *)0x2C5)
#define PLLON        (((volatile __near __bitf_T *)0x2C5)->no0)
#define PLLMUL       (((volatile __near __bitf_T *)0x2C5)->no1)
#define SELPLL       (((volatile __near __bitf_T *)0x2C5)->no2)
#define PLLDIV0      (((volatile __near __bitf_T *)0x2C5)->no4)
#define PLLDIV1      (((volatile __near __bitf_T *)0x2C5)->no5)
#define LCKSEL0      (((volatile __near __bitf_T *)0x2C5)->no6)
#define LCKSEL1      (((volatile __near __bitf_T *)0x2C5)->no7)
#define PLLSTS       (*(volatile __near unsigned char  *)0x2C6)
#define PLLSTS_bit   (*(volatile __near __bitf_T *)0x2C6)
#define SELPLLS      (((volatile __near __bitf_T *)0x2C6)->no3)
#define LOCK         (((volatile __near __bitf_T *)0x2C6)->no7)
#define MDIV         (*(volatile __near unsigned char  *)0x2C7)
#define RTCCL        (*(volatile __near unsigned char  *)0x2C8)
#define RTCCL_bit    (*(volatile __near __bitf_T *)0x2C8)
#define POCRES       (*(volatile __near unsigned char  *)0x2C9)
#define POCRES_bit   (*(volatile __near __bitf_T *)0x2C9)
#define POCRES0      (((volatile __near __bitf_T *)0x2C9)->no0)
#define CLKRF        (((volatile __near __bitf_T *)0x2C9)->no4)
#define STPSTC       (*(volatile __near unsigned char  *)0x2CA)
#define STPSTC_bit   (*(volatile __near __bitf_T *)0x2CA)
#define STPSEL       (((volatile __near __bitf_T *)0x2CA)->no0)
#define STPLV        (((volatile __near __bitf_T *)0x2CA)->no4)
#define STPOEN       (((volatile __near __bitf_T *)0x2CA)->no7)
#define HDTCCR0      (*(volatile __near unsigned char  *)0x2D0)
#define HDTCCR0_bit  (*(volatile __near __bitf_T *)0x2D0)
#define HMODE0       (((volatile __near __bitf_T *)0x2D0)->no0)
#define HRPTSEL0     (((volatile __near __bitf_T *)0x2D0)->no1)
#define HSAMOD0      (((volatile __near __bitf_T *)0x2D0)->no2)
#define HDAMOD0      (((volatile __near __bitf_T *)0x2D0)->no3)
#define HCHNE0       (((volatile __near __bitf_T *)0x2D0)->no4)
#define HRPTINT0     (((volatile __near __bitf_T *)0x2D0)->no5)
#define HSZ0         (((volatile __near __bitf_T *)0x2D0)->no6)
#define HDTCCT0      (*(volatile __near unsigned char  *)0x2D2)
#define HDTCCT0_bit  (*(volatile __near __bitf_T *)0x2D2)
#define HDTRLD0      (*(volatile __near unsigned char  *)0x2D3)
#define HDTRLD0_bit  (*(volatile __near __bitf_T *)0x2D3)
#define HDTSAR0      (*(volatile __near unsigned short *)0x2D4)
#define HDTDAR0      (*(volatile __near unsigned short *)0x2D6)
#define HDTCCR1      (*(volatile __near unsigned char  *)0x2D8)
#define HDTCCR1_bit  (*(volatile __near __bitf_T *)0x2D8)
#define HMODE1       (((volatile __near __bitf_T *)0x2D8)->no0)
#define HRPTSEL1     (((volatile __near __bitf_T *)0x2D8)->no1)
#define HSAMOD1      (((volatile __near __bitf_T *)0x2D8)->no2)
#define HDAMOD1      (((volatile __near __bitf_T *)0x2D8)->no3)
#define HCHNE1       (((volatile __near __bitf_T *)0x2D8)->no4)
#define HRPTINT1     (((volatile __near __bitf_T *)0x2D8)->no5)
#define HSZ1         (((volatile __near __bitf_T *)0x2D8)->no6)
#define HDTCCT1      (*(volatile __near unsigned char  *)0x2DA)
#define HDTCCT1_bit  (*(volatile __near __bitf_T *)0x2DA)
#define HDTRLD1      (*(volatile __near unsigned char  *)0x2DB)
#define HDTRLD1_bit  (*(volatile __near __bitf_T *)0x2DB)
#define HDTSAR1      (*(volatile __near unsigned short *)0x2DC)
#define HDTDAR1      (*(volatile __near unsigned short *)0x2DE)
#define DTCBAR       (*(volatile __near unsigned char  *)0x2E0)
#define SELHS0       (*(volatile __near unsigned char  *)0x2E1)
#define SELHS0_bit   (*(volatile __near __bitf_T *)0x2E1)
#define SELHS1       (*(volatile __near unsigned char  *)0x2E2)
#define SELHS1_bit   (*(volatile __near __bitf_T *)0x2E2)
#define DTCEN0       (*(volatile __near unsigned char  *)0x2E8)
#define DTCEN0_bit   (*(volatile __near __bitf_T *)0x2E8)
#define DTCEN00      (((volatile __near __bitf_T *)0x2E8)->no0)
#define DTCEN01      (((volatile __near __bitf_T *)0x2E8)->no1)
#define DTCEN02      (((volatile __near __bitf_T *)0x2E8)->no2)
#define DTCEN03      (((volatile __near __bitf_T *)0x2E8)->no3)
#define DTCEN04      (((volatile __near __bitf_T *)0x2E8)->no4)
#define DTCEN05      (((volatile __near __bitf_T *)0x2E8)->no5)
#define DTCEN06      (((volatile __near __bitf_T *)0x2E8)->no6)
#define DTCEN1       (*(volatile __near unsigned char  *)0x2E9)
#define DTCEN1_bit   (*(volatile __near __bitf_T *)0x2E9)
#define DTCEN10      (((volatile __near __bitf_T *)0x2E9)->no0)
#define DTCEN11      (((volatile __near __bitf_T *)0x2E9)->no1)
#define DTCEN12      (((volatile __near __bitf_T *)0x2E9)->no2)
#define DTCEN13      (((volatile __near __bitf_T *)0x2E9)->no3)
#define DTCEN14      (((volatile __near __bitf_T *)0x2E9)->no4)
#define DTCEN15      (((volatile __near __bitf_T *)0x2E9)->no5)
#define DTCEN16      (((volatile __near __bitf_T *)0x2E9)->no6)
#define DTCEN17      (((volatile __near __bitf_T *)0x2E9)->no7)
#define DTCEN2       (*(volatile __near unsigned char  *)0x2EA)
#define DTCEN2_bit   (*(volatile __near __bitf_T *)0x2EA)
#define DTCEN20      (((volatile __near __bitf_T *)0x2EA)->no0)
#define DTCEN21      (((volatile __near __bitf_T *)0x2EA)->no1)
#define DTCEN22      (((volatile __near __bitf_T *)0x2EA)->no2)
#define DTCEN23      (((volatile __near __bitf_T *)0x2EA)->no3)
#define DTCEN24      (((volatile __near __bitf_T *)0x2EA)->no4)
#define DTCEN25      (((volatile __near __bitf_T *)0x2EA)->no5)
#define DTCEN27      (((volatile __near __bitf_T *)0x2EA)->no7)
#define DTCEN3       (*(volatile __near unsigned char  *)0x2EB)
#define DTCEN3_bit   (*(volatile __near __bitf_T *)0x2EB)
#define DTCEN30      (((volatile __near __bitf_T *)0x2EB)->no0)
#define DTCEN31      (((volatile __near __bitf_T *)0x2EB)->no1)
#define DTCEN32      (((volatile __near __bitf_T *)0x2EB)->no2)
#define DTCEN33      (((volatile __near __bitf_T *)0x2EB)->no3)
#define DTCEN34      (((volatile __near __bitf_T *)0x2EB)->no4)
#define DTCEN35      (((volatile __near __bitf_T *)0x2EB)->no5)
#define DTCEN36      (((volatile __near __bitf_T *)0x2EB)->no6)
#define DTCEN37      (((volatile __near __bitf_T *)0x2EB)->no7)
#define DTCEN4       (*(volatile __near unsigned char  *)0x2EC)
#define DTCEN4_bit   (*(volatile __near __bitf_T *)0x2EC)
#define DTCEN40      (((volatile __near __bitf_T *)0x2EC)->no0)
#define DTCEN41      (((volatile __near __bitf_T *)0x2EC)->no1)
#define DTCEN42      (((volatile __near __bitf_T *)0x2EC)->no2)
#define DTCEN43      (((volatile __near __bitf_T *)0x2EC)->no3)
#define DTCEN44      (((volatile __near __bitf_T *)0x2EC)->no4)
#define DTCEN45      (((volatile __near __bitf_T *)0x2EC)->no5)
#define DTCEN46      (((volatile __near __bitf_T *)0x2EC)->no6)
#define DTCEN47      (((volatile __near __bitf_T *)0x2EC)->no7)
#define DTCEN5       (*(volatile __near unsigned char  *)0x2ED)
#define DTCEN5_bit   (*(volatile __near __bitf_T *)0x2ED)
#define DTCEN52      (((volatile __near __bitf_T *)0x2ED)->no2)
#define DTCEN53      (((volatile __near __bitf_T *)0x2ED)->no3)
#define DTCEN54      (((volatile __near __bitf_T *)0x2ED)->no4)
#define DTCEN55      (((volatile __near __bitf_T *)0x2ED)->no5)
#define DTCEN56      (((volatile __near __bitf_T *)0x2ED)->no6)
#define DTCEN57      (((volatile __near __bitf_T *)0x2ED)->no7)
#define CRC0CTL      (*(volatile __near unsigned char  *)0x2F0)
#define CRC0CTL_bit  (*(volatile __near __bitf_T *)0x2F0)
#define CRC0EN       (((volatile __near __bitf_T *)0x2F0)->no7)
#define PGCRCL       (*(volatile __near unsigned short *)0x2F2)
#define CRCMD        (*(volatile __near unsigned char  *)0x2F9)
#define CRCD         (*(volatile __near unsigned short *)0x2FA)
#define C0CFGL       (*(volatile __near unsigned short *)0x300)
#define C0CFGLL      (*(volatile __near unsigned char  *)0x300)
#define C0CFGLH      (*(volatile __near unsigned char  *)0x301)
#define C0CFGH       (*(volatile __near unsigned short *)0x302)
#define C0CFGHL      (*(volatile __near unsigned char  *)0x302)
#define C0CFGHH      (*(volatile __near unsigned char  *)0x303)
#define C0CTRL       (*(volatile __near unsigned short *)0x304)
#define C0CTRLL      (*(volatile __near unsigned char  *)0x304)
#define C0CTRLH      (*(volatile __near unsigned char  *)0x305)
#define C0CTRH       (*(volatile __near unsigned short *)0x306)
#define C0CTRHL      (*(volatile __near unsigned char  *)0x306)
#define C0CTRHH      (*(volatile __near unsigned char  *)0x307)
#define C0STSL       (*(volatile __near unsigned short *)0x308)
#define C0STSLL      (*(volatile __near unsigned char  *)0x308)
#define C0STSLH      (*(volatile __near unsigned char  *)0x309)
#define C0STSH       (*(volatile __near unsigned short *)0x30A)
#define C0STSHL      (*(volatile __near unsigned char  *)0x30A)
#define C0STSHH      (*(volatile __near unsigned char  *)0x30B)
#define C0ERFLL      (*(volatile __near unsigned short *)0x30C)
#define C0ERFLLL     (*(volatile __near unsigned char  *)0x30C)
#define C0ERFLLH     (*(volatile __near unsigned char  *)0x30D)
#define C0ERFLH      (*(volatile __near unsigned short *)0x30E)
#define C0ERFLHL     (*(volatile __near unsigned char  *)0x30E)
#define C0ERFLHH     (*(volatile __near unsigned char  *)0x30F)
#define GCFGL        (*(volatile __near unsigned short *)0x322)
#define GCFGLL       (*(volatile __near unsigned char  *)0x322)
#define GCFGLH       (*(volatile __near unsigned char  *)0x323)
#define GCFGH        (*(volatile __near unsigned short *)0x324)
#define GCFGHL       (*(volatile __near unsigned char  *)0x324)
#define GCFGHH       (*(volatile __near unsigned char  *)0x325)
#define GCTRL        (*(volatile __near unsigned short *)0x326)
#define GCTRLL       (*(volatile __near unsigned char  *)0x326)
#define GCTRLH       (*(volatile __near unsigned char  *)0x327)
#define GCTRH        (*(volatile __near unsigned short *)0x328)
#define GCTRHL       (*(volatile __near unsigned char  *)0x328)
#define GCTRHH       (*(volatile __near unsigned char  *)0x329)
#define GSTS         (*(volatile __near unsigned short *)0x32A)
#define GSTSL        (*(volatile __near unsigned char  *)0x32A)
#define GSTSH        (*(volatile __near unsigned char  *)0x32B)
#define GERFLL       (*(volatile __near unsigned char  *)0x32C)
#define GTSC         (*(volatile __near unsigned short *)0x32E)
#define GAFLCFG      (*(volatile __near unsigned short *)0x330)
#define GAFLCFGL     (*(volatile __near unsigned char  *)0x330)
#define GAFLCFGH     (*(volatile __near unsigned char  *)0x331)
#define RMNB         (*(volatile __near unsigned short *)0x332)
#define RMNBL        (*(volatile __near unsigned char  *)0x332)
#define RMND0        (*(volatile __near unsigned short *)0x334)
#define RMND0L       (*(volatile __near unsigned char  *)0x334)
#define RMND0H       (*(volatile __near unsigned char  *)0x335)
#define RFCC0        (*(volatile __near unsigned short *)0x338)
#define RFCC0L       (*(volatile __near unsigned char  *)0x338)
#define RFCC0H       (*(volatile __near unsigned char  *)0x339)
#define RFCC1        (*(volatile __near unsigned short *)0x33A)
#define RFCC1L       (*(volatile __near unsigned char  *)0x33A)
#define RFCC1H       (*(volatile __near unsigned char  *)0x33B)
#define RFSTS0       (*(volatile __near unsigned short *)0x340)
#define RFSTS0L      (*(volatile __near unsigned char  *)0x340)
#define RFSTS0H      (*(volatile __near unsigned char  *)0x341)
#define RFSTS1       (*(volatile __near unsigned short *)0x342)
#define RFSTS1L      (*(volatile __near unsigned char  *)0x342)
#define RFSTS1H      (*(volatile __near unsigned char  *)0x343)
#define RFPCTR0      (*(volatile __near unsigned short *)0x348)
#define RFPCTR0L     (*(volatile __near unsigned char  *)0x348)
#define RFPCTR0H     (*(volatile __near unsigned char  *)0x349)
#define RFPCTR1      (*(volatile __near unsigned short *)0x34A)
#define RFPCTR1L     (*(volatile __near unsigned char  *)0x34A)
#define RFPCTR1H     (*(volatile __near unsigned char  *)0x34B)
#define CFCCL0       (*(volatile __near unsigned short *)0x350)
#define CFCCL0L      (*(volatile __near unsigned char  *)0x350)
#define CFCCL0H      (*(volatile __near unsigned char  *)0x351)
#define CFCCH0       (*(volatile __near unsigned short *)0x352)
#define CFCCH0L      (*(volatile __near unsigned char  *)0x352)
#define CFCCH0H      (*(volatile __near unsigned char  *)0x353)
#define CFSTS0       (*(volatile __near unsigned short *)0x358)
#define CFSTS0L      (*(volatile __near unsigned char  *)0x358)
#define CFSTS0H      (*(volatile __near unsigned char  *)0x359)
#define CFPCTR0      (*(volatile __near unsigned short *)0x35C)
#define CFPCTR0L     (*(volatile __near unsigned char  *)0x35C)
#define RFMSTS       (*(volatile __near unsigned char  *)0x360)
#define CFMSTS       (*(volatile __near unsigned char  *)0x361)
#define RFISTS       (*(volatile __near unsigned char  *)0x362)
#define CFISTS       (*(volatile __near unsigned char  *)0x363)
#define TMC0         (*(volatile __near unsigned char  *)0x364)
#define TMC1         (*(volatile __near unsigned char  *)0x365)
#define TMC2         (*(volatile __near unsigned char  *)0x366)
#define TMC3         (*(volatile __near unsigned char  *)0x367)
#define TMSTS0       (*(volatile __near unsigned char  *)0x36C)
#define TMSTS1       (*(volatile __near unsigned char  *)0x36D)
#define TMSTS2       (*(volatile __near unsigned char  *)0x36E)
#define TMSTS3       (*(volatile __near unsigned char  *)0x36F)
#define TMTRSTS      (*(volatile __near unsigned short *)0x374)
#define TMTRSTSL     (*(volatile __near unsigned char  *)0x374)
#define TMTRSTSH     (*(volatile __near unsigned char  *)0x375)
#define TMTCSTS      (*(volatile __near unsigned short *)0x376)
#define TMTCSTSL     (*(volatile __near unsigned char  *)0x376)
#define TMTCSTSH     (*(volatile __near unsigned char  *)0x377)
#define TMTASTS      (*(volatile __near unsigned short *)0x378)
#define TMTASTSL     (*(volatile __near unsigned char  *)0x378)
#define TMTASTSH     (*(volatile __near unsigned char  *)0x379)
#define TMIEC        (*(volatile __near unsigned short *)0x37A)
#define TMIECL       (*(volatile __near unsigned char  *)0x37A)
#define TMIECH       (*(volatile __near unsigned char  *)0x37B)
#define THLCC0       (*(volatile __near unsigned short *)0x37C)
#define THLCC0L      (*(volatile __near unsigned char  *)0x37C)
#define THLCC0H      (*(volatile __near unsigned char  *)0x37D)
#define THLSTS0      (*(volatile __near unsigned short *)0x380)
#define THLSTS0L     (*(volatile __near unsigned char  *)0x380)
#define THLSTS0H     (*(volatile __near unsigned char  *)0x381)
#define THLPCTR0     (*(volatile __near unsigned short *)0x384)
#define THLPCTR0L    (*(volatile __near unsigned char  *)0x384)
#define THLPCTR0H    (*(volatile __near unsigned char  *)0x385)
#define GTINTSTS     (*(volatile __near unsigned short *)0x388)
#define GTINTSTSL    (*(volatile __near unsigned char  *)0x388)
#define GTINTSTSH    (*(volatile __near unsigned char  *)0x389)
#define GRWCR        (*(volatile __near unsigned short *)0x38A)
#define GRWCRL       (*(volatile __near unsigned char  *)0x38A)
#define GRWCRH       (*(volatile __near unsigned char  *)0x38B)
#define GTSTCFG      (*(volatile __near unsigned short *)0x38C)
#define GTSTCFGL     (*(volatile __near unsigned char  *)0x38C)
#define GTSTCFGH     (*(volatile __near unsigned char  *)0x38D)
#define GTSTCTRL     (*(volatile __near unsigned char  *)0x38E)
#define GLOCKK       (*(volatile __near unsigned short *)0x394)
#define GAFLIDL0     (*(volatile __near unsigned short *)0x3A0)
#define RMIDL0       (*(volatile __near unsigned short *)0x3A0)
#define GAFLIDL0L    (*(volatile __near unsigned char  *)0x3A0)
#define RMIDL0L      (*(volatile __near unsigned char  *)0x3A0)
#define GAFLIDL0H    (*(volatile __near unsigned char  *)0x3A1)
#define RMIDL0H      (*(volatile __near unsigned char  *)0x3A1)
#define GAFLIDH0     (*(volatile __near unsigned short *)0x3A2)
#define RMIDH0       (*(volatile __near unsigned short *)0x3A2)
#define GAFLIDH0L    (*(volatile __near unsigned char  *)0x3A2)
#define RMIDH0L      (*(volatile __near unsigned char  *)0x3A2)
#define GAFLIDH0H    (*(volatile __near unsigned char  *)0x3A3)
#define RMIDH0H      (*(volatile __near unsigned char  *)0x3A3)
#define GAFLML0      (*(volatile __near unsigned short *)0x3A4)
#define RMTS0        (*(volatile __near unsigned short *)0x3A4)
#define GAFLML0L     (*(volatile __near unsigned char  *)0x3A4)
#define RMTS0L       (*(volatile __near unsigned char  *)0x3A4)
#define GAFLML0H     (*(volatile __near unsigned char  *)0x3A5)
#define RMTS0H       (*(volatile __near unsigned char  *)0x3A5)
#define GAFLMH0      (*(volatile __near unsigned short *)0x3A6)
#define RMPTR0       (*(volatile __near unsigned short *)0x3A6)
#define GAFLMH0L     (*(volatile __near unsigned char  *)0x3A6)
#define RMPTR0L      (*(volatile __near unsigned char  *)0x3A6)
#define GAFLMH0H     (*(volatile __near unsigned char  *)0x3A7)
#define RMPTR0H      (*(volatile __near unsigned char  *)0x3A7)
#define GAFLPL0      (*(volatile __near unsigned short *)0x3A8)
#define RMDF00       (*(volatile __near unsigned short *)0x3A8)
#define GAFLPL0L     (*(volatile __near unsigned char  *)0x3A8)
#define RMDF00L      (*(volatile __near unsigned char  *)0x3A8)
#define GAFLPL0H     (*(volatile __near unsigned char  *)0x3A9)
#define RMDF00H      (*(volatile __near unsigned char  *)0x3A9)
#define GAFLPH0      (*(volatile __near unsigned short *)0x3AA)
#define RMDF10       (*(volatile __near unsigned short *)0x3AA)
#define GAFLPH0L     (*(volatile __near unsigned char  *)0x3AA)
#define RMDF10L      (*(volatile __near unsigned char  *)0x3AA)
#define GAFLPH0H     (*(volatile __near unsigned char  *)0x3AB)
#define RMDF10H      (*(volatile __near unsigned char  *)0x3AB)
#define GAFLIDL1     (*(volatile __near unsigned short *)0x3AC)
#define RMDF20       (*(volatile __near unsigned short *)0x3AC)
#define GAFLIDL1L    (*(volatile __near unsigned char  *)0x3AC)
#define RMDF20L      (*(volatile __near unsigned char  *)0x3AC)
#define GAFLIDL1H    (*(volatile __near unsigned char  *)0x3AD)
#define RMDF20H      (*(volatile __near unsigned char  *)0x3AD)
#define GAFLIDH1     (*(volatile __near unsigned short *)0x3AE)
#define RMDF30       (*(volatile __near unsigned short *)0x3AE)
#define GAFLIDH1L    (*(volatile __near unsigned char  *)0x3AE)
#define RMDF30L      (*(volatile __near unsigned char  *)0x3AE)
#define GAFLIDH1H    (*(volatile __near unsigned char  *)0x3AF)
#define RMDF30H      (*(volatile __near unsigned char  *)0x3AF)
#define GAFLML1      (*(volatile __near unsigned short *)0x3B0)
#define RMIDL1       (*(volatile __near unsigned short *)0x3B0)
#define GAFLML1L     (*(volatile __near unsigned char  *)0x3B0)
#define RMIDL1L      (*(volatile __near unsigned char  *)0x3B0)
#define GAFLML1H     (*(volatile __near unsigned char  *)0x3B1)
#define RMIDL1H      (*(volatile __near unsigned char  *)0x3B1)
#define GAFLMH1      (*(volatile __near unsigned short *)0x3B2)
#define RMIDH1       (*(volatile __near unsigned short *)0x3B2)
#define GAFLMH1L     (*(volatile __near unsigned char  *)0x3B2)
#define RMIDH1L      (*(volatile __near unsigned char  *)0x3B2)
#define GAFLMH1H     (*(volatile __near unsigned char  *)0x3B3)
#define RMIDH1H      (*(volatile __near unsigned char  *)0x3B3)
#define GAFLPL1      (*(volatile __near unsigned short *)0x3B4)
#define RMTS1        (*(volatile __near unsigned short *)0x3B4)
#define GAFLPL1L     (*(volatile __near unsigned char  *)0x3B4)
#define RMTS1L       (*(volatile __near unsigned char  *)0x3B4)
#define GAFLPL1H     (*(volatile __near unsigned char  *)0x3B5)
#define RMTS1H       (*(volatile __near unsigned char  *)0x3B5)
#define GAFLPH1      (*(volatile __near unsigned short *)0x3B6)
#define RMPTR1       (*(volatile __near unsigned short *)0x3B6)
#define GAFLPH1L     (*(volatile __near unsigned char  *)0x3B6)
#define RMPTR1L      (*(volatile __near unsigned char  *)0x3B6)
#define GAFLPH1H     (*(volatile __near unsigned char  *)0x3B7)
#define RMPTR1H      (*(volatile __near unsigned char  *)0x3B7)
#define GAFLIDL2     (*(volatile __near unsigned short *)0x3B8)
#define RMDF01       (*(volatile __near unsigned short *)0x3B8)
#define GAFLIDL2L    (*(volatile __near unsigned char  *)0x3B8)
#define RMDF01L      (*(volatile __near unsigned char  *)0x3B8)
#define GAFLIDL2H    (*(volatile __near unsigned char  *)0x3B9)
#define RMDF01H      (*(volatile __near unsigned char  *)0x3B9)
#define GAFLIDH2     (*(volatile __near unsigned short *)0x3BA)
#define RMDF11       (*(volatile __near unsigned short *)0x3BA)
#define GAFLIDH2L    (*(volatile __near unsigned char  *)0x3BA)
#define RMDF11L      (*(volatile __near unsigned char  *)0x3BA)
#define GAFLIDH2H    (*(volatile __near unsigned char  *)0x3BB)
#define RMDF11H      (*(volatile __near unsigned char  *)0x3BB)
#define GAFLML2      (*(volatile __near unsigned short *)0x3BC)
#define RMDF21       (*(volatile __near unsigned short *)0x3BC)
#define GAFLML2L     (*(volatile __near unsigned char  *)0x3BC)
#define RMDF21L      (*(volatile __near unsigned char  *)0x3BC)
#define GAFLML2H     (*(volatile __near unsigned char  *)0x3BD)
#define RMDF21H      (*(volatile __near unsigned char  *)0x3BD)
#define GAFLMH2      (*(volatile __near unsigned short *)0x3BE)
#define RMDF31       (*(volatile __near unsigned short *)0x3BE)
#define GAFLMH2L     (*(volatile __near unsigned char  *)0x3BE)
#define RMDF31L      (*(volatile __near unsigned char  *)0x3BE)
#define GAFLMH2H     (*(volatile __near unsigned char  *)0x3BF)
#define RMDF31H      (*(volatile __near unsigned char  *)0x3BF)
#define GAFLPL2      (*(volatile __near unsigned short *)0x3C0)
#define RMIDL2       (*(volatile __near unsigned short *)0x3C0)
#define GAFLPL2L     (*(volatile __near unsigned char  *)0x3C0)
#define RMIDL2L      (*(volatile __near unsigned char  *)0x3C0)
#define GAFLPL2H     (*(volatile __near unsigned char  *)0x3C1)
#define RMIDL2H      (*(volatile __near unsigned char  *)0x3C1)
#define GAFLPH2      (*(volatile __near unsigned short *)0x3C2)
#define RMIDH2       (*(volatile __near unsigned short *)0x3C2)
#define GAFLPH2L     (*(volatile __near unsigned char  *)0x3C2)
#define RMIDH2L      (*(volatile __near unsigned char  *)0x3C2)
#define GAFLPH2H     (*(volatile __near unsigned char  *)0x3C3)
#define RMIDH2H      (*(volatile __near unsigned char  *)0x3C3)
#define GAFLIDL3     (*(volatile __near unsigned short *)0x3C4)
#define RMTS2        (*(volatile __near unsigned short *)0x3C4)
#define GAFLIDL3L    (*(volatile __near unsigned char  *)0x3C4)
#define RMTS2L       (*(volatile __near unsigned char  *)0x3C4)
#define GAFLIDL3H    (*(volatile __near unsigned char  *)0x3C5)
#define RMTS2H       (*(volatile __near unsigned char  *)0x3C5)
#define GAFLIDH3     (*(volatile __near unsigned short *)0x3C6)
#define RMPTR2       (*(volatile __near unsigned short *)0x3C6)
#define GAFLIDH3L    (*(volatile __near unsigned char  *)0x3C6)
#define RMPTR2L      (*(volatile __near unsigned char  *)0x3C6)
#define GAFLIDH3H    (*(volatile __near unsigned char  *)0x3C7)
#define RMPTR2H      (*(volatile __near unsigned char  *)0x3C7)
#define GAFLML3      (*(volatile __near unsigned short *)0x3C8)
#define RMDF02       (*(volatile __near unsigned short *)0x3C8)
#define GAFLML3L     (*(volatile __near unsigned char  *)0x3C8)
#define RMDF02L      (*(volatile __near unsigned char  *)0x3C8)
#define GAFLML3H     (*(volatile __near unsigned char  *)0x3C9)
#define RMDF02H      (*(volatile __near unsigned char  *)0x3C9)
#define GAFLMH3      (*(volatile __near unsigned short *)0x3CA)
#define RMDF12       (*(volatile __near unsigned short *)0x3CA)
#define GAFLMH3L     (*(volatile __near unsigned char  *)0x3CA)
#define RMDF12L      (*(volatile __near unsigned char  *)0x3CA)
#define GAFLMH3H     (*(volatile __near unsigned char  *)0x3CB)
#define RMDF12H      (*(volatile __near unsigned char  *)0x3CB)
#define GAFLPL3      (*(volatile __near unsigned short *)0x3CC)
#define RMDF22       (*(volatile __near unsigned short *)0x3CC)
#define GAFLPL3L     (*(volatile __near unsigned char  *)0x3CC)
#define RMDF22L      (*(volatile __near unsigned char  *)0x3CC)
#define GAFLPL3H     (*(volatile __near unsigned char  *)0x3CD)
#define RMDF22H      (*(volatile __near unsigned char  *)0x3CD)
#define GAFLPH3      (*(volatile __near unsigned short *)0x3CE)
#define RMDF32       (*(volatile __near unsigned short *)0x3CE)
#define GAFLPH3L     (*(volatile __near unsigned char  *)0x3CE)
#define RMDF32L      (*(volatile __near unsigned char  *)0x3CE)
#define GAFLPH3H     (*(volatile __near unsigned char  *)0x3CF)
#define RMDF32H      (*(volatile __near unsigned char  *)0x3CF)
#define GAFLIDL4     (*(volatile __near unsigned short *)0x3D0)
#define RMIDL3       (*(volatile __near unsigned short *)0x3D0)
#define GAFLIDL4L    (*(volatile __near unsigned char  *)0x3D0)
#define RMIDL3L      (*(volatile __near unsigned char  *)0x3D0)
#define GAFLIDL4H    (*(volatile __near unsigned char  *)0x3D1)
#define RMIDL3H      (*(volatile __near unsigned char  *)0x3D1)
#define GAFLIDH4     (*(volatile __near unsigned short *)0x3D2)
#define RMIDH3       (*(volatile __near unsigned short *)0x3D2)
#define GAFLIDH4L    (*(volatile __near unsigned char  *)0x3D2)
#define RMIDH3L      (*(volatile __near unsigned char  *)0x3D2)
#define GAFLIDH4H    (*(volatile __near unsigned char  *)0x3D3)
#define RMIDH3H      (*(volatile __near unsigned char  *)0x3D3)
#define GAFLML4      (*(volatile __near unsigned short *)0x3D4)
#define RMTS3        (*(volatile __near unsigned short *)0x3D4)
#define GAFLML4L     (*(volatile __near unsigned char  *)0x3D4)
#define RMTS3L       (*(volatile __near unsigned char  *)0x3D4)
#define GAFLML4H     (*(volatile __near unsigned char  *)0x3D5)
#define RMTS3H       (*(volatile __near unsigned char  *)0x3D5)
#define GAFLMH4      (*(volatile __near unsigned short *)0x3D6)
#define RMPTR3       (*(volatile __near unsigned short *)0x3D6)
#define GAFLMH4L     (*(volatile __near unsigned char  *)0x3D6)
#define RMPTR3L      (*(volatile __near unsigned char  *)0x3D6)
#define GAFLMH4H     (*(volatile __near unsigned char  *)0x3D7)
#define RMPTR3H      (*(volatile __near unsigned char  *)0x3D7)
#define GAFLPL4      (*(volatile __near unsigned short *)0x3D8)
#define RMDF03       (*(volatile __near unsigned short *)0x3D8)
#define GAFLPL4L     (*(volatile __near unsigned char  *)0x3D8)
#define RMDF03L      (*(volatile __near unsigned char  *)0x3D8)
#define GAFLPL4H     (*(volatile __near unsigned char  *)0x3D9)
#define RMDF03H      (*(volatile __near unsigned char  *)0x3D9)
#define GAFLPH4      (*(volatile __near unsigned short *)0x3DA)
#define RMDF13       (*(volatile __near unsigned short *)0x3DA)
#define GAFLPH4L     (*(volatile __near unsigned char  *)0x3DA)
#define RMDF13L      (*(volatile __near unsigned char  *)0x3DA)
#define GAFLPH4H     (*(volatile __near unsigned char  *)0x3DB)
#define RMDF13H      (*(volatile __near unsigned char  *)0x3DB)
#define GAFLIDL5     (*(volatile __near unsigned short *)0x3DC)
#define RMDF23       (*(volatile __near unsigned short *)0x3DC)
#define GAFLIDL5L    (*(volatile __near unsigned char  *)0x3DC)
#define RMDF23L      (*(volatile __near unsigned char  *)0x3DC)
#define GAFLIDL5H    (*(volatile __near unsigned char  *)0x3DD)
#define RMDF23H      (*(volatile __near unsigned char  *)0x3DD)
#define GAFLIDH5     (*(volatile __near unsigned short *)0x3DE)
#define RMDF33       (*(volatile __near unsigned short *)0x3DE)
#define GAFLIDH5L    (*(volatile __near unsigned char  *)0x3DE)
#define RMDF33L      (*(volatile __near unsigned char  *)0x3DE)
#define GAFLIDH5H    (*(volatile __near unsigned char  *)0x3DF)
#define RMDF33H      (*(volatile __near unsigned char  *)0x3DF)
#define GAFLML5      (*(volatile __near unsigned short *)0x3E0)
#define RMIDL4       (*(volatile __near unsigned short *)0x3E0)
#define GAFLML5L     (*(volatile __near unsigned char  *)0x3E0)
#define RMIDL4L      (*(volatile __near unsigned char  *)0x3E0)
#define GAFLML5H     (*(volatile __near unsigned char  *)0x3E1)
#define RMIDL4H      (*(volatile __near unsigned char  *)0x3E1)
#define GAFLMH5      (*(volatile __near unsigned short *)0x3E2)
#define RMIDH4       (*(volatile __near unsigned short *)0x3E2)
#define GAFLMH5L     (*(volatile __near unsigned char  *)0x3E2)
#define RMIDH4L      (*(volatile __near unsigned char  *)0x3E2)
#define GAFLMH5H     (*(volatile __near unsigned char  *)0x3E3)
#define RMIDH4H      (*(volatile __near unsigned char  *)0x3E3)
#define GAFLPL5      (*(volatile __near unsigned short *)0x3E4)
#define RMTS4        (*(volatile __near unsigned short *)0x3E4)
#define GAFLPL5L     (*(volatile __near unsigned char  *)0x3E4)
#define RMTS4L       (*(volatile __near unsigned char  *)0x3E4)
#define GAFLPL5H     (*(volatile __near unsigned char  *)0x3E5)
#define RMTS4H       (*(volatile __near unsigned char  *)0x3E5)
#define GAFLPH5      (*(volatile __near unsigned short *)0x3E6)
#define RMPTR4       (*(volatile __near unsigned short *)0x3E6)
#define GAFLPH5L     (*(volatile __near unsigned char  *)0x3E6)
#define RMPTR4L      (*(volatile __near unsigned char  *)0x3E6)
#define GAFLPH5H     (*(volatile __near unsigned char  *)0x3E7)
#define RMPTR4H      (*(volatile __near unsigned char  *)0x3E7)
#define GAFLIDL6     (*(volatile __near unsigned short *)0x3E8)
#define RMDF04       (*(volatile __near unsigned short *)0x3E8)
#define GAFLIDL6L    (*(volatile __near unsigned char  *)0x3E8)
#define RMDF04L      (*(volatile __near unsigned char  *)0x3E8)
#define GAFLIDL6H    (*(volatile __near unsigned char  *)0x3E9)
#define RMDF04H      (*(volatile __near unsigned char  *)0x3E9)
#define GAFLIDH6     (*(volatile __near unsigned short *)0x3EA)
#define RMDF14       (*(volatile __near unsigned short *)0x3EA)
#define GAFLIDH6L    (*(volatile __near unsigned char  *)0x3EA)
#define RMDF14L      (*(volatile __near unsigned char  *)0x3EA)
#define GAFLIDH6H    (*(volatile __near unsigned char  *)0x3EB)
#define RMDF14H      (*(volatile __near unsigned char  *)0x3EB)
#define GAFLML6      (*(volatile __near unsigned short *)0x3EC)
#define RMDF24       (*(volatile __near unsigned short *)0x3EC)
#define GAFLML6L     (*(volatile __near unsigned char  *)0x3EC)
#define RMDF24L      (*(volatile __near unsigned char  *)0x3EC)
#define GAFLML6H     (*(volatile __near unsigned char  *)0x3ED)
#define RMDF24H      (*(volatile __near unsigned char  *)0x3ED)
#define GAFLMH6      (*(volatile __near unsigned short *)0x3EE)
#define RMDF34       (*(volatile __near unsigned short *)0x3EE)
#define GAFLMH6L     (*(volatile __near unsigned char  *)0x3EE)
#define RMDF34L      (*(volatile __near unsigned char  *)0x3EE)
#define GAFLMH6H     (*(volatile __near unsigned char  *)0x3EF)
#define RMDF34H      (*(volatile __near unsigned char  *)0x3EF)
#define GAFLPL6      (*(volatile __near unsigned short *)0x3F0)
#define RMIDL5       (*(volatile __near unsigned short *)0x3F0)
#define GAFLPL6L     (*(volatile __near unsigned char  *)0x3F0)
#define RMIDL5L      (*(volatile __near unsigned char  *)0x3F0)
#define GAFLPL6H     (*(volatile __near unsigned char  *)0x3F1)
#define RMIDL5H      (*(volatile __near unsigned char  *)0x3F1)
#define GAFLPH6      (*(volatile __near unsigned short *)0x3F2)
#define RMIDH5       (*(volatile __near unsigned short *)0x3F2)
#define GAFLPH6L     (*(volatile __near unsigned char  *)0x3F2)
#define RMIDH5L      (*(volatile __near unsigned char  *)0x3F2)
#define GAFLPH6H     (*(volatile __near unsigned char  *)0x3F3)
#define RMIDH5H      (*(volatile __near unsigned char  *)0x3F3)
#define GAFLIDL7     (*(volatile __near unsigned short *)0x3F4)
#define RMTS5        (*(volatile __near unsigned short *)0x3F4)
#define GAFLIDL7L    (*(volatile __near unsigned char  *)0x3F4)
#define RMTS5L       (*(volatile __near unsigned char  *)0x3F4)
#define GAFLIDL7H    (*(volatile __near unsigned char  *)0x3F5)
#define RMTS5H       (*(volatile __near unsigned char  *)0x3F5)
#define GAFLIDH7     (*(volatile __near unsigned short *)0x3F6)
#define RMPTR5       (*(volatile __near unsigned short *)0x3F6)
#define GAFLIDH7L    (*(volatile __near unsigned char  *)0x3F6)
#define RMPTR5L      (*(volatile __near unsigned char  *)0x3F6)
#define GAFLIDH7H    (*(volatile __near unsigned char  *)0x3F7)
#define RMPTR5H      (*(volatile __near unsigned char  *)0x3F7)
#define GAFLML7      (*(volatile __near unsigned short *)0x3F8)
#define RMDF05       (*(volatile __near unsigned short *)0x3F8)
#define GAFLML7L     (*(volatile __near unsigned char  *)0x3F8)
#define RMDF05L      (*(volatile __near unsigned char  *)0x3F8)
#define GAFLML7H     (*(volatile __near unsigned char  *)0x3F9)
#define RMDF05H      (*(volatile __near unsigned char  *)0x3F9)
#define GAFLMH7      (*(volatile __near unsigned short *)0x3FA)
#define RMDF15       (*(volatile __near unsigned short *)0x3FA)
#define GAFLMH7L     (*(volatile __near unsigned char  *)0x3FA)
#define RMDF15L      (*(volatile __near unsigned char  *)0x3FA)
#define GAFLMH7H     (*(volatile __near unsigned char  *)0x3FB)
#define RMDF15H      (*(volatile __near unsigned char  *)0x3FB)
#define GAFLPL7      (*(volatile __near unsigned short *)0x3FC)
#define RMDF25       (*(volatile __near unsigned short *)0x3FC)
#define GAFLPL7L     (*(volatile __near unsigned char  *)0x3FC)
#define RMDF25L      (*(volatile __near unsigned char  *)0x3FC)
#define GAFLPL7H     (*(volatile __near unsigned char  *)0x3FD)
#define RMDF25H      (*(volatile __near unsigned char  *)0x3FD)
#define GAFLPH7      (*(volatile __near unsigned short *)0x3FE)
#define RMDF35       (*(volatile __near unsigned short *)0x3FE)
#define GAFLPH7L     (*(volatile __near unsigned char  *)0x3FE)
#define RMDF35L      (*(volatile __near unsigned char  *)0x3FE)
#define GAFLPH7H     (*(volatile __near unsigned char  *)0x3FF)
#define RMDF35H      (*(volatile __near unsigned char  *)0x3FF)
#define GAFLIDL8     (*(volatile __near unsigned short *)0x400)
#define RMIDL6       (*(volatile __near unsigned short *)0x400)
#define GAFLIDL8L    (*(volatile __near unsigned char  *)0x400)
#define RMIDL6L      (*(volatile __near unsigned char  *)0x400)
#define GAFLIDL8H    (*(volatile __near unsigned char  *)0x401)
#define RMIDL6H      (*(volatile __near unsigned char  *)0x401)
#define GAFLIDH8     (*(volatile __near unsigned short *)0x402)
#define RMIDH6       (*(volatile __near unsigned short *)0x402)
#define GAFLIDH8L    (*(volatile __near unsigned char  *)0x402)
#define RMIDH6L      (*(volatile __near unsigned char  *)0x402)
#define GAFLIDH8H    (*(volatile __near unsigned char  *)0x403)
#define RMIDH6H      (*(volatile __near unsigned char  *)0x403)
#define GAFLML8      (*(volatile __near unsigned short *)0x404)
#define RMTS6        (*(volatile __near unsigned short *)0x404)
#define GAFLML8L     (*(volatile __near unsigned char  *)0x404)
#define RMTS6L       (*(volatile __near unsigned char  *)0x404)
#define GAFLML8H     (*(volatile __near unsigned char  *)0x405)
#define RMTS6H       (*(volatile __near unsigned char  *)0x405)
#define GAFLMH8      (*(volatile __near unsigned short *)0x406)
#define RMPTR6       (*(volatile __near unsigned short *)0x406)
#define GAFLMH8L     (*(volatile __near unsigned char  *)0x406)
#define RMPTR6L      (*(volatile __near unsigned char  *)0x406)
#define GAFLMH8H     (*(volatile __near unsigned char  *)0x407)
#define RMPTR6H      (*(volatile __near unsigned char  *)0x407)
#define GAFLPL8      (*(volatile __near unsigned short *)0x408)
#define RMDF06       (*(volatile __near unsigned short *)0x408)
#define GAFLPL8L     (*(volatile __near unsigned char  *)0x408)
#define RMDF06L      (*(volatile __near unsigned char  *)0x408)
#define GAFLPL8H     (*(volatile __near unsigned char  *)0x409)
#define RMDF06H      (*(volatile __near unsigned char  *)0x409)
#define GAFLPH8      (*(volatile __near unsigned short *)0x40A)
#define RMDF16       (*(volatile __near unsigned short *)0x40A)
#define GAFLPH8L     (*(volatile __near unsigned char  *)0x40A)
#define RMDF16L      (*(volatile __near unsigned char  *)0x40A)
#define GAFLPH8H     (*(volatile __near unsigned char  *)0x40B)
#define RMDF16H      (*(volatile __near unsigned char  *)0x40B)
#define GAFLIDL9     (*(volatile __near unsigned short *)0x40C)
#define RMDF26       (*(volatile __near unsigned short *)0x40C)
#define GAFLIDL9L    (*(volatile __near unsigned char  *)0x40C)
#define RMDF26L      (*(volatile __near unsigned char  *)0x40C)
#define GAFLIDL9H    (*(volatile __near unsigned char  *)0x40D)
#define RMDF26H      (*(volatile __near unsigned char  *)0x40D)
#define GAFLIDH9     (*(volatile __near unsigned short *)0x40E)
#define RMDF36       (*(volatile __near unsigned short *)0x40E)
#define GAFLIDH9L    (*(volatile __near unsigned char  *)0x40E)
#define RMDF36L      (*(volatile __near unsigned char  *)0x40E)
#define GAFLIDH9H    (*(volatile __near unsigned char  *)0x40F)
#define RMDF36H      (*(volatile __near unsigned char  *)0x40F)
#define GAFLML9      (*(volatile __near unsigned short *)0x410)
#define RMIDL7       (*(volatile __near unsigned short *)0x410)
#define GAFLML9L     (*(volatile __near unsigned char  *)0x410)
#define RMIDL7L      (*(volatile __near unsigned char  *)0x410)
#define GAFLML9H     (*(volatile __near unsigned char  *)0x411)
#define RMIDL7H      (*(volatile __near unsigned char  *)0x411)
#define GAFLMH9      (*(volatile __near unsigned short *)0x412)
#define RMIDH7       (*(volatile __near unsigned short *)0x412)
#define GAFLMH9L     (*(volatile __near unsigned char  *)0x412)
#define RMIDH7L      (*(volatile __near unsigned char  *)0x412)
#define GAFLMH9H     (*(volatile __near unsigned char  *)0x413)
#define RMIDH7H      (*(volatile __near unsigned char  *)0x413)
#define GAFLPL9      (*(volatile __near unsigned short *)0x414)
#define RMTS7        (*(volatile __near unsigned short *)0x414)
#define GAFLPL9L     (*(volatile __near unsigned char  *)0x414)
#define RMTS7L       (*(volatile __near unsigned char  *)0x414)
#define GAFLPL9H     (*(volatile __near unsigned char  *)0x415)
#define RMTS7H       (*(volatile __near unsigned char  *)0x415)
#define GAFLPH9      (*(volatile __near unsigned short *)0x416)
#define RMPTR7       (*(volatile __near unsigned short *)0x416)
#define GAFLPH9L     (*(volatile __near unsigned char  *)0x416)
#define RMPTR7L      (*(volatile __near unsigned char  *)0x416)
#define GAFLPH9H     (*(volatile __near unsigned char  *)0x417)
#define RMPTR7H      (*(volatile __near unsigned char  *)0x417)
#define GAFLIDL10    (*(volatile __near unsigned short *)0x418)
#define RMDF07       (*(volatile __near unsigned short *)0x418)
#define GAFLIDL10L   (*(volatile __near unsigned char  *)0x418)
#define RMDF07L      (*(volatile __near unsigned char  *)0x418)
#define GAFLIDL10H   (*(volatile __near unsigned char  *)0x419)
#define RMDF07H      (*(volatile __near unsigned char  *)0x419)
#define GAFLIDH10    (*(volatile __near unsigned short *)0x41A)
#define RMDF17       (*(volatile __near unsigned short *)0x41A)
#define GAFLIDH10L   (*(volatile __near unsigned char  *)0x41A)
#define RMDF17L      (*(volatile __near unsigned char  *)0x41A)
#define GAFLIDH10H   (*(volatile __near unsigned char  *)0x41B)
#define RMDF17H      (*(volatile __near unsigned char  *)0x41B)
#define GAFLML10     (*(volatile __near unsigned short *)0x41C)
#define RMDF27       (*(volatile __near unsigned short *)0x41C)
#define GAFLML10L    (*(volatile __near unsigned char  *)0x41C)
#define RMDF27L      (*(volatile __near unsigned char  *)0x41C)
#define GAFLML10H    (*(volatile __near unsigned char  *)0x41D)
#define RMDF27H      (*(volatile __near unsigned char  *)0x41D)
#define GAFLMH10     (*(volatile __near unsigned short *)0x41E)
#define RMDF37       (*(volatile __near unsigned short *)0x41E)
#define GAFLMH10L    (*(volatile __near unsigned char  *)0x41E)
#define RMDF37L      (*(volatile __near unsigned char  *)0x41E)
#define GAFLMH10H    (*(volatile __near unsigned char  *)0x41F)
#define RMDF37H      (*(volatile __near unsigned char  *)0x41F)
#define GAFLPL10     (*(volatile __near unsigned short *)0x420)
#define RMIDL8       (*(volatile __near unsigned short *)0x420)
#define GAFLPL10L    (*(volatile __near unsigned char  *)0x420)
#define RMIDL8L      (*(volatile __near unsigned char  *)0x420)
#define GAFLPL10H    (*(volatile __near unsigned char  *)0x421)
#define RMIDL8H      (*(volatile __near unsigned char  *)0x421)
#define GAFLPH10     (*(volatile __near unsigned short *)0x422)
#define RMIDH8       (*(volatile __near unsigned short *)0x422)
#define GAFLPH10L    (*(volatile __near unsigned char  *)0x422)
#define RMIDH8L      (*(volatile __near unsigned char  *)0x422)
#define GAFLPH10H    (*(volatile __near unsigned char  *)0x423)
#define RMIDH8H      (*(volatile __near unsigned char  *)0x423)
#define GAFLIDL11    (*(volatile __near unsigned short *)0x424)
#define RMTS8        (*(volatile __near unsigned short *)0x424)
#define GAFLIDL11L   (*(volatile __near unsigned char  *)0x424)
#define RMTS8L       (*(volatile __near unsigned char  *)0x424)
#define GAFLIDL11H   (*(volatile __near unsigned char  *)0x425)
#define RMTS8H       (*(volatile __near unsigned char  *)0x425)
#define GAFLIDH11    (*(volatile __near unsigned short *)0x426)
#define RMPTR8       (*(volatile __near unsigned short *)0x426)
#define GAFLIDH11L   (*(volatile __near unsigned char  *)0x426)
#define RMPTR8L      (*(volatile __near unsigned char  *)0x426)
#define GAFLIDH11H   (*(volatile __near unsigned char  *)0x427)
#define RMPTR8H      (*(volatile __near unsigned char  *)0x427)
#define GAFLML11     (*(volatile __near unsigned short *)0x428)
#define RMDF08       (*(volatile __near unsigned short *)0x428)
#define GAFLML11L    (*(volatile __near unsigned char  *)0x428)
#define RMDF08L      (*(volatile __near unsigned char  *)0x428)
#define GAFLML11H    (*(volatile __near unsigned char  *)0x429)
#define RMDF08H      (*(volatile __near unsigned char  *)0x429)
#define GAFLMH11     (*(volatile __near unsigned short *)0x42A)
#define RMDF18       (*(volatile __near unsigned short *)0x42A)
#define GAFLMH11L    (*(volatile __near unsigned char  *)0x42A)
#define RMDF18L      (*(volatile __near unsigned char  *)0x42A)
#define GAFLMH11H    (*(volatile __near unsigned char  *)0x42B)
#define RMDF18H      (*(volatile __near unsigned char  *)0x42B)
#define GAFLPL11     (*(volatile __near unsigned short *)0x42C)
#define RMDF28       (*(volatile __near unsigned short *)0x42C)
#define GAFLPL11L    (*(volatile __near unsigned char  *)0x42C)
#define RMDF28L      (*(volatile __near unsigned char  *)0x42C)
#define GAFLPL11H    (*(volatile __near unsigned char  *)0x42D)
#define RMDF28H      (*(volatile __near unsigned char  *)0x42D)
#define GAFLPH11     (*(volatile __near unsigned short *)0x42E)
#define RMDF38       (*(volatile __near unsigned short *)0x42E)
#define GAFLPH11L    (*(volatile __near unsigned char  *)0x42E)
#define RMDF38L      (*(volatile __near unsigned char  *)0x42E)
#define GAFLPH11H    (*(volatile __near unsigned char  *)0x42F)
#define RMDF38H      (*(volatile __near unsigned char  *)0x42F)
#define GAFLIDL12    (*(volatile __near unsigned short *)0x430)
#define RMIDL9       (*(volatile __near unsigned short *)0x430)
#define GAFLIDL12L   (*(volatile __near unsigned char  *)0x430)
#define RMIDL9L      (*(volatile __near unsigned char  *)0x430)
#define GAFLIDL12H   (*(volatile __near unsigned char  *)0x431)
#define RMIDL9H      (*(volatile __near unsigned char  *)0x431)
#define GAFLIDH12    (*(volatile __near unsigned short *)0x432)
#define RMIDH9       (*(volatile __near unsigned short *)0x432)
#define GAFLIDH12L   (*(volatile __near unsigned char  *)0x432)
#define RMIDH9L      (*(volatile __near unsigned char  *)0x432)
#define GAFLIDH12H   (*(volatile __near unsigned char  *)0x433)
#define RMIDH9H      (*(volatile __near unsigned char  *)0x433)
#define GAFLML12     (*(volatile __near unsigned short *)0x434)
#define RMTS9        (*(volatile __near unsigned short *)0x434)
#define GAFLML12L    (*(volatile __near unsigned char  *)0x434)
#define RMTS9L       (*(volatile __near unsigned char  *)0x434)
#define GAFLML12H    (*(volatile __near unsigned char  *)0x435)
#define RMTS9H       (*(volatile __near unsigned char  *)0x435)
#define GAFLMH12     (*(volatile __near unsigned short *)0x436)
#define RMPTR9       (*(volatile __near unsigned short *)0x436)
#define GAFLMH12L    (*(volatile __near unsigned char  *)0x436)
#define RMPTR9L      (*(volatile __near unsigned char  *)0x436)
#define GAFLMH12H    (*(volatile __near unsigned char  *)0x437)
#define RMPTR9H      (*(volatile __near unsigned char  *)0x437)
#define GAFLPL12     (*(volatile __near unsigned short *)0x438)
#define RMDF09       (*(volatile __near unsigned short *)0x438)
#define GAFLPL12L    (*(volatile __near unsigned char  *)0x438)
#define RMDF09L      (*(volatile __near unsigned char  *)0x438)
#define GAFLPL12H    (*(volatile __near unsigned char  *)0x439)
#define RMDF09H      (*(volatile __near unsigned char  *)0x439)
#define GAFLPH12     (*(volatile __near unsigned short *)0x43A)
#define RMDF19       (*(volatile __near unsigned short *)0x43A)
#define GAFLPH12L    (*(volatile __near unsigned char  *)0x43A)
#define RMDF19L      (*(volatile __near unsigned char  *)0x43A)
#define GAFLPH12H    (*(volatile __near unsigned char  *)0x43B)
#define RMDF19H      (*(volatile __near unsigned char  *)0x43B)
#define GAFLIDL13    (*(volatile __near unsigned short *)0x43C)
#define RMDF29       (*(volatile __near unsigned short *)0x43C)
#define GAFLIDL13L   (*(volatile __near unsigned char  *)0x43C)
#define RMDF29L      (*(volatile __near unsigned char  *)0x43C)
#define GAFLIDL13H   (*(volatile __near unsigned char  *)0x43D)
#define RMDF29H      (*(volatile __near unsigned char  *)0x43D)
#define GAFLIDH13    (*(volatile __near unsigned short *)0x43E)
#define RMDF39       (*(volatile __near unsigned short *)0x43E)
#define GAFLIDH13L   (*(volatile __near unsigned char  *)0x43E)
#define RMDF39L      (*(volatile __near unsigned char  *)0x43E)
#define GAFLIDH13H   (*(volatile __near unsigned char  *)0x43F)
#define RMDF39H      (*(volatile __near unsigned char  *)0x43F)
#define GAFLML13     (*(volatile __near unsigned short *)0x440)
#define RMIDL10      (*(volatile __near unsigned short *)0x440)
#define GAFLML13L    (*(volatile __near unsigned char  *)0x440)
#define RMIDL10L     (*(volatile __near unsigned char  *)0x440)
#define GAFLML13H    (*(volatile __near unsigned char  *)0x441)
#define RMIDL10H     (*(volatile __near unsigned char  *)0x441)
#define GAFLMH13     (*(volatile __near unsigned short *)0x442)
#define RMIDH10      (*(volatile __near unsigned short *)0x442)
#define GAFLMH13L    (*(volatile __near unsigned char  *)0x442)
#define RMIDH10L     (*(volatile __near unsigned char  *)0x442)
#define GAFLMH13H    (*(volatile __near unsigned char  *)0x443)
#define RMIDH10H     (*(volatile __near unsigned char  *)0x443)
#define GAFLPL13     (*(volatile __near unsigned short *)0x444)
#define RMTS10       (*(volatile __near unsigned short *)0x444)
#define GAFLPL13L    (*(volatile __near unsigned char  *)0x444)
#define RMTS10L      (*(volatile __near unsigned char  *)0x444)
#define GAFLPL13H    (*(volatile __near unsigned char  *)0x445)
#define RMTS10H      (*(volatile __near unsigned char  *)0x445)
#define GAFLPH13     (*(volatile __near unsigned short *)0x446)
#define RMPTR10      (*(volatile __near unsigned short *)0x446)
#define GAFLPH13L    (*(volatile __near unsigned char  *)0x446)
#define RMPTR10L     (*(volatile __near unsigned char  *)0x446)
#define GAFLPH13H    (*(volatile __near unsigned char  *)0x447)
#define RMPTR10H     (*(volatile __near unsigned char  *)0x447)
#define GAFLIDL14    (*(volatile __near unsigned short *)0x448)
#define RMDF010      (*(volatile __near unsigned short *)0x448)
#define GAFLIDL14L   (*(volatile __near unsigned char  *)0x448)
#define RMDF010L     (*(volatile __near unsigned char  *)0x448)
#define GAFLIDL14H   (*(volatile __near unsigned char  *)0x449)
#define RMDF010H     (*(volatile __near unsigned char  *)0x449)
#define GAFLIDH14    (*(volatile __near unsigned short *)0x44A)
#define RMDF110      (*(volatile __near unsigned short *)0x44A)
#define GAFLIDH14L   (*(volatile __near unsigned char  *)0x44A)
#define RMDF110L     (*(volatile __near unsigned char  *)0x44A)
#define GAFLIDH14H   (*(volatile __near unsigned char  *)0x44B)
#define RMDF110H     (*(volatile __near unsigned char  *)0x44B)
#define GAFLML14     (*(volatile __near unsigned short *)0x44C)
#define RMDF210      (*(volatile __near unsigned short *)0x44C)
#define GAFLML14L    (*(volatile __near unsigned char  *)0x44C)
#define RMDF210L     (*(volatile __near unsigned char  *)0x44C)
#define GAFLML14H    (*(volatile __near unsigned char  *)0x44D)
#define RMDF210H     (*(volatile __near unsigned char  *)0x44D)
#define GAFLMH14     (*(volatile __near unsigned short *)0x44E)
#define RMDF310      (*(volatile __near unsigned short *)0x44E)
#define GAFLMH14L    (*(volatile __near unsigned char  *)0x44E)
#define RMDF310L     (*(volatile __near unsigned char  *)0x44E)
#define GAFLMH14H    (*(volatile __near unsigned char  *)0x44F)
#define RMDF310H     (*(volatile __near unsigned char  *)0x44F)
#define GAFLPL14     (*(volatile __near unsigned short *)0x450)
#define RMIDL11      (*(volatile __near unsigned short *)0x450)
#define GAFLPL14L    (*(volatile __near unsigned char  *)0x450)
#define RMIDL11L     (*(volatile __near unsigned char  *)0x450)
#define GAFLPL14H    (*(volatile __near unsigned char  *)0x451)
#define RMIDL11H     (*(volatile __near unsigned char  *)0x451)
#define GAFLPH14     (*(volatile __near unsigned short *)0x452)
#define RMIDH11      (*(volatile __near unsigned short *)0x452)
#define GAFLPH14L    (*(volatile __near unsigned char  *)0x452)
#define RMIDH11L     (*(volatile __near unsigned char  *)0x452)
#define GAFLPH14H    (*(volatile __near unsigned char  *)0x453)
#define RMIDH11H     (*(volatile __near unsigned char  *)0x453)
#define GAFLIDL15    (*(volatile __near unsigned short *)0x454)
#define RMTS11       (*(volatile __near unsigned short *)0x454)
#define GAFLIDL15L   (*(volatile __near unsigned char  *)0x454)
#define RMTS11L      (*(volatile __near unsigned char  *)0x454)
#define GAFLIDL15H   (*(volatile __near unsigned char  *)0x455)
#define RMTS11H      (*(volatile __near unsigned char  *)0x455)
#define GAFLIDH15    (*(volatile __near unsigned short *)0x456)
#define RMPTR11      (*(volatile __near unsigned short *)0x456)
#define GAFLIDH15L   (*(volatile __near unsigned char  *)0x456)
#define RMPTR11L     (*(volatile __near unsigned char  *)0x456)
#define GAFLIDH15H   (*(volatile __near unsigned char  *)0x457)
#define RMPTR11H     (*(volatile __near unsigned char  *)0x457)
#define GAFLML15     (*(volatile __near unsigned short *)0x458)
#define RMDF011      (*(volatile __near unsigned short *)0x458)
#define GAFLML15L    (*(volatile __near unsigned char  *)0x458)
#define RMDF011L     (*(volatile __near unsigned char  *)0x458)
#define GAFLML15H    (*(volatile __near unsigned char  *)0x459)
#define RMDF011H     (*(volatile __near unsigned char  *)0x459)
#define GAFLMH15     (*(volatile __near unsigned short *)0x45A)
#define RMDF111      (*(volatile __near unsigned short *)0x45A)
#define GAFLMH15L    (*(volatile __near unsigned char  *)0x45A)
#define RMDF111L     (*(volatile __near unsigned char  *)0x45A)
#define GAFLMH15H    (*(volatile __near unsigned char  *)0x45B)
#define RMDF111H     (*(volatile __near unsigned char  *)0x45B)
#define GAFLPL15     (*(volatile __near unsigned short *)0x45C)
#define RMDF211      (*(volatile __near unsigned short *)0x45C)
#define GAFLPL15L    (*(volatile __near unsigned char  *)0x45C)
#define RMDF211L     (*(volatile __near unsigned char  *)0x45C)
#define GAFLPL15H    (*(volatile __near unsigned char  *)0x45D)
#define RMDF211H     (*(volatile __near unsigned char  *)0x45D)
#define GAFLPH15     (*(volatile __near unsigned short *)0x45E)
#define RMDF311      (*(volatile __near unsigned short *)0x45E)
#define GAFLPH15L    (*(volatile __near unsigned char  *)0x45E)
#define RMDF311L     (*(volatile __near unsigned char  *)0x45E)
#define GAFLPH15H    (*(volatile __near unsigned char  *)0x45F)
#define RMDF311H     (*(volatile __near unsigned char  *)0x45F)
#define RMIDL12      (*(volatile __near unsigned short *)0x460)
#define RMIDL12L     (*(volatile __near unsigned char  *)0x460)
#define RMIDL12H     (*(volatile __near unsigned char  *)0x461)
#define RMIDH12      (*(volatile __near unsigned short *)0x462)
#define RMIDH12L     (*(volatile __near unsigned char  *)0x462)
#define RMIDH12H     (*(volatile __near unsigned char  *)0x463)
#define RMTS12       (*(volatile __near unsigned short *)0x464)
#define RMTS12L      (*(volatile __near unsigned char  *)0x464)
#define RMTS12H      (*(volatile __near unsigned char  *)0x465)
#define RMPTR12      (*(volatile __near unsigned short *)0x466)
#define RMPTR12L     (*(volatile __near unsigned char  *)0x466)
#define RMPTR12H     (*(volatile __near unsigned char  *)0x467)
#define RMDF012      (*(volatile __near unsigned short *)0x468)
#define RMDF012L     (*(volatile __near unsigned char  *)0x468)
#define RMDF012H     (*(volatile __near unsigned char  *)0x469)
#define RMDF112      (*(volatile __near unsigned short *)0x46A)
#define RMDF112L     (*(volatile __near unsigned char  *)0x46A)
#define RMDF112H     (*(volatile __near unsigned char  *)0x46B)
#define RMDF212      (*(volatile __near unsigned short *)0x46C)
#define RMDF212L     (*(volatile __near unsigned char  *)0x46C)
#define RMDF212H     (*(volatile __near unsigned char  *)0x46D)
#define RMDF312      (*(volatile __near unsigned short *)0x46E)
#define RMDF312L     (*(volatile __near unsigned char  *)0x46E)
#define RMDF312H     (*(volatile __near unsigned char  *)0x46F)
#define RMIDL13      (*(volatile __near unsigned short *)0x470)
#define RMIDL13L     (*(volatile __near unsigned char  *)0x470)
#define RMIDL13H     (*(volatile __near unsigned char  *)0x471)
#define RMIDH13      (*(volatile __near unsigned short *)0x472)
#define RMIDH13L     (*(volatile __near unsigned char  *)0x472)
#define RMIDH13H     (*(volatile __near unsigned char  *)0x473)
#define RMTS13       (*(volatile __near unsigned short *)0x474)
#define RMTS13L      (*(volatile __near unsigned char  *)0x474)
#define RMTS13H      (*(volatile __near unsigned char  *)0x475)
#define RMPTR13      (*(volatile __near unsigned short *)0x476)
#define RMPTR13L     (*(volatile __near unsigned char  *)0x476)
#define RMPTR13H     (*(volatile __near unsigned char  *)0x477)
#define RMDF013      (*(volatile __near unsigned short *)0x478)
#define RMDF013L     (*(volatile __near unsigned char  *)0x478)
#define RMDF013H     (*(volatile __near unsigned char  *)0x479)
#define RMDF113      (*(volatile __near unsigned short *)0x47A)
#define RMDF113L     (*(volatile __near unsigned char  *)0x47A)
#define RMDF113H     (*(volatile __near unsigned char  *)0x47B)
#define RMDF213      (*(volatile __near unsigned short *)0x47C)
#define RMDF213L     (*(volatile __near unsigned char  *)0x47C)
#define RMDF213H     (*(volatile __near unsigned char  *)0x47D)
#define RMDF313      (*(volatile __near unsigned short *)0x47E)
#define RMDF313L     (*(volatile __near unsigned char  *)0x47E)
#define RMDF313H     (*(volatile __near unsigned char  *)0x47F)
#define RMIDL14      (*(volatile __near unsigned short *)0x480)
#define RMIDL14L     (*(volatile __near unsigned char  *)0x480)
#define RMIDL14H     (*(volatile __near unsigned char  *)0x481)
#define RMIDH14      (*(volatile __near unsigned short *)0x482)
#define RMIDH14L     (*(volatile __near unsigned char  *)0x482)
#define RMIDH14H     (*(volatile __near unsigned char  *)0x483)
#define RMTS14       (*(volatile __near unsigned short *)0x484)
#define RMTS14L      (*(volatile __near unsigned char  *)0x484)
#define RMTS14H      (*(volatile __near unsigned char  *)0x485)
#define RMPTR14      (*(volatile __near unsigned short *)0x486)
#define RMPTR14L     (*(volatile __near unsigned char  *)0x486)
#define RMPTR14H     (*(volatile __near unsigned char  *)0x487)
#define RMDF014      (*(volatile __near unsigned short *)0x488)
#define RMDF014L     (*(volatile __near unsigned char  *)0x488)
#define RMDF014H     (*(volatile __near unsigned char  *)0x489)
#define RMDF114      (*(volatile __near unsigned short *)0x48A)
#define RMDF114L     (*(volatile __near unsigned char  *)0x48A)
#define RMDF114H     (*(volatile __near unsigned char  *)0x48B)
#define RMDF214      (*(volatile __near unsigned short *)0x48C)
#define RMDF214L     (*(volatile __near unsigned char  *)0x48C)
#define RMDF214H     (*(volatile __near unsigned char  *)0x48D)
#define RMDF314      (*(volatile __near unsigned short *)0x48E)
#define RMDF314L     (*(volatile __near unsigned char  *)0x48E)
#define RMDF314H     (*(volatile __near unsigned char  *)0x48F)
#define RMIDL15      (*(volatile __near unsigned short *)0x490)
#define RMIDL15L     (*(volatile __near unsigned char  *)0x490)
#define RMIDL15H     (*(volatile __near unsigned char  *)0x491)
#define RMIDH15      (*(volatile __near unsigned short *)0x492)
#define RMIDH15L     (*(volatile __near unsigned char  *)0x492)
#define RMIDH15H     (*(volatile __near unsigned char  *)0x493)
#define RMTS15       (*(volatile __near unsigned short *)0x494)
#define RMTS15L      (*(volatile __near unsigned char  *)0x494)
#define RMTS15H      (*(volatile __near unsigned char  *)0x495)
#define RMPTR15      (*(volatile __near unsigned short *)0x496)
#define RMPTR15L     (*(volatile __near unsigned char  *)0x496)
#define RMPTR15H     (*(volatile __near unsigned char  *)0x497)
#define RMDF015      (*(volatile __near unsigned short *)0x498)
#define RMDF015L     (*(volatile __near unsigned char  *)0x498)
#define RMDF015H     (*(volatile __near unsigned char  *)0x499)
#define RMDF115      (*(volatile __near unsigned short *)0x49A)
#define RMDF115L     (*(volatile __near unsigned char  *)0x49A)
#define RMDF115H     (*(volatile __near unsigned char  *)0x49B)
#define RMDF215      (*(volatile __near unsigned short *)0x49C)
#define RMDF215L     (*(volatile __near unsigned char  *)0x49C)
#define RMDF215H     (*(volatile __near unsigned char  *)0x49D)
#define RMDF315      (*(volatile __near unsigned short *)0x49E)
#define RMDF315L     (*(volatile __near unsigned char  *)0x49E)
#define RMDF315H     (*(volatile __near unsigned char  *)0x49F)
#define RPGACC0      (*(volatile __near unsigned short *)0x580)
#define RPGACC0L     (*(volatile __near unsigned char  *)0x580)
#define RPGACC0H     (*(volatile __near unsigned char  *)0x581)
#define RPGACC1      (*(volatile __near unsigned short *)0x582)
#define RPGACC1L     (*(volatile __near unsigned char  *)0x582)
#define RPGACC1H     (*(volatile __near unsigned char  *)0x583)
#define RPGACC2      (*(volatile __near unsigned short *)0x584)
#define RPGACC2L     (*(volatile __near unsigned char  *)0x584)
#define RPGACC2H     (*(volatile __near unsigned char  *)0x585)
#define RPGACC3      (*(volatile __near unsigned short *)0x586)
#define RPGACC3L     (*(volatile __near unsigned char  *)0x586)
#define RPGACC3H     (*(volatile __near unsigned char  *)0x587)
#define RPGACC4      (*(volatile __near unsigned short *)0x588)
#define RPGACC4L     (*(volatile __near unsigned char  *)0x588)
#define RPGACC4H     (*(volatile __near unsigned char  *)0x589)
#define RPGACC5      (*(volatile __near unsigned short *)0x58A)
#define RPGACC5L     (*(volatile __near unsigned char  *)0x58A)
#define RPGACC5H     (*(volatile __near unsigned char  *)0x58B)
#define RPGACC6      (*(volatile __near unsigned short *)0x58C)
#define RPGACC6L     (*(volatile __near unsigned char  *)0x58C)
#define RPGACC6H     (*(volatile __near unsigned char  *)0x58D)
#define RPGACC7      (*(volatile __near unsigned short *)0x58E)
#define RPGACC7L     (*(volatile __near unsigned char  *)0x58E)
#define RPGACC7H     (*(volatile __near unsigned char  *)0x58F)
#define RPGACC8      (*(volatile __near unsigned short *)0x590)
#define RPGACC8L     (*(volatile __near unsigned char  *)0x590)
#define RPGACC8H     (*(volatile __near unsigned char  *)0x591)
#define RPGACC9      (*(volatile __near unsigned short *)0x592)
#define RPGACC9L     (*(volatile __near unsigned char  *)0x592)
#define RPGACC9H     (*(volatile __near unsigned char  *)0x593)
#define RPGACC10     (*(volatile __near unsigned short *)0x594)
#define RPGACC10L    (*(volatile __near unsigned char  *)0x594)
#define RPGACC10H    (*(volatile __near unsigned char  *)0x595)
#define RPGACC11     (*(volatile __near unsigned short *)0x596)
#define RPGACC11L    (*(volatile __near unsigned char  *)0x596)
#define RPGACC11H    (*(volatile __near unsigned char  *)0x597)
#define RPGACC12     (*(volatile __near unsigned short *)0x598)
#define RPGACC12L    (*(volatile __near unsigned char  *)0x598)
#define RPGACC12H    (*(volatile __near unsigned char  *)0x599)
#define RPGACC13     (*(volatile __near unsigned short *)0x59A)
#define RPGACC13L    (*(volatile __near unsigned char  *)0x59A)
#define RPGACC13H    (*(volatile __near unsigned char  *)0x59B)
#define RPGACC14     (*(volatile __near unsigned short *)0x59C)
#define RPGACC14L    (*(volatile __near unsigned char  *)0x59C)
#define RPGACC14H    (*(volatile __near unsigned char  *)0x59D)
#define RPGACC15     (*(volatile __near unsigned short *)0x59E)
#define RPGACC15L    (*(volatile __near unsigned char  *)0x59E)
#define RPGACC15H    (*(volatile __near unsigned char  *)0x59F)
#define RFIDL0       (*(volatile __near unsigned short *)0x5A0)
#define RPGACC16     (*(volatile __near unsigned short *)0x5A0)
#define RFIDL0L      (*(volatile __near unsigned char  *)0x5A0)
#define RPGACC16L    (*(volatile __near unsigned char  *)0x5A0)
#define RFIDL0H      (*(volatile __near unsigned char  *)0x5A1)
#define RPGACC16H    (*(volatile __near unsigned char  *)0x5A1)
#define RFIDH0       (*(volatile __near unsigned short *)0x5A2)
#define RPGACC17     (*(volatile __near unsigned short *)0x5A2)
#define RFIDH0L      (*(volatile __near unsigned char  *)0x5A2)
#define RPGACC17L    (*(volatile __near unsigned char  *)0x5A2)
#define RFIDH0H      (*(volatile __near unsigned char  *)0x5A3)
#define RPGACC17H    (*(volatile __near unsigned char  *)0x5A3)
#define RFTS0        (*(volatile __near unsigned short *)0x5A4)
#define RPGACC18     (*(volatile __near unsigned short *)0x5A4)
#define RFTS0L       (*(volatile __near unsigned char  *)0x5A4)
#define RPGACC18L    (*(volatile __near unsigned char  *)0x5A4)
#define RFTS0H       (*(volatile __near unsigned char  *)0x5A5)
#define RPGACC18H    (*(volatile __near unsigned char  *)0x5A5)
#define RFPTR0       (*(volatile __near unsigned short *)0x5A6)
#define RPGACC19     (*(volatile __near unsigned short *)0x5A6)
#define RFPTR0L      (*(volatile __near unsigned char  *)0x5A6)
#define RPGACC19L    (*(volatile __near unsigned char  *)0x5A6)
#define RFPTR0H      (*(volatile __near unsigned char  *)0x5A7)
#define RPGACC19H    (*(volatile __near unsigned char  *)0x5A7)
#define RFDF00       (*(volatile __near unsigned short *)0x5A8)
#define RPGACC20     (*(volatile __near unsigned short *)0x5A8)
#define RFDF00L      (*(volatile __near unsigned char  *)0x5A8)
#define RPGACC20L    (*(volatile __near unsigned char  *)0x5A8)
#define RFDF00H      (*(volatile __near unsigned char  *)0x5A9)
#define RPGACC20H    (*(volatile __near unsigned char  *)0x5A9)
#define RFDF10       (*(volatile __near unsigned short *)0x5AA)
#define RPGACC21     (*(volatile __near unsigned short *)0x5AA)
#define RFDF10L      (*(volatile __near unsigned char  *)0x5AA)
#define RPGACC21L    (*(volatile __near unsigned char  *)0x5AA)
#define RFDF10H      (*(volatile __near unsigned char  *)0x5AB)
#define RPGACC21H    (*(volatile __near unsigned char  *)0x5AB)
#define RFDF20       (*(volatile __near unsigned short *)0x5AC)
#define RPGACC22     (*(volatile __near unsigned short *)0x5AC)
#define RFDF20L      (*(volatile __near unsigned char  *)0x5AC)
#define RPGACC22L    (*(volatile __near unsigned char  *)0x5AC)
#define RFDF20H      (*(volatile __near unsigned char  *)0x5AD)
#define RPGACC22H    (*(volatile __near unsigned char  *)0x5AD)
#define RFDF30       (*(volatile __near unsigned short *)0x5AE)
#define RPGACC23     (*(volatile __near unsigned short *)0x5AE)
#define RFDF30L      (*(volatile __near unsigned char  *)0x5AE)
#define RPGACC23L    (*(volatile __near unsigned char  *)0x5AE)
#define RFDF30H      (*(volatile __near unsigned char  *)0x5AF)
#define RPGACC23H    (*(volatile __near unsigned char  *)0x5AF)
#define RFIDL1       (*(volatile __near unsigned short *)0x5B0)
#define RPGACC24     (*(volatile __near unsigned short *)0x5B0)
#define RFIDL1L      (*(volatile __near unsigned char  *)0x5B0)
#define RPGACC24L    (*(volatile __near unsigned char  *)0x5B0)
#define RFIDL1H      (*(volatile __near unsigned char  *)0x5B1)
#define RPGACC24H    (*(volatile __near unsigned char  *)0x5B1)
#define RFIDH1       (*(volatile __near unsigned short *)0x5B2)
#define RPGACC25     (*(volatile __near unsigned short *)0x5B2)
#define RFIDH1L      (*(volatile __near unsigned char  *)0x5B2)
#define RPGACC25L    (*(volatile __near unsigned char  *)0x5B2)
#define RFIDH1H      (*(volatile __near unsigned char  *)0x5B3)
#define RPGACC25H    (*(volatile __near unsigned char  *)0x5B3)
#define RFTS1        (*(volatile __near unsigned short *)0x5B4)
#define RPGACC26     (*(volatile __near unsigned short *)0x5B4)
#define RFTS1L       (*(volatile __near unsigned char  *)0x5B4)
#define RPGACC26L    (*(volatile __near unsigned char  *)0x5B4)
#define RFTS1H       (*(volatile __near unsigned char  *)0x5B5)
#define RPGACC26H    (*(volatile __near unsigned char  *)0x5B5)
#define RFPTR1       (*(volatile __near unsigned short *)0x5B6)
#define RPGACC27     (*(volatile __near unsigned short *)0x5B6)
#define RFPTR1L      (*(volatile __near unsigned char  *)0x5B6)
#define RPGACC27L    (*(volatile __near unsigned char  *)0x5B6)
#define RFPTR1H      (*(volatile __near unsigned char  *)0x5B7)
#define RPGACC27H    (*(volatile __near unsigned char  *)0x5B7)
#define RFDF01       (*(volatile __near unsigned short *)0x5B8)
#define RPGACC28     (*(volatile __near unsigned short *)0x5B8)
#define RFDF01L      (*(volatile __near unsigned char  *)0x5B8)
#define RPGACC28L    (*(volatile __near unsigned char  *)0x5B8)
#define RFDF01H      (*(volatile __near unsigned char  *)0x5B9)
#define RPGACC28H    (*(volatile __near unsigned char  *)0x5B9)
#define RFDF11       (*(volatile __near unsigned short *)0x5BA)
#define RPGACC29     (*(volatile __near unsigned short *)0x5BA)
#define RFDF11L      (*(volatile __near unsigned char  *)0x5BA)
#define RPGACC29L    (*(volatile __near unsigned char  *)0x5BA)
#define RFDF11H      (*(volatile __near unsigned char  *)0x5BB)
#define RPGACC29H    (*(volatile __near unsigned char  *)0x5BB)
#define RFDF21       (*(volatile __near unsigned short *)0x5BC)
#define RPGACC30     (*(volatile __near unsigned short *)0x5BC)
#define RFDF21L      (*(volatile __near unsigned char  *)0x5BC)
#define RPGACC30L    (*(volatile __near unsigned char  *)0x5BC)
#define RFDF21H      (*(volatile __near unsigned char  *)0x5BD)
#define RPGACC30H    (*(volatile __near unsigned char  *)0x5BD)
#define RFDF31       (*(volatile __near unsigned short *)0x5BE)
#define RPGACC31     (*(volatile __near unsigned short *)0x5BE)
#define RFDF31L      (*(volatile __near unsigned char  *)0x5BE)
#define RPGACC31L    (*(volatile __near unsigned char  *)0x5BE)
#define RFDF31H      (*(volatile __near unsigned char  *)0x5BF)
#define RPGACC31H    (*(volatile __near unsigned char  *)0x5BF)
#define RPGACC32     (*(volatile __near unsigned short *)0x5C0)
#define RPGACC32L    (*(volatile __near unsigned char  *)0x5C0)
#define RPGACC32H    (*(volatile __near unsigned char  *)0x5C1)
#define RPGACC33     (*(volatile __near unsigned short *)0x5C2)
#define RPGACC33L    (*(volatile __near unsigned char  *)0x5C2)
#define RPGACC33H    (*(volatile __near unsigned char  *)0x5C3)
#define RPGACC34     (*(volatile __near unsigned short *)0x5C4)
#define RPGACC34L    (*(volatile __near unsigned char  *)0x5C4)
#define RPGACC34H    (*(volatile __near unsigned char  *)0x5C5)
#define RPGACC35     (*(volatile __near unsigned short *)0x5C6)
#define RPGACC35L    (*(volatile __near unsigned char  *)0x5C6)
#define RPGACC35H    (*(volatile __near unsigned char  *)0x5C7)
#define RPGACC36     (*(volatile __near unsigned short *)0x5C8)
#define RPGACC36L    (*(volatile __near unsigned char  *)0x5C8)
#define RPGACC36H    (*(volatile __near unsigned char  *)0x5C9)
#define RPGACC37     (*(volatile __near unsigned short *)0x5CA)
#define RPGACC37L    (*(volatile __near unsigned char  *)0x5CA)
#define RPGACC37H    (*(volatile __near unsigned char  *)0x5CB)
#define RPGACC38     (*(volatile __near unsigned short *)0x5CC)
#define RPGACC38L    (*(volatile __near unsigned char  *)0x5CC)
#define RPGACC38H    (*(volatile __near unsigned char  *)0x5CD)
#define RPGACC39     (*(volatile __near unsigned short *)0x5CE)
#define RPGACC39L    (*(volatile __near unsigned char  *)0x5CE)
#define RPGACC39H    (*(volatile __near unsigned char  *)0x5CF)
#define RPGACC40     (*(volatile __near unsigned short *)0x5D0)
#define RPGACC40L    (*(volatile __near unsigned char  *)0x5D0)
#define RPGACC40H    (*(volatile __near unsigned char  *)0x5D1)
#define RPGACC41     (*(volatile __near unsigned short *)0x5D2)
#define RPGACC41L    (*(volatile __near unsigned char  *)0x5D2)
#define RPGACC41H    (*(volatile __near unsigned char  *)0x5D3)
#define RPGACC42     (*(volatile __near unsigned short *)0x5D4)
#define RPGACC42L    (*(volatile __near unsigned char  *)0x5D4)
#define RPGACC42H    (*(volatile __near unsigned char  *)0x5D5)
#define RPGACC43     (*(volatile __near unsigned short *)0x5D6)
#define RPGACC43L    (*(volatile __near unsigned char  *)0x5D6)
#define RPGACC43H    (*(volatile __near unsigned char  *)0x5D7)
#define RPGACC44     (*(volatile __near unsigned short *)0x5D8)
#define RPGACC44L    (*(volatile __near unsigned char  *)0x5D8)
#define RPGACC44H    (*(volatile __near unsigned char  *)0x5D9)
#define RPGACC45     (*(volatile __near unsigned short *)0x5DA)
#define RPGACC45L    (*(volatile __near unsigned char  *)0x5DA)
#define RPGACC45H    (*(volatile __near unsigned char  *)0x5DB)
#define RPGACC46     (*(volatile __near unsigned short *)0x5DC)
#define RPGACC46L    (*(volatile __near unsigned char  *)0x5DC)
#define RPGACC46H    (*(volatile __near unsigned char  *)0x5DD)
#define RPGACC47     (*(volatile __near unsigned short *)0x5DE)
#define RPGACC47L    (*(volatile __near unsigned char  *)0x5DE)
#define RPGACC47H    (*(volatile __near unsigned char  *)0x5DF)
#define CFIDL0       (*(volatile __near unsigned short *)0x5E0)
#define RPGACC48     (*(volatile __near unsigned short *)0x5E0)
#define CFIDL0L      (*(volatile __near unsigned char  *)0x5E0)
#define RPGACC48L    (*(volatile __near unsigned char  *)0x5E0)
#define CFIDL0H      (*(volatile __near unsigned char  *)0x5E1)
#define RPGACC48H    (*(volatile __near unsigned char  *)0x5E1)
#define CFIDH0       (*(volatile __near unsigned short *)0x5E2)
#define RPGACC49     (*(volatile __near unsigned short *)0x5E2)
#define CFIDH0L      (*(volatile __near unsigned char  *)0x5E2)
#define RPGACC49L    (*(volatile __near unsigned char  *)0x5E2)
#define CFIDH0H      (*(volatile __near unsigned char  *)0x5E3)
#define RPGACC49H    (*(volatile __near unsigned char  *)0x5E3)
#define CFTS0        (*(volatile __near unsigned short *)0x5E4)
#define RPGACC50     (*(volatile __near unsigned short *)0x5E4)
#define CFTS0L       (*(volatile __near unsigned char  *)0x5E4)
#define RPGACC50L    (*(volatile __near unsigned char  *)0x5E4)
#define CFTS0H       (*(volatile __near unsigned char  *)0x5E5)
#define RPGACC50H    (*(volatile __near unsigned char  *)0x5E5)
#define CFPTR0       (*(volatile __near unsigned short *)0x5E6)
#define RPGACC51     (*(volatile __near unsigned short *)0x5E6)
#define CFPTR0L      (*(volatile __near unsigned char  *)0x5E6)
#define RPGACC51L    (*(volatile __near unsigned char  *)0x5E6)
#define CFPTR0H      (*(volatile __near unsigned char  *)0x5E7)
#define RPGACC51H    (*(volatile __near unsigned char  *)0x5E7)
#define CFDF00       (*(volatile __near unsigned short *)0x5E8)
#define RPGACC52     (*(volatile __near unsigned short *)0x5E8)
#define CFDF00L      (*(volatile __near unsigned char  *)0x5E8)
#define RPGACC52L    (*(volatile __near unsigned char  *)0x5E8)
#define CFDF00H      (*(volatile __near unsigned char  *)0x5E9)
#define RPGACC52H    (*(volatile __near unsigned char  *)0x5E9)
#define CFDF10       (*(volatile __near unsigned short *)0x5EA)
#define RPGACC53     (*(volatile __near unsigned short *)0x5EA)
#define CFDF10L      (*(volatile __near unsigned char  *)0x5EA)
#define RPGACC53L    (*(volatile __near unsigned char  *)0x5EA)
#define CFDF10H      (*(volatile __near unsigned char  *)0x5EB)
#define RPGACC53H    (*(volatile __near unsigned char  *)0x5EB)
#define CFDF20       (*(volatile __near unsigned short *)0x5EC)
#define RPGACC54     (*(volatile __near unsigned short *)0x5EC)
#define CFDF20L      (*(volatile __near unsigned char  *)0x5EC)
#define RPGACC54L    (*(volatile __near unsigned char  *)0x5EC)
#define CFDF20H      (*(volatile __near unsigned char  *)0x5ED)
#define RPGACC54H    (*(volatile __near unsigned char  *)0x5ED)
#define CFDF30       (*(volatile __near unsigned short *)0x5EE)
#define RPGACC55     (*(volatile __near unsigned short *)0x5EE)
#define CFDF30L      (*(volatile __near unsigned char  *)0x5EE)
#define RPGACC55L    (*(volatile __near unsigned char  *)0x5EE)
#define CFDF30H      (*(volatile __near unsigned char  *)0x5EF)
#define RPGACC55H    (*(volatile __near unsigned char  *)0x5EF)
#define RPGACC56     (*(volatile __near unsigned short *)0x5F0)
#define RPGACC56L    (*(volatile __near unsigned char  *)0x5F0)
#define RPGACC56H    (*(volatile __near unsigned char  *)0x5F1)
#define RPGACC57     (*(volatile __near unsigned short *)0x5F2)
#define RPGACC57L    (*(volatile __near unsigned char  *)0x5F2)
#define RPGACC57H    (*(volatile __near unsigned char  *)0x5F3)
#define RPGACC58     (*(volatile __near unsigned short *)0x5F4)
#define RPGACC58L    (*(volatile __near unsigned char  *)0x5F4)
#define RPGACC58H    (*(volatile __near unsigned char  *)0x5F5)
#define RPGACC59     (*(volatile __near unsigned short *)0x5F6)
#define RPGACC59L    (*(volatile __near unsigned char  *)0x5F6)
#define RPGACC59H    (*(volatile __near unsigned char  *)0x5F7)
#define RPGACC60     (*(volatile __near unsigned short *)0x5F8)
#define RPGACC60L    (*(volatile __near unsigned char  *)0x5F8)
#define RPGACC60H    (*(volatile __near unsigned char  *)0x5F9)
#define RPGACC61     (*(volatile __near unsigned short *)0x5FA)
#define RPGACC61L    (*(volatile __near unsigned char  *)0x5FA)
#define RPGACC61H    (*(volatile __near unsigned char  *)0x5FB)
#define RPGACC62     (*(volatile __near unsigned short *)0x5FC)
#define RPGACC62L    (*(volatile __near unsigned char  *)0x5FC)
#define RPGACC62H    (*(volatile __near unsigned char  *)0x5FD)
#define RPGACC63     (*(volatile __near unsigned short *)0x5FE)
#define RPGACC63L    (*(volatile __near unsigned char  *)0x5FE)
#define RPGACC63H    (*(volatile __near unsigned char  *)0x5FF)
#define RPGACC64     (*(volatile __near unsigned short *)0x600)
#define TMIDL0       (*(volatile __near unsigned short *)0x600)
#define RPGACC64L    (*(volatile __near unsigned char  *)0x600)
#define TMIDL0L      (*(volatile __near unsigned char  *)0x600)
#define RPGACC64H    (*(volatile __near unsigned char  *)0x601)
#define TMIDL0H      (*(volatile __near unsigned char  *)0x601)
#define RPGACC65     (*(volatile __near unsigned short *)0x602)
#define TMIDH0       (*(volatile __near unsigned short *)0x602)
#define RPGACC65L    (*(volatile __near unsigned char  *)0x602)
#define TMIDH0L      (*(volatile __near unsigned char  *)0x602)
#define RPGACC65H    (*(volatile __near unsigned char  *)0x603)
#define TMIDH0H      (*(volatile __near unsigned char  *)0x603)
#define RPGACC66     (*(volatile __near unsigned short *)0x604)
#define RPGACC66L    (*(volatile __near unsigned char  *)0x604)
#define RPGACC66H    (*(volatile __near unsigned char  *)0x605)
#define RPGACC67     (*(volatile __near unsigned short *)0x606)
#define TMPTR0       (*(volatile __near unsigned short *)0x606)
#define RPGACC67L    (*(volatile __near unsigned char  *)0x606)
#define TMPTR0L      (*(volatile __near unsigned char  *)0x606)
#define RPGACC67H    (*(volatile __near unsigned char  *)0x607)
#define TMPTR0H      (*(volatile __near unsigned char  *)0x607)
#define RPGACC68     (*(volatile __near unsigned short *)0x608)
#define TMDF00       (*(volatile __near unsigned short *)0x608)
#define RPGACC68L    (*(volatile __near unsigned char  *)0x608)
#define TMDF00L      (*(volatile __near unsigned char  *)0x608)
#define RPGACC68H    (*(volatile __near unsigned char  *)0x609)
#define TMDF00H      (*(volatile __near unsigned char  *)0x609)
#define RPGACC69     (*(volatile __near unsigned short *)0x60A)
#define TMDF10       (*(volatile __near unsigned short *)0x60A)
#define RPGACC69L    (*(volatile __near unsigned char  *)0x60A)
#define TMDF10L      (*(volatile __near unsigned char  *)0x60A)
#define RPGACC69H    (*(volatile __near unsigned char  *)0x60B)
#define TMDF10H      (*(volatile __near unsigned char  *)0x60B)
#define RPGACC70     (*(volatile __near unsigned short *)0x60C)
#define TMDF20       (*(volatile __near unsigned short *)0x60C)
#define RPGACC70L    (*(volatile __near unsigned char  *)0x60C)
#define TMDF20L      (*(volatile __near unsigned char  *)0x60C)
#define RPGACC70H    (*(volatile __near unsigned char  *)0x60D)
#define TMDF20H      (*(volatile __near unsigned char  *)0x60D)
#define RPGACC71     (*(volatile __near unsigned short *)0x60E)
#define TMDF30       (*(volatile __near unsigned short *)0x60E)
#define RPGACC71L    (*(volatile __near unsigned char  *)0x60E)
#define TMDF30L      (*(volatile __near unsigned char  *)0x60E)
#define RPGACC71H    (*(volatile __near unsigned char  *)0x60F)
#define TMDF30H      (*(volatile __near unsigned char  *)0x60F)
#define RPGACC72     (*(volatile __near unsigned short *)0x610)
#define TMIDL1       (*(volatile __near unsigned short *)0x610)
#define RPGACC72L    (*(volatile __near unsigned char  *)0x610)
#define TMIDL1L      (*(volatile __near unsigned char  *)0x610)
#define RPGACC72H    (*(volatile __near unsigned char  *)0x611)
#define TMIDL1H      (*(volatile __near unsigned char  *)0x611)
#define RPGACC73     (*(volatile __near unsigned short *)0x612)
#define TMIDH1       (*(volatile __near unsigned short *)0x612)
#define RPGACC73L    (*(volatile __near unsigned char  *)0x612)
#define TMIDH1L      (*(volatile __near unsigned char  *)0x612)
#define RPGACC73H    (*(volatile __near unsigned char  *)0x613)
#define TMIDH1H      (*(volatile __near unsigned char  *)0x613)
#define RPGACC74     (*(volatile __near unsigned short *)0x614)
#define RPGACC74L    (*(volatile __near unsigned char  *)0x614)
#define RPGACC74H    (*(volatile __near unsigned char  *)0x615)
#define RPGACC75     (*(volatile __near unsigned short *)0x616)
#define TMPTR1       (*(volatile __near unsigned short *)0x616)
#define RPGACC75L    (*(volatile __near unsigned char  *)0x616)
#define TMPTR1L      (*(volatile __near unsigned char  *)0x616)
#define RPGACC75H    (*(volatile __near unsigned char  *)0x617)
#define TMPTR1H      (*(volatile __near unsigned char  *)0x617)
#define RPGACC76     (*(volatile __near unsigned short *)0x618)
#define TMDF01       (*(volatile __near unsigned short *)0x618)
#define RPGACC76L    (*(volatile __near unsigned char  *)0x618)
#define TMDF01L      (*(volatile __near unsigned char  *)0x618)
#define RPGACC76H    (*(volatile __near unsigned char  *)0x619)
#define TMDF01H      (*(volatile __near unsigned char  *)0x619)
#define RPGACC77     (*(volatile __near unsigned short *)0x61A)
#define TMDF11       (*(volatile __near unsigned short *)0x61A)
#define RPGACC77L    (*(volatile __near unsigned char  *)0x61A)
#define TMDF11L      (*(volatile __near unsigned char  *)0x61A)
#define RPGACC77H    (*(volatile __near unsigned char  *)0x61B)
#define TMDF11H      (*(volatile __near unsigned char  *)0x61B)
#define RPGACC78     (*(volatile __near unsigned short *)0x61C)
#define TMDF21       (*(volatile __near unsigned short *)0x61C)
#define RPGACC78L    (*(volatile __near unsigned char  *)0x61C)
#define TMDF21L      (*(volatile __near unsigned char  *)0x61C)
#define RPGACC78H    (*(volatile __near unsigned char  *)0x61D)
#define TMDF21H      (*(volatile __near unsigned char  *)0x61D)
#define RPGACC79     (*(volatile __near unsigned short *)0x61E)
#define TMDF31       (*(volatile __near unsigned short *)0x61E)
#define RPGACC79L    (*(volatile __near unsigned char  *)0x61E)
#define TMDF31L      (*(volatile __near unsigned char  *)0x61E)
#define RPGACC79H    (*(volatile __near unsigned char  *)0x61F)
#define TMDF31H      (*(volatile __near unsigned char  *)0x61F)
#define RPGACC80     (*(volatile __near unsigned short *)0x620)
#define TMIDL2       (*(volatile __near unsigned short *)0x620)
#define RPGACC80L    (*(volatile __near unsigned char  *)0x620)
#define TMIDL2L      (*(volatile __near unsigned char  *)0x620)
#define RPGACC80H    (*(volatile __near unsigned char  *)0x621)
#define TMIDL2H      (*(volatile __near unsigned char  *)0x621)
#define RPGACC81     (*(volatile __near unsigned short *)0x622)
#define TMIDH2       (*(volatile __near unsigned short *)0x622)
#define RPGACC81L    (*(volatile __near unsigned char  *)0x622)
#define TMIDH2L      (*(volatile __near unsigned char  *)0x622)
#define RPGACC81H    (*(volatile __near unsigned char  *)0x623)
#define TMIDH2H      (*(volatile __near unsigned char  *)0x623)
#define RPGACC82     (*(volatile __near unsigned short *)0x624)
#define RPGACC82L    (*(volatile __near unsigned char  *)0x624)
#define RPGACC82H    (*(volatile __near unsigned char  *)0x625)
#define RPGACC83     (*(volatile __near unsigned short *)0x626)
#define TMPTR2       (*(volatile __near unsigned short *)0x626)
#define RPGACC83L    (*(volatile __near unsigned char  *)0x626)
#define TMPTR2L      (*(volatile __near unsigned char  *)0x626)
#define RPGACC83H    (*(volatile __near unsigned char  *)0x627)
#define TMPTR2H      (*(volatile __near unsigned char  *)0x627)
#define RPGACC84     (*(volatile __near unsigned short *)0x628)
#define TMDF02       (*(volatile __near unsigned short *)0x628)
#define RPGACC84L    (*(volatile __near unsigned char  *)0x628)
#define TMDF02L      (*(volatile __near unsigned char  *)0x628)
#define RPGACC84H    (*(volatile __near unsigned char  *)0x629)
#define TMDF02H      (*(volatile __near unsigned char  *)0x629)
#define RPGACC85     (*(volatile __near unsigned short *)0x62A)
#define TMDF12       (*(volatile __near unsigned short *)0x62A)
#define RPGACC85L    (*(volatile __near unsigned char  *)0x62A)
#define TMDF12L      (*(volatile __near unsigned char  *)0x62A)
#define RPGACC85H    (*(volatile __near unsigned char  *)0x62B)
#define TMDF12H      (*(volatile __near unsigned char  *)0x62B)
#define RPGACC86     (*(volatile __near unsigned short *)0x62C)
#define TMDF22       (*(volatile __near unsigned short *)0x62C)
#define RPGACC86L    (*(volatile __near unsigned char  *)0x62C)
#define TMDF22L      (*(volatile __near unsigned char  *)0x62C)
#define RPGACC86H    (*(volatile __near unsigned char  *)0x62D)
#define TMDF22H      (*(volatile __near unsigned char  *)0x62D)
#define RPGACC87     (*(volatile __near unsigned short *)0x62E)
#define TMDF32       (*(volatile __near unsigned short *)0x62E)
#define RPGACC87L    (*(volatile __near unsigned char  *)0x62E)
#define TMDF32L      (*(volatile __near unsigned char  *)0x62E)
#define RPGACC87H    (*(volatile __near unsigned char  *)0x62F)
#define TMDF32H      (*(volatile __near unsigned char  *)0x62F)
#define RPGACC88     (*(volatile __near unsigned short *)0x630)
#define TMIDL3       (*(volatile __near unsigned short *)0x630)
#define RPGACC88L    (*(volatile __near unsigned char  *)0x630)
#define TMIDL3L      (*(volatile __near unsigned char  *)0x630)
#define RPGACC88H    (*(volatile __near unsigned char  *)0x631)
#define TMIDL3H      (*(volatile __near unsigned char  *)0x631)
#define RPGACC89     (*(volatile __near unsigned short *)0x632)
#define TMIDH3       (*(volatile __near unsigned short *)0x632)
#define RPGACC89L    (*(volatile __near unsigned char  *)0x632)
#define TMIDH3L      (*(volatile __near unsigned char  *)0x632)
#define RPGACC89H    (*(volatile __near unsigned char  *)0x633)
#define TMIDH3H      (*(volatile __near unsigned char  *)0x633)
#define RPGACC90     (*(volatile __near unsigned short *)0x634)
#define RPGACC90L    (*(volatile __near unsigned char  *)0x634)
#define RPGACC90H    (*(volatile __near unsigned char  *)0x635)
#define RPGACC91     (*(volatile __near unsigned short *)0x636)
#define TMPTR3       (*(volatile __near unsigned short *)0x636)
#define RPGACC91L    (*(volatile __near unsigned char  *)0x636)
#define TMPTR3L      (*(volatile __near unsigned char  *)0x636)
#define RPGACC91H    (*(volatile __near unsigned char  *)0x637)
#define TMPTR3H      (*(volatile __near unsigned char  *)0x637)
#define RPGACC92     (*(volatile __near unsigned short *)0x638)
#define TMDF03       (*(volatile __near unsigned short *)0x638)
#define RPGACC92L    (*(volatile __near unsigned char  *)0x638)
#define TMDF03L      (*(volatile __near unsigned char  *)0x638)
#define RPGACC92H    (*(volatile __near unsigned char  *)0x639)
#define TMDF03H      (*(volatile __near unsigned char  *)0x639)
#define RPGACC93     (*(volatile __near unsigned short *)0x63A)
#define TMDF13       (*(volatile __near unsigned short *)0x63A)
#define RPGACC93L    (*(volatile __near unsigned char  *)0x63A)
#define TMDF13L      (*(volatile __near unsigned char  *)0x63A)
#define RPGACC93H    (*(volatile __near unsigned char  *)0x63B)
#define TMDF13H      (*(volatile __near unsigned char  *)0x63B)
#define RPGACC94     (*(volatile __near unsigned short *)0x63C)
#define TMDF23       (*(volatile __near unsigned short *)0x63C)
#define RPGACC94L    (*(volatile __near unsigned char  *)0x63C)
#define TMDF23L      (*(volatile __near unsigned char  *)0x63C)
#define RPGACC94H    (*(volatile __near unsigned char  *)0x63D)
#define TMDF23H      (*(volatile __near unsigned char  *)0x63D)
#define RPGACC95     (*(volatile __near unsigned short *)0x63E)
#define TMDF33       (*(volatile __near unsigned short *)0x63E)
#define RPGACC95L    (*(volatile __near unsigned char  *)0x63E)
#define TMDF33L      (*(volatile __near unsigned char  *)0x63E)
#define RPGACC95H    (*(volatile __near unsigned char  *)0x63F)
#define TMDF33H      (*(volatile __near unsigned char  *)0x63F)
#define RPGACC96     (*(volatile __near unsigned short *)0x640)
#define RPGACC96L    (*(volatile __near unsigned char  *)0x640)
#define RPGACC96H    (*(volatile __near unsigned char  *)0x641)
#define RPGACC97     (*(volatile __near unsigned short *)0x642)
#define RPGACC97L    (*(volatile __near unsigned char  *)0x642)
#define RPGACC97H    (*(volatile __near unsigned char  *)0x643)
#define RPGACC98     (*(volatile __near unsigned short *)0x644)
#define RPGACC98L    (*(volatile __near unsigned char  *)0x644)
#define RPGACC98H    (*(volatile __near unsigned char  *)0x645)
#define RPGACC99     (*(volatile __near unsigned short *)0x646)
#define RPGACC99L    (*(volatile __near unsigned char  *)0x646)
#define RPGACC99H    (*(volatile __near unsigned char  *)0x647)
#define RPGACC100    (*(volatile __near unsigned short *)0x648)
#define RPGACC100L   (*(volatile __near unsigned char  *)0x648)
#define RPGACC100H   (*(volatile __near unsigned char  *)0x649)
#define RPGACC101    (*(volatile __near unsigned short *)0x64A)
#define RPGACC101L   (*(volatile __near unsigned char  *)0x64A)
#define RPGACC101H   (*(volatile __near unsigned char  *)0x64B)
#define RPGACC102    (*(volatile __near unsigned short *)0x64C)
#define RPGACC102L   (*(volatile __near unsigned char  *)0x64C)
#define RPGACC102H   (*(volatile __near unsigned char  *)0x64D)
#define RPGACC103    (*(volatile __near unsigned short *)0x64E)
#define RPGACC103L   (*(volatile __near unsigned char  *)0x64E)
#define RPGACC103H   (*(volatile __near unsigned char  *)0x64F)
#define RPGACC104    (*(volatile __near unsigned short *)0x650)
#define RPGACC104L   (*(volatile __near unsigned char  *)0x650)
#define RPGACC104H   (*(volatile __near unsigned char  *)0x651)
#define RPGACC105    (*(volatile __near unsigned short *)0x652)
#define RPGACC105L   (*(volatile __near unsigned char  *)0x652)
#define RPGACC105H   (*(volatile __near unsigned char  *)0x653)
#define RPGACC106    (*(volatile __near unsigned short *)0x654)
#define RPGACC106L   (*(volatile __near unsigned char  *)0x654)
#define RPGACC106H   (*(volatile __near unsigned char  *)0x655)
#define RPGACC107    (*(volatile __near unsigned short *)0x656)
#define RPGACC107L   (*(volatile __near unsigned char  *)0x656)
#define RPGACC107H   (*(volatile __near unsigned char  *)0x657)
#define RPGACC108    (*(volatile __near unsigned short *)0x658)
#define RPGACC108L   (*(volatile __near unsigned char  *)0x658)
#define RPGACC108H   (*(volatile __near unsigned char  *)0x659)
#define RPGACC109    (*(volatile __near unsigned short *)0x65A)
#define RPGACC109L   (*(volatile __near unsigned char  *)0x65A)
#define RPGACC109H   (*(volatile __near unsigned char  *)0x65B)
#define RPGACC110    (*(volatile __near unsigned short *)0x65C)
#define RPGACC110L   (*(volatile __near unsigned char  *)0x65C)
#define RPGACC110H   (*(volatile __near unsigned char  *)0x65D)
#define RPGACC111    (*(volatile __near unsigned short *)0x65E)
#define RPGACC111L   (*(volatile __near unsigned char  *)0x65E)
#define RPGACC111H   (*(volatile __near unsigned char  *)0x65F)
#define RPGACC112    (*(volatile __near unsigned short *)0x660)
#define RPGACC112L   (*(volatile __near unsigned char  *)0x660)
#define RPGACC112H   (*(volatile __near unsigned char  *)0x661)
#define RPGACC113    (*(volatile __near unsigned short *)0x662)
#define RPGACC113L   (*(volatile __near unsigned char  *)0x662)
#define RPGACC113H   (*(volatile __near unsigned char  *)0x663)
#define RPGACC114    (*(volatile __near unsigned short *)0x664)
#define RPGACC114L   (*(volatile __near unsigned char  *)0x664)
#define RPGACC114H   (*(volatile __near unsigned char  *)0x665)
#define RPGACC115    (*(volatile __near unsigned short *)0x666)
#define RPGACC115L   (*(volatile __near unsigned char  *)0x666)
#define RPGACC115H   (*(volatile __near unsigned char  *)0x667)
#define RPGACC116    (*(volatile __near unsigned short *)0x668)
#define RPGACC116L   (*(volatile __near unsigned char  *)0x668)
#define RPGACC116H   (*(volatile __near unsigned char  *)0x669)
#define RPGACC117    (*(volatile __near unsigned short *)0x66A)
#define RPGACC117L   (*(volatile __near unsigned char  *)0x66A)
#define RPGACC117H   (*(volatile __near unsigned char  *)0x66B)
#define RPGACC118    (*(volatile __near unsigned short *)0x66C)
#define RPGACC118L   (*(volatile __near unsigned char  *)0x66C)
#define RPGACC118H   (*(volatile __near unsigned char  *)0x66D)
#define RPGACC119    (*(volatile __near unsigned short *)0x66E)
#define RPGACC119L   (*(volatile __near unsigned char  *)0x66E)
#define RPGACC119H   (*(volatile __near unsigned char  *)0x66F)
#define RPGACC120    (*(volatile __near unsigned short *)0x670)
#define RPGACC120L   (*(volatile __near unsigned char  *)0x670)
#define RPGACC120H   (*(volatile __near unsigned char  *)0x671)
#define RPGACC121    (*(volatile __near unsigned short *)0x672)
#define RPGACC121L   (*(volatile __near unsigned char  *)0x672)
#define RPGACC121H   (*(volatile __near unsigned char  *)0x673)
#define RPGACC122    (*(volatile __near unsigned short *)0x674)
#define RPGACC122L   (*(volatile __near unsigned char  *)0x674)
#define RPGACC122H   (*(volatile __near unsigned char  *)0x675)
#define RPGACC123    (*(volatile __near unsigned short *)0x676)
#define RPGACC123L   (*(volatile __near unsigned char  *)0x676)
#define RPGACC123H   (*(volatile __near unsigned char  *)0x677)
#define RPGACC124    (*(volatile __near unsigned short *)0x678)
#define RPGACC124L   (*(volatile __near unsigned char  *)0x678)
#define RPGACC124H   (*(volatile __near unsigned char  *)0x679)
#define RPGACC125    (*(volatile __near unsigned short *)0x67A)
#define RPGACC125L   (*(volatile __near unsigned char  *)0x67A)
#define RPGACC125H   (*(volatile __near unsigned char  *)0x67B)
#define RPGACC126    (*(volatile __near unsigned short *)0x67C)
#define RPGACC126L   (*(volatile __near unsigned char  *)0x67C)
#define RPGACC126H   (*(volatile __near unsigned char  *)0x67D)
#define RPGACC127    (*(volatile __near unsigned short *)0x67E)
#define RPGACC127L   (*(volatile __near unsigned char  *)0x67E)
#define RPGACC127H   (*(volatile __near unsigned char  *)0x67F)
#define THLACC0      (*(volatile __near unsigned short *)0x680)
#define THLACC0L     (*(volatile __near unsigned char  *)0x680)
#define THLACC0H     (*(volatile __near unsigned char  *)0x681)
#define LWBR0        (*(volatile __near unsigned char  *)0x6C1)
#define LWBR1        (*(volatile __near unsigned char  *)0x6C1)
#define LBRP0        (*(volatile __near unsigned short *)0x6C2)
#define LBRP1        (*(volatile __near unsigned short *)0x6C2)
#define LBRP00       (*(volatile __near unsigned char  *)0x6C2)
#define LBRP10       (*(volatile __near unsigned char  *)0x6C2)
#define LBRP01       (*(volatile __near unsigned char  *)0x6C3)
#define LBRP11       (*(volatile __near unsigned char  *)0x6C3)
#define LSTC0        (*(volatile __near unsigned char  *)0x6C4)
#define LSTC1        (*(volatile __near unsigned char  *)0x6C4)
#define LUSC0        (*(volatile __near unsigned char  *)0x6C5)
#define LUSC1        (*(volatile __near unsigned char  *)0x6C5)
#define LMD0         (*(volatile __near unsigned char  *)0x6C8)
#define LMD1         (*(volatile __near unsigned char  *)0x6C8)
#define LBFC0        (*(volatile __near unsigned char  *)0x6C9)
#define LBFC1        (*(volatile __near unsigned char  *)0x6C9)
#define LSC0         (*(volatile __near unsigned char  *)0x6CA)
#define LSC1         (*(volatile __near unsigned char  *)0x6CA)
#define LWUP0        (*(volatile __near unsigned char  *)0x6CB)
#define LWUP1        (*(volatile __near unsigned char  *)0x6CB)
#define LIE0         (*(volatile __near unsigned char  *)0x6CC)
#define LIE1         (*(volatile __near unsigned char  *)0x6CC)
#define LEDE0        (*(volatile __near unsigned char  *)0x6CD)
#define LEDE1        (*(volatile __near unsigned char  *)0x6CD)
#define LCUC0        (*(volatile __near unsigned char  *)0x6CE)
#define LCUC1        (*(volatile __near unsigned char  *)0x6CE)
#define LTRC0        (*(volatile __near unsigned char  *)0x6D0)
#define LTRC1        (*(volatile __near unsigned char  *)0x6D0)
#define LMST0        (*(volatile __near unsigned char  *)0x6D1)
#define LMST1        (*(volatile __near unsigned char  *)0x6D1)
#define LST0         (*(volatile __near unsigned char  *)0x6D2)
#define LST1         (*(volatile __near unsigned char  *)0x6D2)
#define LEST0        (*(volatile __near unsigned char  *)0x6D3)
#define LEST1        (*(volatile __near unsigned char  *)0x6D3)
#define LDFC0        (*(volatile __near unsigned char  *)0x6D4)
#define LDFC1        (*(volatile __near unsigned char  *)0x6D4)
#define LIDB0        (*(volatile __near unsigned char  *)0x6D5)
#define LIDB1        (*(volatile __near unsigned char  *)0x6D5)
#define LCBR0        (*(volatile __near unsigned char  *)0x6D6)
#define LCBR1        (*(volatile __near unsigned char  *)0x6D6)
#define LUDB00       (*(volatile __near unsigned char  *)0x6D7)
#define LUDB10       (*(volatile __near unsigned char  *)0x6D7)
#define LDB01        (*(volatile __near unsigned char  *)0x6D8)
#define LDB11        (*(volatile __near unsigned char  *)0x6D8)
#define LDB02        (*(volatile __near unsigned char  *)0x6D9)
#define LDB12        (*(volatile __near unsigned char  *)0x6D9)
#define LDB03        (*(volatile __near unsigned char  *)0x6DA)
#define LDB13        (*(volatile __near unsigned char  *)0x6DA)
#define LDB04        (*(volatile __near unsigned char  *)0x6DB)
#define LDB14        (*(volatile __near unsigned char  *)0x6DB)
#define LDB05        (*(volatile __near unsigned char  *)0x6DC)
#define LDB15        (*(volatile __near unsigned char  *)0x6DC)
#define LDB06        (*(volatile __near unsigned char  *)0x6DD)
#define LDB16        (*(volatile __near unsigned char  *)0x6DD)
#define LDB07        (*(volatile __near unsigned char  *)0x6DE)
#define LDB17        (*(volatile __near unsigned char  *)0x6DE)
#define LDB08        (*(volatile __near unsigned char  *)0x6DF)
#define LDB18        (*(volatile __near unsigned char  *)0x6DF)
#define LUOER0       (*(volatile __near unsigned char  *)0x6E0)
#define LUOER1       (*(volatile __near unsigned char  *)0x6E0)
#define LUOR01       (*(volatile __near unsigned char  *)0x6E1)
#define LUOR11       (*(volatile __near unsigned char  *)0x6E1)
#define LUTDR0       (*(volatile __near unsigned short *)0x6E4)
#define LUTDR1       (*(volatile __near unsigned short *)0x6E4)
#define LUTDR0L      (*(volatile __near unsigned char  *)0x6E4)
#define LUTDR1L      (*(volatile __near unsigned char  *)0x6E4)
#define LUTDR0H      (*(volatile __near unsigned char  *)0x6E5)
#define LUTDR1H      (*(volatile __near unsigned char  *)0x6E5)
#define LURDR0       (*(volatile __near unsigned short *)0x6E6)
#define LURDR1       (*(volatile __near unsigned short *)0x6E6)
#define LURDR0L      (*(volatile __near unsigned char  *)0x6E6)
#define LURDR1L      (*(volatile __near unsigned char  *)0x6E6)
#define LURDR0H      (*(volatile __near unsigned char  *)0x6E7)
#define LURDR1H      (*(volatile __near unsigned char  *)0x6E7)
#define LUWTDR0      (*(volatile __near unsigned short *)0x6E8)
#define LUWTDR1      (*(volatile __near unsigned short *)0x6E8)
#define LUWTDR0L     (*(volatile __near unsigned char  *)0x6E8)
#define LUWTDR1L     (*(volatile __near unsigned char  *)0x6E8)
#define LUWTDR0H     (*(volatile __near unsigned char  *)0x6E9)
#define LUWTDR1H     (*(volatile __near unsigned char  *)0x6E9)
#define TRJ0         (*(volatile __near unsigned short *)0x6F0)
#define ELSELR00     (*(volatile __near unsigned char  *)0x780)
#define ELSELR00_bit (*(volatile __near __bitf_T *)0x780)
#define ELSELR01     (*(volatile __near unsigned char  *)0x781)
#define ELSELR01_bit (*(volatile __near __bitf_T *)0x781)
#define ELSELR02     (*(volatile __near unsigned char  *)0x782)
#define ELSELR02_bit (*(volatile __near __bitf_T *)0x782)
#define ELSELR03     (*(volatile __near unsigned char  *)0x783)
#define ELSELR03_bit (*(volatile __near __bitf_T *)0x783)
#define ELSELR04     (*(volatile __near unsigned char  *)0x784)
#define ELSELR04_bit (*(volatile __near __bitf_T *)0x784)
#define ELSELR05     (*(volatile __near unsigned char  *)0x785)
#define ELSELR05_bit (*(volatile __near __bitf_T *)0x785)
#define ELSELR06     (*(volatile __near unsigned char  *)0x786)
#define ELSELR06_bit (*(volatile __near __bitf_T *)0x786)
#define ELSELR07     (*(volatile __near unsigned char  *)0x787)
#define ELSELR07_bit (*(volatile __near __bitf_T *)0x787)
#define ELSELR08     (*(volatile __near unsigned char  *)0x788)
#define ELSELR08_bit (*(volatile __near __bitf_T *)0x788)
#define ELSELR09     (*(volatile __near unsigned char  *)0x789)
#define ELSELR09_bit (*(volatile __near __bitf_T *)0x789)
#define ELSELR10     (*(volatile __near unsigned char  *)0x78A)
#define ELSELR10_bit (*(volatile __near __bitf_T *)0x78A)
#define ELSELR11     (*(volatile __near unsigned char  *)0x78B)
#define ELSELR11_bit (*(volatile __near __bitf_T *)0x78B)
#define ELSELR12     (*(volatile __near unsigned char  *)0x78C)
#define ELSELR12_bit (*(volatile __near __bitf_T *)0x78C)
#define ELSELR13     (*(volatile __near unsigned char  *)0x78D)
#define ELSELR13_bit (*(volatile __near __bitf_T *)0x78D)
#define ELSELR14     (*(volatile __near unsigned char  *)0x78E)
#define ELSELR14_bit (*(volatile __near __bitf_T *)0x78E)
#define ELSELR15     (*(volatile __near unsigned char  *)0x78F)
#define ELSELR15_bit (*(volatile __near __bitf_T *)0x78F)
#define ELSELR16     (*(volatile __near unsigned char  *)0x790)
#define ELSELR16_bit (*(volatile __near __bitf_T *)0x790)
#define ELSELR17     (*(volatile __near unsigned char  *)0x791)
#define ELSELR17_bit (*(volatile __near __bitf_T *)0x791)
#define ELSELR18     (*(volatile __near unsigned char  *)0x792)
#define ELSELR18_bit (*(volatile __near __bitf_T *)0x792)
#define ELSELR19     (*(volatile __near unsigned char  *)0x793)
#define ELSELR19_bit (*(volatile __near __bitf_T *)0x793)
#define ELSELR20     (*(volatile __near unsigned char  *)0x794)
#define ELSELR20_bit (*(volatile __near __bitf_T *)0x794)
#define ELSELR21     (*(volatile __near unsigned char  *)0x795)
#define ELSELR21_bit (*(volatile __near __bitf_T *)0x795)
#define ELSELR22     (*(volatile __near unsigned char  *)0x796)
#define ELSELR22_bit (*(volatile __near __bitf_T *)0x796)
#define ELSELR23     (*(volatile __near unsigned char  *)0x797)
#define ELSELR23_bit (*(volatile __near __bitf_T *)0x797)
#define ELSELR24     (*(volatile __near unsigned char  *)0x798)
#define ELSELR24_bit (*(volatile __near __bitf_T *)0x798)
#define ELSELR25     (*(volatile __near unsigned char  *)0x799)
#define ELSELR25_bit (*(volatile __near __bitf_T *)0x799)
#define P0           (*(volatile __near unsigned char  *)0xFF00)
#define P0_bit       (*(volatile __near __bitf_T *)0xFF00)
#define P1           (*(volatile __near unsigned char  *)0xFF01)
#define P1_bit       (*(volatile __near __bitf_T *)0xFF01)
#define P3           (*(volatile __near unsigned char  *)0xFF03)
#define P3_bit       (*(volatile __near __bitf_T *)0xFF03)
#define P4           (*(volatile __near unsigned char  *)0xFF04)
#define P4_bit       (*(volatile __near __bitf_T *)0xFF04)
#define P5           (*(volatile __near unsigned char  *)0xFF05)
#define P5_bit       (*(volatile __near __bitf_T *)0xFF05)
#define P6           (*(volatile __near unsigned char  *)0xFF06)
#define P6_bit       (*(volatile __near __bitf_T *)0xFF06)
#define P7           (*(volatile __near unsigned char  *)0xFF07)
#define P7_bit       (*(volatile __near __bitf_T *)0xFF07)
#define P8           (*(volatile __near unsigned char  *)0xFF08)
#define P8_bit       (*(volatile __near __bitf_T *)0xFF08)
#define P9           (*(volatile __near unsigned char  *)0xFF09)
#define P9_bit       (*(volatile __near __bitf_T *)0xFF09)
#define P10          (*(volatile __near unsigned char  *)0xFF0A)
#define P10_bit      (*(volatile __near __bitf_T *)0xFF0A)
#define P12          (*(volatile __near unsigned char  *)0xFF0C)
#define P12_bit      (*(volatile __near __bitf_T *)0xFF0C)
#define P13          (*(volatile __near unsigned char  *)0xFF0D)
#define P13_bit      (*(volatile __near __bitf_T *)0xFF0D)
#define P14          (*(volatile __near unsigned char  *)0xFF0E)
#define P14_bit      (*(volatile __near __bitf_T *)0xFF0E)
#define P15          (*(volatile __near unsigned char  *)0xFF0F)
#define P15_bit      (*(volatile __near __bitf_T *)0xFF0F)
#define SDR00        (*(volatile __near unsigned short *)0xFF10)
#define SDR00L       (*(volatile __near unsigned char  *)0xFF10)
#define SDR01        (*(volatile __near unsigned short *)0xFF12)
#define SDR01L       (*(volatile __near unsigned char  *)0xFF12)
#define TDR00        (*(volatile __near unsigned short *)0xFF18)
#define TDR01        (*(volatile __near unsigned short *)0xFF1A)
#define TDR01L       (*(volatile __near unsigned char  *)0xFF1A)
#define TDR01H       (*(volatile __near unsigned char  *)0xFF1B)
#define ADCR         (*(volatile __near unsigned short *)0xFF1E)
#define ADCRH        (*(volatile __near unsigned char  *)0xFF1F)
#define PM0          (*(volatile __near unsigned char  *)0xFF20)
#define PM0_bit      (*(volatile __near __bitf_T *)0xFF20)
#define PM1          (*(volatile __near unsigned char  *)0xFF21)
#define PM1_bit      (*(volatile __near __bitf_T *)0xFF21)
#define PM3          (*(volatile __near unsigned char  *)0xFF23)
#define PM3_bit      (*(volatile __near __bitf_T *)0xFF23)
#define PM4          (*(volatile __near unsigned char  *)0xFF24)
#define PM4_bit      (*(volatile __near __bitf_T *)0xFF24)
#define PM5          (*(volatile __near unsigned char  *)0xFF25)
#define PM5_bit      (*(volatile __near __bitf_T *)0xFF25)
#define PM6          (*(volatile __near unsigned char  *)0xFF26)
#define PM6_bit      (*(volatile __near __bitf_T *)0xFF26)
#define PM7          (*(volatile __near unsigned char  *)0xFF27)
#define PM7_bit      (*(volatile __near __bitf_T *)0xFF27)
#define PM8          (*(volatile __near unsigned char  *)0xFF28)
#define PM8_bit      (*(volatile __near __bitf_T *)0xFF28)
#define PM9          (*(volatile __near unsigned char  *)0xFF29)
#define PM9_bit      (*(volatile __near __bitf_T *)0xFF29)
#define PM10         (*(volatile __near unsigned char  *)0xFF2A)
#define PM10_bit     (*(volatile __near __bitf_T *)0xFF2A)
#define PM12         (*(volatile __near unsigned char  *)0xFF2C)
#define PM12_bit     (*(volatile __near __bitf_T *)0xFF2C)
#define PM14         (*(volatile __near unsigned char  *)0xFF2E)
#define PM14_bit     (*(volatile __near __bitf_T *)0xFF2E)
#define PM15         (*(volatile __near unsigned char  *)0xFF2F)
#define PM15_bit     (*(volatile __near __bitf_T *)0xFF2F)
#define ADM0         (*(volatile __near unsigned char  *)0xFF30)
#define ADM0_bit     (*(volatile __near __bitf_T *)0xFF30)
#define ADCE         (((volatile __near __bitf_T *)0xFF30)->no0)
#define ADCS         (((volatile __near __bitf_T *)0xFF30)->no7)
#define ADS          (*(volatile __near unsigned char  *)0xFF31)
#define ADS_bit      (*(volatile __near __bitf_T *)0xFF31)
#define ADM1         (*(volatile __near unsigned char  *)0xFF32)
#define ADM1_bit     (*(volatile __near __bitf_T *)0xFF32)
#define DACS0        (*(volatile __near unsigned char  *)0xFF34)
#define DAM          (*(volatile __near unsigned char  *)0xFF36)
#define DAM_bit      (*(volatile __near __bitf_T *)0xFF36)
#define DACE0        (((volatile __near __bitf_T *)0xFF36)->no4)
#define KRM          (*(volatile __near unsigned char  *)0xFF37)
#define KRM_bit      (*(volatile __near __bitf_T *)0xFF37)
#define EGP0         (*(volatile __near unsigned char  *)0xFF38)
#define EGP0_bit     (*(volatile __near __bitf_T *)0xFF38)
#define EGN0         (*(volatile __near unsigned char  *)0xFF39)
#define EGN0_bit     (*(volatile __near __bitf_T *)0xFF39)
#define EGP1         (*(volatile __near unsigned char  *)0xFF3A)
#define EGP1_bit     (*(volatile __near __bitf_T *)0xFF3A)
#define EGN1         (*(volatile __near unsigned char  *)0xFF3B)
#define EGN1_bit     (*(volatile __near __bitf_T *)0xFF3B)
#define SDR10        (*(volatile __near unsigned short *)0xFF48)
#define SDR10L       (*(volatile __near unsigned char  *)0xFF48)
#define SDR11        (*(volatile __near unsigned short *)0xFF4A)
#define SDR11L       (*(volatile __near unsigned char  *)0xFF4A)
#define IICA0        (*(volatile __near unsigned char  *)0xFF50)
#define IICS0        (*(volatile __near unsigned char  *)0xFF51)
#define IICS0_bit    (*(volatile __near __bitf_T *)0xFF51)
#define SPD0         (((volatile __near __bitf_T *)0xFF51)->no0)
#define STD0         (((volatile __near __bitf_T *)0xFF51)->no1)
#define ACKD0        (((volatile __near __bitf_T *)0xFF51)->no2)
#define TRC0         (((volatile __near __bitf_T *)0xFF51)->no3)
#define COI0         (((volatile __near __bitf_T *)0xFF51)->no4)
#define EXC0         (((volatile __near __bitf_T *)0xFF51)->no5)
#define ALD0         (((volatile __near __bitf_T *)0xFF51)->no6)
#define MSTS0        (((volatile __near __bitf_T *)0xFF51)->no7)
#define IICF0        (*(volatile __near unsigned char  *)0xFF52)
#define IICF0_bit    (*(volatile __near __bitf_T *)0xFF52)
#define IICRSV0      (((volatile __near __bitf_T *)0xFF52)->no0)
#define STCEN0       (((volatile __near __bitf_T *)0xFF52)->no1)
#define IICBSY0      (((volatile __near __bitf_T *)0xFF52)->no6)
#define STCF0        (((volatile __near __bitf_T *)0xFF52)->no7)
#define SUBCUDW      (*(volatile __near unsigned short *)0xFF54)
#define TRDGRC0      (*(volatile __near unsigned short *)0xFF58)
#define TRDGRD0      (*(volatile __near unsigned short *)0xFF5A)
#define TRDGRC1      (*(volatile __near unsigned short *)0xFF5C)
#define TRDGRD1      (*(volatile __near unsigned short *)0xFF5E)
#define TDR02        (*(volatile __near unsigned short *)0xFF64)
#define TDR03        (*(volatile __near unsigned short *)0xFF66)
#define TDR03L       (*(volatile __near unsigned char  *)0xFF66)
#define TDR03H       (*(volatile __near unsigned char  *)0xFF67)
#define TDR04        (*(volatile __near unsigned short *)0xFF68)
#define TDR05        (*(volatile __near unsigned short *)0xFF6A)
#define TDR06        (*(volatile __near unsigned short *)0xFF6C)
#define TDR07        (*(volatile __near unsigned short *)0xFF6E)
#define TDR10        (*(volatile __near unsigned short *)0xFF70)
#define TDR11        (*(volatile __near unsigned short *)0xFF72)
#define TDR11L       (*(volatile __near unsigned char  *)0xFF72)
#define TDR11H       (*(volatile __near unsigned char  *)0xFF73)
#define TDR12        (*(volatile __near unsigned short *)0xFF74)
#define TDR13        (*(volatile __near unsigned short *)0xFF76)
#define TDR13L       (*(volatile __near unsigned char  *)0xFF76)
#define TDR13H       (*(volatile __near unsigned char  *)0xFF77)
#define TDR14        (*(volatile __near unsigned short *)0xFF78)
#define TDR15        (*(volatile __near unsigned short *)0xFF7A)
#define TDR16        (*(volatile __near unsigned short *)0xFF7C)
#define TDR17        (*(volatile __near unsigned short *)0xFF7E)
#define SEC          (*(volatile __near unsigned char  *)0xFF92)
#define MIN          (*(volatile __near unsigned char  *)0xFF93)
#define HOUR         (*(volatile __near unsigned char  *)0xFF94)
#define WEEK         (*(volatile __near unsigned char  *)0xFF95)
#define DAY          (*(volatile __near unsigned char  *)0xFF96)
#define MONTH        (*(volatile __near unsigned char  *)0xFF97)
#define YEAR         (*(volatile __near unsigned char  *)0xFF98)
#define SUBCUD       (*(volatile __near unsigned char  *)0xFF99)
#define ALARMWM      (*(volatile __near unsigned char  *)0xFF9A)
#define ALARMWH      (*(volatile __near unsigned char  *)0xFF9B)
#define ALARMWW      (*(volatile __near unsigned char  *)0xFF9C)
#define RTCC0        (*(volatile __near unsigned char  *)0xFF9D)
#define RTCC0_bit    (*(volatile __near __bitf_T *)0xFF9D)
#define RCLOE1       (((volatile __near __bitf_T *)0xFF9D)->no5)
#define RTCE         (((volatile __near __bitf_T *)0xFF9D)->no7)
#define RTCC1        (*(volatile __near unsigned char  *)0xFF9E)
#define RTCC1_bit    (*(volatile __near __bitf_T *)0xFF9E)
#define RWAIT        (((volatile __near __bitf_T *)0xFF9E)->no0)
#define RWST         (((volatile __near __bitf_T *)0xFF9E)->no1)
#define RIFG         (((volatile __near __bitf_T *)0xFF9E)->no3)
#define WAFG         (((volatile __near __bitf_T *)0xFF9E)->no4)
#define WALIE        (((volatile __near __bitf_T *)0xFF9E)->no6)
#define WALE         (((volatile __near __bitf_T *)0xFF9E)->no7)
#define CMC          (*(volatile __near unsigned char  *)0xFFA0)
#define CSC          (*(volatile __near unsigned char  *)0xFFA1)
#define CSC_bit      (*(volatile __near __bitf_T *)0xFFA1)
#define HIOSTOP      (((volatile __near __bitf_T *)0xFFA1)->no0)
#define XTSTOP       (((volatile __near __bitf_T *)0xFFA1)->no6)
#define MSTOP        (((volatile __near __bitf_T *)0xFFA1)->no7)
#define OSTC         (*(volatile __near unsigned char  *)0xFFA2)
#define OSTC_bit     (*(volatile __near __bitf_T *)0xFFA2)
#define OSTS         (*(volatile __near unsigned char  *)0xFFA3)
#define CKC          (*(volatile __near unsigned char  *)0xFFA4)
#define CKC_bit      (*(volatile __near __bitf_T *)0xFFA4)
#define MCM0         (((volatile __near __bitf_T *)0xFFA4)->no4)
#define MCS          (((volatile __near __bitf_T *)0xFFA4)->no5)
#define CSS          (((volatile __near __bitf_T *)0xFFA4)->no6)
#define CLS          (((volatile __near __bitf_T *)0xFFA4)->no7)
#define CKS0         (*(volatile __near unsigned char  *)0xFFA5)
#define CKS0_bit     (*(volatile __near __bitf_T *)0xFFA5)
#define PCLOE0       (((volatile __near __bitf_T *)0xFFA5)->no7)
#define RESF         (*(volatile __near unsigned char  *)0xFFA8)
#define LVIM         (*(volatile __near unsigned char  *)0xFFA9)
#define LVIM_bit     (*(volatile __near __bitf_T *)0xFFA9)
#define LVIF         (((volatile __near __bitf_T *)0xFFA9)->no0)
#define LVIOMSK      (((volatile __near __bitf_T *)0xFFA9)->no1)
#define LVISEN       (((volatile __near __bitf_T *)0xFFA9)->no7)
#define LVIS         (*(volatile __near unsigned char  *)0xFFAA)
#define LVIS_bit     (*(volatile __near __bitf_T *)0xFFAA)
#define LVILV        (((volatile __near __bitf_T *)0xFFAA)->no0)
#define LVIMD        (((volatile __near __bitf_T *)0xFFAA)->no7)
#define WDTE         (*(volatile __near unsigned char  *)0xFFAB)
#define CRCIN        (*(volatile __near unsigned char  *)0xFFAC)
#define IF2          (*(volatile __near unsigned short *)0xFFD0)
#define IF2L         (*(volatile __near unsigned char  *)0xFFD0)
#define IF2L_bit     (*(volatile __near __bitf_T *)0xFFD0)
#define IF2H         (*(volatile __near unsigned char  *)0xFFD1)
#define IF2H_bit     (*(volatile __near __bitf_T *)0xFFD1)
#define TMIF05       (((volatile __near __bitf_T *)0xFFD0)->no0)
#define TMIF06       (((volatile __near __bitf_T *)0xFFD0)->no1)
#define TMIF07       (((volatile __near __bitf_T *)0xFFD0)->no2)
#define LIN0WUPIF    (((volatile __near __bitf_T *)0xFFD0)->no3)
#define PIF11        (((volatile __near __bitf_T *)0xFFD0)->no3)
#define KRIF         (((volatile __near __bitf_T *)0xFFD0)->no4)
#define CAN0ERRIF    (((volatile __near __bitf_T *)0xFFD0)->no5)
#define CAN0WUPIF    (((volatile __near __bitf_T *)0xFFD0)->no6)
#define CAN0CFRIF    (((volatile __near __bitf_T *)0xFFD0)->no7)
#define CAN0TRMIF    (((volatile __near __bitf_T *)0xFFD1)->no0)
#define CANGRFRIF    (((volatile __near __bitf_T *)0xFFD1)->no1)
#define CANGERRIF    (((volatile __near __bitf_T *)0xFFD1)->no2)
#define TMIF10       (((volatile __near __bitf_T *)0xFFD1)->no3)
#define TMIF11       (((volatile __near __bitf_T *)0xFFD1)->no4)
#define TMIF12       (((volatile __near __bitf_T *)0xFFD1)->no5)
#define TMIF13       (((volatile __near __bitf_T *)0xFFD1)->no6)
#define FLIF         (((volatile __near __bitf_T *)0xFFD1)->no7)
#define IF3L         (*(volatile __near unsigned char  *)0xFFD2)
#define IF3L_bit     (*(volatile __near __bitf_T *)0xFFD2)
#define LIN1WUPIF    (((volatile __near __bitf_T *)0xFFD2)->no0)
#define PIF12        (((volatile __near __bitf_T *)0xFFD2)->no0)
#define LIN1TRMIF    (((volatile __near __bitf_T *)0xFFD2)->no1)
#define LIN1RVCIF    (((volatile __near __bitf_T *)0xFFD2)->no2)
#define LIN1IF       (((volatile __near __bitf_T *)0xFFD2)->no3)
#define LIN1STAIF    (((volatile __near __bitf_T *)0xFFD2)->no3)
#define TMIF14       (((volatile __near __bitf_T *)0xFFD2)->no4)
#define TMIF15       (((volatile __near __bitf_T *)0xFFD2)->no5)
#define TMIF16       (((volatile __near __bitf_T *)0xFFD2)->no6)
#define TMIF17       (((volatile __near __bitf_T *)0xFFD2)->no7)
#define MK2          (*(volatile __near unsigned short *)0xFFD4)
#define MK2L         (*(volatile __near unsigned char  *)0xFFD4)
#define MK2L_bit     (*(volatile __near __bitf_T *)0xFFD4)
#define MK2H         (*(volatile __near unsigned char  *)0xFFD5)
#define MK2H_bit     (*(volatile __near __bitf_T *)0xFFD5)
#define TMMK05       (((volatile __near __bitf_T *)0xFFD4)->no0)
#define TMMK06       (((volatile __near __bitf_T *)0xFFD4)->no1)
#define TMMK07       (((volatile __near __bitf_T *)0xFFD4)->no2)
#define LIN0WUPMK    (((volatile __near __bitf_T *)0xFFD4)->no3)
#define PMK11        (((volatile __near __bitf_T *)0xFFD4)->no3)
#define KRMK         (((volatile __near __bitf_T *)0xFFD4)->no4)
#define CAN0ERRMK    (((volatile __near __bitf_T *)0xFFD4)->no5)
#define CAN0WUPMK    (((volatile __near __bitf_T *)0xFFD4)->no6)
#define CAN0CFRMK    (((volatile __near __bitf_T *)0xFFD4)->no7)
#define CAN0TRMMK    (((volatile __near __bitf_T *)0xFFD5)->no0)
#define CANGRFRMK    (((volatile __near __bitf_T *)0xFFD5)->no1)
#define CANGERRMK    (((volatile __near __bitf_T *)0xFFD5)->no2)
#define TMMK10       (((volatile __near __bitf_T *)0xFFD5)->no3)
#define TMMK11       (((volatile __near __bitf_T *)0xFFD5)->no4)
#define TMMK12       (((volatile __near __bitf_T *)0xFFD5)->no5)
#define TMMK13       (((volatile __near __bitf_T *)0xFFD5)->no6)
#define FLMK         (((volatile __near __bitf_T *)0xFFD5)->no7)
#define MK3L         (*(volatile __near unsigned char  *)0xFFD6)
#define MK3L_bit     (*(volatile __near __bitf_T *)0xFFD6)
#define LIN1WUPMK    (((volatile __near __bitf_T *)0xFFD6)->no0)
#define PMK12        (((volatile __near __bitf_T *)0xFFD6)->no0)
#define LIN1TRMMK    (((volatile __near __bitf_T *)0xFFD6)->no1)
#define LIN1RVCMK    (((volatile __near __bitf_T *)0xFFD6)->no2)
#define LIN1MK       (((volatile __near __bitf_T *)0xFFD6)->no3)
#define LIN1STAMK    (((volatile __near __bitf_T *)0xFFD6)->no3)
#define TMMK14       (((volatile __near __bitf_T *)0xFFD6)->no4)
#define TMMK15       (((volatile __near __bitf_T *)0xFFD6)->no5)
#define TMMK16       (((volatile __near __bitf_T *)0xFFD6)->no6)
#define TMMK17       (((volatile __near __bitf_T *)0xFFD6)->no7)
#define PR02         (*(volatile __near unsigned short *)0xFFD8)
#define PR02L        (*(volatile __near unsigned char  *)0xFFD8)
#define PR02L_bit    (*(volatile __near __bitf_T *)0xFFD8)
#define PR02H        (*(volatile __near unsigned char  *)0xFFD9)
#define PR02H_bit    (*(volatile __near __bitf_T *)0xFFD9)
#define TMPR005      (((volatile __near __bitf_T *)0xFFD8)->no0)
#define TMPR006      (((volatile __near __bitf_T *)0xFFD8)->no1)
#define TMPR007      (((volatile __near __bitf_T *)0xFFD8)->no2)
#define LIN0WUPPR0   (((volatile __near __bitf_T *)0xFFD8)->no3)
#define PPR011       (((volatile __near __bitf_T *)0xFFD8)->no3)
#define KRPR0        (((volatile __near __bitf_T *)0xFFD8)->no4)
#define CAN0ERRPR0   (((volatile __near __bitf_T *)0xFFD8)->no5)
#define CAN0WUPPR0   (((volatile __near __bitf_T *)0xFFD8)->no6)
#define CAN0CFRPR0   (((volatile __near __bitf_T *)0xFFD8)->no7)
#define CAN0TRMPR0   (((volatile __near __bitf_T *)0xFFD9)->no0)
#define CANGRFRPR0   (((volatile __near __bitf_T *)0xFFD9)->no1)
#define CANGERRPR0   (((volatile __near __bitf_T *)0xFFD9)->no2)
#define TMPR010      (((volatile __near __bitf_T *)0xFFD9)->no3)
#define TMPR011      (((volatile __near __bitf_T *)0xFFD9)->no4)
#define TMPR012      (((volatile __near __bitf_T *)0xFFD9)->no5)
#define TMPR013      (((volatile __near __bitf_T *)0xFFD9)->no6)
#define FLPR0        (((volatile __near __bitf_T *)0xFFD9)->no7)
#define PR03L        (*(volatile __near unsigned char  *)0xFFDA)
#define PR03L_bit    (*(volatile __near __bitf_T *)0xFFDA)
#define LIN1WUPPR0   (((volatile __near __bitf_T *)0xFFDA)->no0)
#define PPR012       (((volatile __near __bitf_T *)0xFFDA)->no0)
#define LIN1TRMPR0   (((volatile __near __bitf_T *)0xFFDA)->no1)
#define LIN1RVCPR0   (((volatile __near __bitf_T *)0xFFDA)->no2)
#define LIN1PR0      (((volatile __near __bitf_T *)0xFFDA)->no3)
#define LIN1STAPR0   (((volatile __near __bitf_T *)0xFFDA)->no3)
#define TMPR014      (((volatile __near __bitf_T *)0xFFDA)->no4)
#define TMPR015      (((volatile __near __bitf_T *)0xFFDA)->no5)
#define TMPR016      (((volatile __near __bitf_T *)0xFFDA)->no6)
#define TMPR017      (((volatile __near __bitf_T *)0xFFDA)->no7)
#define PR12         (*(volatile __near unsigned short *)0xFFDC)
#define PR12L        (*(volatile __near unsigned char  *)0xFFDC)
#define PR12L_bit    (*(volatile __near __bitf_T *)0xFFDC)
#define PR12H        (*(volatile __near unsigned char  *)0xFFDD)
#define PR12H_bit    (*(volatile __near __bitf_T *)0xFFDD)
#define TMPR105      (((volatile __near __bitf_T *)0xFFDC)->no0)
#define TMPR106      (((volatile __near __bitf_T *)0xFFDC)->no1)
#define TMPR107      (((volatile __near __bitf_T *)0xFFDC)->no2)
#define LIN0WUPPR1   (((volatile __near __bitf_T *)0xFFDC)->no3)
#define PPR111       (((volatile __near __bitf_T *)0xFFDC)->no3)
#define KRPR1        (((volatile __near __bitf_T *)0xFFDC)->no4)
#define CAN0ERRPR1   (((volatile __near __bitf_T *)0xFFDC)->no5)
#define CAN0WUPPR1   (((volatile __near __bitf_T *)0xFFDC)->no6)
#define CAN0CFRPR1   (((volatile __near __bitf_T *)0xFFDC)->no7)
#define CAN0TRMPR1   (((volatile __near __bitf_T *)0xFFDD)->no0)
#define CANGRFRPR1   (((volatile __near __bitf_T *)0xFFDD)->no1)
#define CANGERRPR1   (((volatile __near __bitf_T *)0xFFDD)->no2)
#define TMPR110      (((volatile __near __bitf_T *)0xFFDD)->no3)
#define TMPR111      (((volatile __near __bitf_T *)0xFFDD)->no4)
#define TMPR112      (((volatile __near __bitf_T *)0xFFDD)->no5)
#define TMPR113      (((volatile __near __bitf_T *)0xFFDD)->no6)
#define FLPR1        (((volatile __near __bitf_T *)0xFFDD)->no7)
#define PR13L        (*(volatile __near unsigned char  *)0xFFDE)
#define PR13L_bit    (*(volatile __near __bitf_T *)0xFFDE)
#define LIN1WUPPR1   (((volatile __near __bitf_T *)0xFFDE)->no0)
#define PPR112       (((volatile __near __bitf_T *)0xFFDE)->no0)
#define LIN1TRMPR1   (((volatile __near __bitf_T *)0xFFDE)->no1)
#define LIN1RVCPR1   (((volatile __near __bitf_T *)0xFFDE)->no2)
#define LIN1PR1      (((volatile __near __bitf_T *)0xFFDE)->no3)
#define LIN1STAPR1   (((volatile __near __bitf_T *)0xFFDE)->no3)
#define TMPR114      (((volatile __near __bitf_T *)0xFFDE)->no4)
#define TMPR115      (((volatile __near __bitf_T *)0xFFDE)->no5)
#define TMPR116      (((volatile __near __bitf_T *)0xFFDE)->no6)
#define TMPR117      (((volatile __near __bitf_T *)0xFFDE)->no7)
#define IF0          (*(volatile __near unsigned short *)0xFFE0)
#define IF0L         (*(volatile __near unsigned char  *)0xFFE0)
#define IF0L_bit     (*(volatile __near __bitf_T *)0xFFE0)
#define IF0H         (*(volatile __near unsigned char  *)0xFFE1)
#define IF0H_bit     (*(volatile __near __bitf_T *)0xFFE1)
#define WDTIIF       (((volatile __near __bitf_T *)0xFFE0)->no0)
#define LVIIF        (((volatile __near __bitf_T *)0xFFE0)->no1)
#define PIF0         (((volatile __near __bitf_T *)0xFFE0)->no2)
#define PIF1         (((volatile __near __bitf_T *)0xFFE0)->no3)
#define PIF2         (((volatile __near __bitf_T *)0xFFE0)->no4)
#define PIF3         (((volatile __near __bitf_T *)0xFFE0)->no5)
#define PIF4         (((volatile __near __bitf_T *)0xFFE0)->no6)
#define SPMIF        (((volatile __near __bitf_T *)0xFFE0)->no6)
#define CMPIF0       (((volatile __near __bitf_T *)0xFFE0)->no7)
#define PIF5         (((volatile __near __bitf_T *)0xFFE0)->no7)
#define CLMIF        (((volatile __near __bitf_T *)0xFFE1)->no0)
#define PIF13        (((volatile __near __bitf_T *)0xFFE1)->no0)
#define CSIIF00      (((volatile __near __bitf_T *)0xFFE1)->no1)
#define IICIF00      (((volatile __near __bitf_T *)0xFFE1)->no1)
#define STIF0        (((volatile __near __bitf_T *)0xFFE1)->no1)
#define CSIIF01      (((volatile __near __bitf_T *)0xFFE1)->no2)
#define IICIF01      (((volatile __near __bitf_T *)0xFFE1)->no2)
#define SRIF0        (((volatile __near __bitf_T *)0xFFE1)->no2)
#define TRDIF0       (((volatile __near __bitf_T *)0xFFE1)->no3)
#define TRDIF1       (((volatile __near __bitf_T *)0xFFE1)->no4)
#define TRJIF0       (((volatile __near __bitf_T *)0xFFE1)->no5)
#define RAMIF        (((volatile __near __bitf_T *)0xFFE1)->no6)
#define LIN0TRMIF    (((volatile __near __bitf_T *)0xFFE1)->no7)
#define IF1          (*(volatile __near unsigned short *)0xFFE2)
#define IF1L         (*(volatile __near unsigned char  *)0xFFE2)
#define IF1L_bit     (*(volatile __near __bitf_T *)0xFFE2)
#define IF1H         (*(volatile __near unsigned char  *)0xFFE3)
#define IF1H_bit     (*(volatile __near __bitf_T *)0xFFE3)
#define LIN0RVCIF    (((volatile __near __bitf_T *)0xFFE2)->no0)
#define LIN0IF       (((volatile __near __bitf_T *)0xFFE2)->no1)
#define LIN0STAIF    (((volatile __near __bitf_T *)0xFFE2)->no1)
#define IICAIF0      (((volatile __near __bitf_T *)0xFFE2)->no2)
#define PIF8         (((volatile __near __bitf_T *)0xFFE2)->no3)
#define RTCIF        (((volatile __near __bitf_T *)0xFFE2)->no3)
#define TMIF00       (((volatile __near __bitf_T *)0xFFE2)->no4)
#define TMIF01       (((volatile __near __bitf_T *)0xFFE2)->no5)
#define TMIF02       (((volatile __near __bitf_T *)0xFFE2)->no6)
#define TMIF03       (((volatile __near __bitf_T *)0xFFE2)->no7)
#define ADIF         (((volatile __near __bitf_T *)0xFFE3)->no0)
#define PIF6         (((volatile __near __bitf_T *)0xFFE3)->no1)
#define TMIF11H      (((volatile __near __bitf_T *)0xFFE3)->no1)
#define PIF7         (((volatile __near __bitf_T *)0xFFE3)->no2)
#define TMIF13H      (((volatile __near __bitf_T *)0xFFE3)->no2)
#define PIF9         (((volatile __near __bitf_T *)0xFFE3)->no3)
#define TMIF01H      (((volatile __near __bitf_T *)0xFFE3)->no3)
#define PIF10        (((volatile __near __bitf_T *)0xFFE3)->no4)
#define TMIF03H      (((volatile __near __bitf_T *)0xFFE3)->no4)
#define CSIIF10      (((volatile __near __bitf_T *)0xFFE3)->no5)
#define IICIF10      (((volatile __near __bitf_T *)0xFFE3)->no5)
#define STIF1        (((volatile __near __bitf_T *)0xFFE3)->no5)
#define CSIIF11      (((volatile __near __bitf_T *)0xFFE3)->no6)
#define IICIF11      (((volatile __near __bitf_T *)0xFFE3)->no6)
#define SRIF1        (((volatile __near __bitf_T *)0xFFE3)->no6)
#define TMIF04       (((volatile __near __bitf_T *)0xFFE3)->no7)
#define MK0          (*(volatile __near unsigned short *)0xFFE4)
#define MK0L         (*(volatile __near unsigned char  *)0xFFE4)
#define MK0L_bit     (*(volatile __near __bitf_T *)0xFFE4)
#define MK0H         (*(volatile __near unsigned char  *)0xFFE5)
#define MK0H_bit     (*(volatile __near __bitf_T *)0xFFE5)
#define WDTIMK       (((volatile __near __bitf_T *)0xFFE4)->no0)
#define LVIMK        (((volatile __near __bitf_T *)0xFFE4)->no1)
#define PMK0         (((volatile __near __bitf_T *)0xFFE4)->no2)
#define PMK1         (((volatile __near __bitf_T *)0xFFE4)->no3)
#define PMK2         (((volatile __near __bitf_T *)0xFFE4)->no4)
#define PMK3         (((volatile __near __bitf_T *)0xFFE4)->no5)
#define PMK4         (((volatile __near __bitf_T *)0xFFE4)->no6)
#define SPMMK        (((volatile __near __bitf_T *)0xFFE4)->no6)
#define CMPMK0       (((volatile __near __bitf_T *)0xFFE4)->no7)
#define PMK5         (((volatile __near __bitf_T *)0xFFE4)->no7)
#define CLMMK        (((volatile __near __bitf_T *)0xFFE5)->no0)
#define PMK13        (((volatile __near __bitf_T *)0xFFE5)->no0)
#define CSIMK00      (((volatile __near __bitf_T *)0xFFE5)->no1)
#define IICMK00      (((volatile __near __bitf_T *)0xFFE5)->no1)
#define STMK0        (((volatile __near __bitf_T *)0xFFE5)->no1)
#define CSIMK01      (((volatile __near __bitf_T *)0xFFE5)->no2)
#define IICMK01      (((volatile __near __bitf_T *)0xFFE5)->no2)
#define SRMK0        (((volatile __near __bitf_T *)0xFFE5)->no2)
#define TRDMK0       (((volatile __near __bitf_T *)0xFFE5)->no3)
#define TRDMK1       (((volatile __near __bitf_T *)0xFFE5)->no4)
#define TRJMK0       (((volatile __near __bitf_T *)0xFFE5)->no5)
#define RAMMK        (((volatile __near __bitf_T *)0xFFE5)->no6)
#define LIN0TRMMK    (((volatile __near __bitf_T *)0xFFE5)->no7)
#define MK1          (*(volatile __near unsigned short *)0xFFE6)
#define MK1L         (*(volatile __near unsigned char  *)0xFFE6)
#define MK1L_bit     (*(volatile __near __bitf_T *)0xFFE6)
#define MK1H         (*(volatile __near unsigned char  *)0xFFE7)
#define MK1H_bit     (*(volatile __near __bitf_T *)0xFFE7)
#define LIN0RVCMK    (((volatile __near __bitf_T *)0xFFE6)->no0)
#define LIN0MK       (((volatile __near __bitf_T *)0xFFE6)->no1)
#define LIN0STAMK    (((volatile __near __bitf_T *)0xFFE6)->no1)
#define IICAMK0      (((volatile __near __bitf_T *)0xFFE6)->no2)
#define PMK8         (((volatile __near __bitf_T *)0xFFE6)->no3)
#define RTCMK        (((volatile __near __bitf_T *)0xFFE6)->no3)
#define TMMK00       (((volatile __near __bitf_T *)0xFFE6)->no4)
#define TMMK01       (((volatile __near __bitf_T *)0xFFE6)->no5)
#define TMMK02       (((volatile __near __bitf_T *)0xFFE6)->no6)
#define TMMK03       (((volatile __near __bitf_T *)0xFFE6)->no7)
#define ADMK         (((volatile __near __bitf_T *)0xFFE7)->no0)
#define PMK6         (((volatile __near __bitf_T *)0xFFE7)->no1)
#define TMMK11H      (((volatile __near __bitf_T *)0xFFE7)->no1)
#define PMK7         (((volatile __near __bitf_T *)0xFFE7)->no2)
#define TMMK13H      (((volatile __near __bitf_T *)0xFFE7)->no2)
#define PMK9         (((volatile __near __bitf_T *)0xFFE7)->no3)
#define TMMK01H      (((volatile __near __bitf_T *)0xFFE7)->no3)
#define PMK10        (((volatile __near __bitf_T *)0xFFE7)->no4)
#define TMMK03H      (((volatile __near __bitf_T *)0xFFE7)->no4)
#define CSIMK10      (((volatile __near __bitf_T *)0xFFE7)->no5)
#define IICMK10      (((volatile __near __bitf_T *)0xFFE7)->no5)
#define STMK1        (((volatile __near __bitf_T *)0xFFE7)->no5)
#define CSIMK11      (((volatile __near __bitf_T *)0xFFE7)->no6)
#define IICMK11      (((volatile __near __bitf_T *)0xFFE7)->no6)
#define SRMK1        (((volatile __near __bitf_T *)0xFFE7)->no6)
#define TMMK04       (((volatile __near __bitf_T *)0xFFE7)->no7)
#define PR00         (*(volatile __near unsigned short *)0xFFE8)
#define PR00L        (*(volatile __near unsigned char  *)0xFFE8)
#define PR00L_bit    (*(volatile __near __bitf_T *)0xFFE8)
#define PR00H        (*(volatile __near unsigned char  *)0xFFE9)
#define PR00H_bit    (*(volatile __near __bitf_T *)0xFFE9)
#define WDTIPR0      (((volatile __near __bitf_T *)0xFFE8)->no0)
#define LVIPR0       (((volatile __near __bitf_T *)0xFFE8)->no1)
#define PPR00        (((volatile __near __bitf_T *)0xFFE8)->no2)
#define PPR01        (((volatile __near __bitf_T *)0xFFE8)->no3)
#define PPR02        (((volatile __near __bitf_T *)0xFFE8)->no4)
#define PPR03        (((volatile __near __bitf_T *)0xFFE8)->no5)
#define PPR04        (((volatile __near __bitf_T *)0xFFE8)->no6)
#define SPMPR0       (((volatile __near __bitf_T *)0xFFE8)->no6)
#define CMPPR00      (((volatile __near __bitf_T *)0xFFE8)->no7)
#define PPR05        (((volatile __near __bitf_T *)0xFFE8)->no7)
#define CLMPR0       (((volatile __near __bitf_T *)0xFFE9)->no0)
#define PPR013       (((volatile __near __bitf_T *)0xFFE9)->no0)
#define CSIPR000     (((volatile __near __bitf_T *)0xFFE9)->no1)
#define IICPR000     (((volatile __near __bitf_T *)0xFFE9)->no1)
#define STPR00       (((volatile __near __bitf_T *)0xFFE9)->no1)
#define CSIPR001     (((volatile __near __bitf_T *)0xFFE9)->no2)
#define IICPR001     (((volatile __near __bitf_T *)0xFFE9)->no2)
#define SRPR00       (((volatile __near __bitf_T *)0xFFE9)->no2)
#define TRDPR00      (((volatile __near __bitf_T *)0xFFE9)->no3)
#define TRDPR01      (((volatile __near __bitf_T *)0xFFE9)->no4)
#define TRJPR00      (((volatile __near __bitf_T *)0xFFE9)->no5)
#define RAMPR0       (((volatile __near __bitf_T *)0xFFE9)->no6)
#define LIN0TRMPR0   (((volatile __near __bitf_T *)0xFFE9)->no7)
#define PR01         (*(volatile __near unsigned short *)0xFFEA)
#define PR01L        (*(volatile __near unsigned char  *)0xFFEA)
#define PR01L_bit    (*(volatile __near __bitf_T *)0xFFEA)
#define PR01H        (*(volatile __near unsigned char  *)0xFFEB)
#define PR01H_bit    (*(volatile __near __bitf_T *)0xFFEB)
#define LIN0RVCPR0   (((volatile __near __bitf_T *)0xFFEA)->no0)
#define LIN0PR0      (((volatile __near __bitf_T *)0xFFEA)->no1)
#define LIN0STAPR0   (((volatile __near __bitf_T *)0xFFEA)->no1)
#define IICAPR00     (((volatile __near __bitf_T *)0xFFEA)->no2)
#define PPR08        (((volatile __near __bitf_T *)0xFFEA)->no3)
#define RTCPR0       (((volatile __near __bitf_T *)0xFFEA)->no3)
#define TMPR000      (((volatile __near __bitf_T *)0xFFEA)->no4)
#define TMPR001      (((volatile __near __bitf_T *)0xFFEA)->no5)
#define TMPR002      (((volatile __near __bitf_T *)0xFFEA)->no6)
#define TMPR003      (((volatile __near __bitf_T *)0xFFEA)->no7)
#define ADPR0        (((volatile __near __bitf_T *)0xFFEB)->no0)
#define PPR06        (((volatile __near __bitf_T *)0xFFEB)->no1)
#define TMPR011H     (((volatile __near __bitf_T *)0xFFEB)->no1)
#define PPR07        (((volatile __near __bitf_T *)0xFFEB)->no2)
#define TMPR013H     (((volatile __near __bitf_T *)0xFFEB)->no2)
#define PPR09        (((volatile __near __bitf_T *)0xFFEB)->no3)
#define TMPR001H     (((volatile __near __bitf_T *)0xFFEB)->no3)
#define PPR010       (((volatile __near __bitf_T *)0xFFEB)->no4)
#define TMPR003H     (((volatile __near __bitf_T *)0xFFEB)->no4)
#define CSIPR010     (((volatile __near __bitf_T *)0xFFEB)->no5)
#define IICPR010     (((volatile __near __bitf_T *)0xFFEB)->no5)
#define STPR01       (((volatile __near __bitf_T *)0xFFEB)->no5)
#define CSIPR011     (((volatile __near __bitf_T *)0xFFEB)->no6)
#define IICPR011     (((volatile __near __bitf_T *)0xFFEB)->no6)
#define SRPR01       (((volatile __near __bitf_T *)0xFFEB)->no6)
#define TMPR004      (((volatile __near __bitf_T *)0xFFEB)->no7)
#define PR10         (*(volatile __near unsigned short *)0xFFEC)
#define PR10L        (*(volatile __near unsigned char  *)0xFFEC)
#define PR10L_bit    (*(volatile __near __bitf_T *)0xFFEC)
#define PR10H        (*(volatile __near unsigned char  *)0xFFED)
#define PR10H_bit    (*(volatile __near __bitf_T *)0xFFED)
#define WDTIPR1      (((volatile __near __bitf_T *)0xFFEC)->no0)
#define LVIPR1       (((volatile __near __bitf_T *)0xFFEC)->no1)
#define PPR10        (((volatile __near __bitf_T *)0xFFEC)->no2)
#define PPR11        (((volatile __near __bitf_T *)0xFFEC)->no3)
#define PPR12        (((volatile __near __bitf_T *)0xFFEC)->no4)
#define PPR13        (((volatile __near __bitf_T *)0xFFEC)->no5)
#define PPR14        (((volatile __near __bitf_T *)0xFFEC)->no6)
#define SPMPR1       (((volatile __near __bitf_T *)0xFFEC)->no6)
#define CMPPR10      (((volatile __near __bitf_T *)0xFFEC)->no7)
#define PPR15        (((volatile __near __bitf_T *)0xFFEC)->no7)
#define CLMPR1       (((volatile __near __bitf_T *)0xFFED)->no0)
#define PPR113       (((volatile __near __bitf_T *)0xFFED)->no0)
#define CSIPR100     (((volatile __near __bitf_T *)0xFFED)->no1)
#define IICPR100     (((volatile __near __bitf_T *)0xFFED)->no1)
#define STPR10       (((volatile __near __bitf_T *)0xFFED)->no1)
#define CSIPR101     (((volatile __near __bitf_T *)0xFFED)->no2)
#define IICPR101     (((volatile __near __bitf_T *)0xFFED)->no2)
#define SRPR10       (((volatile __near __bitf_T *)0xFFED)->no2)
#define TRDPR10      (((volatile __near __bitf_T *)0xFFED)->no3)
#define TRDPR11      (((volatile __near __bitf_T *)0xFFED)->no4)
#define TRJPR10      (((volatile __near __bitf_T *)0xFFED)->no5)
#define RAMPR1       (((volatile __near __bitf_T *)0xFFED)->no6)
#define LIN0TRMPR1   (((volatile __near __bitf_T *)0xFFED)->no7)
#define PR11         (*(volatile __near unsigned short *)0xFFEE)
#define PR11L        (*(volatile __near unsigned char  *)0xFFEE)
#define PR11L_bit    (*(volatile __near __bitf_T *)0xFFEE)
#define PR11H        (*(volatile __near unsigned char  *)0xFFEF)
#define PR11H_bit    (*(volatile __near __bitf_T *)0xFFEF)
#define LIN0RVCPR1   (((volatile __near __bitf_T *)0xFFEE)->no0)
#define LIN0PR1      (((volatile __near __bitf_T *)0xFFEE)->no1)
#define LIN0STAPR1   (((volatile __near __bitf_T *)0xFFEE)->no1)
#define IICAPR10     (((volatile __near __bitf_T *)0xFFEE)->no2)
#define PPR18        (((volatile __near __bitf_T *)0xFFEE)->no3)
#define RTCPR1       (((volatile __near __bitf_T *)0xFFEE)->no3)
#define TMPR100      (((volatile __near __bitf_T *)0xFFEE)->no4)
#define TMPR101      (((volatile __near __bitf_T *)0xFFEE)->no5)
#define TMPR102      (((volatile __near __bitf_T *)0xFFEE)->no6)
#define TMPR103      (((volatile __near __bitf_T *)0xFFEE)->no7)
#define ADPR1        (((volatile __near __bitf_T *)0xFFEF)->no0)
#define PPR16        (((volatile __near __bitf_T *)0xFFEF)->no1)
#define TMPR111H     (((volatile __near __bitf_T *)0xFFEF)->no1)
#define PPR17        (((volatile __near __bitf_T *)0xFFEF)->no2)
#define TMPR113H     (((volatile __near __bitf_T *)0xFFEF)->no2)
#define PPR19        (((volatile __near __bitf_T *)0xFFEF)->no3)
#define TMPR101H     (((volatile __near __bitf_T *)0xFFEF)->no3)
#define PPR110       (((volatile __near __bitf_T *)0xFFEF)->no4)
#define TMPR103H     (((volatile __near __bitf_T *)0xFFEF)->no4)
#define CSIPR110     (((volatile __near __bitf_T *)0xFFEF)->no5)
#define IICPR110     (((volatile __near __bitf_T *)0xFFEF)->no5)
#define STPR11       (((volatile __near __bitf_T *)0xFFEF)->no5)
#define CSIPR111     (((volatile __near __bitf_T *)0xFFEF)->no6)
#define IICPR111     (((volatile __near __bitf_T *)0xFFEF)->no6)
#define SRPR11       (((volatile __near __bitf_T *)0xFFEF)->no6)
#define TMPR104      (((volatile __near __bitf_T *)0xFFEF)->no7)
#define MACRL        (*(volatile __near unsigned short *)0xFFF0)
#define MACRH        (*(volatile __near unsigned short *)0xFFF2)
#define PMC          (*(volatile __near unsigned char  *)0xFFFE)
#define PMC_bit      (*(volatile __near __bitf_T *)0xFFFE)
#define MAA          (((volatile __near __bitf_T *)0xFFFE)->no0)


#define INTSRO                          0x0004
#define INTWDTI                         0x0004
#define INTLVI                          0x0006
#define INTP0                           0x0008
#define INTP1                           0x000A
#define INTP2                           0x000C
#define INTP3                           0x000E
#define INTP4                           0x0010
#define INTSPM                          0x0010
#define INTCMP0                         0x0012
#define INTP5                           0x0012
#define INTCLM                          0x0014
#define INTP13                          0x0014
#define INTCSI00                        0x0016
#define INTIIC00                        0x0016
#define INTST0                          0x0016
#define INTCSI01                        0x0018
#define INTIIC01                        0x0018
#define INTSR0                          0x0018
#define INTTRD0                         0x001A
#define INTTRD1                         0x001C
#define INTTRJ0                         0x001E
#define INTRAM                          0x0020
#define INTLIN0TRM                      0x0022
#define INTLIN0RVC                      0x0024
#define INTLIN0                         0x0026
#define INTLIN0STA                      0x0026
#define INTIICA0                        0x0028
#define INTP8                           0x002A
#define INTRTC                          0x002A
#define INTTM00                         0x002C
#define INTTM01                         0x002E
#define INTTM02                         0x0030
#define INTTM03                         0x0032
#define INTAD                           0x0034
#define INTP6                           0x0036
#define INTTM11H                        0x0036
#define INTP7                           0x0038
#define INTTM13H                        0x0038
#define INTP9                           0x003A
#define INTTM01H                        0x003A
#define INTP10                          0x003C
#define INTTM03H                        0x003C
#define INTCSI10                        0x003E
#define INTIIC10                        0x003E
#define INTST1                          0x003E
#define INTCSI11                        0x0040
#define INTIIC11                        0x0040
#define INTSR1                          0x0040
#define INTTM04                         0x0042
#define INTTM05                         0x0044
#define INTTM06                         0x0046
#define INTTM07                         0x0048
#define INTLIN0WUP                      0x004A
#define INTP11                          0x004A
#define INTKR                           0x004C
#define INTCAN0ERR                      0x004E
#define INTCAN0WUP                      0x0050
#define INTCAN0CFR                      0x0052
#define INTCAN0TRM                      0x0054
#define INTCANGRFR                      0x0056
#define INTCANGERR                      0x0058
#define INTTM10                         0x005A
#define INTTM11                         0x005C
#define INTTM12                         0x005E
#define INTTM13                         0x0060
#define INTFL                           0x0062
#define INTLIN1WUP                      0x0064
#define INTP12                          0x0064
#define INTLIN1TRM                      0x0066
#define INTLIN1RVC                      0x0068
#define INTLIN1                         0x006A
#define INTLIN1STA                      0x006A
#define INTTM14                         0x006C
#define INTTM15                         0x006E
#define INTTM16                         0x0070
#define INTTM17                         0x0072

#endif
